/*
 * Decompiled with CFR 0.152.
 */
package com.blinkfox.stalker.result;

import com.blinkfox.stalker.kit.MathKit;
import com.blinkfox.stalker.result.MeasureResult;
import java.util.ArrayList;
import java.util.List;

public class MeasureStatistician
extends MeasureResult {
    private static final double Z = 1.96;
    private static final int THRESHOLD = 100000;
    private final List<Long> eachCosts = new ArrayList<Long>(3325);
    private double varSum;

    public void update(long currSuccess, long currFailure, long currCosts, List<Long> currEachCosts) {
        this.success = currSuccess;
        this.failure = currFailure;
        this.total = this.success + this.failure;
        this.costs = currCosts;
        this.throughput = MathKit.calcThroughput(this.total, this.costs);
        for (Long cost : currEachCosts) {
            this.eachCosts.add(cost);
            this.sum += cost.longValue();
            if (this.min > cost) {
                this.min = cost;
            }
            if (this.max >= cost) continue;
            this.max = cost;
        }
        this.avg = this.sum / this.total;
        double currVarSum = this.varSum;
        for (long measure : this.eachCosts) {
            currVarSum += Math.pow((double)measure - (double)this.avg, 2.0);
        }
        this.stdDev = Math.sqrt(currVarSum / (double)this.total);
        double radius = 1.96 * this.stdDev / Math.sqrt(this.total);
        this.lowerConfidence = (double)this.avg - radius;
        this.upperConfidence = (double)this.avg + radius;
        if (this.eachCosts.size() > 100000) {
            this.eachCosts.clear();
            this.varSum = currVarSum;
        }
    }

    public MeasureResult updateAndGet(long currSuccess, long currFailure, long currCosts, List<Long> currEachCosts) {
        this.update(currSuccess, currFailure, currCosts, currEachCosts);
        return this.get();
    }

    public MeasureResult get() {
        return new MeasureResult().setCosts(this.costs).setTotal(this.total).setSuccess(this.success).setFailure(this.failure).setThroughput(this.throughput).setSum(this.sum).setAvg(this.avg).setMin(this.min).setMax(this.max).setStdDev(this.stdDev).setLowerConfidence(this.lowerConfidence).setUpperConfidence(this.upperConfidence);
    }
}

