/*
 * Decompiled with CFR 0.152.
 */
package com.blinkfox.stalker.output;

import com.blinkfox.minitable.MiniTable;
import com.blinkfox.stalker.config.Options;
import com.blinkfox.stalker.kit.StrKit;
import com.blinkfox.stalker.output.MeasureOutput;
import com.blinkfox.stalker.result.MeasureResult;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutputConsole
implements MeasureOutput {
    private static final Logger log = LoggerFactory.getLogger(OutputConsole.class);
    private static final List<String> HEADERS = Arrays.asList("", "Costs", "Total", "Success", "Failure", "Throughput", "Sum", "Avg", "Min", "Max", "StdDev", "95% LowerConfidence", "95% UpperConfidence");

    @Override
    public Object output(Options options, MeasureResult ... measureResults) {
        String result = this.getRenderResult(options, measureResults);
        log.warn("\n{}", (Object)result);
        return result;
    }

    private String getRenderResult(Options options, MeasureResult ... measureResults) {
        if (options == null || measureResults == null) {
            throw new IllegalArgumentException("options or measureResult is null.");
        }
        String title = options.getDuration() != null ? StrKit.join("duration: ", options.getDuration().toString(), ", concurrens: ", options.getConcurrens(), ", warmups:", options.getWarmups(), ", runs: ", options.getRuns(), ", printErrorLog: ", options.isPrintErrorLog()) : StrKit.join("threads: ", options.getThreads(), ", concurrens: ", options.getConcurrens(), ", warmups:", options.getWarmups(), ", runs: ", options.getRuns(), ", printErrorLog: ", options.isPrintErrorLog());
        String name = options.getName();
        title = StrKit.isEmpty(name) ? title : StrKit.join("name: ", name, ", ", title);
        MiniTable table = new MiniTable(title).addHeaders(HEADERS);
        int len = measureResults.length;
        for (int i = 0; i < len; ++i) {
            MeasureResult result = measureResults[i];
            table.addDatas(new Object[]{i + 1, result.getEasyReadCosts(), result.getTotal(), result.getSuccess(), result.getFailure(), result.getEasyReadThroughput(), result.getEasyReadSum(), result.getEasyReadAvg(), result.getEasyReadMin(), result.getEasyReadMax(), result.getEasyReadStdDev(), result.getEasyReadLowerConfidence(), result.getEasyReadUpperConfidence()});
        }
        return table.render();
    }
}

