/*
 * Decompiled with CFR 0.152.
 */
package com.blinkfox.stalker.output;

import com.blinkfox.minitable.MiniTable;
import com.blinkfox.stalker.config.Options;
import com.blinkfox.stalker.kit.StrKit;
import com.blinkfox.stalker.output.MeasureOutput;
import com.blinkfox.stalker.result.MeasureResult;
import java.util.Arrays;
import java.util.List;

public class AsciiTableOutput
implements MeasureOutput {
    private static final List<String> HEADERS = Arrays.asList("Costs", "Total", "Success", "Failure", "Throughput", "Avg", "Min", "Max", "StdDev", "95% LC", "95% UC");

    @Override
    public Object output(Options options, MeasureResult ... measureResults) {
        if (options == null || measureResults == null || measureResults.length == 0) {
            throw new IllegalArgumentException("options or measureResult is empty.");
        }
        String title = options.getDuration() != null ? StrKit.join("duration: ", options.getDuration().toString(), ", concurrens: ", options.getConcurrens(), ", warmups:", options.getWarmups(), ", runs: ", options.getRuns(), ", printErrorLog: ", options.isPrintErrorLog()) : StrKit.join("threads: ", options.getThreads(), ", concurrens: ", options.getConcurrens(), ", warmups:", options.getWarmups(), ", runs: ", options.getRuns(), ", printErrorLog: ", options.isPrintErrorLog());
        String name = options.getName();
        title = StrKit.isEmpty(name) ? title : StrKit.join("name: ", name, ", ", title);
        MiniTable table = new MiniTable(title).addHeaders(HEADERS);
        for (MeasureResult result : measureResults) {
            table.addDatas(new Object[]{result.getEasyReadCosts(), result.getTotal(), result.getSuccess(), result.getFailure(), result.getEasyReadThroughput(), result.getEasyReadAvg(), result.getEasyReadMin(), result.getEasyReadMax(), result.getEasyReadStdDev(), result.getEasyReadLowerConfidence(), result.getEasyReadUpperConfidence()});
        }
        return table.render();
    }
}

