/*
 * Decompiled with CFR 0.152.
 */
package com.blinkfox.stalker.kit;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.concurrent.TimeUnit;
import org.slf4j.helpers.MessageFormatter;

public final class StrKit {
    public static boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }

    public static String join(Object ... objects) {
        if (objects != null && objects.length > 0) {
            StringBuilder sb = new StringBuilder();
            for (Object o : objects) {
                sb.append(o == null ? "" : o.toString());
            }
            return sb.toString();
        }
        return "";
    }

    public static String format(String pattern, Object ... args) {
        return pattern == null ? "" : MessageFormatter.arrayFormat((String)pattern, (Object[])args).getMessage();
    }

    public static String convertTime(Number n) {
        double d = n.doubleValue();
        if (d < 100000.0) {
            return Long.toString(n.longValue()).concat(" ns");
        }
        if (d >= 10000.0 && d < 1.0E9) {
            return StrKit.roundToString(d / 1000000.0, "ms");
        }
        if (d >= 1.0E9 && d < 6.0E10) {
            return StrKit.roundToString(d / 1.0E9, "s");
        }
        if (d >= 6.0E10 && d < 3.6E12) {
            return StrKit.roundToString(d / 6.0E10, "min");
        }
        if (d >= 3.6E12 && d < 8.64E13) {
            return StrKit.roundToString(d / 3.6E12, "h");
        }
        return StrKit.roundToString(d / 8.64E13, "d");
    }

    public static String convertTimeUnit(long amount, TimeUnit timeUnit) {
        switch (timeUnit) {
            case NANOSECONDS: {
                return amount + " ns";
            }
            case MICROSECONDS: {
                return amount + " \u03bcs";
            }
            case MILLISECONDS: {
                return amount + " ms";
            }
            case SECONDS: {
                return amount + " s";
            }
            case MINUTES: {
                return amount + " m";
            }
            case HOURS: {
                return amount + " h";
            }
            case DAYS: {
                return amount + " d";
            }
        }
        return String.valueOf(amount);
    }

    private static String roundToString(double d, String unit) {
        return StrKit.join(BigDecimal.valueOf(d).setScale(2, RoundingMode.HALF_UP).toString(), " ", unit);
    }

    public static String roundToString(double d) {
        return BigDecimal.valueOf(d).setScale(2, RoundingMode.HALF_UP).toString();
    }

    private StrKit() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

