/*
 * Decompiled with CFR 0.152.
 */
package com.blinkfox.stalker.config;

import com.blinkfox.stalker.config.Options;
import com.blinkfox.stalker.config.ScheduledUpdater;
import com.blinkfox.stalker.output.OutputConsole;

public final class StalkerConfigManager {
    private static final StalkerConfigManager stalkerConfigManager = new StalkerConfigManager();
    private Options defaultOptions = new Options().threads(1).concurrens(1).warmups(5).runs(10).printErrorLog(false).outputs(new OutputConsole());
    private ScheduledUpdater defaultScheduledUpdater = ScheduledUpdater.ofSeconds(10L).disable();

    private StalkerConfigManager() {
    }

    public static StalkerConfigManager getInstance() {
        return stalkerConfigManager;
    }

    public synchronized void reLoadOptions(Options options) {
        options.valid();
        this.defaultOptions = options;
    }

    public synchronized void reLoadOptions(Options options, ScheduledUpdater scheduledUpdater) {
        options.valid();
        scheduledUpdater.valid();
        this.defaultOptions = options;
        this.defaultScheduledUpdater = scheduledUpdater;
    }

    public Options getDefaultOptions() {
        return this.defaultOptions;
    }

    public ScheduledUpdater getDefaultScheduledUpdater() {
        return this.defaultScheduledUpdater;
    }
}

