/*
 * Decompiled with CFR 0.152.
 */
package com.blinkfox.stalker.config;

import java.util.concurrent.TimeUnit;

public class ScheduledUpdater {
    private boolean enabled;
    private final long initialDelay;
    private final long delay;
    private final TimeUnit timeUnit;

    private ScheduledUpdater(boolean enabled, long initialDelay, long delay, TimeUnit timeUnit) {
        this.enabled = enabled;
        this.initialDelay = initialDelay;
        this.delay = delay;
        this.timeUnit = timeUnit;
    }

    public static ScheduledUpdater of(boolean enabled, long initialDelay, long delay, TimeUnit timeUnit) {
        ScheduledUpdater.checkDelay(initialDelay);
        ScheduledUpdater.checkParams(delay, timeUnit);
        return new ScheduledUpdater(enabled, initialDelay, delay, timeUnit);
    }

    public static ScheduledUpdater of(long delay, TimeUnit timeUnit) {
        ScheduledUpdater.checkParams(delay, timeUnit);
        return new ScheduledUpdater(true, delay, delay, timeUnit);
    }

    public static ScheduledUpdater ofSeconds(long delay) {
        ScheduledUpdater.checkDelay(delay);
        return new ScheduledUpdater(true, delay, delay, TimeUnit.SECONDS);
    }

    public static ScheduledUpdater ofMinutes(long delay) {
        ScheduledUpdater.checkDelay(delay);
        return new ScheduledUpdater(true, delay, delay, TimeUnit.MINUTES);
    }

    public static ScheduledUpdater ofEnable() {
        return new ScheduledUpdater(true, 5L, 5L, TimeUnit.SECONDS);
    }

    public static ScheduledUpdater ofDisable() {
        return new ScheduledUpdater(false, 5L, 5L, TimeUnit.SECONDS);
    }

    public ScheduledUpdater enable() {
        this.enabled = true;
        return this;
    }

    public ScheduledUpdater disable() {
        this.enabled = false;
        return this;
    }

    public void valid() {
        ScheduledUpdater.checkDelay(this.initialDelay);
        ScheduledUpdater.checkParams(this.delay, this.timeUnit);
    }

    private static void checkDelay(long delay) {
        if (delay <= 0L) {
            throw new IllegalArgumentException("\u3010Stalker \u65e0\u6548\u53c2\u6570\u5f02\u5e38\u3011\u5ef6\u8fdf\u66f4\u65b0\u7edf\u8ba1\u6570\u636e\u7684\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e 0\uff0c\u83b7\u53d6\u5230\u7684\u503c\u662f\uff1a\u3010" + delay + "\u3011.");
        }
    }

    private static void checkParams(long delay, TimeUnit timeUnit) {
        ScheduledUpdater.checkDelay(delay);
        if (timeUnit == null) {
            throw new IllegalArgumentException("\u3010Stalker \u65e0\u6548\u53c2\u6570\u5f02\u5e38\u3011\u8fd0\u884c\u7684\u65f6\u95f4\u95f4\u9694\u7684\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a\u3010null\u3011.");
        }
        if (timeUnit == TimeUnit.NANOSECONDS || timeUnit == TimeUnit.MICROSECONDS || timeUnit == TimeUnit.MILLISECONDS) {
            throw new IllegalArgumentException("\u3010Stalker \u65e0\u6548\u53c2\u6570\u5f02\u5e38\u3011\u8fd0\u884c\u7684\u65f6\u95f4\u95f4\u9694\u7684\u5355\u4f4d\u81f3\u5c11\u662f\u3010\u79d2\u3011\uff0c\u4e0d\u80fd\u662f\u3010\u7eb3\u79d2\u3011\u3001\u3010\u5fae\u79d2\u3011\u6216\u8005\u3010\u6beb\u79d2\u3011\uff0c\u83b7\u53d6\u5230\u7684\u503c\u662f\uff1a\u3010" + timeUnit.name() + "\u3011.");
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public long getInitialDelay() {
        return this.initialDelay;
    }

    public long getDelay() {
        return this.delay;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }
}

