/*
 * Decompiled with CFR 0.152.
 */
package com.blinkfox.stalker.config;

import com.blinkfox.stalker.kit.StrKit;
import java.util.concurrent.TimeUnit;

public class RunDuration {
    private final long amount;
    private final TimeUnit timeUnit;

    private RunDuration(long amount, TimeUnit timeUnit) {
        this.amount = amount;
        this.timeUnit = timeUnit;
    }

    public static RunDuration of(long amount, TimeUnit timeUnit) {
        RunDuration.checkParams(amount, timeUnit);
        return new RunDuration(amount, timeUnit);
    }

    public static RunDuration ofSeconds(long amount) {
        RunDuration.checkAmount(amount);
        return new RunDuration(amount, TimeUnit.SECONDS);
    }

    public static RunDuration ofMinutes(long amount) {
        RunDuration.checkAmount(amount);
        return new RunDuration(amount, TimeUnit.MINUTES);
    }

    public static RunDuration ofHours(long amount) {
        RunDuration.checkAmount(amount);
        return new RunDuration(amount, TimeUnit.HOURS);
    }

    public static RunDuration ofDays(long amount) {
        RunDuration.checkAmount(amount);
        return new RunDuration(amount, TimeUnit.DAYS);
    }

    public long getEndNanoTime(long startNanoTime) {
        return startNanoTime + this.getAmountNanoTime();
    }

    public long getAmountNanoTime() {
        switch (this.timeUnit) {
            case NANOSECONDS: {
                return this.amount;
            }
            case MICROSECONDS: {
                return this.amount * 1000L;
            }
            case MILLISECONDS: {
                return this.amount * 1000000L;
            }
            case SECONDS: {
                return this.amount * 1000000000L;
            }
            case MINUTES: {
                return this.amount * 60000000000L;
            }
            case HOURS: {
                return this.amount * 3600000000000L;
            }
            case DAYS: {
                return this.amount * 86400000000000L;
            }
        }
        return 0L;
    }

    private static void checkParams(long amount, TimeUnit timeUnit) {
        RunDuration.checkAmount(amount);
        if (timeUnit == null) {
            throw new IllegalArgumentException("\u3010Stalker \u65e0\u6548\u53c2\u6570\u5f02\u5e38\u3011\u8fd0\u884c\u7684\u6700\u5c0f\u6301\u7eed\u65f6\u95f4\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a\u3010null\u3011.");
        }
        if (timeUnit == TimeUnit.NANOSECONDS || timeUnit == TimeUnit.MICROSECONDS || timeUnit == TimeUnit.MILLISECONDS) {
            throw new IllegalArgumentException("\u3010Stalker \u65e0\u6548\u53c2\u6570\u5f02\u5e38\u3011\u8fd0\u884c\u7684\u6700\u5c0f\u6301\u7eed\u65f6\u95f4\u5355\u4f4d\u81f3\u5c11\u662f\u3010\u79d2\u3011\uff0c\u4e0d\u80fd\u662f\u3010\u7eb3\u79d2\u3011\u3001\u3010\u5fae\u79d2\u3011\u6216\u8005\u3010\u6beb\u79d2\u3011\uff0c\u83b7\u53d6\u5230\u7684\u503c\u662f\uff1a\u3010" + timeUnit.name() + "\u3011.");
        }
    }

    private static void checkAmount(long amount) {
        if (amount <= 0L) {
            throw new IllegalArgumentException("\u3010Stalker \u65e0\u6548\u53c2\u6570\u5f02\u5e38\u3011\u8fd0\u884c\u7684\u7eed\u65f6\u95f4\u5fc5\u987b\u662f\u6b63\u6574\u6570\uff0c\u83b7\u53d6\u5230\u7684\u503c\u662f\uff1a\u3010" + amount + "\u3011.");
        }
    }

    public static long parseToSeconds(String duration) {
        long totalSeconds = 0L;
        StringBuilder sb = new StringBuilder();
        for (char c : duration.toCharArray()) {
            if (c >= '0' && c <= '9') {
                sb.append(c);
                continue;
            }
            if (c == 'd' || c == 'D') {
                String day = sb.toString();
                if (day.length() <= 0) continue;
                totalSeconds += Long.parseLong(day) * 86400L;
                sb.setLength(0);
                continue;
            }
            if (c == 'h' || c == 'H') {
                String hour = sb.toString();
                if (hour.length() <= 0) continue;
                totalSeconds += Long.parseLong(hour) * 3600L;
                sb.setLength(0);
                continue;
            }
            if (c == 'm' || c == 'M') {
                String minute = sb.toString();
                if (minute.length() <= 0) continue;
                totalSeconds += Long.parseLong(minute) * 60L;
                sb.setLength(0);
                continue;
            }
            if (c == 's' || c == 'S') {
                String second = sb.toString();
                if (second.length() <= 0) continue;
                totalSeconds += Long.parseLong(second);
                sb.setLength(0);
                continue;
            }
            sb.setLength(0);
        }
        return totalSeconds;
    }

    public String toString() {
        return StrKit.convertTimeUnit(this.amount, this.timeUnit);
    }

    public long getAmount() {
        return this.amount;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }
}

