/*
 * Decompiled with CFR 0.152.
 */
package com.blinkfox.stalker.config;

import com.blinkfox.stalker.config.RunDuration;
import com.blinkfox.stalker.config.ScheduledUpdater;
import com.blinkfox.stalker.config.StalkerConfigManager;
import com.blinkfox.stalker.output.MeasureOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class Options {
    private String name;
    private int threads;
    private int concurrens;
    private int warmups;
    private int runs;
    private RunDuration duration;
    private boolean printErrorLog;
    private List<MeasureOutput> outputs;
    private String message;
    private ScheduledUpdater scheduledUpdater;

    public static Options of() {
        Options defaultOptions = StalkerConfigManager.getInstance().getDefaultOptions();
        return new Options().threads(defaultOptions.getThreads()).concurrens(defaultOptions.getConcurrens()).warmups(defaultOptions.getWarmups()).runs(defaultOptions.getRuns()).printErrorLog(defaultOptions.isPrintErrorLog()).outputs(defaultOptions.getOutputs());
    }

    public static Options of(String name) {
        Options options = Options.of();
        options.name = name;
        return options;
    }

    public static Options of(int runs) {
        Options options = Options.of();
        options.runs = runs;
        return options;
    }

    public static Options of(String name, int runs) {
        Options options = Options.of(name);
        options.runs = runs;
        return options;
    }

    public static Options of(int threads, int concurrens) {
        Options options = Options.of();
        options.threads = threads;
        options.concurrens = concurrens;
        options.runs = 1;
        return options;
    }

    public static Options of(String name, int threads, int concurrens) {
        Options options = Options.of(threads, concurrens);
        options.name = name;
        return options;
    }

    public static Options of(String name, int threads, int concurrens, int runs) {
        Options options = Options.of(name, threads, concurrens);
        options.runs = runs;
        return options;
    }

    public static Options ofDuration(long amount, TimeUnit timeUnit) {
        Options options = Options.of(1, 1);
        options.runs = 1;
        options.duration = RunDuration.of(amount, timeUnit);
        return options;
    }

    public static Options ofDuration(long amount, TimeUnit timeUnit, int concurrens) {
        Options options = Options.of(1, 1);
        options.concurrens = concurrens;
        options.runs = 1;
        options.duration = RunDuration.of(amount, timeUnit);
        return options;
    }

    public static Options ofDurationSeconds(long amount, int concurrens) {
        return Options.ofDuration(amount, TimeUnit.SECONDS, concurrens);
    }

    public static Options ofDurationMinutes(long amount, int concurrens) {
        return Options.ofDuration(amount, TimeUnit.MINUTES, concurrens);
    }

    public static Options ofDurationHours(long amount, int concurrens) {
        return Options.ofDuration(amount, TimeUnit.HOURS, concurrens);
    }

    public static Options ofDurationDays(long amount, int concurrens) {
        return Options.ofDuration(amount, TimeUnit.DAYS, concurrens);
    }

    public void valid() {
        if (this.verify(this.getThreads() <= 0, "Options \u4e2d\u7684\u7ebf\u7a0b\u6570 threads \u7684\u503c\u5fc5\u987b\u5927\u4e8e0.") || this.verify(this.getConcurrens() <= 0, "Options \u4e2d\u7684\u7ebf\u7a0b\u6570 concurrens \u7684\u503c\u5fc5\u987b\u5927\u4e8e0.") || this.verify(this.getWarmups() < 0, "Options \u4e2d\u7684\u7ebf\u7a0b\u6570 warmups \u7684\u503c\u5fc5\u987b\u5927\u4e8e0.") || this.verify(this.getRuns() <= 0, "Options \u4e2d\u7684\u7ebf\u7a0b\u6570 runs \u7684\u503c\u5fc5\u987b\u5927\u4e8e0.")) {
            throw new IllegalArgumentException(this.message);
        }
    }

    private boolean verify(boolean condition, String message) {
        if (condition) {
            this.message = message;
        }
        return condition;
    }

    public Options named(String name) {
        this.name = name;
        return this;
    }

    public Options threads(int threads) {
        this.threads = threads;
        return this;
    }

    public Options concurrens(int concurrens) {
        this.concurrens = concurrens;
        return this;
    }

    public Options warmups(int warmups) {
        this.warmups = warmups;
        return this;
    }

    public Options runs(int runs) {
        this.runs = runs;
        return this;
    }

    public Options duration(long amount, TimeUnit timeUnit) {
        this.duration = RunDuration.of(amount, timeUnit);
        return this;
    }

    public Options printErrorLog(boolean printErrorLog) {
        this.printErrorLog = printErrorLog;
        return this;
    }

    public Options outputs(MeasureOutput ... measureOutputs) {
        if (this.outputs == null) {
            this.outputs = new ArrayList<MeasureOutput>();
        }
        this.outputs.addAll(Arrays.asList(measureOutputs));
        return this;
    }

    public Options outputs(List<MeasureOutput> outputs) {
        this.outputs = outputs;
        return this;
    }

    public Options enableScheduledUpdater() {
        ScheduledUpdater updater = StalkerConfigManager.getInstance().getDefaultScheduledUpdater();
        this.scheduledUpdater = ScheduledUpdater.of(true, updater.getInitialDelay(), updater.getDelay(), updater.getTimeUnit());
        return this;
    }

    public Options enableScheduledUpdater(long delay, TimeUnit timeUnit) {
        this.scheduledUpdater = ScheduledUpdater.of(delay, timeUnit);
        return this;
    }

    public Options enableScheduledUpdater(long initialDelay, long delay, TimeUnit timeUnit) {
        this.scheduledUpdater = ScheduledUpdater.of(true, initialDelay, delay, timeUnit);
        return this;
    }

    public String getName() {
        return this.name;
    }

    public int getThreads() {
        return this.threads;
    }

    public int getConcurrens() {
        return this.concurrens;
    }

    public int getWarmups() {
        return this.warmups;
    }

    public int getRuns() {
        return this.runs;
    }

    public RunDuration getDuration() {
        return this.duration;
    }

    public boolean isPrintErrorLog() {
        return this.printErrorLog;
    }

    public List<MeasureOutput> getOutputs() {
        return this.outputs;
    }

    public String getMessage() {
        return this.message;
    }

    public ScheduledUpdater getScheduledUpdater() {
        return this.scheduledUpdater;
    }
}

