/*
 * Decompiled with CFR 0.152.
 */
package com.blinkfox.stalker;

import com.blinkfox.stalker.config.Options;
import com.blinkfox.stalker.config.RunDuration;
import com.blinkfox.stalker.output.MeasureOutputContext;
import com.blinkfox.stalker.result.MeasureResult;
import com.blinkfox.stalker.result.StalkerFuture;
import com.blinkfox.stalker.runner.MeasureRunnerContext;
import java.util.List;

public final class Stalker {
    public static StalkerFuture submit(Runnable task) {
        return Stalker.submit(Options.of(), task);
    }

    public static StalkerFuture submit(Options options, Runnable task) {
        if (options == null || task == null) {
            throw new IllegalArgumentException("options or runnables is null (or empty)!");
        }
        options.valid();
        options.enableScheduledUpdater();
        return MeasureRunnerContext.submit(options, task);
    }

    public static List<Object> run(Runnable ... runnables) {
        return Stalker.run(Options.of(), runnables);
    }

    public static List<Object> run(Options options, Runnable ... runnables) {
        return new MeasureOutputContext().output(options, Stalker.runStatis(options, runnables));
    }

    public static MeasureResult[] runStatis(Options options, Runnable ... runnables) {
        int len;
        if (options == null || runnables == null || (len = runnables.length) == 0) {
            throw new IllegalArgumentException("\u3010Stalker \u53c2\u6570\u5f02\u5e38\u3011options or runnables is null (or empty)!");
        }
        MeasureResult[] measurements = new MeasureResult[len];
        for (int i = 0; i < len; ++i) {
            measurements[i] = new MeasureRunnerContext(options).run(runnables[i]);
        }
        return measurements;
    }

    public static double getProgress(Options options, MeasureResult result) {
        RunDuration duration = options.getDuration();
        double progress = duration != null ? (double)result.getCosts() * 100.0 / (double)duration.getAmountNanoTime() : (double)result.getTotal() * 100.0 / (double)options.getThreads();
        return progress > 100.0 ? 100.0 : progress;
    }

    private Stalker() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

