/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.cdn;

import com.baidubce.AbstractBceClient;
import com.baidubce.BceClientConfiguration;
import com.baidubce.BceClientException;
import com.baidubce.auth.SignOptions;
import com.baidubce.http.HttpMethodName;
import com.baidubce.http.handler.BceErrorResponseHandler;
import com.baidubce.http.handler.BceJsonResponseHandler;
import com.baidubce.http.handler.BceMetadataResponseHandler;
import com.baidubce.http.handler.HttpResponseHandler;
import com.baidubce.internal.InternalRequest;
import com.baidubce.internal.RestartableInputStream;
import com.baidubce.model.AbstractBceRequest;
import com.baidubce.services.cdn.model.CreateDomainRequest;
import com.baidubce.services.cdn.model.CreateDomainResponse;
import com.baidubce.services.cdn.model.DeleteDomainRequest;
import com.baidubce.services.cdn.model.DeleteDomainResponse;
import com.baidubce.services.cdn.model.DescribeIpRequest;
import com.baidubce.services.cdn.model.DescribeIpResponse;
import com.baidubce.services.cdn.model.DisableDomainRequest;
import com.baidubce.services.cdn.model.DisableDomainResponse;
import com.baidubce.services.cdn.model.EnableDomainRequest;
import com.baidubce.services.cdn.model.EnableDomainResponse;
import com.baidubce.services.cdn.model.GetCacheQuotaRequest;
import com.baidubce.services.cdn.model.GetCacheQuotaResponse;
import com.baidubce.services.cdn.model.GetDomainCacheTTLRequest;
import com.baidubce.services.cdn.model.GetDomainCacheTTLResponse;
import com.baidubce.services.cdn.model.GetDomainConfigRequest;
import com.baidubce.services.cdn.model.GetDomainConfigResponse;
import com.baidubce.services.cdn.model.GetDomainLogRequest;
import com.baidubce.services.cdn.model.GetDomainLogResponse;
import com.baidubce.services.cdn.model.GetPrefetchStatusRequest;
import com.baidubce.services.cdn.model.GetPrefetchStatusResponse;
import com.baidubce.services.cdn.model.GetPurgeStatusRequest;
import com.baidubce.services.cdn.model.GetPurgeStatusResponse;
import com.baidubce.services.cdn.model.GetStatAvgSpeedRequest;
import com.baidubce.services.cdn.model.GetStatAvgSpeedResponse;
import com.baidubce.services.cdn.model.GetStatFlowRequest;
import com.baidubce.services.cdn.model.GetStatFlowResponse;
import com.baidubce.services.cdn.model.GetStatHitRateRequest;
import com.baidubce.services.cdn.model.GetStatHitRateResponse;
import com.baidubce.services.cdn.model.GetStatHttpCodeRequest;
import com.baidubce.services.cdn.model.GetStatHttpCodeResponse;
import com.baidubce.services.cdn.model.GetStatPvRequest;
import com.baidubce.services.cdn.model.GetStatPvResponse;
import com.baidubce.services.cdn.model.GetStatSrcFlowRequest;
import com.baidubce.services.cdn.model.GetStatSrcFlowResponse;
import com.baidubce.services.cdn.model.GetStatTopRefererRequest;
import com.baidubce.services.cdn.model.GetStatTopRefererResponse;
import com.baidubce.services.cdn.model.GetStatTopUrlRequest;
import com.baidubce.services.cdn.model.GetStatTopUrlResponse;
import com.baidubce.services.cdn.model.GetStatUvRequest;
import com.baidubce.services.cdn.model.GetStatUvResponse;
import com.baidubce.services.cdn.model.HttpsConfig;
import com.baidubce.services.cdn.model.ListDomainsRequest;
import com.baidubce.services.cdn.model.ListDomainsResponse;
import com.baidubce.services.cdn.model.OriginPeer;
import com.baidubce.services.cdn.model.PrefetchRequest;
import com.baidubce.services.cdn.model.PrefetchResponse;
import com.baidubce.services.cdn.model.PrefetchTask;
import com.baidubce.services.cdn.model.PurgeRequest;
import com.baidubce.services.cdn.model.PurgeResponse;
import com.baidubce.services.cdn.model.PurgeTask;
import com.baidubce.services.cdn.model.RequestAuth;
import com.baidubce.services.cdn.model.SetDomainCacheFullUrlRequest;
import com.baidubce.services.cdn.model.SetDomainCacheFullUrlResponse;
import com.baidubce.services.cdn.model.SetDomainCacheTTLRequest;
import com.baidubce.services.cdn.model.SetDomainCacheTTLResponse;
import com.baidubce.services.cdn.model.SetDomainIpACLRequest;
import com.baidubce.services.cdn.model.SetDomainIpACLResponse;
import com.baidubce.services.cdn.model.SetDomainLimitRateRequest;
import com.baidubce.services.cdn.model.SetDomainLimitRateResponse;
import com.baidubce.services.cdn.model.SetDomainOriginRequest;
import com.baidubce.services.cdn.model.SetDomainOriginResponse;
import com.baidubce.services.cdn.model.SetDomainRefererACLRequest;
import com.baidubce.services.cdn.model.SetDomainRefererACLResponse;
import com.baidubce.services.cdn.model.SetHttpsConfigRequest;
import com.baidubce.services.cdn.model.SetHttpsConfigResponse;
import com.baidubce.services.cdn.model.SetRequestAuthRequest;
import com.baidubce.services.cdn.model.SetRequestAuthResponse;
import com.baidubce.util.DateUtils;
import com.baidubce.util.HttpUtils;
import com.baidubce.util.JsonUtils;
import com.baidubce.util.Validate;
import com.google.common.base.Preconditions;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;

public class CdnClient
extends AbstractBceClient {
    private static final String VERSION = "v2";
    private static final String DOMAIN = "domain";
    private static final String STAT = "stat";
    private static final String CACHE = "cache";
    private static final String LOG = "log";
    private static final String UTILS = "utils";
    private static final String[] HEADERS_TO_SIGN = new String[]{"host", "x-bce-date"};
    private static final HttpResponseHandler[] cdnHandlers = new HttpResponseHandler[]{new BceMetadataResponseHandler(), new BceErrorResponseHandler(), new BceJsonResponseHandler()};

    public CdnClient() {
        this(new BceClientConfiguration());
    }

    public CdnClient(BceClientConfiguration clientConfiguration) {
        super(clientConfiguration, cdnHandlers);
    }

    public CreateDomainResponse createDomain(CreateDomainRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, DOMAIN, request.getDomain());
        this.attachRequestToBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, CreateDomainResponse.class);
    }

    public void enableDomain(String domain) {
        this.enableDomain(new EnableDomainRequest().withDomain(domain));
    }

    public EnableDomainResponse enableDomain(EnableDomainRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, DOMAIN, request.getDomain());
        internalRequest.addParameter("enable", "");
        return this.invokeHttpClient(internalRequest, EnableDomainResponse.class);
    }

    public void disableDomain(String domain) {
        this.disableDomain(new DisableDomainRequest().withDomain(domain));
    }

    public DisableDomainResponse disableDomain(DisableDomainRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, DOMAIN, request.getDomain());
        internalRequest.addParameter("disable", "");
        return this.invokeHttpClient(internalRequest, DisableDomainResponse.class);
    }

    public void deleteDomain(String domain) {
        this.deleteDomain(new DeleteDomainRequest().withDomain(domain));
    }

    public DeleteDomainResponse deleteDomain(DeleteDomainRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.DELETE, DOMAIN, request.getDomain());
        return this.invokeHttpClient(internalRequest, DeleteDomainResponse.class);
    }

    public ListDomainsResponse listDomains() {
        return this.listDomains(new ListDomainsRequest());
    }

    public ListDomainsResponse listDomains(ListDomainsRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, DOMAIN);
        return this.invokeHttpClient(internalRequest, ListDomainsResponse.class);
    }

    public GetDomainConfigResponse getDomainConfig(String domain) {
        return this.getDomainConfig(new GetDomainConfigRequest().withDomain(domain));
    }

    public GetDomainConfigResponse getDomainConfig(GetDomainConfigRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, DOMAIN, request.getDomain(), "config");
        return this.invokeHttpClient(internalRequest, GetDomainConfigResponse.class);
    }

    public void setDomainOrigin(String domain, String peer) {
        ArrayList<OriginPeer> origin = new ArrayList<OriginPeer>();
        origin.add(new OriginPeer().withPeer(peer));
        SetDomainOriginRequest request = new SetDomainOriginRequest().withDomain(domain).withOrigin(origin);
        this.setDomainOrigin(request);
    }

    public SetDomainOriginResponse setDomainOrigin(SetDomainOriginRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, DOMAIN, request.getDomain(), "config");
        internalRequest.addParameter("origin", "");
        this.attachRequestToBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, SetDomainOriginResponse.class);
    }

    public GetDomainCacheTTLResponse getDomainCacheTTL(String domain) {
        GetDomainCacheTTLRequest request = new GetDomainCacheTTLRequest().withDomain(domain);
        return this.getDomainCacheTTL(request);
    }

    public GetDomainCacheTTLResponse getDomainCacheTTL(GetDomainCacheTTLRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, DOMAIN, request.getDomain(), "config");
        internalRequest.addParameter("cacheTTL", "");
        return this.invokeHttpClient(internalRequest, GetDomainCacheTTLResponse.class);
    }

    public SetDomainCacheTTLResponse setDomainCacheTTL(SetDomainCacheTTLRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, DOMAIN, request.getDomain(), "config");
        internalRequest.addParameter("cacheTTL", "");
        this.attachRequestToBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, SetDomainCacheTTLResponse.class);
    }

    public void setDomainCacheFullUrl(String domain, boolean setting) {
        SetDomainCacheFullUrlRequest request = new SetDomainCacheFullUrlRequest().withDomain(domain);
        request.setCacheFullUrl(setting);
        this.setDomainCacheFullUrl(request);
    }

    public SetDomainCacheFullUrlResponse setDomainCacheFullUrl(SetDomainCacheFullUrlRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, DOMAIN, request.getDomain(), "config");
        internalRequest.addParameter("cacheFullUrl", "");
        this.attachRequestToBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, SetDomainCacheFullUrlResponse.class);
    }

    public SetDomainRefererACLResponse setDomainRefererACL(SetDomainRefererACLRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, DOMAIN, request.getDomain(), "config");
        internalRequest.addParameter("refererACL", "");
        this.attachRequestToBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, SetDomainRefererACLResponse.class);
    }

    public SetDomainIpACLResponse setDomainIpACL(SetDomainIpACLRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, DOMAIN, request.getDomain(), "config");
        internalRequest.addParameter("ipACL", "");
        this.attachRequestToBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, SetDomainIpACLResponse.class);
    }

    public void setDomainLimitRate(String domain, int limitRate) {
        SetDomainLimitRateRequest request = new SetDomainLimitRateRequest().withDomain(domain).withLimitRate(limitRate);
        this.setDomainLimitRate(request);
    }

    public SetDomainLimitRateResponse setDomainLimitRate(SetDomainLimitRateRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, DOMAIN, request.getDomain(), "config");
        internalRequest.addParameter("limitRate", "");
        this.attachRequestToBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, SetDomainLimitRateResponse.class);
    }

    public void setHttpsConfig(String domain, HttpsConfig https) {
        SetHttpsConfigRequest request = new SetHttpsConfigRequest().withDomain(domain).withHttps(https);
        this.setHttpsConfig(request);
    }

    public SetHttpsConfigResponse setHttpsConfig(SetHttpsConfigRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, DOMAIN, request.getDomain(), "config");
        internalRequest.addParameter("https", "");
        this.attachRequestToBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, SetHttpsConfigResponse.class);
    }

    public void setRequestAuth(String domain, RequestAuth requestAuth) {
        SetRequestAuthRequest request = new SetRequestAuthRequest().withDomain(domain).withRequestAuth(requestAuth);
        this.setRequestAuth(request);
    }

    public SetRequestAuthResponse setRequestAuth(SetRequestAuthRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, DOMAIN, request.getDomain(), "config");
        internalRequest.addParameter("requestAuth", "");
        this.attachRequestToBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, SetRequestAuthResponse.class);
    }

    public PrefetchResponse prefetch(String url) {
        return this.prefetch(new PrefetchRequest().addTask(new PrefetchTask().withUrl(url)));
    }

    public PrefetchResponse prefetch(PrefetchRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, CACHE, "prefetch");
        this.attachRequestToBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, PrefetchResponse.class);
    }

    public PurgeResponse purge(String url) {
        return this.purge(new PurgeRequest().addTask(new PurgeTask().withUrl(url)));
    }

    public PurgeResponse purgeDirectory(String directory) {
        return this.purge(new PurgeRequest().addTask(new PurgeTask().withDirectory(directory)));
    }

    public PurgeResponse purge(PurgeRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, CACHE, "purge");
        this.attachRequestToBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, PurgeResponse.class);
    }

    public GetPurgeStatusResponse getPurgeStatus(GetPurgeStatusRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, CACHE, "purge");
        if (request.getId() != null) {
            internalRequest.addParameter("id", request.getId());
        }
        if (request.getStartTime() != null) {
            internalRequest.addParameter("startTime", DateUtils.formatAlternateIso8601Date(request.getStartTime()));
        }
        if (request.getEndTime() != null) {
            internalRequest.addParameter("endTime", DateUtils.formatAlternateIso8601Date(request.getEndTime()));
        }
        if (request.getMarker() != null) {
            internalRequest.addParameter("marker", request.getMarker());
        }
        if (request.getUrl() != null) {
            internalRequest.addParameter("url", request.getUrl());
        }
        return this.invokeHttpClient(internalRequest, GetPurgeStatusResponse.class);
    }

    public GetPrefetchStatusResponse getPrefetchStatus(GetPrefetchStatusRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, CACHE, "prefetch");
        if (request.getId() != null) {
            internalRequest.addParameter("id", request.getId());
        }
        if (request.getStartTime() != null) {
            internalRequest.addParameter("startTime", DateUtils.formatAlternateIso8601Date(request.getStartTime()));
        }
        if (request.getEndTime() != null) {
            internalRequest.addParameter("endTime", DateUtils.formatAlternateIso8601Date(request.getEndTime()));
        }
        if (request.getMarker() != null) {
            internalRequest.addParameter("marker", request.getMarker());
        }
        if (request.getUrl() != null) {
            internalRequest.addParameter("url", request.getUrl());
        }
        return this.invokeHttpClient(internalRequest, GetPrefetchStatusResponse.class);
    }

    public GetStatPvResponse getStatPv(GetStatPvRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, STAT, "pv");
        if (request.getStartTime() != null) {
            internalRequest.addParameter("startTime", DateUtils.formatAlternateIso8601Date(request.getStartTime()));
        }
        if (request.getEndTime() != null) {
            internalRequest.addParameter("endTime", DateUtils.formatAlternateIso8601Date(request.getEndTime()));
        }
        if (request.getDomain() != null) {
            internalRequest.addParameter(DOMAIN, request.getDomain());
        }
        if (request.getPeriod() != null) {
            internalRequest.addParameter("period", String.valueOf(request.getPeriod()));
        }
        if (request.isWithRegion()) {
            internalRequest.addParameter("withRegion", "");
        }
        return this.invokeHttpClient(internalRequest, GetStatPvResponse.class);
    }

    public GetStatFlowResponse getStatFlow(GetStatFlowRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, STAT, "flow");
        if (request.getStartTime() != null) {
            internalRequest.addParameter("startTime", DateUtils.formatAlternateIso8601Date(request.getStartTime()));
        }
        if (request.getEndTime() != null) {
            internalRequest.addParameter("endTime", DateUtils.formatAlternateIso8601Date(request.getEndTime()));
        }
        if (request.getDomain() != null) {
            internalRequest.addParameter(DOMAIN, request.getDomain());
        }
        if (request.getPeriod() != null) {
            internalRequest.addParameter("period", String.valueOf(request.getPeriod()));
        }
        if (request.isWithRegion()) {
            internalRequest.addParameter("withRegion", "");
        }
        return this.invokeHttpClient(internalRequest, GetStatFlowResponse.class);
    }

    public GetStatSrcFlowResponse getStatSrcFlow(GetStatSrcFlowRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, STAT, "srcflow");
        if (request.getStartTime() != null) {
            internalRequest.addParameter("startTime", DateUtils.formatAlternateIso8601Date(request.getStartTime()));
        }
        if (request.getEndTime() != null) {
            internalRequest.addParameter("endTime", DateUtils.formatAlternateIso8601Date(request.getEndTime()));
        }
        if (request.getDomain() != null) {
            internalRequest.addParameter(DOMAIN, request.getDomain());
        }
        if (request.getPeriod() != null) {
            internalRequest.addParameter("period", String.valueOf(request.getPeriod()));
        }
        return this.invokeHttpClient(internalRequest, GetStatSrcFlowResponse.class);
    }

    public GetStatHitRateResponse getStatHitRate(GetStatHitRateRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, STAT, "hitrate");
        if (request.getStartTime() != null) {
            internalRequest.addParameter("startTime", DateUtils.formatAlternateIso8601Date(request.getStartTime()));
        }
        if (request.getEndTime() != null) {
            internalRequest.addParameter("endTime", DateUtils.formatAlternateIso8601Date(request.getEndTime()));
        }
        if (request.getDomain() != null) {
            internalRequest.addParameter(DOMAIN, request.getDomain());
        }
        if (request.getPeriod() != null) {
            internalRequest.addParameter("period", String.valueOf(request.getPeriod()));
        }
        return this.invokeHttpClient(internalRequest, GetStatHitRateResponse.class);
    }

    public GetStatHttpCodeResponse getStatHttpCode(GetStatHttpCodeRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, STAT, "httpcode");
        if (request.getStartTime() != null) {
            internalRequest.addParameter("startTime", DateUtils.formatAlternateIso8601Date(request.getStartTime()));
        }
        if (request.getEndTime() != null) {
            internalRequest.addParameter("endTime", DateUtils.formatAlternateIso8601Date(request.getEndTime()));
        }
        if (request.getDomain() != null) {
            internalRequest.addParameter(DOMAIN, request.getDomain());
        }
        if (request.getPeriod() != null) {
            internalRequest.addParameter("period", String.valueOf(request.getPeriod()));
        }
        if (request.isWithRegion()) {
            internalRequest.addParameter("withRegion", "");
        }
        return this.invokeHttpClient(internalRequest, GetStatHttpCodeResponse.class);
    }

    public GetStatTopUrlResponse getStatTopUrl(GetStatTopUrlRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, STAT, "topn", "url");
        if (request.getStartTime() != null) {
            internalRequest.addParameter("startTime", DateUtils.formatAlternateIso8601Date(request.getStartTime()));
        }
        if (request.getEndTime() != null) {
            internalRequest.addParameter("endTime", DateUtils.formatAlternateIso8601Date(request.getEndTime()));
        }
        if (request.getDomain() != null) {
            internalRequest.addParameter(DOMAIN, request.getDomain());
        }
        if (request.getPeriod() != null) {
            internalRequest.addParameter("period", String.valueOf(request.getPeriod()));
        }
        return this.invokeHttpClient(internalRequest, GetStatTopUrlResponse.class);
    }

    public GetStatTopRefererResponse getStatTopReferer(GetStatTopRefererRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, STAT, "topn", "referer");
        if (request.getStartTime() != null) {
            internalRequest.addParameter("startTime", DateUtils.formatAlternateIso8601Date(request.getStartTime()));
        }
        if (request.getEndTime() != null) {
            internalRequest.addParameter("endTime", DateUtils.formatAlternateIso8601Date(request.getEndTime()));
        }
        if (request.getDomain() != null) {
            internalRequest.addParameter(DOMAIN, request.getDomain());
        }
        if (request.getPeriod() != null) {
            internalRequest.addParameter("period", String.valueOf(request.getPeriod()));
        }
        return this.invokeHttpClient(internalRequest, GetStatTopRefererResponse.class);
    }

    public GetStatUvResponse getStatUv(GetStatUvRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, STAT, "uv");
        if (request.getStartTime() != null) {
            internalRequest.addParameter("startTime", DateUtils.formatAlternateIso8601Date(request.getStartTime()));
        }
        if (request.getEndTime() != null) {
            internalRequest.addParameter("endTime", DateUtils.formatAlternateIso8601Date(request.getEndTime()));
        }
        if (request.getDomain() != null) {
            internalRequest.addParameter(DOMAIN, request.getDomain());
        }
        if (request.getPeriod() != null) {
            internalRequest.addParameter("period", String.valueOf(request.getPeriod()));
        }
        return this.invokeHttpClient(internalRequest, GetStatUvResponse.class);
    }

    public GetStatAvgSpeedResponse getStatAvgSpeed(GetStatAvgSpeedRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, STAT, "avgspeed");
        if (request.getStartTime() != null) {
            internalRequest.addParameter("startTime", DateUtils.formatAlternateIso8601Date(request.getStartTime()));
        }
        if (request.getEndTime() != null) {
            internalRequest.addParameter("endTime", DateUtils.formatAlternateIso8601Date(request.getEndTime()));
        }
        if (request.getDomain() != null) {
            internalRequest.addParameter(DOMAIN, request.getDomain());
        }
        if (request.getPeriod() != null) {
            internalRequest.addParameter("period", String.valueOf(request.getPeriod()));
        }
        return this.invokeHttpClient(internalRequest, GetStatAvgSpeedResponse.class);
    }

    public GetCacheQuotaResponse getCacheQuota() {
        GetCacheQuotaRequest request = new GetCacheQuotaRequest();
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, CACHE, "quota");
        return this.invokeHttpClient(internalRequest, GetCacheQuotaResponse.class);
    }

    public GetCacheQuotaResponse getCacheQuota(GetCacheQuotaRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, CACHE, "quota");
        return this.invokeHttpClient(internalRequest, GetCacheQuotaResponse.class);
    }

    public GetDomainLogResponse getDomainLog(GetDomainLogRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, LOG, request.getDomain(), LOG);
        if (request.getStartTime() != null) {
            internalRequest.addParameter("startTime", DateUtils.formatAlternateIso8601Date(request.getStartTime()));
        }
        if (request.getEndTime() != null) {
            internalRequest.addParameter("endTime", DateUtils.formatAlternateIso8601Date(request.getEndTime()));
        }
        return this.invokeHttpClient(internalRequest, GetDomainLogResponse.class);
    }

    public DescribeIpResponse describeIp(String ip) {
        DescribeIpRequest request = new DescribeIpRequest().withIp(ip);
        return this.describeIp(request);
    }

    public DescribeIpResponse describeIp(DescribeIpRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, UTILS);
        Preconditions.checkNotNull((Object)request.getIp());
        internalRequest.addParameter("action", request.getAction());
        internalRequest.addParameter("ip", request.getIp());
        return this.invokeHttpClient(internalRequest, DescribeIpResponse.class);
    }

    private InternalRequest createRequest(AbstractBceRequest bceRequest, HttpMethodName httpMethod, String ... pathVariables) {
        ArrayList<String> path = new ArrayList<String>();
        path.add(VERSION);
        if (pathVariables != null) {
            for (String pathVariable : pathVariables) {
                path.add(pathVariable);
            }
        }
        URI uri = HttpUtils.appendUri(this.getEndpoint(), path.toArray(new String[path.size()]));
        InternalRequest request = new InternalRequest(httpMethod, uri);
        SignOptions signOptions = new SignOptions();
        signOptions.setHeadersToSign(new HashSet<String>(Arrays.asList(HEADERS_TO_SIGN)));
        request.setSignOptions(signOptions);
        request.setCredentials(bceRequest.getRequestCredentials());
        return request;
    }

    private void attachRequestToBody(AbstractBceRequest request, InternalRequest httpRequest) {
        byte[] content;
        try {
            content = JsonUtils.toJsonString(request).getBytes("utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new BceClientException("utf-8 encoding not supported!", e);
        }
        httpRequest.addHeader("Content-Length", String.valueOf(content.length));
        httpRequest.addHeader("Content-Type", "application/json; charset=utf-8");
        httpRequest.setContent(RestartableInputStream.wrap(content));
    }
}

