/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.HighWaterMarkChangeDetectionPolicy;
import com.azure.search.documents.indexes.models.SqlIntegratedChangeTrackingPolicy;
import java.io.IOException;

public class DataChangeDetectionPolicy
implements JsonSerializable<DataChangeDetectionPolicy> {
    private String odataType = "DataChangeDetectionPolicy";

    public String getOdataType() {
        return this.odataType;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("@odata.type", this.odataType);
        return jsonWriter.writeEndObject();
    }

    public static DataChangeDetectionPolicy fromJson(JsonReader jsonReader) throws IOException {
        return (DataChangeDetectionPolicy)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                DataChangeDetectionPolicy dataChangeDetectionPolicy;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("@odata.type".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("#Microsoft.Azure.Search.HighWaterMarkChangeDetectionPolicy".equals(discriminatorValue)) {
                    dataChangeDetectionPolicy = HighWaterMarkChangeDetectionPolicy.fromJson(readerToUse.reset());
                    return dataChangeDetectionPolicy;
                }
                if ("#Microsoft.Azure.Search.SqlIntegratedChangeTrackingPolicy".equals(discriminatorValue)) {
                    dataChangeDetectionPolicy = SqlIntegratedChangeTrackingPolicy.fromJson(readerToUse.reset());
                    return dataChangeDetectionPolicy;
                }
                dataChangeDetectionPolicy = DataChangeDetectionPolicy.fromJsonKnownDiscriminator(readerToUse.reset());
                return dataChangeDetectionPolicy;
            }
        });
    }

    static DataChangeDetectionPolicy fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (DataChangeDetectionPolicy)jsonReader.readObject(reader -> {
            DataChangeDetectionPolicy deserializedDataChangeDetectionPolicy = new DataChangeDetectionPolicy();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("@odata.type".equals(fieldName)) {
                    deserializedDataChangeDetectionPolicy.odataType = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDataChangeDetectionPolicy;
        });
    }
}

