/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.models;

import com.azure.cosmos.ConsistencyLevel;
import com.azure.cosmos.CosmosDiagnosticsThresholds;
import com.azure.cosmos.CosmosItemSerializer;
import com.azure.cosmos.implementation.ImplementationBridgeHelpers;
import com.azure.cosmos.implementation.RequestOptions;
import com.azure.cosmos.implementation.apachecommons.collections.list.UnmodifiableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class CosmosBatchRequestOptions {
    private ConsistencyLevel consistencyLevel;
    private String sessionToken;
    private Map<String, String> customOptions;
    private CosmosDiagnosticsThresholds thresholds = new CosmosDiagnosticsThresholds();
    private List<String> excludeRegions;
    private CosmosItemSerializer customSerializer;
    private Set<String> keywordIdentifiers;
    private static final Set<String> EMPTY_KEYWORD_IDENTIFIERS = Collections.unmodifiableSet(new HashSet());

    public CosmosBatchRequestOptions() {
    }

    CosmosBatchRequestOptions(CosmosBatchRequestOptions toBeCloned) {
        this.consistencyLevel = toBeCloned.consistencyLevel;
        this.sessionToken = toBeCloned.sessionToken;
        this.customOptions = toBeCloned.customOptions;
        this.thresholds = toBeCloned.thresholds;
        this.customSerializer = toBeCloned.customSerializer;
        if (toBeCloned.excludeRegions != null) {
            this.excludeRegions = new ArrayList<String>(toBeCloned.excludeRegions);
        }
    }

    ConsistencyLevel getConsistencyLevel() {
        return this.consistencyLevel;
    }

    CosmosBatchRequestOptions setConsistencyLevel(ConsistencyLevel consistencyLevel) {
        this.consistencyLevel = consistencyLevel;
        return this;
    }

    public String getSessionToken() {
        return this.sessionToken;
    }

    public CosmosBatchRequestOptions setSessionToken(String sessionToken) {
        this.sessionToken = sessionToken;
        return this;
    }

    public CosmosBatchRequestOptions setDiagnosticsThresholds(CosmosDiagnosticsThresholds operationSpecificThresholds) {
        this.thresholds = operationSpecificThresholds;
        return this;
    }

    public CosmosDiagnosticsThresholds getDiagnosticsThresholds() {
        return this.thresholds;
    }

    RequestOptions toRequestOptions() {
        RequestOptions requestOptions = new RequestOptions();
        requestOptions.setConsistencyLevel(this.getConsistencyLevel());
        requestOptions.setSessionToken(this.sessionToken);
        requestOptions.setDiagnosticsThresholds(this.thresholds);
        requestOptions.setEffectiveItemSerializer(this.customSerializer);
        if (this.customOptions != null) {
            for (Map.Entry<String, String> entry : this.customOptions.entrySet()) {
                requestOptions.setHeader(entry.getKey(), entry.getValue());
            }
        }
        requestOptions.setExcludedRegions(this.excludeRegions);
        requestOptions.setKeywordIdentifiers(this.keywordIdentifiers);
        return requestOptions;
    }

    CosmosBatchRequestOptions setHeader(String name, String value) {
        if (this.customOptions == null) {
            this.customOptions = new HashMap<String, String>();
        }
        this.customOptions.put(name, value);
        return this;
    }

    public CosmosBatchRequestOptions setExcludedRegions(List<String> excludeRegions) {
        this.excludeRegions = excludeRegions;
        return this;
    }

    public List<String> getExcludedRegions() {
        if (this.excludeRegions == null) {
            return null;
        }
        return UnmodifiableList.unmodifiableList(this.excludeRegions);
    }

    public CosmosItemSerializer getCustomItemSerializer() {
        return this.customSerializer;
    }

    public CosmosBatchRequestOptions setCustomItemSerializer(CosmosItemSerializer customItemSerializer) {
        this.customSerializer = customItemSerializer;
        return this;
    }

    Map<String, String> getHeaders() {
        return this.customOptions;
    }

    public CosmosBatchRequestOptions setKeywordIdentifiers(Set<String> keywordIdentifiers) {
        this.keywordIdentifiers = keywordIdentifiers != null ? Collections.unmodifiableSet(keywordIdentifiers) : EMPTY_KEYWORD_IDENTIFIERS;
        return this;
    }

    public Set<String> getKeywordIdentifiers() {
        return this.keywordIdentifiers;
    }

    static void initialize() {
        ImplementationBridgeHelpers.CosmosBatchRequestOptionsHelper.setCosmosBatchRequestOptionsAccessor(new ImplementationBridgeHelpers.CosmosBatchRequestOptionsHelper.CosmosBatchRequestOptionsAccessor(){

            @Override
            public ConsistencyLevel getConsistencyLevel(CosmosBatchRequestOptions cosmosBatchRequestOptions) {
                return cosmosBatchRequestOptions.getConsistencyLevel();
            }

            @Override
            public CosmosBatchRequestOptions setConsistencyLevel(CosmosBatchRequestOptions cosmosBatchRequestOptions, ConsistencyLevel consistencyLevel) {
                return cosmosBatchRequestOptions.setConsistencyLevel(consistencyLevel);
            }

            @Override
            public CosmosBatchRequestOptions setHeader(CosmosBatchRequestOptions cosmosItemRequestOptions, String name, String value) {
                return cosmosItemRequestOptions.setHeader(name, value);
            }

            @Override
            public Map<String, String> getHeader(CosmosBatchRequestOptions cosmosItemRequestOptions) {
                return cosmosItemRequestOptions.getHeaders();
            }

            @Override
            public CosmosBatchRequestOptions clone(CosmosBatchRequestOptions toBeCloned) {
                return new CosmosBatchRequestOptions(toBeCloned);
            }
        });
    }

    static {
        CosmosBatchRequestOptions.initialize();
    }
}

