/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.CosmosException;
import com.azure.cosmos.CosmosRegionSwitchHint;
import com.azure.cosmos.SessionRetryOptions;
import com.azure.cosmos.implementation.Configs;
import com.azure.cosmos.implementation.IRetryPolicy;
import com.azure.cosmos.implementation.ImplementationBridgeHelpers;
import com.azure.cosmos.implementation.RetryContext;
import com.azure.cosmos.implementation.ShouldRetryResult;
import com.azure.cosmos.implementation.directconnectivity.TimeoutHelper;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class SessionTokenMismatchRetryPolicy
implements IRetryPolicy {
    private static final ImplementationBridgeHelpers.CosmosSessionRetryOptionsHelper.CosmosSessionRetryOptionsAccessor sessionRetryOptionsAccessor = ImplementationBridgeHelpers.CosmosSessionRetryOptionsHelper.getCosmosSessionRetryOptionsAccessor();
    private static final Logger LOGGER = LoggerFactory.getLogger(SessionTokenMismatchRetryPolicy.class);
    private static final int BACKOFF_MULTIPLIER = 5;
    private final Duration maximumBackoff;
    private final TimeoutHelper waitTimeTimeoutHelper = new TimeoutHelper(Duration.ofMillis(Configs.getSessionTokenMismatchDefaultWaitTimeInMs()));
    private final AtomicInteger retryCount;
    private Duration currentBackoff;
    private RetryContext retryContext;
    private final AtomicInteger maxRetryAttemptsInCurrentRegion;
    private final CosmosRegionSwitchHint regionSwitchHint;
    private final Duration minInRegionRetryTime;

    public SessionTokenMismatchRetryPolicy(RetryContext retryContext, SessionRetryOptions sessionRetryOptions) {
        this.maximumBackoff = Duration.ofMillis(Configs.getSessionTokenMismatchMaximumBackoffTimeInMs());
        this.retryCount = new AtomicInteger();
        this.retryCount.set(0);
        this.currentBackoff = Duration.ofMillis(Configs.getSessionTokenMismatchInitialBackoffTimeInMs());
        if (sessionRetryOptions != null) {
            this.maxRetryAttemptsInCurrentRegion = new AtomicInteger(sessionRetryOptionsAccessor.getMaxInRegionRetryCount(sessionRetryOptions));
            this.regionSwitchHint = sessionRetryOptionsAccessor.getRegionSwitchHint(sessionRetryOptions);
            this.minInRegionRetryTime = sessionRetryOptionsAccessor.getMinInRegionRetryTime(sessionRetryOptions);
        } else {
            this.maxRetryAttemptsInCurrentRegion = null;
            this.regionSwitchHint = CosmosRegionSwitchHint.LOCAL_REGION_PREFERRED;
            this.minInRegionRetryTime = null;
        }
        this.retryContext = retryContext;
    }

    @Override
    public Mono<ShouldRetryResult> shouldRetry(Exception e) {
        Duration remainingMinRetryTimeInLocalRegion;
        if (!(e instanceof CosmosException)) {
            return Mono.just((Object)ShouldRetryResult.noRetryOnNonRelatedException());
        }
        CosmosException cosmosException = (CosmosException)((Object)e);
        if (cosmosException.getStatusCode() != 404 || cosmosException.getSubStatusCode() != 1002) {
            LOGGER.debug("SessionTokenMismatchRetryPolicy not retrying because StatusCode or SubStatusCode not found.");
            return Mono.just((Object)ShouldRetryResult.noRetryOnNonRelatedException());
        }
        if (this.waitTimeTimeoutHelper.isElapsed()) {
            LOGGER.warn("SessionTokenMismatchRetryPolicy not retrying because it has exceeded the time limit. Retry count = {}", (Object)this.retryCount);
            return Mono.just((Object)ShouldRetryResult.noRetry());
        }
        if (!this.shouldRetryLocally(this.regionSwitchHint, this.retryCount.get())) {
            LOGGER.debug("SessionTokenMismatchRetryPolicy not retrying because it a retry attempt for the current region and fallback to a different region is preferred ");
            return Mono.just((Object)ShouldRetryResult.noRetry());
        }
        Duration effectiveBackoff = Duration.ZERO;
        int attempt = this.retryCount.getAndIncrement();
        if (attempt > 0) {
            effectiveBackoff = SessionTokenMismatchRetryPolicy.getEffectiveBackoff(this.currentBackoff, this.waitTimeTimeoutHelper.getRemainingTime());
            this.currentBackoff = SessionTokenMismatchRetryPolicy.getEffectiveBackoff(Duration.ofMillis(this.currentBackoff.toMillis() * 5L), this.maximumBackoff);
        }
        if (this.regionSwitchHint == CosmosRegionSwitchHint.REMOTE_REGION_PREFERRED && attempt >= this.maxRetryAttemptsInCurrentRegion.get() - 1 && (remainingMinRetryTimeInLocalRegion = this.waitTimeTimeoutHelper.getRemainingTime(this.minInRegionRetryTime)).compareTo(effectiveBackoff) > 0) {
            effectiveBackoff = remainingMinRetryTimeInLocalRegion;
        }
        LOGGER.debug("SessionTokenMismatchRetryPolicy will retry. Retry count = {}.  Backoff time = {} ms", (Object)this.retryCount, (Object)effectiveBackoff.toMillis());
        return Mono.just((Object)ShouldRetryResult.retryAfter(effectiveBackoff));
    }

    @Override
    public RetryContext getRetryContext() {
        return this.retryContext;
    }

    private static Duration getEffectiveBackoff(Duration backoff, Duration remainingTime) {
        if (backoff.compareTo(remainingTime) > 0) {
            return remainingTime;
        }
        return backoff;
    }

    private boolean shouldRetryLocally(CosmosRegionSwitchHint regionSwitchHint, int sessionTokenMismatchRetryAttempts) {
        if (regionSwitchHint != CosmosRegionSwitchHint.REMOTE_REGION_PREFERRED) {
            return true;
        }
        return sessionTokenMismatchRetryAttempts <= this.maxRetryAttemptsInCurrentRegion.get() - 1;
    }
}

