/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.uuid;

import com.azure.cosmos.implementation.uuid.TimestampSynchronizer;
import com.azure.cosmos.implementation.uuid.UUIDClock;
import java.io.IOException;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UUIDTimer {
    private static final Logger logger = LoggerFactory.getLogger(UUIDTimer.class);
    private static final long kClockOffset = 122192928000000000L;
    private static final int kClockMultiplier = 10000;
    private static final long kClockMultiplierL = 10000L;
    private static final long kMaxClockAdvance = 100L;
    protected final TimestampSynchronizer _syncer;
    protected final Random _random;
    protected final UUIDClock _clock;
    private int _clockSequence;
    private long _lastSystemTimestamp = 0L;
    private long _lastUsedTimestamp = 0L;
    private long _firstUnsafeTimestamp = Long.MAX_VALUE;
    private int _clockCounter = 0;
    private static final int MAX_WAIT_COUNT = 50;

    public UUIDTimer(Random rnd, TimestampSynchronizer sync) throws IOException {
        this(rnd, sync, new UUIDClock());
    }

    public UUIDTimer(Random rnd, TimestampSynchronizer sync, UUIDClock clock) throws IOException {
        long lastSaved;
        this._random = rnd;
        this._syncer = sync;
        this._clock = clock;
        this.initCounters(rnd);
        this._lastSystemTimestamp = 0L;
        this._lastUsedTimestamp = 0L;
        if (sync != null && (lastSaved = sync.initialize()) > this._lastUsedTimestamp) {
            this._lastUsedTimestamp = lastSaved;
        }
        this._firstUnsafeTimestamp = 0L;
    }

    private void initCounters(Random rnd) {
        this._clockSequence = rnd.nextInt();
        this._clockCounter = this._clockSequence >> 16 & 0xFF;
    }

    public int getClockSequence() {
        return this._clockSequence & 0xFFFF;
    }

    public synchronized long getTimestamp() {
        long systime = this._clock.currentTimeMillis();
        if (systime < this._lastSystemTimestamp) {
            logger.warn("System time going backwards! (got value {}, last {}", (Object)systime, (Object)this._lastSystemTimestamp);
            this._lastSystemTimestamp = systime;
        }
        if (systime <= this._lastUsedTimestamp) {
            if (this._clockCounter < 10000) {
                systime = this._lastUsedTimestamp;
            } else {
                long actDiff = this._lastUsedTimestamp - systime;
                long origTime = systime;
                systime = this._lastUsedTimestamp + 1L;
                logger.warn("Timestamp over-run: need to reinitialize random sequence");
                this.initCounters(this._random);
                if (actDiff >= 100L) {
                    UUIDTimer.slowDown(origTime, actDiff);
                }
            }
        } else {
            this._clockCounter &= 0xFF;
        }
        this._lastUsedTimestamp = systime;
        if (this._syncer != null && systime >= this._firstUnsafeTimestamp) {
            try {
                this._firstUnsafeTimestamp = this._syncer.update(systime);
            }
            catch (IOException ioe) {
                throw new RuntimeException("Failed to synchronize timestamp: " + ioe);
            }
        }
        systime *= 10000L;
        systime += 122192928000000000L;
        ++this._clockCounter;
        return systime += (long)this._clockCounter;
    }

    protected final void getAndSetTimestamp(byte[] uuidBytes) {
        long timestamp = this.getTimestamp();
        uuidBytes[8] = (byte)this._clockSequence;
        uuidBytes[9] = (byte)(this._clockSequence >> 8);
        int clockHi = (int)(timestamp >>> 32);
        int clockLo = (int)timestamp;
        uuidBytes[6] = (byte)(clockHi >>> 24);
        uuidBytes[7] = (byte)(clockHi >>> 16);
        uuidBytes[4] = (byte)(clockHi >>> 8);
        uuidBytes[5] = (byte)clockHi;
        uuidBytes[0] = (byte)(clockLo >>> 24);
        uuidBytes[1] = (byte)(clockLo >>> 16);
        uuidBytes[2] = (byte)(clockLo >>> 8);
        uuidBytes[3] = (byte)clockLo;
    }

    protected static void slowDown(long startTime, long actDiff) {
        long ratio = actDiff / 100L;
        long delay = ratio < 2L ? 1L : (ratio < 10L ? 2L : (ratio < 600L ? 3L : 5L));
        logger.warn("Need to wait for {} milliseconds; virtual clock advanced too far in the future", (Object)delay);
        long waitUntil = startTime + delay;
        int counter = 0;
        do {
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            delay = 1L;
        } while (++counter <= 50 && System.currentTimeMillis() < waitUntil);
    }
}

