/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.patch;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.CosmosPatchOperations;
import com.azure.cosmos.implementation.JsonSerializable;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.patch.PatchOperation;
import com.azure.cosmos.implementation.patch.PatchOperationCore;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.List;

public final class PatchUtil {
    public static <T> JsonSerializable serializableBatchPatchOperation(T item) {
        if (item instanceof CosmosPatchOperations) {
            return PatchUtil.cosmosPatchToJsonSerializable((CosmosPatchOperations)item);
        }
        throw new UnsupportedOperationException("Unknown Patch operations.");
    }

    public static byte[] serializeCosmosPatchToByteArray(CosmosPatchOperations cosmosPatchOperations) {
        byte[] serializedBody;
        JsonSerializable jsonSerializable = PatchUtil.cosmosPatchToJsonSerializable(cosmosPatchOperations);
        try {
            serializedBody = Utils.getSimpleObjectMapper().writeValueAsBytes((Object)jsonSerializable.getPropertyBag());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Can't serialize the object into the byte array", e);
        }
        return serializedBody;
    }

    private static JsonSerializable cosmosPatchToJsonSerializable(CosmosPatchOperations cosmosPatchOperations) {
        JsonSerializable jsonSerializable = new JsonSerializable();
        ArrayNode operations = Utils.getSimpleObjectMapper().createArrayNode();
        List<PatchOperation> patchOperations = BridgeInternal.getPatchOperationsFromCosmosPatch(cosmosPatchOperations);
        for (PatchOperation patchOperation : patchOperations) {
            JsonSerializable operationJsonSerializable = new JsonSerializable();
            operationJsonSerializable.set("op", patchOperation.getOperationType().getOperationValue());
            if (!(patchOperation instanceof PatchOperationCore)) {
                throw new IllegalArgumentException("Invalid patch operation type");
            }
            operationJsonSerializable.set("path", ((PatchOperationCore)patchOperation).getPath());
            operationJsonSerializable.set("value", ((PatchOperationCore)patchOperation).getResource());
            operations.add((JsonNode)operationJsonSerializable.getPropertyBag());
        }
        jsonSerializable.set("operations", operations);
        return jsonSerializable;
    }
}

