/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.batch;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.CosmosAsyncContainer;
import com.azure.cosmos.CosmosBridgeInternal;
import com.azure.cosmos.CosmosItemOperation;
import com.azure.cosmos.TransactionalBatch;
import com.azure.cosmos.TransactionalBatchRequestOptions;
import com.azure.cosmos.TransactionalBatchResponse;
import com.azure.cosmos.implementation.batch.SinglePartitionKeyServerBatchRequest;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import java.util.List;
import reactor.core.publisher.Mono;

public final class BatchExecutor {
    private final CosmosAsyncContainer container;
    private final TransactionalBatchRequestOptions options;
    private final TransactionalBatch transactionalBatch;

    public BatchExecutor(CosmosAsyncContainer container, TransactionalBatch transactionalBatch, TransactionalBatchRequestOptions options) {
        this.container = container;
        this.transactionalBatch = transactionalBatch;
        this.options = options;
    }

    public final Mono<TransactionalBatchResponse> executeAsync() {
        List<CosmosItemOperation> operations = this.transactionalBatch.getOperations();
        Preconditions.checkArgument(operations.size() > 0, "Number of operations should be more than 0.");
        SinglePartitionKeyServerBatchRequest request = SinglePartitionKeyServerBatchRequest.createBatchRequest(this.transactionalBatch.getPartitionKeyValue(), operations);
        request.setAtomicBatch(true);
        request.setShouldContinueOnError(false);
        return CosmosBridgeInternal.getAsyncDocumentClient(this.container.getDatabase()).executeBatchRequest(BridgeInternal.getLink(this.container), request, BridgeInternal.toRequestOptions(this.options), false);
    }
}

