/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.core.http.ProxyOptions;
import java.time.Duration;

public final class GatewayConnectionConfig {
    private static final Duration DEFAULT_REQUEST_TIMEOUT = Duration.ofSeconds(5L);
    private static final Duration DEFAULT_IDLE_CONNECTION_TIMEOUT = Duration.ofSeconds(60L);
    private static final int DEFAULT_MAX_CONNECTION_POOL_SIZE = 1000;
    private Duration requestTimeout;
    private int maxConnectionPoolSize = 1000;
    private Duration idleConnectionTimeout = DEFAULT_IDLE_CONNECTION_TIMEOUT;
    private ProxyOptions proxy;

    public GatewayConnectionConfig() {
        this.requestTimeout = DEFAULT_REQUEST_TIMEOUT;
    }

    public static GatewayConnectionConfig getDefaultConfig() {
        return new GatewayConnectionConfig();
    }

    Duration getRequestTimeout() {
        return this.requestTimeout;
    }

    GatewayConnectionConfig setRequestTimeout(Duration requestTimeout) {
        this.requestTimeout = requestTimeout;
        return this;
    }

    public int getMaxConnectionPoolSize() {
        return this.maxConnectionPoolSize;
    }

    public GatewayConnectionConfig setMaxConnectionPoolSize(int maxConnectionPoolSize) {
        this.maxConnectionPoolSize = maxConnectionPoolSize;
        return this;
    }

    public Duration getIdleConnectionTimeout() {
        return this.idleConnectionTimeout;
    }

    public GatewayConnectionConfig setIdleConnectionTimeout(Duration idleConnectionTimeout) {
        this.idleConnectionTimeout = idleConnectionTimeout;
        return this;
    }

    public ProxyOptions getProxy() {
        return this.proxy;
    }

    public GatewayConnectionConfig setProxy(ProxyOptions proxy) {
        if (proxy.getType() != ProxyOptions.Type.HTTP) {
            throw new IllegalArgumentException("Only http proxy type is supported.");
        }
        this.proxy = proxy;
        return this;
    }

    public String toString() {
        String proxyType = this.proxy != null ? this.proxy.getType().toString() : null;
        String proxyAddress = this.proxy != null ? this.proxy.getAddress().toString() : null;
        return "GatewayConnectionConfig{, maxConnectionPoolSize=" + this.maxConnectionPoolSize + ", idleConnectionTimeout=" + this.idleConnectionTimeout + ", proxyType=" + proxyType + ", inetSocketProxyAddress=" + proxyAddress + '}';
    }
}

