/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import java.util.HashMap;
import java.util.Map;

public enum ConsistencyLevel {
    STRONG("Strong"),
    BOUNDED_STALENESS("BoundedStaleness"),
    SESSION("Session"),
    EVENTUAL("Eventual"),
    CONSISTENT_PREFIX("ConsistentPrefix");

    private static Map<String, ConsistencyLevel> consistencyLevelHashMap;
    private final String overWireValue;

    private ConsistencyLevel(String overWireValue) {
        this.overWireValue = overWireValue;
    }

    static ConsistencyLevel fromServiceSerializedFormat(String consistencyLevel) {
        return consistencyLevelHashMap.get(consistencyLevel);
    }

    public String toString() {
        return this.overWireValue;
    }

    static {
        consistencyLevelHashMap = new HashMap<String, ConsistencyLevel>();
        for (ConsistencyLevel cl : ConsistencyLevel.values()) {
            consistencyLevelHashMap.put(cl.toString(), cl);
        }
    }
}

