/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.management.implementation.polling;

import com.azure.core.http.HttpHeaders;
import com.azure.core.util.logging.ClientLogger;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

class Util {
    Util() {
    }

    static URL getAzureAsyncOperationUrl(HttpHeaders headers, ClientLogger logger) {
        return Util.getUrl("Azure-AsyncOperation", headers, logger, false);
    }

    static URL getAzureAsyncOperationUrl(HttpHeaders headers, ClientLogger logger, boolean ignoreException) {
        return Util.getUrl("Azure-AsyncOperation", headers, logger, ignoreException);
    }

    static URL getLocationUrl(HttpHeaders headers, ClientLogger logger) {
        return Util.getUrl("Location", headers, logger, false);
    }

    static URL getLocationUrl(HttpHeaders headers, ClientLogger logger, boolean ignoreException) {
        return Util.getUrl("Location", headers, logger, ignoreException);
    }

    private static URL getUrl(String urlHeaderName, HttpHeaders headers, ClientLogger logger, boolean ignoreException) {
        String value = headers.getValue(urlHeaderName);
        if (value != null) {
            try {
                return new URI(value).toURL();
            }
            catch (IllegalArgumentException | MalformedURLException | URISyntaxException me) {
                String message = "Malformed value '" + value + "' for URL header: '" + urlHeaderName + "'.";
                if (ignoreException) {
                    logger.logExceptionAsError((RuntimeException)new MalformedUrlException(message, me));
                }
                throw logger.logExceptionAsError((RuntimeException)new MalformedUrlException(message, me));
            }
        }
        return null;
    }

    static class MalformedUrlException
    extends RuntimeException {
        MalformedUrlException(String message) {
            super(message);
        }

        MalformedUrlException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

