/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.okhttp;

import com.azure.core.http.HttpClient;
import com.azure.core.http.ProxyOptions;
import com.azure.core.http.okhttp.OkHttpAsyncHttpClient;
import com.azure.core.http.okhttp.implementation.OkHttpProxySelector;
import com.azure.core.http.okhttp.implementation.ProxyAuthenticator;
import com.azure.core.implementation.util.HttpUtils;
import com.azure.core.util.Configuration;
import com.azure.core.util.logging.ClientLogger;
import java.net.ProxySelector;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import okhttp3.Authenticator;
import okhttp3.ConnectionPool;
import okhttp3.Dispatcher;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;

public class OkHttpAsyncHttpClientBuilder {
    private static final ClientLogger LOGGER = new ClientLogger(OkHttpAsyncHttpClientBuilder.class);
    private final OkHttpClient okHttpClient;
    private List<Interceptor> networkInterceptors = new ArrayList<Interceptor>();
    private Duration readTimeout;
    private Duration responseTimeout;
    private Duration writeTimeout;
    private Duration connectionTimeout;
    private Duration callTimeout;
    private ConnectionPool connectionPool;
    private Dispatcher dispatcher;
    private ProxyOptions proxyOptions;
    private Configuration configuration;
    private boolean followRedirects;

    public OkHttpAsyncHttpClientBuilder() {
        this.okHttpClient = null;
    }

    public OkHttpAsyncHttpClientBuilder(OkHttpClient okHttpClient) {
        this.okHttpClient = Objects.requireNonNull(okHttpClient, "'okHttpClient' cannot be null.");
    }

    public OkHttpAsyncHttpClientBuilder addNetworkInterceptor(Interceptor networkInterceptor) {
        Objects.requireNonNull(networkInterceptor, "'networkInterceptor' cannot be null.");
        this.networkInterceptors.add(networkInterceptor);
        return this;
    }

    public OkHttpAsyncHttpClientBuilder networkInterceptors(List<Interceptor> networkInterceptors) {
        this.networkInterceptors = Objects.requireNonNull(networkInterceptors, "'networkInterceptors' cannot be null.");
        return this;
    }

    public OkHttpAsyncHttpClientBuilder readTimeout(Duration readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    public OkHttpAsyncHttpClientBuilder responseTimeout(Duration responseTimeout) {
        this.responseTimeout = responseTimeout;
        return this;
    }

    public OkHttpAsyncHttpClientBuilder writeTimeout(Duration writeTimeout) {
        this.writeTimeout = writeTimeout;
        return this;
    }

    public OkHttpAsyncHttpClientBuilder connectionTimeout(Duration connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        return this;
    }

    public OkHttpAsyncHttpClientBuilder callTimeout(Duration callTimeout) {
        if (callTimeout != null && callTimeout.isNegative()) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'callTimeout' cannot be negative"));
        }
        this.callTimeout = callTimeout;
        return this;
    }

    public OkHttpAsyncHttpClientBuilder connectionPool(ConnectionPool connectionPool) {
        this.connectionPool = Objects.requireNonNull(connectionPool, "'connectionPool' cannot be null.");
        return this;
    }

    public OkHttpAsyncHttpClientBuilder dispatcher(Dispatcher dispatcher) {
        this.dispatcher = Objects.requireNonNull(dispatcher, "'dispatcher' cannot be null.");
        return this;
    }

    public OkHttpAsyncHttpClientBuilder proxy(ProxyOptions proxyOptions) {
        this.proxyOptions = proxyOptions;
        return this;
    }

    public OkHttpAsyncHttpClientBuilder configuration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public OkHttpAsyncHttpClientBuilder followRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
        return this;
    }

    public HttpClient build() {
        ProxyOptions buildProxyOptions;
        OkHttpClient.Builder httpClientBuilder = this.okHttpClient == null ? new OkHttpClient.Builder() : this.okHttpClient.newBuilder();
        for (Interceptor interceptor : this.networkInterceptors) {
            httpClientBuilder.addNetworkInterceptor(interceptor);
        }
        httpClientBuilder.connectTimeout(HttpUtils.getTimeout((Duration)this.connectionTimeout, (Duration)HttpUtils.getDefaultConnectTimeout())).writeTimeout(HttpUtils.getTimeout((Duration)this.writeTimeout, (Duration)HttpUtils.getDefaultWriteTimeout())).readTimeout(HttpUtils.getTimeout((Duration)this.readTimeout, (Duration)HttpUtils.getDefaultReadTimeout()));
        if (this.callTimeout != null) {
            httpClientBuilder.callTimeout(this.callTimeout);
        }
        if (this.connectionPool != null) {
            httpClientBuilder.connectionPool(this.connectionPool);
        }
        if (this.dispatcher != null) {
            httpClientBuilder.dispatcher(this.dispatcher);
        }
        Configuration buildConfiguration = this.configuration == null ? Configuration.getGlobalConfiguration() : this.configuration;
        ProxyOptions proxyOptions = buildProxyOptions = this.proxyOptions == null ? ProxyOptions.fromConfiguration((Configuration)buildConfiguration, (boolean)true) : this.proxyOptions;
        if (buildProxyOptions != null) {
            httpClientBuilder.proxySelector((ProxySelector)new OkHttpProxySelector(buildProxyOptions.getType().toProxyType(), () -> ((ProxyOptions)buildProxyOptions).getAddress(), buildProxyOptions.getNonProxyHosts()));
            if (buildProxyOptions.getUsername() != null) {
                ProxyAuthenticator proxyAuthenticator = new ProxyAuthenticator(buildProxyOptions.getUsername(), buildProxyOptions.getPassword());
                httpClientBuilder.proxyAuthenticator((Authenticator)proxyAuthenticator).addInterceptor(proxyAuthenticator.getProxyAuthenticationInfoInterceptor());
            }
        }
        httpClientBuilder.followRedirects(this.followRedirects);
        return new OkHttpAsyncHttpClient(httpClientBuilder.build(), HttpUtils.getTimeout((Duration)this.responseTimeout, (Duration)HttpUtils.getDefaultResponseTimeout()));
    }
}

