/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util.io;

import com.azure.core.http.rest.StreamResponse;
import com.azure.core.implementation.AsynchronousFileChannelAdapter;
import com.azure.core.implementation.ByteCountingAsynchronousByteChannel;
import com.azure.core.util.ProgressReporter;
import com.azure.core.util.logging.ClientLogger;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousByteChannel;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.CompletionHandler;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Objects;
import java.util.function.BiFunction;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;

public final class IOUtils {
    private static final ClientLogger LOGGER = new ClientLogger(IOUtils.class);
    private static final int DEFAULT_BUFFER_SIZE = 8192;

    public static AsynchronousByteChannel toAsynchronousByteChannel(AsynchronousFileChannel fileChannel, long position) {
        Objects.requireNonNull(fileChannel, "'fileChannel' must not be null");
        if (position < 0L) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("'position' cannot be less than 0."));
        }
        return new AsynchronousFileChannelAdapter(fileChannel, position);
    }

    public static void transfer(ReadableByteChannel source, WritableByteChannel destination) throws IOException {
        int read;
        Objects.requireNonNull(source, "'source' must not be null");
        Objects.requireNonNull(source, "'destination' must not be null");
        ByteBuffer buffer = ByteBuffer.allocate(8192);
        do {
            buffer.clear();
            read = source.read(buffer);
            buffer.flip();
            while (buffer.hasRemaining()) {
                destination.write(buffer);
            }
        } while (read >= 0);
    }

    public static Mono<Void> transferAsync(ReadableByteChannel source, AsynchronousByteChannel destination) {
        Objects.requireNonNull(source, "'source' must not be null");
        Objects.requireNonNull(source, "'destination' must not be null");
        return Mono.create(sink -> sink.onRequest(value -> {
            ByteBuffer buffer = ByteBuffer.allocate(8192);
            try {
                IOUtils.transferAsynchronously(source, destination, buffer, (MonoSink<Void>)sink);
            }
            catch (IOException e) {
                sink.error((Throwable)e);
            }
        }));
    }

    private static void transferAsynchronously(final ReadableByteChannel source, final AsynchronousByteChannel destination, final ByteBuffer buffer, final MonoSink<Void> sink) throws IOException {
        buffer.clear();
        int read = source.read(buffer);
        if (read >= 0) {
            buffer.flip();
            destination.write(buffer, buffer, new CompletionHandler<Integer, ByteBuffer>(){

                @Override
                public void completed(Integer result, ByteBuffer attachment) {
                    try {
                        if (buffer.hasRemaining()) {
                            destination.write(buffer, buffer, this);
                        } else {
                            IOUtils.transferAsynchronously(source, destination, buffer, (MonoSink<Void>)sink);
                        }
                    }
                    catch (IOException e) {
                        sink.error((Throwable)e);
                    }
                }

                @Override
                public void failed(Throwable e, ByteBuffer attachment) {
                    sink.error(e);
                }
            });
        } else {
            sink.success();
        }
    }

    public static Mono<Void> transferStreamResponseToAsynchronousByteChannel(AsynchronousByteChannel targetChannel, StreamResponse sourceResponse, BiFunction<Throwable, Long, Mono<StreamResponse>> onErrorResume, ProgressReporter progressReporter, int maxRetries) {
        return IOUtils.transferStreamResponseToAsynchronousByteChannelHelper(new ByteCountingAsynchronousByteChannel(targetChannel, null, progressReporter), sourceResponse, onErrorResume, maxRetries, 0);
    }

    private static Mono<Void> transferStreamResponseToAsynchronousByteChannelHelper(ByteCountingAsynchronousByteChannel targetChannel, StreamResponse response, BiFunction<Throwable, Long, Mono<StreamResponse>> onErrorResume, int maxRetries, int retryCount) {
        return response.writeValueToAsync(targetChannel).doFinally(ignored -> response.close()).onErrorResume(Exception.class, exception -> {
            response.close();
            int updatedRetryCount = retryCount + 1;
            if (updatedRetryCount > maxRetries) {
                LOGGER.atError().addKeyValue("tryCount", retryCount).log(() -> "Retry attempts have been exhausted.", (Throwable)exception);
                return Mono.error((Throwable)exception);
            }
            LOGGER.atInfo().addKeyValue("tryCount", retryCount).log(() -> String.format("Using retry attempt %d of %d.", updatedRetryCount, maxRetries), (Throwable)exception);
            return ((Mono)onErrorResume.apply((Throwable)exception, targetChannel.getBytesWritten())).flatMap(newResponse -> IOUtils.transferStreamResponseToAsynchronousByteChannelHelper(targetChannel, newResponse, onErrorResume, maxRetries, updatedRetryCount));
        });
    }

    private IOUtils() {
    }
}

