/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.models;

import com.azure.ai.openai.implementation.models.FunctionCallPreset;
import com.azure.ai.openai.models.AzureChatEnhancementConfiguration;
import com.azure.ai.openai.models.AzureChatExtensionConfiguration;
import com.azure.ai.openai.models.ChatCompletionsResponseFormat;
import com.azure.ai.openai.models.ChatCompletionsToolDefinition;
import com.azure.ai.openai.models.ChatRequestMessage;
import com.azure.ai.openai.models.FunctionCallConfig;
import com.azure.ai.openai.models.FunctionDefinition;
import com.azure.ai.openai.models.FunctionName;
import com.azure.core.util.BinaryData;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

public final class ChatCompletionsOptions {
    @JsonProperty(value="messages")
    private List<ChatRequestMessage> messages;
    @JsonProperty(value="max_tokens")
    private Integer maxTokens;
    @JsonProperty(value="temperature")
    private Double temperature;
    @JsonProperty(value="top_p")
    private Double topP;
    @JsonProperty(value="logit_bias")
    private Map<String, Integer> logitBias;
    @JsonProperty(value="user")
    private String user;
    @JsonProperty(value="n")
    private Integer n;
    @JsonProperty(value="stop")
    private List<String> stop;
    @JsonProperty(value="presence_penalty")
    private Double presencePenalty;
    @JsonProperty(value="frequency_penalty")
    private Double frequencyPenalty;
    @JsonProperty(value="stream")
    private Boolean stream;
    @JsonProperty(value="model")
    private String model;
    @JsonProperty(value="functions")
    private List<FunctionDefinition> functions;
    @JsonProperty(value="function_call")
    private BinaryData functionCall;
    @JsonIgnore
    private FunctionCallConfig functionCallConfig;
    @JsonProperty(value="data_sources")
    private List<AzureChatExtensionConfiguration> dataSources;
    @JsonProperty(value="enhancements")
    private AzureChatEnhancementConfiguration enhancements;
    @JsonProperty(value="seed")
    private Long seed;
    @JsonProperty(value="response_format")
    private ChatCompletionsResponseFormat responseFormat;
    @JsonProperty(value="tools")
    private List<ChatCompletionsToolDefinition> tools;
    @JsonProperty(value="tool_choice")
    private BinaryData toolChoice;
    @JsonProperty(value="logprobs")
    private Boolean logprobs;
    @JsonProperty(value="top_logprobs")
    private Integer topLogprobs;

    @JsonCreator
    public ChatCompletionsOptions(@JsonProperty(value="messages") List<ChatRequestMessage> messages) {
        this.messages = messages;
    }

    public List<ChatRequestMessage> getMessages() {
        return this.messages;
    }

    public Integer getMaxTokens() {
        return this.maxTokens;
    }

    public ChatCompletionsOptions setMaxTokens(Integer maxTokens) {
        this.maxTokens = maxTokens;
        return this;
    }

    public Double getTemperature() {
        return this.temperature;
    }

    public ChatCompletionsOptions setTemperature(Double temperature) {
        this.temperature = temperature;
        return this;
    }

    public Double getTopP() {
        return this.topP;
    }

    public ChatCompletionsOptions setTopP(Double topP) {
        this.topP = topP;
        return this;
    }

    public Map<String, Integer> getLogitBias() {
        return this.logitBias;
    }

    public ChatCompletionsOptions setLogitBias(Map<String, Integer> logitBias) {
        this.logitBias = logitBias;
        return this;
    }

    public String getUser() {
        return this.user;
    }

    public ChatCompletionsOptions setUser(String user) {
        this.user = user;
        return this;
    }

    public Integer getN() {
        return this.n;
    }

    public ChatCompletionsOptions setN(Integer n) {
        this.n = n;
        return this;
    }

    public List<String> getStop() {
        return this.stop;
    }

    public ChatCompletionsOptions setStop(List<String> stop) {
        this.stop = stop;
        return this;
    }

    public Double getPresencePenalty() {
        return this.presencePenalty;
    }

    public ChatCompletionsOptions setPresencePenalty(Double presencePenalty) {
        this.presencePenalty = presencePenalty;
        return this;
    }

    public Double getFrequencyPenalty() {
        return this.frequencyPenalty;
    }

    public ChatCompletionsOptions setFrequencyPenalty(Double frequencyPenalty) {
        this.frequencyPenalty = frequencyPenalty;
        return this;
    }

    public Boolean isStream() {
        return this.stream;
    }

    public ChatCompletionsOptions setStream(Boolean stream) {
        this.stream = stream;
        return this;
    }

    public String getModel() {
        return this.model;
    }

    public ChatCompletionsOptions setModel(String model) {
        this.model = model;
        return this;
    }

    public List<FunctionDefinition> getFunctions() {
        return this.functions;
    }

    public ChatCompletionsOptions setFunctions(List<FunctionDefinition> functions) {
        this.functions = functions;
        return this;
    }

    BinaryData getFunctionCallInternal() {
        return this.functionCall;
    }

    ChatCompletionsOptions setFunctionCallInternal(BinaryData functionCall) {
        this.functionCall = functionCall;
        return this;
    }

    public FunctionCallConfig getFunctionCall() {
        return this.functionCallConfig;
    }

    public ChatCompletionsOptions setFunctionCall(FunctionCallConfig functionCallConfig) {
        this.functionCallConfig = functionCallConfig;
        this.functionCall = FunctionCallPreset.values().stream().anyMatch(preset -> preset.toString().equals(functionCallConfig.getName())) ? BinaryData.fromObject((Object)((Object)FunctionCallPreset.fromString(this.functionCallConfig.getName()))) : BinaryData.fromObject((Object)new FunctionName(this.functionCallConfig.getName()));
        return this;
    }

    public List<AzureChatExtensionConfiguration> getDataSources() {
        return this.dataSources;
    }

    public ChatCompletionsOptions setDataSources(List<AzureChatExtensionConfiguration> dataSources) {
        this.dataSources = dataSources;
        return this;
    }

    public AzureChatEnhancementConfiguration getEnhancements() {
        return this.enhancements;
    }

    public ChatCompletionsOptions setEnhancements(AzureChatEnhancementConfiguration enhancements) {
        this.enhancements = enhancements;
        return this;
    }

    public Long getSeed() {
        return this.seed;
    }

    public ChatCompletionsOptions setSeed(Long seed) {
        this.seed = seed;
        return this;
    }

    public ChatCompletionsResponseFormat getResponseFormat() {
        return this.responseFormat;
    }

    public ChatCompletionsOptions setResponseFormat(ChatCompletionsResponseFormat responseFormat) {
        this.responseFormat = responseFormat;
        return this;
    }

    public List<ChatCompletionsToolDefinition> getTools() {
        return this.tools;
    }

    public ChatCompletionsOptions setTools(List<ChatCompletionsToolDefinition> tools) {
        this.tools = tools;
        return this;
    }

    public BinaryData getToolChoice() {
        return this.toolChoice;
    }

    public ChatCompletionsOptions setToolChoice(BinaryData toolChoice) {
        this.toolChoice = toolChoice;
        return this;
    }

    public Boolean isLogprobs() {
        return this.logprobs;
    }

    public ChatCompletionsOptions setLogprobs(Boolean logprobs) {
        this.logprobs = logprobs;
        return this;
    }

    public Integer getTopLogprobs() {
        return this.topLogprobs;
    }

    public ChatCompletionsOptions setTopLogprobs(Integer topLogprobs) {
        this.topLogprobs = topLogprobs;
        return this;
    }
}

