/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.responses.models;

import com.azure.ai.openai.responses.models.ResponsesComputerCallActionType;
import com.azure.ai.openai.responses.models.ResponsesComputerCallItemAction;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class ResponsesComputerCallDoubleClickAction
extends ResponsesComputerCallItemAction {
    private ResponsesComputerCallActionType type = ResponsesComputerCallActionType.DOUBLE_CLICK;
    private final int x;
    private final int y;

    public ResponsesComputerCallDoubleClickAction(int x, int y) {
        this.x = x;
        this.y = y;
    }

    @Override
    public ResponsesComputerCallActionType getType() {
        return this.type;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("x", this.x);
        jsonWriter.writeIntField("y", this.y);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    public static ResponsesComputerCallDoubleClickAction fromJson(JsonReader jsonReader) throws IOException {
        return (ResponsesComputerCallDoubleClickAction)jsonReader.readObject(reader -> {
            int x = 0;
            int y = 0;
            ResponsesComputerCallActionType type = ResponsesComputerCallActionType.DOUBLE_CLICK;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("x".equals(fieldName)) {
                    x = reader.getInt();
                    continue;
                }
                if ("y".equals(fieldName)) {
                    y = reader.getInt();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = ResponsesComputerCallActionType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            ResponsesComputerCallDoubleClickAction deserializedResponsesComputerCallDoubleClickAction = new ResponsesComputerCallDoubleClickAction(x, y);
            deserializedResponsesComputerCallDoubleClickAction.type = type;
            return deserializedResponsesComputerCallDoubleClickAction;
        });
    }
}

