/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.models;

import com.azure.ai.openai.models.InputAudioFormat;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Base64;

public final class InputAudioContent
implements JsonSerializable<InputAudioContent> {
    private final String data;
    private final InputAudioFormat format;

    public InputAudioContent(String data, InputAudioFormat format) {
        this.data = data;
        this.format = format;
    }

    public InputAudioContent(byte[] data, InputAudioFormat format) {
        this.data = Base64.getEncoder().encodeToString(data);
        this.format = format;
    }

    public String getData() {
        return this.data;
    }

    public InputAudioFormat getFormat() {
        return this.format;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("data", this.data);
        jsonWriter.writeStringField("format", this.format == null ? null : this.format.toString());
        return jsonWriter.writeEndObject();
    }

    public static InputAudioContent fromJson(JsonReader jsonReader) throws IOException {
        return (InputAudioContent)jsonReader.readObject(reader -> {
            String data = null;
            InputAudioFormat format = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("data".equals(fieldName)) {
                    data = reader.getString();
                    continue;
                }
                if ("format".equals(fieldName)) {
                    format = InputAudioFormat.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return new InputAudioContent(data, format);
        });
    }
}

