/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.implementation;

import com.azure.core.http.rest.RequestOptions;
import com.azure.core.util.ServiceVersion;

public final class OpenAIUtils {
    private static final String OPEN_AI_ENDPOINT = "https://api.openai.com";

    private OpenAIUtils() {
    }

    public static void addAzureVersionToRequestOptions(String endpoint, RequestOptions requestOptions, ServiceVersion serviceVersion) {
        if (OpenAIUtils.useAzureOpenAIService(endpoint)) {
            requestOptions.addQueryParam("api-version", serviceVersion.getVersion());
        }
    }

    public static boolean useAzureOpenAIService(String endpoint) {
        return endpoint != null && !endpoint.startsWith(OPEN_AI_ENDPOINT);
    }
}

