/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.implementation;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.management.Resource;
import com.azure.resourcemanager.containerregistry.ContainerRegistryManager;
import com.azure.resourcemanager.containerregistry.fluent.ContainerRegistryManagementClient;
import com.azure.resourcemanager.containerregistry.fluent.models.RegistryInner;
import com.azure.resourcemanager.containerregistry.fluent.models.RunInner;
import com.azure.resourcemanager.containerregistry.fluent.models.SourceUploadDefinitionInner;
import com.azure.resourcemanager.containerregistry.implementation.RegistryTaskRunImpl;
import com.azure.resourcemanager.containerregistry.implementation.SourceUploadDefinitionImpl;
import com.azure.resourcemanager.containerregistry.implementation.WebhookImpl;
import com.azure.resourcemanager.containerregistry.implementation.WebhookOperationsImpl;
import com.azure.resourcemanager.containerregistry.implementation.WebhooksImpl;
import com.azure.resourcemanager.containerregistry.models.AccessKeyType;
import com.azure.resourcemanager.containerregistry.models.PublicNetworkAccess;
import com.azure.resourcemanager.containerregistry.models.Registry;
import com.azure.resourcemanager.containerregistry.models.RegistryCredentials;
import com.azure.resourcemanager.containerregistry.models.RegistryTaskRun;
import com.azure.resourcemanager.containerregistry.models.RegistryUpdateParameters;
import com.azure.resourcemanager.containerregistry.models.RegistryUsage;
import com.azure.resourcemanager.containerregistry.models.Sku;
import com.azure.resourcemanager.containerregistry.models.SkuName;
import com.azure.resourcemanager.containerregistry.models.SourceUploadDefinition;
import com.azure.resourcemanager.containerregistry.models.WebhookOperations;
import com.azure.resourcemanager.resources.fluentcore.arm.Manager;
import com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import com.azure.resourcemanager.resources.fluentcore.model.implementation.IndexableRefreshableWrapperImpl;
import java.time.OffsetDateTime;
import java.util.Collection;
import reactor.core.publisher.Mono;

public class RegistryImpl
extends GroupableResourceImpl<Registry, RegistryInner, RegistryImpl, ContainerRegistryManager>
implements Registry,
Registry.Definition,
Registry.Update {
    private RegistryUpdateParameters updateParameters;
    private WebhooksImpl webhooks = new WebhooksImpl(this, "Webhook");

    protected RegistryImpl(String name, RegistryInner innerObject, ContainerRegistryManager manager) {
        super(name, (Resource)innerObject, (Manager)manager);
    }

    protected Mono<RegistryInner> getInnerAsync() {
        return ((ContainerRegistryManagementClient)((ContainerRegistryManager)this.manager()).serviceClient()).getRegistries().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    public RegistryImpl update() {
        this.updateParameters = new RegistryUpdateParameters();
        return (RegistryImpl)super.update();
    }

    public Mono<Registry> createResourceAsync() {
        RegistryImpl self = this;
        if (this.isInCreateMode()) {
            return ((ContainerRegistryManagementClient)((ContainerRegistryManager)this.manager()).serviceClient()).getRegistries().createAsync(self.resourceGroupName(), self.name(), (RegistryInner)((Object)self.innerModel())).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this));
        }
        this.updateParameters.withTags(((RegistryInner)((Object)this.innerModel())).tags());
        return ((ContainerRegistryManagementClient)((ContainerRegistryManager)this.manager()).serviceClient()).getRegistries().updateAsync(self.resourceGroupName(), self.name(), self.updateParameters).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this));
    }

    public Mono<Void> afterPostRunAsync(boolean isGroupFaulted) {
        this.webhooks.clear();
        return Mono.empty();
    }

    @Override
    public Sku sku() {
        return ((RegistryInner)((Object)this.innerModel())).sku();
    }

    @Override
    public String loginServerUrl() {
        return ((RegistryInner)((Object)this.innerModel())).loginServer();
    }

    @Override
    public OffsetDateTime creationDate() {
        return ((RegistryInner)((Object)this.innerModel())).creationDate();
    }

    @Override
    public boolean adminUserEnabled() {
        return ((RegistryInner)((Object)this.innerModel())).adminUserEnabled();
    }

    @Override
    public RegistryImpl withBasicSku() {
        return this.setManagedSku(new Sku().withName(SkuName.BASIC));
    }

    @Override
    public RegistryImpl withStandardSku() {
        return this.setManagedSku(new Sku().withName(SkuName.STANDARD));
    }

    @Override
    public RegistryImpl withPremiumSku() {
        return this.setManagedSku(new Sku().withName(SkuName.PREMIUM));
    }

    private RegistryImpl setManagedSku(Sku sku) {
        if (this.isInCreateMode()) {
            ((RegistryInner)((Object)this.innerModel())).withSku(sku);
        } else {
            this.updateParameters.withSku(sku);
        }
        return this;
    }

    @Override
    public RegistryImpl withRegistryNameAsAdminUser() {
        if (this.isInCreateMode()) {
            ((RegistryInner)((Object)this.innerModel())).withAdminUserEnabled(true);
        } else {
            this.updateParameters.withAdminUserEnabled(true);
        }
        return this;
    }

    @Override
    public RegistryImpl withoutRegistryNameAsAdminUser() {
        if (this.isInCreateMode()) {
            ((RegistryInner)((Object)this.innerModel())).withAdminUserEnabled(false);
        } else {
            this.updateParameters.withAdminUserEnabled(false);
        }
        return this;
    }

    @Override
    public RegistryCredentials getCredentials() {
        return ((ContainerRegistryManager)this.manager()).containerRegistries().getCredentials(this.resourceGroupName(), this.name());
    }

    @Override
    public Mono<RegistryCredentials> getCredentialsAsync() {
        return ((ContainerRegistryManager)this.manager()).containerRegistries().getCredentialsAsync(this.resourceGroupName(), this.name());
    }

    @Override
    public RegistryCredentials regenerateCredential(AccessKeyType accessKeyType) {
        return ((ContainerRegistryManager)this.manager()).containerRegistries().regenerateCredential(this.resourceGroupName(), this.name(), accessKeyType);
    }

    @Override
    public Mono<RegistryCredentials> regenerateCredentialAsync(AccessKeyType accessKeyType) {
        return ((ContainerRegistryManager)this.manager()).containerRegistries().regenerateCredentialAsync(this.resourceGroupName(), this.name(), accessKeyType);
    }

    @Override
    public Collection<RegistryUsage> listQuotaUsages() {
        return ((ContainerRegistryManager)this.manager()).containerRegistries().listQuotaUsages(this.resourceGroupName(), this.name());
    }

    @Override
    public PagedFlux<RegistryUsage> listQuotaUsagesAsync() {
        return ((ContainerRegistryManager)this.manager()).containerRegistries().listQuotaUsagesAsync(this.resourceGroupName(), this.name());
    }

    @Override
    public WebhookOperations webhooks() {
        return new WebhookOperationsImpl(this);
    }

    @Override
    public PublicNetworkAccess publicNetworkAccess() {
        return ((RegistryInner)((Object)this.innerModel())).publicNetworkAccess();
    }

    @Override
    public RegistryTaskRun.DefinitionStages.BlankFromRegistry scheduleRun() {
        return new RegistryTaskRunImpl((ContainerRegistryManager)this.manager(), new RunInner()).withExistingRegistry(this.resourceGroupName(), this.name());
    }

    @Override
    public SourceUploadDefinition getBuildSourceUploadUrl() {
        return (SourceUploadDefinition)this.getBuildSourceUploadUrlAsync().block();
    }

    @Override
    public Mono<SourceUploadDefinition> getBuildSourceUploadUrlAsync() {
        return ((ContainerRegistryManagementClient)((ContainerRegistryManager)this.manager()).serviceClient()).getRegistries().getBuildSourceUploadUrlAsync(this.resourceGroupName(), this.name()).map(sourceUploadDefinitionInner -> new SourceUploadDefinitionImpl((SourceUploadDefinitionInner)sourceUploadDefinitionInner));
    }

    @Override
    public RegistryImpl withoutWebhook(String name) {
        this.webhooks.withoutWebhook(name);
        return this;
    }

    public WebhookImpl updateWebhook(String name) {
        return this.webhooks.updateWebhook(name);
    }

    public WebhookImpl defineWebhook(String name) {
        return this.webhooks.defineWebhook(name);
    }

    @Override
    public RegistryImpl enablePublicNetworkAccess() {
        if (this.isInCreateMode()) {
            ((RegistryInner)((Object)this.innerModel())).withPublicNetworkAccess(PublicNetworkAccess.ENABLED);
        } else {
            this.updateParameters.withPublicNetworkAccess(PublicNetworkAccess.ENABLED);
        }
        return this;
    }

    @Override
    public RegistryImpl disablePublicNetworkAccess() {
        if (this.isInCreateMode()) {
            ((RegistryInner)((Object)this.innerModel())).withPublicNetworkAccess(PublicNetworkAccess.DISABLED);
        } else {
            this.updateParameters.withPublicNetworkAccess(PublicNetworkAccess.DISABLED);
        }
        return this;
    }
}

