/*
 * Decompiled with CFR 0.152.
 */
package com.anji.plus.gaea.oss.ossbuilder.builders;

import com.anji.plus.gaea.oss.config.OSSProperties;
import com.anji.plus.gaea.oss.exceptions.GaeaOSSException;
import com.anji.plus.gaea.oss.exceptions.GaeaOSSExceptionBuilder;
import com.anji.plus.gaea.oss.ossbuilder.GaeaOSSTemplate;
import io.minio.PutObjectOptions;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.web.multipart.MultipartFile;

public class MinioClient
implements GaeaOSSTemplate {
    private static Logger logger = LoggerFactory.getLogger(MinioClient.class);
    private io.minio.MinioClient minioClient;
    private String bucketName;
    private String fileTypeWhileList;

    @Override
    public String getFileTypeWhileList() {
        return this.fileTypeWhileList;
    }

    public MinioClient(OSSProperties ossProperties) {
        this.fileTypeWhileList = ossProperties.getFileTypeWhileList();
        String url = ossProperties.getMinio().getUrl();
        int port = ossProperties.getMinio().getPort();
        String accessKey = ossProperties.getMinio().getAccessKey();
        String secretKey = ossProperties.getMinio().getSecretKey();
        this.bucketName = ossProperties.getMinio().getBucketName();
        try {
            this.minioClient = new io.minio.MinioClient(url, port, accessKey, secretKey);
            boolean found = this.minioClient.bucketExists(this.bucketName);
            if (!found) {
                this.minioClient.makeBucket(this.bucketName);
            }
            logger.info("\u521d\u59cb\u5316\u6587\u4ef6\u5b58\u50a8\uff0c\u6fc0\u6d3bMinio\u5206\u5e03\u5f0f\u5b58\u50a8\u6876:{}", (Object)this.bucketName);
        }
        catch (Exception e) {
            logger.error("\u521d\u59cb\u5316\u6587\u4ef6\u5b58\u50a8\uff0c\u6fc0\u6d3bMinio\u5b58\u50a8\u6876:{}\u5931\u8d25:{}", (Object)this.bucketName, (Object)e);
        }
    }

    @Override
    public String uploadFileByInputStream(MultipartFile file, String fileObjectName) throws GaeaOSSException {
        this.checkFileSuffixName(file);
        InputStream fileInputStream = null;
        try {
            fileInputStream = file.getInputStream();
            PutObjectOptions options = new PutObjectOptions((long)fileInputStream.available(), -1L);
            options.setContentType("application/octet-stream");
            this.minioClient.putObject(this.bucketName, fileObjectName, fileInputStream, options);
        }
        catch (Exception e) {
            logger.error("save file to minio store error:", (Throwable)e);
            throw GaeaOSSExceptionBuilder.build("save file to minio store error", e);
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (Exception e) {
                logger.error("close InputStream error:", (Throwable)e);
            }
        }
        return fileObjectName;
    }

    @Override
    public byte[] downloadFile(String fileObjectName) throws GaeaOSSException {
        byte[] fileBytes = null;
        InputStream inputStream = null;
        try {
            inputStream = this.minioClient.getObject(this.bucketName, fileObjectName);
            if (inputStream == null) {
                logger.error("file {} not exist in minio store ", (Object)fileObjectName);
                throw GaeaOSSExceptionBuilder.build("file not exist in minio store, objectName=" + fileObjectName);
            }
            fileBytes = IOUtils.toByteArray((InputStream)inputStream);
        }
        catch (Exception e) {
            logger.error("read file from minio store error:", (Throwable)e);
            throw GaeaOSSExceptionBuilder.build("read file from minio store error, objectName=" + fileObjectName);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        return fileBytes;
    }

    @Override
    public void deleteFile(String fileObjectName) {
        try {
            this.minioClient.removeObject(this.bucketName, fileObjectName);
        }
        catch (Exception e) {
            logger.warn("delete file in minio store fail, bucket={}, file={}", (Object)this.bucketName, (Object)fileObjectName);
        }
    }

    @Override
    public void deleteFiles(List<String> fileObjectNames) {
        try {
            if (CollectionUtils.isEmpty(fileObjectNames)) {
                return;
            }
            this.minioClient.removeObjects(this.bucketName, fileObjectNames);
        }
        catch (Exception e) {
            logger.warn("delete file in minio store fail, bucket={}, file={}", (Object)this.bucketName, (Object)fileObjectNames.toString());
        }
    }
}

