/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.com.viapi;

import com.aliyun.oss.OSSClient;
import com.aliyuncs.AcsRequest;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import com.aliyuncs.viapiutils.model.v20200401.GetOssStsTokenRequest;
import com.aliyuncs.viapiutils.model.v20200401.GetOssStsTokenResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class FileUtils {
    DefaultAcsClient client;
    String endpoint = "viapiutils.cn-shanghai.aliyuncs.com";
    String accessKeyId;
    Pattern fileNameRegex = Pattern.compile("\\w+.(jpg|gif|png|jpeg|bmp|mov|mp4|avi)");
    static Map<String, FileUtils> map = new HashMap<String, FileUtils>();

    public static synchronized FileUtils getInstance(String accessKeyId, String accessKeySecret) throws ClientException {
        String mapKey = accessKeyId + accessKeySecret;
        FileUtils fileUtils = map.get(mapKey);
        if (fileUtils == null) {
            fileUtils = new FileUtils(accessKeyId, accessKeySecret);
            map.put(mapKey, fileUtils);
        }
        return fileUtils;
    }

    private FileUtils(String accessKeyId, String accessKeySecret) throws ClientException {
        DefaultProfile profile = DefaultProfile.getProfile((String)"cn-shanghai", (String)accessKeyId, (String)accessKeySecret);
        DefaultProfile.addEndpoint((String)"", (String)"cn-shanghai", (String)"viapiutils", (String)this.endpoint);
        this.client = new DefaultAcsClient((IClientProfile)profile);
        this.accessKeyId = accessKeyId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String upload(String filePath) throws ClientException, IOException {
        try (InputStream ins = null;){
            String fileName = "";
            if (StringUtils.startsWithAny((CharSequence)filePath, (CharSequence[])new CharSequence[]{"http://", "https://"})) {
                Matcher matcher = this.fileNameRegex.matcher(StringUtils.lowerCase((String)(filePath = URLDecoder.decode(filePath, "UTF-8"))));
                if (matcher.find()) {
                    fileName = matcher.group();
                }
                URL url = new URL(filePath);
                if (StringUtils.isBlank((CharSequence)fileName)) {
                    fileName = url.getPath();
                    fileName = StringUtils.substringAfterLast((String)fileName, (String)"/");
                }
                URLConnection urlConnection = url.openConnection();
                ins = urlConnection.getInputStream();
            } else {
                File file = new File(filePath);
                fileName = file.getName();
                ins = new FileInputStream(file);
            }
            String string = this.upload(fileName, ins);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String upload(String fileName, InputStream stream) throws ClientException, IOException {
        GetOssStsTokenRequest getOssStsTokenRequest = new GetOssStsTokenRequest();
        GetOssStsTokenResponse getOssStsTokenResponse = (GetOssStsTokenResponse)this.client.getAcsResponse((AcsRequest)getOssStsTokenRequest);
        String akKey = getOssStsTokenResponse.getData().getAccessKeyId();
        String akSec = getOssStsTokenResponse.getData().getAccessKeySecret();
        String token = getOssStsTokenResponse.getData().getSecurityToken();
        OSSClient ossClient = null;
        try {
            ossClient = new OSSClient("http://oss-cn-shanghai.aliyuncs.com", akKey, akSec, token);
            String key = this.accessKeyId + "/" + UUID.randomUUID().toString() + fileName;
            ossClient.putObject("viapi-customer-temp", key, stream);
            String string = "http://viapi-customer-temp.oss-cn-shanghai.aliyuncs.com/" + key;
            return string;
        }
        finally {
            if (ossClient != null) {
                ossClient.shutdown();
            }
        }
    }
}

