/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.teaopenapi;

import com.aliyun.tea.Tea;
import com.aliyun.tea.TeaConverter;
import com.aliyun.tea.TeaException;
import com.aliyun.tea.TeaModel;
import com.aliyun.tea.TeaPair;
import com.aliyun.tea.TeaRequest;
import com.aliyun.tea.TeaResponse;
import com.aliyun.tea.TeaUnretryableException;
import com.aliyun.teaopenapi.models.Config;
import com.aliyun.teaopenapi.models.OpenApiRequest;
import com.aliyun.teaopenapi.models.Params;
import com.aliyun.teautil.Common;
import com.aliyun.teautil.models.RuntimeOptions;
import java.io.InputStream;
import java.util.Map;

public class Client {
    public String _endpoint;
    public String _regionId;
    public String _protocol;
    public String _userAgent;
    public String _endpointRule;
    public Map<String, String> _endpointMap;
    public String _suffix;
    public Integer _readTimeout;
    public Integer _connectTimeout;
    public String _httpProxy;
    public String _httpsProxy;
    public String _socks5Proxy;
    public String _socks5NetWork;
    public String _noProxy;
    public String _network;
    public String _productId;
    public Integer _maxIdleConns;
    public String _endpointType;
    public String _openPlatformEndpoint;
    public com.aliyun.credentials.Client _credential;
    public String _signatureAlgorithm;

    public Client(Config config) throws Exception {
        if (Common.isUnset((Object)TeaModel.buildMap((TeaModel)config))) {
            throw new TeaException(TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("code", (Object)"ParameterMissing"), new TeaPair("message", (Object)"'config' can not be unset")}));
        }
        if (!Common.empty((String)config.accessKeyId) && !Common.empty((String)config.accessKeySecret)) {
            config.type = !Common.empty((String)config.securityToken) ? "sts" : "access_key";
            com.aliyun.credentials.models.Config credentialConfig = com.aliyun.credentials.models.Config.build((Map)TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("accessKeyId", (Object)config.accessKeyId), new TeaPair("type", (Object)config.type), new TeaPair("accessKeySecret", (Object)config.accessKeySecret), new TeaPair("securityToken", (Object)config.securityToken)}));
            this._credential = new com.aliyun.credentials.Client(credentialConfig);
        } else if (!Common.isUnset((Object)config.credential)) {
            this._credential = config.credential;
        }
        this._endpoint = config.endpoint;
        this._protocol = config.protocol;
        this._regionId = config.regionId;
        this._userAgent = config.userAgent;
        this._readTimeout = config.readTimeout;
        this._connectTimeout = config.connectTimeout;
        this._httpProxy = config.httpProxy;
        this._httpsProxy = config.httpsProxy;
        this._noProxy = config.noProxy;
        this._socks5Proxy = config.socks5Proxy;
        this._socks5NetWork = config.socks5NetWork;
        this._maxIdleConns = config.maxIdleConns;
        this._signatureAlgorithm = config.signatureAlgorithm;
    }

    public Map<String, ?> doRPCRequest(String action, String version, String protocol, String method, String authType, String bodyType, OpenApiRequest request, RuntimeOptions runtime) throws Exception {
        TeaModel.validateParams((TeaModel)request, (String)"request");
        Map runtime_ = TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("timeouted", (Object)"retry"), new TeaPair("readTimeout", (Object)Common.defaultNumber((Number)runtime.readTimeout, (Number)this._readTimeout)), new TeaPair("connectTimeout", (Object)Common.defaultNumber((Number)runtime.connectTimeout, (Number)this._connectTimeout)), new TeaPair("httpProxy", (Object)Common.defaultString((String)runtime.httpProxy, (String)this._httpProxy)), new TeaPair("httpsProxy", (Object)Common.defaultString((String)runtime.httpsProxy, (String)this._httpsProxy)), new TeaPair("noProxy", (Object)Common.defaultString((String)runtime.noProxy, (String)this._noProxy)), new TeaPair("maxIdleConns", (Object)Common.defaultNumber((Number)runtime.maxIdleConns, (Number)this._maxIdleConns)), new TeaPair("retry", (Object)TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("retryable", (Object)runtime.autoretry), new TeaPair("maxAttempts", (Object)Common.defaultNumber((Number)runtime.maxAttempts, (Number)3))})), new TeaPair("backoff", (Object)TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("policy", (Object)Common.defaultString((String)runtime.backoffPolicy, (String)"no")), new TeaPair("period", (Object)Common.defaultNumber((Number)runtime.backoffPeriod, (Number)1))})), new TeaPair("ignoreSSL", (Object)runtime.ignoreSSL)});
        TeaRequest _lastRequest = null;
        long _now = System.currentTimeMillis();
        int _retryTimes = 0;
        while (Tea.allowRetry((Map)((Map)runtime_.get("retry")), (int)_retryTimes, (long)_now)) {
            int backoffTime;
            if (_retryTimes > 0 && (backoffTime = Tea.getBackoffTime(runtime_.get("backoff"), (int)_retryTimes)) > 0) {
                Tea.sleep((int)backoffTime);
            }
            ++_retryTimes;
            try {
                TeaRequest request_ = new TeaRequest();
                request_.protocol = Common.defaultString((String)this._protocol, (String)protocol);
                request_.method = method;
                request_.pathname = "/";
                request_.query = TeaConverter.merge(String.class, (Map[])new Map[]{TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("Action", (Object)action), new TeaPair("Format", (Object)"json"), new TeaPair("Version", (Object)version), new TeaPair("Timestamp", (Object)com.aliyun.openapiutil.Client.getTimestamp()), new TeaPair("SignatureNonce", (Object)Common.getNonce())}), request.query});
                request_.headers = TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("host", (Object)this._endpoint), new TeaPair("x-acs-version", (Object)version), new TeaPair("x-acs-action", (Object)action), new TeaPair("user-agent", (Object)this.getUserAgent())});
                if (!Common.isUnset((Object)request.body)) {
                    Map m = Common.assertAsMap((Object)request.body);
                    Map tmp = Common.anyifyMapValue((Map)com.aliyun.openapiutil.Client.query((Map)m));
                    request_.body = Tea.toReadable((String)Common.toFormString((Map)tmp));
                    request_.headers.put("content-type", "application/x-www-form-urlencoded");
                }
                if (!Common.equalString((String)authType, (String)"Anonymous")) {
                    String accessKeyId = this.getAccessKeyId();
                    String accessKeySecret = this.getAccessKeySecret();
                    String securityToken = this.getSecurityToken();
                    if (!Common.empty((String)securityToken)) {
                        request_.query.put("SecurityToken", securityToken);
                    }
                    request_.query.put("SignatureMethod", "HMAC-SHA1");
                    request_.query.put("SignatureVersion", "1.0");
                    request_.query.put("AccessKeyId", accessKeyId);
                    Map t = null;
                    if (!Common.isUnset((Object)request.body)) {
                        t = Common.assertAsMap((Object)request.body);
                    }
                    Map signedParam = TeaConverter.merge(String.class, (Map[])new Map[]{request_.query, com.aliyun.openapiutil.Client.query((Map)t)});
                    request_.query.put("Signature", com.aliyun.openapiutil.Client.getRPCSignature((Map)signedParam, (String)request_.method, (String)accessKeySecret));
                }
                _lastRequest = request_;
                TeaResponse response_ = Tea.doAction((TeaRequest)request_, (Map)runtime_);
                if (Common.is4xx((Number)response_.statusCode) || Common.is5xx((Number)response_.statusCode)) {
                    Object _res = Common.readAsJSON((InputStream)response_.body);
                    Map err = Common.assertAsMap((Object)_res);
                    throw new TeaException(TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("code", (Object)("" + Client.defaultAny(err.get("Code"), err.get("code")) + "")), new TeaPair("message", (Object)("code: " + response_.statusCode + ", " + Client.defaultAny(err.get("Message"), err.get("message")) + " request id: " + Client.defaultAny(err.get("RequestId"), err.get("requestId")) + "")), new TeaPair("data", (Object)err)}));
                }
                if (Common.equalString((String)bodyType, (String)"binary")) {
                    Map resp = TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("body", (Object)response_.body), new TeaPair("headers", (Object)response_.headers)});
                    return resp;
                }
                if (Common.equalString((String)bodyType, (String)"byte")) {
                    byte[] byt = Common.readAsBytes((InputStream)response_.body);
                    return TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("body", (Object)byt), new TeaPair("headers", (Object)response_.headers)});
                }
                if (Common.equalString((String)bodyType, (String)"string")) {
                    String str = Common.readAsString((InputStream)response_.body);
                    return TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("body", (Object)str), new TeaPair("headers", (Object)response_.headers)});
                }
                if (Common.equalString((String)bodyType, (String)"json")) {
                    Object obj = Common.readAsJSON((InputStream)response_.body);
                    Map res = Common.assertAsMap((Object)obj);
                    return TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("body", (Object)res), new TeaPair("headers", (Object)response_.headers)});
                }
                if (Common.equalString((String)bodyType, (String)"array")) {
                    Object arr = Common.readAsJSON((InputStream)response_.body);
                    return TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("body", arr), new TeaPair("headers", (Object)response_.headers)});
                }
                return TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("headers", (Object)response_.headers)});
            }
            catch (Exception e) {
                if (Tea.isRetryable((Exception)e)) continue;
                throw e;
            }
        }
        throw new TeaUnretryableException(_lastRequest);
    }

    public Map<String, ?> doROARequest(String action, String version, String protocol, String method, String authType, String pathname, String bodyType, OpenApiRequest request, RuntimeOptions runtime) throws Exception {
        TeaModel.validateParams((TeaModel)request, (String)"request");
        Map runtime_ = TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("timeouted", (Object)"retry"), new TeaPair("readTimeout", (Object)Common.defaultNumber((Number)runtime.readTimeout, (Number)this._readTimeout)), new TeaPair("connectTimeout", (Object)Common.defaultNumber((Number)runtime.connectTimeout, (Number)this._connectTimeout)), new TeaPair("httpProxy", (Object)Common.defaultString((String)runtime.httpProxy, (String)this._httpProxy)), new TeaPair("httpsProxy", (Object)Common.defaultString((String)runtime.httpsProxy, (String)this._httpsProxy)), new TeaPair("noProxy", (Object)Common.defaultString((String)runtime.noProxy, (String)this._noProxy)), new TeaPair("maxIdleConns", (Object)Common.defaultNumber((Number)runtime.maxIdleConns, (Number)this._maxIdleConns)), new TeaPair("retry", (Object)TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("retryable", (Object)runtime.autoretry), new TeaPair("maxAttempts", (Object)Common.defaultNumber((Number)runtime.maxAttempts, (Number)3))})), new TeaPair("backoff", (Object)TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("policy", (Object)Common.defaultString((String)runtime.backoffPolicy, (String)"no")), new TeaPair("period", (Object)Common.defaultNumber((Number)runtime.backoffPeriod, (Number)1))})), new TeaPair("ignoreSSL", (Object)runtime.ignoreSSL)});
        TeaRequest _lastRequest = null;
        long _now = System.currentTimeMillis();
        int _retryTimes = 0;
        while (Tea.allowRetry((Map)((Map)runtime_.get("retry")), (int)_retryTimes, (long)_now)) {
            int backoffTime;
            if (_retryTimes > 0 && (backoffTime = Tea.getBackoffTime(runtime_.get("backoff"), (int)_retryTimes)) > 0) {
                Tea.sleep((int)backoffTime);
            }
            ++_retryTimes;
            try {
                TeaRequest request_ = new TeaRequest();
                request_.protocol = Common.defaultString((String)this._protocol, (String)protocol);
                request_.method = method;
                request_.pathname = pathname;
                request_.headers = TeaConverter.merge(String.class, (Map[])new Map[]{TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("date", (Object)Common.getDateUTCString()), new TeaPair("host", (Object)this._endpoint), new TeaPair("accept", (Object)"application/json"), new TeaPair("x-acs-signature-nonce", (Object)Common.getNonce()), new TeaPair("x-acs-signature-method", (Object)"HMAC-SHA1"), new TeaPair("x-acs-signature-version", (Object)"1.0"), new TeaPair("x-acs-version", (Object)version), new TeaPair("x-acs-action", (Object)action), new TeaPair("user-agent", (Object)Common.getUserAgent((String)this._userAgent))}), request.headers});
                if (!Common.isUnset((Object)request.body)) {
                    request_.body = Tea.toReadable((String)Common.toJSONString((Object)request.body));
                    request_.headers.put("content-type", "application/json; charset=utf-8");
                }
                if (!Common.isUnset(request.query)) {
                    request_.query = request.query;
                }
                if (!Common.equalString((String)authType, (String)"Anonymous")) {
                    String accessKeyId = this.getAccessKeyId();
                    String accessKeySecret = this.getAccessKeySecret();
                    String securityToken = this.getSecurityToken();
                    if (!Common.empty((String)securityToken)) {
                        request_.headers.put("x-acs-accesskey-id", accessKeyId);
                        request_.headers.put("x-acs-security-token", securityToken);
                    }
                    String stringToSign = com.aliyun.openapiutil.Client.getStringToSign((TeaRequest)request_);
                    request_.headers.put("authorization", "acs " + accessKeyId + ":" + com.aliyun.openapiutil.Client.getROASignature((String)stringToSign, (String)accessKeySecret) + "");
                }
                _lastRequest = request_;
                TeaResponse response_ = Tea.doAction((TeaRequest)request_, (Map)runtime_);
                if (Common.equalNumber((Number)response_.statusCode, (Number)204)) {
                    return TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("headers", (Object)response_.headers)});
                }
                if (Common.is4xx((Number)response_.statusCode) || Common.is5xx((Number)response_.statusCode)) {
                    Object _res = Common.readAsJSON((InputStream)response_.body);
                    Map err = Common.assertAsMap((Object)_res);
                    throw new TeaException(TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("code", (Object)("" + Client.defaultAny(err.get("Code"), err.get("code")) + "")), new TeaPair("message", (Object)("code: " + response_.statusCode + ", " + Client.defaultAny(err.get("Message"), err.get("message")) + " request id: " + Client.defaultAny(err.get("RequestId"), err.get("requestId")) + "")), new TeaPair("data", (Object)err)}));
                }
                if (Common.equalString((String)bodyType, (String)"binary")) {
                    Map resp = TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("body", (Object)response_.body), new TeaPair("headers", (Object)response_.headers)});
                    return resp;
                }
                if (Common.equalString((String)bodyType, (String)"byte")) {
                    byte[] byt = Common.readAsBytes((InputStream)response_.body);
                    return TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("body", (Object)byt), new TeaPair("headers", (Object)response_.headers)});
                }
                if (Common.equalString((String)bodyType, (String)"string")) {
                    String str = Common.readAsString((InputStream)response_.body);
                    return TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("body", (Object)str), new TeaPair("headers", (Object)response_.headers)});
                }
                if (Common.equalString((String)bodyType, (String)"json")) {
                    Object obj = Common.readAsJSON((InputStream)response_.body);
                    Map res = Common.assertAsMap((Object)obj);
                    return TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("body", (Object)res), new TeaPair("headers", (Object)response_.headers)});
                }
                if (Common.equalString((String)bodyType, (String)"array")) {
                    Object arr = Common.readAsJSON((InputStream)response_.body);
                    return TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("body", arr), new TeaPair("headers", (Object)response_.headers)});
                }
                return TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("headers", (Object)response_.headers)});
            }
            catch (Exception e) {
                if (Tea.isRetryable((Exception)e)) continue;
                throw e;
            }
        }
        throw new TeaUnretryableException(_lastRequest);
    }

    public Map<String, ?> doROARequestWithForm(String action, String version, String protocol, String method, String authType, String pathname, String bodyType, OpenApiRequest request, RuntimeOptions runtime) throws Exception {
        TeaModel.validateParams((TeaModel)request, (String)"request");
        Map runtime_ = TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("timeouted", (Object)"retry"), new TeaPair("readTimeout", (Object)Common.defaultNumber((Number)runtime.readTimeout, (Number)this._readTimeout)), new TeaPair("connectTimeout", (Object)Common.defaultNumber((Number)runtime.connectTimeout, (Number)this._connectTimeout)), new TeaPair("httpProxy", (Object)Common.defaultString((String)runtime.httpProxy, (String)this._httpProxy)), new TeaPair("httpsProxy", (Object)Common.defaultString((String)runtime.httpsProxy, (String)this._httpsProxy)), new TeaPair("noProxy", (Object)Common.defaultString((String)runtime.noProxy, (String)this._noProxy)), new TeaPair("maxIdleConns", (Object)Common.defaultNumber((Number)runtime.maxIdleConns, (Number)this._maxIdleConns)), new TeaPair("retry", (Object)TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("retryable", (Object)runtime.autoretry), new TeaPair("maxAttempts", (Object)Common.defaultNumber((Number)runtime.maxAttempts, (Number)3))})), new TeaPair("backoff", (Object)TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("policy", (Object)Common.defaultString((String)runtime.backoffPolicy, (String)"no")), new TeaPair("period", (Object)Common.defaultNumber((Number)runtime.backoffPeriod, (Number)1))})), new TeaPair("ignoreSSL", (Object)runtime.ignoreSSL)});
        TeaRequest _lastRequest = null;
        long _now = System.currentTimeMillis();
        int _retryTimes = 0;
        while (Tea.allowRetry((Map)((Map)runtime_.get("retry")), (int)_retryTimes, (long)_now)) {
            int backoffTime;
            if (_retryTimes > 0 && (backoffTime = Tea.getBackoffTime(runtime_.get("backoff"), (int)_retryTimes)) > 0) {
                Tea.sleep((int)backoffTime);
            }
            ++_retryTimes;
            try {
                TeaRequest request_ = new TeaRequest();
                request_.protocol = Common.defaultString((String)this._protocol, (String)protocol);
                request_.method = method;
                request_.pathname = pathname;
                request_.headers = TeaConverter.merge(String.class, (Map[])new Map[]{TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("date", (Object)Common.getDateUTCString()), new TeaPair("host", (Object)this._endpoint), new TeaPair("accept", (Object)"application/json"), new TeaPair("x-acs-signature-nonce", (Object)Common.getNonce()), new TeaPair("x-acs-signature-method", (Object)"HMAC-SHA1"), new TeaPair("x-acs-signature-version", (Object)"1.0"), new TeaPair("x-acs-version", (Object)version), new TeaPair("x-acs-action", (Object)action), new TeaPair("user-agent", (Object)Common.getUserAgent((String)this._userAgent))}), request.headers});
                if (!Common.isUnset((Object)request.body)) {
                    Map m = Common.assertAsMap((Object)request.body);
                    request_.body = Tea.toReadable((String)com.aliyun.openapiutil.Client.toForm((Map)m));
                    request_.headers.put("content-type", "application/x-www-form-urlencoded");
                }
                if (!Common.isUnset(request.query)) {
                    request_.query = request.query;
                }
                if (!Common.equalString((String)authType, (String)"Anonymous")) {
                    String accessKeyId = this.getAccessKeyId();
                    String accessKeySecret = this.getAccessKeySecret();
                    String securityToken = this.getSecurityToken();
                    if (!Common.empty((String)securityToken)) {
                        request_.headers.put("x-acs-accesskey-id", accessKeyId);
                        request_.headers.put("x-acs-security-token", securityToken);
                    }
                    String stringToSign = com.aliyun.openapiutil.Client.getStringToSign((TeaRequest)request_);
                    request_.headers.put("authorization", "acs " + accessKeyId + ":" + com.aliyun.openapiutil.Client.getROASignature((String)stringToSign, (String)accessKeySecret) + "");
                }
                _lastRequest = request_;
                TeaResponse response_ = Tea.doAction((TeaRequest)request_, (Map)runtime_);
                if (Common.equalNumber((Number)response_.statusCode, (Number)204)) {
                    return TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("headers", (Object)response_.headers)});
                }
                if (Common.is4xx((Number)response_.statusCode) || Common.is5xx((Number)response_.statusCode)) {
                    Object _res = Common.readAsJSON((InputStream)response_.body);
                    Map err = Common.assertAsMap((Object)_res);
                    throw new TeaException(TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("code", (Object)("" + Client.defaultAny(err.get("Code"), err.get("code")) + "")), new TeaPair("message", (Object)("code: " + response_.statusCode + ", " + Client.defaultAny(err.get("Message"), err.get("message")) + " request id: " + Client.defaultAny(err.get("RequestId"), err.get("requestId")) + "")), new TeaPair("data", (Object)err)}));
                }
                if (Common.equalString((String)bodyType, (String)"binary")) {
                    Map resp = TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("body", (Object)response_.body), new TeaPair("headers", (Object)response_.headers)});
                    return resp;
                }
                if (Common.equalString((String)bodyType, (String)"byte")) {
                    byte[] byt = Common.readAsBytes((InputStream)response_.body);
                    return TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("body", (Object)byt), new TeaPair("headers", (Object)response_.headers)});
                }
                if (Common.equalString((String)bodyType, (String)"string")) {
                    String str = Common.readAsString((InputStream)response_.body);
                    return TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("body", (Object)str), new TeaPair("headers", (Object)response_.headers)});
                }
                if (Common.equalString((String)bodyType, (String)"json")) {
                    Object obj = Common.readAsJSON((InputStream)response_.body);
                    Map res = Common.assertAsMap((Object)obj);
                    return TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("body", (Object)res), new TeaPair("headers", (Object)response_.headers)});
                }
                if (Common.equalString((String)bodyType, (String)"array")) {
                    Object arr = Common.readAsJSON((InputStream)response_.body);
                    return TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("body", arr), new TeaPair("headers", (Object)response_.headers)});
                }
                return TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("headers", (Object)response_.headers)});
            }
            catch (Exception e) {
                if (Tea.isRetryable((Exception)e)) continue;
                throw e;
            }
        }
        throw new TeaUnretryableException(_lastRequest);
    }

    public Map<String, ?> doRequest(Params params, OpenApiRequest request, RuntimeOptions runtime) throws Exception {
        TeaModel.validateParams((TeaModel)params, (String)"params");
        TeaModel.validateParams((TeaModel)request, (String)"request");
        Map runtime_ = TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("timeouted", (Object)"retry"), new TeaPair("readTimeout", (Object)Common.defaultNumber((Number)runtime.readTimeout, (Number)this._readTimeout)), new TeaPair("connectTimeout", (Object)Common.defaultNumber((Number)runtime.connectTimeout, (Number)this._connectTimeout)), new TeaPair("httpProxy", (Object)Common.defaultString((String)runtime.httpProxy, (String)this._httpProxy)), new TeaPair("httpsProxy", (Object)Common.defaultString((String)runtime.httpsProxy, (String)this._httpsProxy)), new TeaPair("noProxy", (Object)Common.defaultString((String)runtime.noProxy, (String)this._noProxy)), new TeaPair("maxIdleConns", (Object)Common.defaultNumber((Number)runtime.maxIdleConns, (Number)this._maxIdleConns)), new TeaPair("retry", (Object)TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("retryable", (Object)runtime.autoretry), new TeaPair("maxAttempts", (Object)Common.defaultNumber((Number)runtime.maxAttempts, (Number)3))})), new TeaPair("backoff", (Object)TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("policy", (Object)Common.defaultString((String)runtime.backoffPolicy, (String)"no")), new TeaPair("period", (Object)Common.defaultNumber((Number)runtime.backoffPeriod, (Number)1))})), new TeaPair("ignoreSSL", (Object)runtime.ignoreSSL)});
        TeaRequest _lastRequest = null;
        long _now = System.currentTimeMillis();
        int _retryTimes = 0;
        while (Tea.allowRetry((Map)((Map)runtime_.get("retry")), (int)_retryTimes, (long)_now)) {
            int backoffTime;
            if (_retryTimes > 0 && (backoffTime = Tea.getBackoffTime(runtime_.get("backoff"), (int)_retryTimes)) > 0) {
                Tea.sleep((int)backoffTime);
            }
            ++_retryTimes;
            try {
                TeaRequest request_ = new TeaRequest();
                request_.protocol = Common.defaultString((String)this._protocol, (String)params.protocol);
                request_.method = params.method;
                request_.pathname = com.aliyun.openapiutil.Client.getEncodePath((String)params.pathname);
                request_.query = request.query;
                request_.headers = TeaConverter.merge(String.class, (Map[])new Map[]{TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("host", (Object)this._endpoint), new TeaPair("x-acs-version", (Object)params.version), new TeaPair("x-acs-action", (Object)params.action), new TeaPair("user-agent", (Object)this.getUserAgent()), new TeaPair("x-acs-date", (Object)com.aliyun.openapiutil.Client.getTimestamp()), new TeaPair("accept", (Object)"application/json")}), request.headers});
                if (Common.equalString((String)request_.protocol, (String)"http") || Common.equalString((String)request_.protocol, (String)"HTTP")) {
                    request_.headers.put("x-acs-signature-nonce", Common.getNonce());
                }
                String signatureAlgorithm = Common.defaultString((String)this._signatureAlgorithm, (String)"ACS3-HMAC-SHA256");
                String hashedRequestPayload = com.aliyun.openapiutil.Client.hexEncode((byte[])com.aliyun.openapiutil.Client.hash((byte[])Common.toBytes((String)""), (String)signatureAlgorithm));
                if (!Common.isUnset((Object)request.body)) {
                    if (Common.equalString((String)params.reqBodyType, (String)"json")) {
                        String jsonObj = Common.toJSONString((Object)request.body);
                        hashedRequestPayload = com.aliyun.openapiutil.Client.hexEncode((byte[])com.aliyun.openapiutil.Client.hash((byte[])Common.toBytes((String)jsonObj), (String)signatureAlgorithm));
                        request_.body = Tea.toReadable((String)jsonObj);
                    } else {
                        Map m = Common.assertAsMap((Object)request.body);
                        String formObj = com.aliyun.openapiutil.Client.toForm((Map)m);
                        hashedRequestPayload = com.aliyun.openapiutil.Client.hexEncode((byte[])com.aliyun.openapiutil.Client.hash((byte[])Common.toBytes((String)formObj), (String)signatureAlgorithm));
                        request_.body = Tea.toReadable((String)formObj);
                        request_.headers.put("content-type", "application/x-www-form-urlencoded");
                    }
                }
                if (!Common.isUnset((Object)request.stream)) {
                    byte[] tmp = Common.readAsBytes((InputStream)request.stream);
                    hashedRequestPayload = com.aliyun.openapiutil.Client.hexEncode((byte[])com.aliyun.openapiutil.Client.hash((byte[])tmp, (String)signatureAlgorithm));
                    request_.body = Tea.toReadable((byte[])tmp);
                }
                request_.headers.put("x-acs-content-sha256", hashedRequestPayload);
                if (!Common.equalString((String)params.authType, (String)"Anonymous")) {
                    String accessKeyId = this.getAccessKeyId();
                    String accessKeySecret = this.getAccessKeySecret();
                    String securityToken = this.getSecurityToken();
                    if (!Common.empty((String)securityToken)) {
                        request_.headers.put("x-acs-security-token", securityToken);
                    }
                    request_.headers.put("Authorization", com.aliyun.openapiutil.Client.getAuthorization((TeaRequest)request_, (String)signatureAlgorithm, (String)hashedRequestPayload, (String)accessKeyId, (String)accessKeySecret));
                }
                _lastRequest = request_;
                TeaResponse response_ = Tea.doAction((TeaRequest)request_, (Map)runtime_);
                if (Common.is4xx((Number)response_.statusCode) || Common.is5xx((Number)response_.statusCode)) {
                    Object _res = Common.readAsJSON((InputStream)response_.body);
                    Map err = Common.assertAsMap((Object)_res);
                    throw new TeaException(TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("code", (Object)("" + Client.defaultAny(err.get("Code"), err.get("code")) + "")), new TeaPair("message", (Object)("code: " + response_.statusCode + ", " + Client.defaultAny(err.get("Message"), err.get("message")) + " request id: " + Client.defaultAny(err.get("RequestId"), err.get("requestId")) + "")), new TeaPair("data", (Object)err)}));
                }
                if (Common.equalString((String)params.bodyType, (String)"binary")) {
                    Map resp = TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("body", (Object)response_.body), new TeaPair("headers", (Object)response_.headers)});
                    return resp;
                }
                if (Common.equalString((String)params.bodyType, (String)"byte")) {
                    byte[] byt = Common.readAsBytes((InputStream)response_.body);
                    return TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("body", (Object)byt), new TeaPair("headers", (Object)response_.headers)});
                }
                if (Common.equalString((String)params.bodyType, (String)"string")) {
                    String str = Common.readAsString((InputStream)response_.body);
                    return TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("body", (Object)str), new TeaPair("headers", (Object)response_.headers)});
                }
                if (Common.equalString((String)params.bodyType, (String)"json")) {
                    Object obj = Common.readAsJSON((InputStream)response_.body);
                    Map res = Common.assertAsMap((Object)obj);
                    return TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("body", (Object)res), new TeaPair("headers", (Object)response_.headers)});
                }
                if (Common.equalString((String)params.bodyType, (String)"array")) {
                    Object arr = Common.readAsJSON((InputStream)response_.body);
                    return TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("body", arr), new TeaPair("headers", (Object)response_.headers)});
                }
                return TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("headers", (Object)response_.headers)});
            }
            catch (Exception e) {
                if (Tea.isRetryable((Exception)e)) continue;
                throw e;
            }
        }
        throw new TeaUnretryableException(_lastRequest);
    }

    public Map<String, ?> callApi(Params params, OpenApiRequest request, RuntimeOptions runtime) throws Exception {
        if (Common.isUnset((Object)TeaModel.buildMap((TeaModel)params))) {
            throw new TeaException(TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("code", (Object)"ParameterMissing"), new TeaPair("message", (Object)"'params' can not be unset")}));
        }
        if (Common.isUnset((Object)this._signatureAlgorithm) || !Common.equalString((String)this._signatureAlgorithm, (String)"v2")) {
            return this.doRequest(params, request, runtime);
        }
        if (Common.equalString((String)params.style, (String)"ROA") && Common.equalString((String)params.reqBodyType, (String)"json")) {
            return this.doROARequest(params.action, params.version, params.protocol, params.method, params.authType, params.pathname, params.bodyType, request, runtime);
        }
        if (Common.equalString((String)params.style, (String)"ROA")) {
            return this.doROARequestWithForm(params.action, params.version, params.protocol, params.method, params.authType, params.pathname, params.bodyType, request, runtime);
        }
        return this.doRPCRequest(params.action, params.version, params.protocol, params.method, params.authType, params.bodyType, request, runtime);
    }

    public String getUserAgent() throws Exception {
        String userAgent = Common.getUserAgent((String)this._userAgent);
        return userAgent;
    }

    public String getAccessKeyId() throws Exception {
        if (Common.isUnset((Object)this._credential)) {
            return "";
        }
        String accessKeyId = this._credential.getAccessKeyId();
        return accessKeyId;
    }

    public String getAccessKeySecret() throws Exception {
        if (Common.isUnset((Object)this._credential)) {
            return "";
        }
        String secret = this._credential.getAccessKeySecret();
        return secret;
    }

    public String getSecurityToken() throws Exception {
        if (Common.isUnset((Object)this._credential)) {
            return "";
        }
        String token = this._credential.getSecurityToken();
        return token;
    }

    public static Object defaultAny(Object inputValue, Object defaultValue) throws Exception {
        if (Common.isUnset((Object)inputValue)) {
            return defaultValue;
        }
        return inputValue;
    }

    public void checkConfig(Config config) throws Exception {
        if (Common.empty((String)this._endpointRule) && Common.empty((String)config.endpoint)) {
            throw new TeaException(TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("code", (Object)"ParameterMissing"), new TeaPair("message", (Object)"'config.endpoint' can not be empty")}));
        }
    }
}

