/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.utils;

import com.aliyuncs.utils.MapUtils;
import com.aliyuncs.utils.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FlattenMapUtil {
    public static List<Map<Object, Object>> toListMap(Map<String, String> flattenMap, String prefix) {
        MapUtils mapUtils = new MapUtils();
        return mapUtils.convertMapToListMap(flattenMap, prefix);
    }

    public static Map<Object, Object> toMap(Map<String, String> flattenMap, String prefix) {
        Object object = null;
        String[] subPrefixes = prefix.split("\\.");
        for (Map.Entry<String, String> entry : flattenMap.entrySet()) {
            String key = entry.getKey();
            if (!key.startsWith(prefix + ".") || key.endsWith(".Length")) continue;
            String[] subKeys = key.split("\\.");
            object = FlattenMapUtil.putForMap(flattenMap, object, subKeys, subPrefixes.length - 1);
        }
        return FlattenMapUtil.filtrateMap((Map)object, subPrefixes[subPrefixes.length - 1]);
    }

    private static Map<Object, Object> filtrateMap(Map<Object, Object> objectMap, String key) {
        Object resultMap = null;
        if (objectMap != null && !StringUtils.isEmpty(key)) {
            resultMap = objectMap.get(key);
        }
        if (null != resultMap && Map.class.isAssignableFrom(resultMap.getClass())) {
            return (Map)resultMap;
        }
        return objectMap;
    }

    public static Object put(Map<String, String> flattenMap, Object object, String[] subKeys, int subKeysIndex) {
        if (subKeysIndex >= subKeys.length) {
            return object;
        }
        String key = subKeys[subKeysIndex];
        if (key.endsWith("]")) {
            ArrayList<Object> arrayList;
            int index = FlattenMapUtil.parseIndex(key);
            if (index == -1) {
                return null;
            }
            if (object == null) {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < subKeysIndex; ++i) {
                    sb.append(subKeys[i]).append(".");
                }
                sb.append(key);
                int length = FlattenMapUtil.parseLength(flattenMap, sb.toString());
                if (length == -1) {
                    return null;
                }
                arrayList = new ArrayList<Object>(Collections.nCopies(length, null));
            } else {
                arrayList = (ArrayList<Object>)object;
            }
            if (subKeys.length == subKeysIndex + 1) {
                arrayList.set(index, flattenMap.get(FlattenMapUtil.stringJoin(".", subKeys)));
                return arrayList;
            }
            arrayList.set(index, FlattenMapUtil.put(flattenMap, arrayList.get(index), subKeys, subKeysIndex + 1));
            return arrayList;
        }
        HashMap<String, Object> hashMap = object == null ? new HashMap<String, Object>() : (HashMap<String, Object>)object;
        if (subKeys.length == subKeysIndex + 1) {
            hashMap.put(key, flattenMap.get(FlattenMapUtil.stringJoin(".", subKeys)));
            return hashMap;
        }
        hashMap.put(key, FlattenMapUtil.put(flattenMap, hashMap.get(key), subKeys, subKeysIndex + 1));
        return hashMap;
    }

    public static Object putForMap(Map<String, String> flattenMap, Object object, String[] subKeys, int subKeysIndex) {
        if (subKeysIndex >= subKeys.length) {
            return object;
        }
        String key = subKeys[subKeysIndex];
        if (key.endsWith("]")) {
            ArrayList<Object> arrayList;
            int index = FlattenMapUtil.parseIndex(key);
            if (index == -1) {
                return null;
            }
            if (object != null && !(object instanceof HashMap)) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < subKeysIndex; ++i) {
                sb.append(subKeys[i]).append(".");
            }
            sb.append(key);
            int length = FlattenMapUtil.parseLength(flattenMap, sb.toString());
            if (length == -1) {
                return null;
            }
            String name = FlattenMapUtil.parseArrayName(key);
            if (object != null) {
                HashMap hashMap = object;
                if (!(hashMap.get(name) instanceof ArrayList)) {
                    arrayList = new ArrayList<Object>(Collections.nCopies(length, null));
                    hashMap.put(name, arrayList);
                } else {
                    arrayList = (ArrayList<Object>)hashMap.get(name);
                }
            } else {
                HashMap<String, ArrayList<Object>> hashMap = new HashMap<String, ArrayList<Object>>();
                arrayList = new ArrayList<Object>(Collections.nCopies(length, null));
                hashMap.put(name, arrayList);
                object = hashMap;
            }
            if (subKeys.length == subKeysIndex + 1) {
                arrayList.set(index, flattenMap.get(FlattenMapUtil.stringJoin(".", subKeys)));
                return object;
            }
            arrayList.set(index, FlattenMapUtil.putForMap(flattenMap, arrayList.get(index), subKeys, subKeysIndex + 1));
            return object;
        }
        HashMap<String, Object> hashMap = object == null ? new HashMap<String, Object>() : (HashMap<String, Object>)object;
        if (subKeys.length == subKeysIndex + 1) {
            hashMap.put(key, flattenMap.get(FlattenMapUtil.stringJoin(".", subKeys)));
            return hashMap;
        }
        hashMap.put(key, FlattenMapUtil.putForMap(flattenMap, hashMap.get(key), subKeys, subKeysIndex + 1));
        return hashMap;
    }

    public static int parseIndex(String key) {
        int start = key.indexOf("[");
        int end = key.indexOf("]");
        if (start == -1 || end == -1 || end <= start) {
            return -1;
        }
        try {
            return Integer.parseInt(key.substring(start + 1, end));
        }
        catch (Exception e) {
            return -1;
        }
    }

    public static int parseLength(Map<String, String> flattenMap, String key) {
        int end = key.lastIndexOf("[");
        if (end == -1) {
            return -1;
        }
        try {
            return Integer.parseInt(flattenMap.get(key.substring(0, end) + ".Length"));
        }
        catch (Exception e) {
            return -1;
        }
    }

    public static String parseArrayName(String key) {
        if (key == null) {
            return null;
        }
        int end = key.lastIndexOf("[");
        if (end == -1) {
            return null;
        }
        return key.substring(0, end);
    }

    public static String stringJoin(String delimiter, String ... sequences) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < sequences.length; ++i) {
            sb.append(sequences[i]);
            if (i >= sequences.length - 1) continue;
            sb.append(delimiter);
        }
        return sb.toString();
    }
}

