/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.netty;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.protocol.RemotingCommand;
import com.aliyun.openservices.shade.io.netty.channel.DefaultMessageSizeEstimator;
import com.aliyun.openservices.shade.io.netty.channel.MessageSizeEstimator;

public class MqDefaultMessageSizeEstimator
implements MessageSizeEstimator {
    public static final MessageSizeEstimator DEFAULT = new MqDefaultMessageSizeEstimator(100);
    private final MessageSizeEstimator.Handle handle;

    @Override
    public MessageSizeEstimator.Handle newHandle() {
        return this.handle;
    }

    public MqDefaultMessageSizeEstimator(int unknownSize) {
        if (unknownSize < 0) {
            throw new IllegalArgumentException("unknownSize: " + unknownSize + " (expected: >= 0)");
        }
        this.handle = new HandleImpl(unknownSize);
    }

    private static final class HandleImpl
    implements MessageSizeEstimator.Handle {
        private final int unknownSize;

        private HandleImpl(int unknownSize) {
            this.unknownSize = unknownSize;
        }

        @Override
        public int size(Object msg) {
            if (msg instanceof RemotingCommand) {
                byte[] body = ((RemotingCommand)msg).getBody();
                if (body == null) {
                    return this.unknownSize;
                }
                return body.length;
            }
            return DefaultMessageSizeEstimator.DEFAULT.newHandle().size(msg);
        }
    }
}

