/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.client.latency;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.ClientConfig;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.producer.TopicPublishInfo;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.latency.BrokerFetcher;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.latency.LatencyFaultTolerance;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.latency.LatencyFaultToleranceImpl;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.log.ClientLogger;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.MessageQueue;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.InternalLogger;

public class MQFaultStrategy {
    private static final InternalLogger log = ClientLogger.getLog();
    private LatencyFaultTolerance<String> latencyFaultTolerance;
    private boolean sendLatencyFaultEnable;
    private boolean startDetectorEnable;
    private long[] latencyMax = new long[]{50L, 100L, 550L, 1800L, 3000L, 5000L, 15000L};
    private long[] notAvailableDuration = new long[]{0L, 0L, 2000L, 5000L, 6000L, 10000L, 30000L};
    private ThreadLocal<BrokerFilter> threadBrokerFilter = new ThreadLocal<BrokerFilter>(){

        @Override
        protected BrokerFilter initialValue() {
            return new BrokerFilter();
        }
    };
    private TopicPublishInfo.QueueFilter reachableFilter = new TopicPublishInfo.QueueFilter(){

        @Override
        public boolean filter(MessageQueue mq) {
            return MQFaultStrategy.this.latencyFaultTolerance.isReachable(mq.getBrokerName());
        }
    };
    private TopicPublishInfo.QueueFilter availableFilter = new TopicPublishInfo.QueueFilter(){

        @Override
        public boolean filter(MessageQueue mq) {
            return MQFaultStrategy.this.latencyFaultTolerance.isAvailable(mq.getBrokerName());
        }
    };
    private TopicPublishInfo.QueueFilter mainQueueFilter = new TopicPublishInfo.QueueFilter(){

        @Override
        public boolean filter(MessageQueue mq) {
            return mq.isMainQueue();
        }
    };

    public MQFaultStrategy(ClientConfig cc, BrokerFetcher fetcher) {
        this.setStartDetectorEnable(cc.isStartDetectorEnable());
        this.setSendLatencyFaultEnable(cc.isSendLatencyEnable());
        this.latencyFaultTolerance = new LatencyFaultToleranceImpl(fetcher);
        this.latencyFaultTolerance.setDetectInterval(cc.getDetectInterval());
        this.latencyFaultTolerance.setDetectTimeout(cc.getDetectTimeout());
    }

    MQFaultStrategy(ClientConfig cc, LatencyFaultTolerance<String> tolerance) {
        this.setStartDetectorEnable(cc.isStartDetectorEnable());
        this.setSendLatencyFaultEnable(cc.isSendLatencyEnable());
        this.latencyFaultTolerance = tolerance;
        this.latencyFaultTolerance.setDetectInterval(cc.getDetectInterval());
        this.latencyFaultTolerance.setDetectTimeout(cc.getDetectTimeout());
    }

    public long[] getNotAvailableDuration() {
        return this.notAvailableDuration;
    }

    public void setNotAvailableDuration(long[] notAvailableDuration) {
        this.notAvailableDuration = notAvailableDuration;
    }

    public long[] getLatencyMax() {
        return this.latencyMax;
    }

    public void setLatencyMax(long[] latencyMax) {
        this.latencyMax = latencyMax;
    }

    public boolean isSendLatencyFaultEnable() {
        return this.sendLatencyFaultEnable;
    }

    public void setSendLatencyFaultEnable(boolean sendLatencyFaultEnable) {
        this.sendLatencyFaultEnable = sendLatencyFaultEnable;
    }

    public boolean isStartDetectorEnable() {
        return this.startDetectorEnable;
    }

    public void setStartDetectorEnable(boolean startDetectorEnable) {
        this.startDetectorEnable = startDetectorEnable;
    }

    public void startDetector() {
        if (this.sendLatencyFaultEnable && this.startDetectorEnable) {
            this.latencyFaultTolerance.startDetector();
        }
    }

    public void shutdown() {
        if (this.sendLatencyFaultEnable && this.startDetectorEnable) {
            this.latencyFaultTolerance.shutdown();
        }
    }

    public void detectByOneRound() {
        if (this.sendLatencyFaultEnable && this.startDetectorEnable) {
            this.latencyFaultTolerance.detectByOneRound();
        }
    }

    public MessageQueue selectOneMessageQueue(TopicPublishInfo tpInfo, String lastBrokerName, boolean remoteFaultTolerance, boolean resetIndex) {
        BrokerFilter brokerFilter = this.threadBrokerFilter.get();
        brokerFilter.setLastBrokerName(lastBrokerName);
        if (this.isLatencyFaultEnable(remoteFaultTolerance)) {
            MessageQueue mq;
            if (resetIndex) {
                tpInfo.resetIndex();
            }
            if ((mq = tpInfo.selectOneMessageQueue(this.availableFilter, brokerFilter)) != null) {
                return mq;
            }
            mq = tpInfo.selectOneMessageQueue(this.reachableFilter, brokerFilter);
            if (mq != null) {
                return mq;
            }
            return tpInfo.selectOneMessageQueue(new TopicPublishInfo.QueueFilter[0]);
        }
        MessageQueue mq = tpInfo.selectOneMessageQueue(brokerFilter);
        if (mq != null) {
            return mq;
        }
        return tpInfo.selectOneMessageQueue(new TopicPublishInfo.QueueFilter[0]);
    }

    public MessageQueue selectOneMessageQueue(TopicPublishInfo tpInfo, int queueGroupId, String lastBrokerName, boolean remoteFaultTolerance) {
        MessageQueue mq;
        BrokerFilter brokerFilter = this.threadBrokerFilter.get();
        brokerFilter.setLastBrokerName(lastBrokerName);
        if (this.isLatencyFaultEnable(remoteFaultTolerance)) {
            MessageQueue mq2;
            if (tpInfo.isMainQueuePreferred() && (mq2 = tpInfo.selectOneMessageQueue(queueGroupId, this.mainQueueFilter, this.availableFilter, brokerFilter)) != null) {
                return mq2;
            }
            mq2 = tpInfo.selectOneMessageQueue(queueGroupId, this.availableFilter, brokerFilter);
            if (mq2 != null) {
                return mq2;
            }
            mq2 = tpInfo.selectOneMessageQueue(queueGroupId, this.reachableFilter, brokerFilter);
            if (mq2 != null) {
                return mq2;
            }
            return tpInfo.selectOneMessageQueue(queueGroupId, new TopicPublishInfo.QueueFilter[0]);
        }
        if (tpInfo.isMainQueuePreferred() && (mq = tpInfo.selectOneMessageQueue(queueGroupId, this.mainQueueFilter, brokerFilter)) != null) {
            return mq;
        }
        mq = tpInfo.selectOneMessageQueue(queueGroupId, brokerFilter);
        if (mq != null) {
            return mq;
        }
        return tpInfo.selectOneMessageQueue(queueGroupId, new TopicPublishInfo.QueueFilter[0]);
    }

    public void updateFaultItem(String brokerName, long currentLatency, boolean isolation, boolean reachable) {
        if (this.sendLatencyFaultEnable) {
            long duration = this.computeNotAvailableDuration(isolation ? 10000L : currentLatency);
            this.latencyFaultTolerance.updateFaultItem(brokerName, currentLatency, duration, reachable);
        }
    }

    private long computeNotAvailableDuration(long currentLatency) {
        for (int i = this.latencyMax.length - 1; i >= 0; --i) {
            if (currentLatency < this.latencyMax[i]) continue;
            return this.notAvailableDuration[i];
        }
        return 0L;
    }

    private boolean isLatencyFaultEnable(boolean remoteFaultTolerance) {
        return this.sendLatencyFaultEnable && remoteFaultTolerance;
    }

    private class BrokerFilter
    implements TopicPublishInfo.QueueFilter {
        private String lastBrokerName;

        private BrokerFilter() {
        }

        public void setLastBrokerName(String lastBrokerName) {
            this.lastBrokerName = lastBrokerName;
        }

        @Override
        public boolean filter(MessageQueue mq) {
            if (this.lastBrokerName != null) {
                return !mq.getBrokerName().equals(this.lastBrokerName);
            }
            return true;
        }
    }
}

