/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ots.model;

import com.aliyun.common.utils.CodingUtils;
import com.aliyun.openservices.ots.internal.OTSUtil;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class RowQueryCriteria {
    private String tableName;
    private List<String> columnsToGet = new LinkedList<String>();

    public RowQueryCriteria(String tableName) {
        this.setTableName(tableName);
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        CodingUtils.assertStringNotNullOrEmpty(tableName, "tableName");
        OTSUtil.ensureNameValid(tableName);
        this.tableName = tableName;
    }

    public List<String> getColumnsToGet() {
        return Collections.unmodifiableList(this.columnsToGet);
    }

    public void addColumnsToGet(String columnName) {
        CodingUtils.assertStringNotNullOrEmpty(columnName, "columnName");
        OTSUtil.ensureNameValid(columnName);
        this.columnsToGet.add(columnName);
    }

    public void addColumnsToGet(String[] columnNames) {
        int i;
        CodingUtils.assertParameterNotNull(columnNames, "columnNames");
        for (i = 0; i < columnNames.length; ++i) {
            OTSUtil.ensureNameValid(columnNames[i]);
        }
        for (i = 0; i < columnNames.length; ++i) {
            this.columnsToGet.add(columnNames[i]);
        }
    }

    public void setColumnsToGet(List<String> columnsToGet) {
        CodingUtils.assertParameterNotNull(columnsToGet, "columnsToGet");
        this.columnsToGet = columnsToGet;
    }
}

