/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ots.model;

import com.aliyun.openservices.ots.internal.OTSUtil;
import com.aliyun.openservices.ots.model.BatchGetRowResult;
import com.aliyun.openservices.ots.model.BatchWriteRowResult;
import com.aliyun.openservices.ots.model.CapacityUnit;
import com.aliyun.openservices.ots.model.ColumnType;
import com.aliyun.openservices.ots.model.ColumnValue;
import com.aliyun.openservices.ots.model.ConsumedCapacity;
import com.aliyun.openservices.ots.model.Direction;
import com.aliyun.openservices.ots.model.Error;
import com.aliyun.openservices.ots.model.MultiRowQueryCriteria;
import com.aliyun.openservices.ots.model.PrimaryKeyType;
import com.aliyun.openservices.ots.model.PrimaryKeyValue;
import com.aliyun.openservices.ots.model.RangeRowQueryCriteria;
import com.aliyun.openservices.ots.model.ReservedThroughput;
import com.aliyun.openservices.ots.model.ReservedThroughputChange;
import com.aliyun.openservices.ots.model.ReservedThroughputDetails;
import com.aliyun.openservices.ots.model.Row;
import com.aliyun.openservices.ots.model.RowDeleteChange;
import com.aliyun.openservices.ots.model.RowExistenceExpectation;
import com.aliyun.openservices.ots.model.RowPrimaryKey;
import com.aliyun.openservices.ots.model.RowPutChange;
import com.aliyun.openservices.ots.model.RowUpdateChange;
import com.aliyun.openservices.ots.model.SingleRowQueryCriteria;
import com.aliyun.openservices.ots.model.TableMeta;
import com.aliyun.openservices.ots.protocol.OtsProtocol2;
import com.google.protobuf.ByteString;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class OTSProtocolHelper {
    public static OtsProtocol2.ColumnType toPBColumnType(PrimaryKeyType pkType) {
        switch (pkType) {
            case INTEGER: {
                return OtsProtocol2.ColumnType.INTEGER;
            }
            case STRING: {
                return OtsProtocol2.ColumnType.STRING;
            }
        }
        throw new IllegalArgumentException(OTSUtil.OTS_RESOURCE_MANAGER.getFormattedString("InvalidPrimaryKeyType", pkType.toString()));
    }

    public static PrimaryKeyType toPrimaryKeyType(OtsProtocol2.ColumnType type) {
        switch (type) {
            case INTEGER: {
                return PrimaryKeyType.INTEGER;
            }
            case STRING: {
                return PrimaryKeyType.STRING;
            }
        }
        throw new IllegalArgumentException(OTSUtil.OTS_RESOURCE_MANAGER.getFormattedString("InvalidPrimaryKeyType", type.toString()));
    }

    public static OtsProtocol2.ColumnType toPBColumnType(ColumnType colType) {
        switch (colType) {
            case BOOLEAN: {
                return OtsProtocol2.ColumnType.BOOLEAN;
            }
            case INTEGER: {
                return OtsProtocol2.ColumnType.INTEGER;
            }
            case STRING: {
                return OtsProtocol2.ColumnType.STRING;
            }
            case DOUBLE: {
                return OtsProtocol2.ColumnType.DOUBLE;
            }
            case BINARY: {
                return OtsProtocol2.ColumnType.BINARY;
            }
        }
        throw new IllegalArgumentException(OTSUtil.OTS_RESOURCE_MANAGER.getFormattedString("InvalidColumnType", colType.toString()));
    }

    public static ColumnType toColumnType(OtsProtocol2.ColumnType type) {
        switch (type) {
            case BOOLEAN: {
                return ColumnType.BOOLEAN;
            }
            case DOUBLE: {
                return ColumnType.DOUBLE;
            }
            case INTEGER: {
                return ColumnType.INTEGER;
            }
            case STRING: {
                return ColumnType.STRING;
            }
            case BINARY: {
                return ColumnType.BINARY;
            }
        }
        throw new IllegalArgumentException(OTSUtil.OTS_RESOURCE_MANAGER.getFormattedString("InvalidColumnType", type.toString()));
    }

    public static OtsProtocol2.ColumnValue buildColumnValue(PrimaryKeyValue primaryKey) {
        OtsProtocol2.ColumnValue.Builder builder = OtsProtocol2.ColumnValue.newBuilder();
        switch (primaryKey.getType()) {
            case INTEGER: {
                builder.setType(OtsProtocol2.ColumnType.INTEGER);
                builder.setVInt(primaryKey.asLong());
                break;
            }
            case STRING: {
                builder.setType(OtsProtocol2.ColumnType.STRING);
                builder.setVString(primaryKey.asString());
                break;
            }
            default: {
                throw new IllegalArgumentException(OTSUtil.OTS_RESOURCE_MANAGER.getFormattedString("InvalidPartitionKeyType", primaryKey.getType().toString()));
            }
        }
        return builder.build();
    }

    public static PrimaryKeyValue toPrimaryKeyValue(OtsProtocol2.ColumnValue value) {
        switch (value.getType()) {
            case INTEGER: {
                if (!value.hasVInt()) {
                    throw new IllegalArgumentException(OTSUtil.OTS_RESOURCE_MANAGER.getFormattedString("ValueNotSet", "ColumnValue.v_int"));
                }
                return PrimaryKeyValue.fromLong(value.getVInt());
            }
            case STRING: {
                if (!value.hasVString()) {
                    throw new IllegalArgumentException(OTSUtil.OTS_RESOURCE_MANAGER.getFormattedString("ValueNotSet", "ColumnValue.v_string"));
                }
                return PrimaryKeyValue.fromString(value.getVString());
            }
        }
        throw new IllegalArgumentException(OTSUtil.OTS_RESOURCE_MANAGER.getFormattedString("InvalidPrimaryKeyType", value.getType().toString()));
    }

    public static OtsProtocol2.ColumnValue buildColumnValue(ColumnValue column) {
        OtsProtocol2.ColumnValue.Builder builder = OtsProtocol2.ColumnValue.newBuilder();
        switch (column.getType()) {
            case INTEGER: {
                builder.setType(OtsProtocol2.ColumnType.INTEGER);
                builder.setVInt(column.asLong());
                break;
            }
            case STRING: {
                builder.setType(OtsProtocol2.ColumnType.STRING);
                builder.setVString(column.asString());
                break;
            }
            case BOOLEAN: {
                builder.setType(OtsProtocol2.ColumnType.BOOLEAN);
                builder.setVBool(column.asBoolean());
                break;
            }
            case DOUBLE: {
                builder.setType(OtsProtocol2.ColumnType.DOUBLE);
                builder.setVDouble(column.asDouble());
                break;
            }
            case BINARY: {
                builder.setType(OtsProtocol2.ColumnType.BINARY);
                builder.setVBinary(ByteString.copyFrom((byte[])column.asBinary()));
                break;
            }
            default: {
                throw new IllegalArgumentException(OTSUtil.OTS_RESOURCE_MANAGER.getFormattedString("InvalidColumnType", column.getType().toString()));
            }
        }
        return builder.build();
    }

    public static ColumnValue toColumnValue(OtsProtocol2.ColumnValue value) {
        switch (value.getType()) {
            case BOOLEAN: {
                if (!value.hasVBool()) {
                    throw new IllegalArgumentException(OTSUtil.OTS_RESOURCE_MANAGER.getFormattedString("ValueNotSet", "ColumnValue.v_bool"));
                }
                return ColumnValue.fromBoolean(value.getVBool());
            }
            case INTEGER: {
                if (!value.hasVInt()) {
                    throw new IllegalArgumentException(OTSUtil.OTS_RESOURCE_MANAGER.getFormattedString("ValueNotSet", "ColumnValue.v_int"));
                }
                return ColumnValue.fromLong(value.getVInt());
            }
            case STRING: {
                if (!value.hasVString()) {
                    throw new IllegalArgumentException(OTSUtil.OTS_RESOURCE_MANAGER.getFormattedString("ValueNotSet", "ColumnValue.v_string"));
                }
                return ColumnValue.fromString(value.getVString());
            }
            case DOUBLE: {
                if (!value.hasVDouble()) {
                    throw new IllegalArgumentException(OTSUtil.OTS_RESOURCE_MANAGER.getFormattedString("ValueNotSet", "ColumnValue.v_double"));
                }
                return ColumnValue.fromDouble(value.getVDouble());
            }
            case BINARY: {
                if (!value.hasVBinary()) {
                    throw new IllegalArgumentException(OTSUtil.OTS_RESOURCE_MANAGER.getFormattedString("ValueNotSet", "ColumnValue.v_binary"));
                }
                return ColumnValue.fromBinary(value.getVBinary().toByteArray());
            }
        }
        throw new IllegalArgumentException(OTSUtil.OTS_RESOURCE_MANAGER.getFormattedString("InvalidColumnType", value.getType().toString()));
    }

    public static OtsProtocol2.RowExistenceExpectation toPBRowExistenceExpectation(RowExistenceExpectation rowExistenceExpectation) {
        switch (rowExistenceExpectation) {
            case EXPECT_EXIST: {
                return OtsProtocol2.RowExistenceExpectation.EXPECT_EXIST;
            }
            case EXPECT_NOT_EXIST: {
                return OtsProtocol2.RowExistenceExpectation.EXPECT_NOT_EXIST;
            }
            case IGNORE: {
                return OtsProtocol2.RowExistenceExpectation.IGNORE;
            }
        }
        throw new IllegalArgumentException("Invalid row existence expectation: " + (Object)((Object)rowExistenceExpectation));
    }

    public static OtsProtocol2.Column buildColumn(String name, PrimaryKeyValue value) {
        OtsProtocol2.Column.Builder builder = OtsProtocol2.Column.newBuilder();
        builder.setName(name);
        builder.setValue(OTSProtocolHelper.buildColumnValue(value));
        return builder.build();
    }

    public static OtsProtocol2.Column buildColumn(String name, ColumnValue value) {
        OtsProtocol2.Column.Builder builder = OtsProtocol2.Column.newBuilder();
        builder.setName(name);
        builder.setValue(OTSProtocolHelper.buildColumnValue(value));
        return builder.build();
    }

    public static OtsProtocol2.ColumnSchema buildColumnSchema(String name, PrimaryKeyType type) {
        OtsProtocol2.ColumnSchema.Builder builder = OtsProtocol2.ColumnSchema.newBuilder();
        builder.setName(name);
        builder.setType(OTSProtocolHelper.toPBColumnType(type));
        return builder.build();
    }

    public static OtsProtocol2.TableMeta buildTableMeta(TableMeta tableMeta) {
        OtsProtocol2.TableMeta.Builder builder = OtsProtocol2.TableMeta.newBuilder();
        builder.setTableName(tableMeta.getTableName());
        for (Map.Entry<String, PrimaryKeyType> entry : tableMeta.getPrimaryKey().entrySet()) {
            builder.addPrimaryKey(OTSProtocolHelper.buildColumnSchema(entry.getKey(), entry.getValue()));
        }
        return builder.build();
    }

    public static byte[] buildGetRowRequest(SingleRowQueryCriteria criteria) {
        OtsProtocol2.GetRowRequest.Builder builder = OtsProtocol2.GetRowRequest.newBuilder();
        builder.setTableName(criteria.getTableName());
        for (Map.Entry<String, PrimaryKeyValue> entry : criteria.getRowPrimaryKey().getPrimaryKey().entrySet()) {
            builder.addPrimaryKey(OTSProtocolHelper.buildColumn(entry.getKey(), entry.getValue()));
        }
        for (String name : criteria.getColumnsToGet()) {
            builder.addColumnsToGet(name);
        }
        return builder.build().toByteArray();
    }

    public static OtsProtocol2.Row buildRow(Map<String, PrimaryKeyValue> primaryKey, Map<String, ColumnValue> attributeColumns) {
        OtsProtocol2.Row.Builder builder = OtsProtocol2.Row.newBuilder();
        for (Map.Entry<String, PrimaryKeyValue> entry : primaryKey.entrySet()) {
            builder.addPrimaryKeyColumns(OTSProtocolHelper.buildColumn(entry.getKey(), entry.getValue()));
        }
        for (Map.Entry<String, Object> entry : attributeColumns.entrySet()) {
            builder.addAttributeColumns(OTSProtocolHelper.buildColumn(entry.getKey(), (ColumnValue)entry.getValue()));
        }
        return builder.build();
    }

    public static byte[] buildCreateTableRequest(TableMeta tableMeta, ReservedThroughput reservedThroughput) {
        OtsProtocol2.CreateTableRequest.Builder builder = OtsProtocol2.CreateTableRequest.newBuilder();
        builder.setTableMeta(OTSProtocolHelper.buildTableMeta(tableMeta));
        builder.setReservedThroughput(OTSProtocolHelper.buildReservedThroughput(reservedThroughput));
        return builder.build().toByteArray();
    }

    private static OtsProtocol2.ReservedThroughput buildReservedThroughput(ReservedThroughput reservedThroughput) {
        OtsProtocol2.ReservedThroughput.Builder rtBuilder = OtsProtocol2.ReservedThroughput.newBuilder();
        CapacityUnit capacityUnit = reservedThroughput.getCapacityUnit();
        OtsProtocol2.CapacityUnit.Builder builder = OtsProtocol2.CapacityUnit.newBuilder();
        builder.setRead(capacityUnit.getReadCapacityUnit());
        builder.setWrite(capacityUnit.getWriteCapacityUnit());
        rtBuilder.setCapacityUnit(builder.build());
        return rtBuilder.build();
    }

    public static byte[] buildDeleteTableRequest(String tableName) {
        OtsProtocol2.DeleteTableRequest.Builder builder = OtsProtocol2.DeleteTableRequest.newBuilder();
        builder.setTableName(tableName);
        return builder.build().toByteArray();
    }

    public static byte[] buildDeleteRowRequest(RowDeleteChange rowChange) {
        OtsProtocol2.DeleteRowRequest.Builder builder = OtsProtocol2.DeleteRowRequest.newBuilder();
        builder.setTableName(rowChange.getTableName());
        OtsProtocol2.Condition.Builder condBuilder = OtsProtocol2.Condition.newBuilder();
        condBuilder.setRowExistence(OTSProtocolHelper.toPBRowExistenceExpectation(rowChange.getCondition().getRowExistenceExpectation()));
        builder.setCondition(condBuilder.build());
        for (Map.Entry<String, PrimaryKeyValue> entry : rowChange.getRowPrimaryKey().getPrimaryKey().entrySet()) {
            builder.addPrimaryKey(OTSProtocolHelper.buildColumn(entry.getKey(), entry.getValue()));
        }
        return builder.build().toByteArray();
    }

    public static byte[] buildPutRowRequest(RowPutChange rowChange) {
        OtsProtocol2.PutRowRequest.Builder builder = OtsProtocol2.PutRowRequest.newBuilder();
        builder.setTableName(rowChange.getTableName());
        OtsProtocol2.Condition.Builder condBuilder = OtsProtocol2.Condition.newBuilder();
        condBuilder.setRowExistence(OTSProtocolHelper.toPBRowExistenceExpectation(rowChange.getCondition().getRowExistenceExpectation()));
        builder.setCondition(condBuilder.build());
        for (Map.Entry<String, PrimaryKeyValue> entry : rowChange.getRowPrimaryKey().getPrimaryKey().entrySet()) {
            builder.addPrimaryKey(OTSProtocolHelper.buildColumn(entry.getKey(), entry.getValue()));
        }
        for (Map.Entry<String, Object> entry : rowChange.getAttributeColumns().entrySet()) {
            builder.addAttributeColumns(OTSProtocolHelper.buildColumn(entry.getKey(), (ColumnValue)entry.getValue()));
        }
        return builder.build().toByteArray();
    }

    public static ReservedThroughputDetails parseCapacityUnitDetails(OtsProtocol2.ReservedThroughputDetails capacityUnitDetails) {
        ReservedThroughputDetails details = new ReservedThroughputDetails();
        CapacityUnit tableCU = new CapacityUnit();
        OtsProtocol2.CapacityUnit capacityUnit = capacityUnitDetails.getCapacityUnit();
        if (capacityUnit.hasRead()) {
            tableCU.setReadCapacityUnit(capacityUnit.getRead());
        }
        if (capacityUnit.hasWrite()) {
            tableCU.setWriteCapacityUnit(capacityUnit.getWrite());
        }
        details.setCapacityUnit(tableCU);
        details.setLastIncreaseTime(capacityUnitDetails.getLastIncreaseTime());
        details.setNumberOfDecreasesToday(capacityUnitDetails.getNumberOfDecreasesToday());
        if (capacityUnitDetails.hasLastDecreaseTime()) {
            details.setLastDecreaseTime(capacityUnitDetails.getLastDecreaseTime());
        }
        return details;
    }

    public static TableMeta parseTableMeta(OtsProtocol2.TableMeta meta) {
        TableMeta tableMeta = new TableMeta(meta.getTableName());
        for (OtsProtocol2.ColumnSchema pk : meta.getPrimaryKeyList()) {
            tableMeta.addPrimaryKeyColumn(pk.getName(), OTSProtocolHelper.toPrimaryKeyType(pk.getType()));
        }
        return tableMeta;
    }

    public static Row parseRow(OtsProtocol2.Row pbRow) {
        Row row = new Row();
        for (OtsProtocol2.Column pk : pbRow.getPrimaryKeyColumnsList()) {
            row.addColumn(pk.getName(), OTSProtocolHelper.toColumnValue(pk.getValue()));
        }
        for (OtsProtocol2.Column col : pbRow.getAttributeColumnsList()) {
            row.addColumn(col.getName(), OTSProtocolHelper.toColumnValue(col.getValue()));
        }
        return row;
    }

    public static Row parseGetRowResponse(OtsProtocol2.GetRowResponse response) {
        return OTSProtocolHelper.parseRow(response.getRow());
    }

    public static byte[] buildListTableRequest() {
        OtsProtocol2.ListTableRequest.Builder builder = OtsProtocol2.ListTableRequest.newBuilder();
        return builder.build().toByteArray();
    }

    public static byte[] buildDescribeTableRequest(String tableName) {
        OtsProtocol2.DescribeTableRequest.Builder builder = OtsProtocol2.DescribeTableRequest.newBuilder();
        builder.setTableName(tableName);
        return builder.build().toByteArray();
    }

    public static byte[] buildUpdateTableReservedThroughputRequest(String tableName, ReservedThroughputChange rtChange) {
        OtsProtocol2.UpdateTableRequest.Builder builder = OtsProtocol2.UpdateTableRequest.newBuilder();
        builder.setTableName(tableName);
        OtsProtocol2.ReservedThroughput.Builder rtBuilder = OtsProtocol2.ReservedThroughput.newBuilder();
        OtsProtocol2.CapacityUnit.Builder cuBuilder = OtsProtocol2.CapacityUnit.newBuilder();
        if (rtChange.isReadSet()) {
            cuBuilder.setRead(rtChange.getReadCapacityUnit());
        }
        if (rtChange.isWriteSet()) {
            cuBuilder.setWrite(rtChange.getWriteCapacityUnit());
        }
        rtBuilder.setCapacityUnit(cuBuilder.build());
        builder.setReservedThroughput(rtBuilder.build());
        return builder.build().toByteArray();
    }

    public static byte[] buildUpdateRowRequest(RowUpdateChange rowChange) {
        OtsProtocol2.UpdateRowRequest.Builder builder = OtsProtocol2.UpdateRowRequest.newBuilder();
        builder.setTableName(rowChange.getTableName());
        OtsProtocol2.Condition.Builder condBuilder = OtsProtocol2.Condition.newBuilder();
        condBuilder.setRowExistence(OTSProtocolHelper.toPBRowExistenceExpectation(rowChange.getCondition().getRowExistenceExpectation()));
        builder.setCondition(condBuilder.build());
        for (Map.Entry<String, PrimaryKeyValue> entry : rowChange.getRowPrimaryKey().getPrimaryKey().entrySet()) {
            builder.addPrimaryKey(OTSProtocolHelper.buildColumn(entry.getKey(), entry.getValue()));
        }
        for (Map.Entry<String, Object> entry : rowChange.getAttributeColumns().entrySet()) {
            OtsProtocol2.ColumnUpdate.Builder columnUpdateBuilder = OtsProtocol2.ColumnUpdate.newBuilder();
            columnUpdateBuilder.setName(entry.getKey());
            if (entry.getValue() != null) {
                columnUpdateBuilder.setType(OtsProtocol2.OperationType.PUT);
                columnUpdateBuilder.setValue(OTSProtocolHelper.buildColumnValue((ColumnValue)entry.getValue()));
            } else {
                columnUpdateBuilder.setType(OtsProtocol2.OperationType.DELETE);
            }
            builder.addAttributeColumns(columnUpdateBuilder.build());
        }
        return builder.build().toByteArray();
    }

    public static OtsProtocol2.Direction toPBDirection(Direction direction) {
        switch (direction) {
            case BACKWARD: {
                return OtsProtocol2.Direction.BACKWARD;
            }
            case FORWARD: {
                return OtsProtocol2.Direction.FORWARD;
            }
        }
        throw new IllegalArgumentException("Invalid direction type: " + (Object)((Object)direction));
    }

    public static OtsProtocol2.Column buildRangeColumn(String name, PrimaryKeyValue value) {
        OtsProtocol2.Column.Builder builder = OtsProtocol2.Column.newBuilder();
        builder.setName(name);
        if (value == PrimaryKeyValue.INF_MIN) {
            OtsProtocol2.ColumnValue.Builder valueBuilder = OtsProtocol2.ColumnValue.newBuilder();
            valueBuilder.setType(OtsProtocol2.ColumnType.INF_MIN);
            builder.setValue(valueBuilder.build());
        } else if (value == PrimaryKeyValue.INF_MAX) {
            OtsProtocol2.ColumnValue.Builder valueBuilder = OtsProtocol2.ColumnValue.newBuilder();
            valueBuilder.setType(OtsProtocol2.ColumnType.INF_MAX);
            builder.setValue(valueBuilder.build());
        } else {
            builder.setValue(OTSProtocolHelper.buildColumnValue(value));
        }
        return builder.build();
    }

    public static byte[] buildGetRangeRequest(RangeRowQueryCriteria criteria) {
        OtsProtocol2.GetRangeRequest.Builder builder = OtsProtocol2.GetRangeRequest.newBuilder();
        builder.setTableName(criteria.getTableName());
        builder.setDirection(OTSProtocolHelper.toPBDirection(criteria.getDirection()));
        for (String string : criteria.getColumnsToGet()) {
            builder.addColumnsToGet(string);
        }
        if (criteria.getLimit() >= 0) {
            builder.setLimit(criteria.getLimit());
        }
        for (Map.Entry entry : criteria.getInclusiveStartPrimaryKey().getPrimaryKey().entrySet()) {
            builder.addInclusiveStartPrimaryKey(OTSProtocolHelper.buildRangeColumn((String)entry.getKey(), (PrimaryKeyValue)entry.getValue()));
        }
        for (Map.Entry entry : criteria.getExclusiveEndPrimaryKey().getPrimaryKey().entrySet()) {
            builder.addExclusiveEndPrimaryKey(OTSProtocolHelper.buildRangeColumn((String)entry.getKey(), (PrimaryKeyValue)entry.getValue()));
        }
        return builder.build().toByteArray();
    }

    public static byte[] buildBatchGetRowRequest(Map<String, MultiRowQueryCriteria> criteriasGroupByTable) {
        OtsProtocol2.BatchGetRowRequest.Builder builder = OtsProtocol2.BatchGetRowRequest.newBuilder();
        for (Map.Entry<String, MultiRowQueryCriteria> entry : criteriasGroupByTable.entrySet()) {
            String tableName = entry.getKey();
            MultiRowQueryCriteria criteria = entry.getValue();
            OtsProtocol2.TableInBatchGetRowRequest.Builder tableBuilder = OtsProtocol2.TableInBatchGetRowRequest.newBuilder();
            tableBuilder.setTableName(tableName);
            for (RowPrimaryKey primaryKey : criteria.getRowKeys()) {
                OtsProtocol2.RowInBatchGetRowRequest.Builder rowBuilder = OtsProtocol2.RowInBatchGetRowRequest.newBuilder();
                for (Map.Entry<String, PrimaryKeyValue> key : primaryKey.getPrimaryKey().entrySet()) {
                    rowBuilder.addPrimaryKey(OTSProtocolHelper.buildColumn(key.getKey(), key.getValue()));
                }
                tableBuilder.addRows(rowBuilder.build());
            }
            for (String column : criteria.getColumnsToGet()) {
                tableBuilder.addColumnsToGet(column);
            }
            builder.addTables(tableBuilder.build());
        }
        return builder.build().toByteArray();
    }

    public static byte[] buildBatchWriteRowRequest(Map<String, List<RowPutChange>> rowPutChangesGroupByTable, Map<String, List<RowUpdateChange>> rowUpdateChangesGroupByTable, Map<String, List<RowDeleteChange>> rowDeleteChangesGroupByTable) {
        HashSet<String> allTables = new HashSet<String>();
        allTables.addAll(rowPutChangesGroupByTable.keySet());
        allTables.addAll(rowUpdateChangesGroupByTable.keySet());
        allTables.addAll(rowDeleteChangesGroupByTable.keySet());
        OtsProtocol2.BatchWriteRowRequest.Builder builder = OtsProtocol2.BatchWriteRowRequest.newBuilder();
        for (String tableName : allTables) {
            List<RowDeleteChange> rowDeleteChanges;
            List<RowUpdateChange> rowUpdateChanges;
            OtsProtocol2.TableInBatchWriteRowRequest.Builder tableBuilder = OtsProtocol2.TableInBatchWriteRowRequest.newBuilder();
            tableBuilder.setTableName(tableName);
            List<RowPutChange> rowPutChanges = rowPutChangesGroupByTable.get(tableName);
            if (rowPutChanges != null) {
                for (RowPutChange rowPutChange : rowPutChanges) {
                    OtsProtocol2.PutRowInBatchWriteRowRequest.Builder putRowBuilder = OtsProtocol2.PutRowInBatchWriteRowRequest.newBuilder();
                    OtsProtocol2.Condition.Builder condBuilder = OtsProtocol2.Condition.newBuilder();
                    condBuilder.setRowExistence(OTSProtocolHelper.toPBRowExistenceExpectation(rowPutChange.getCondition().getRowExistenceExpectation()));
                    putRowBuilder.setCondition(condBuilder.build());
                    for (Map.Entry<String, PrimaryKeyValue> entry : rowPutChange.getRowPrimaryKey().getPrimaryKey().entrySet()) {
                        putRowBuilder.addPrimaryKey(OTSProtocolHelper.buildColumn(entry.getKey(), entry.getValue()));
                    }
                    for (Map.Entry<String, Object> entry : rowPutChange.getAttributeColumns().entrySet()) {
                        putRowBuilder.addAttributeColumns(OTSProtocolHelper.buildColumn(entry.getKey(), (ColumnValue)entry.getValue()));
                    }
                    tableBuilder.addPutRows(putRowBuilder.build());
                }
            }
            if ((rowUpdateChanges = rowUpdateChangesGroupByTable.get(tableName)) != null) {
                for (RowUpdateChange rowUpdateChange : rowUpdateChanges) {
                    OtsProtocol2.UpdateRowInBatchWriteRowRequest.Builder updateRowBuilder = OtsProtocol2.UpdateRowInBatchWriteRowRequest.newBuilder();
                    OtsProtocol2.Condition.Builder condBuilder = OtsProtocol2.Condition.newBuilder();
                    condBuilder.setRowExistence(OTSProtocolHelper.toPBRowExistenceExpectation(rowUpdateChange.getCondition().getRowExistenceExpectation()));
                    updateRowBuilder.setCondition(condBuilder.build());
                    for (Map.Entry<String, PrimaryKeyValue> entry : rowUpdateChange.getRowPrimaryKey().getPrimaryKey().entrySet()) {
                        updateRowBuilder.addPrimaryKey(OTSProtocolHelper.buildColumn(entry.getKey(), entry.getValue()));
                    }
                    for (Map.Entry<String, ColumnValue> entry : rowUpdateChange.getAttributeColumns().entrySet()) {
                        OtsProtocol2.ColumnUpdate.Builder columnUpdateBuilder = OtsProtocol2.ColumnUpdate.newBuilder();
                        columnUpdateBuilder.setName(entry.getKey());
                        if (entry.getValue() != null) {
                            columnUpdateBuilder.setType(OtsProtocol2.OperationType.PUT);
                            columnUpdateBuilder.setValue(OTSProtocolHelper.buildColumnValue(entry.getValue()));
                        } else {
                            columnUpdateBuilder.setType(OtsProtocol2.OperationType.DELETE);
                        }
                        updateRowBuilder.addAttributeColumns(columnUpdateBuilder.build());
                    }
                    tableBuilder.addUpdateRows(updateRowBuilder.build());
                }
            }
            if ((rowDeleteChanges = rowDeleteChangesGroupByTable.get(tableName)) != null) {
                for (RowDeleteChange rowDeleteChange : rowDeleteChanges) {
                    OtsProtocol2.DeleteRowInBatchWriteRowRequest.Builder deleteRowBuilder = OtsProtocol2.DeleteRowInBatchWriteRowRequest.newBuilder();
                    OtsProtocol2.Condition.Builder builder2 = OtsProtocol2.Condition.newBuilder();
                    builder2.setRowExistence(OTSProtocolHelper.toPBRowExistenceExpectation(rowDeleteChange.getCondition().getRowExistenceExpectation()));
                    deleteRowBuilder.setCondition(builder2.build());
                    for (Map.Entry<String, PrimaryKeyValue> primaryKey : rowDeleteChange.getRowPrimaryKey().getPrimaryKey().entrySet()) {
                        deleteRowBuilder.addPrimaryKey(OTSProtocolHelper.buildColumn(primaryKey.getKey(), primaryKey.getValue()));
                    }
                    tableBuilder.addDeleteRows(deleteRowBuilder.build());
                }
            }
            builder.addTables(tableBuilder.build());
        }
        return builder.build().toByteArray();
    }

    public static ConsumedCapacity parseConsumedCapacity(OtsProtocol2.ConsumedCapacity consumed) {
        ConsumedCapacity cc = new ConsumedCapacity();
        CapacityUnit cu = new CapacityUnit();
        OtsProtocol2.CapacityUnit capacityUnit = consumed.getCapacityUnit();
        if (capacityUnit.hasRead()) {
            cu.setReadCapacityUnit(capacityUnit.getRead());
        }
        if (capacityUnit.hasWrite()) {
            cu.setWriteCapacityUnit(capacityUnit.getWrite());
        }
        cc.setCapacityUnit(cu);
        return cc;
    }

    public static BatchGetRowResult.RowStatus parseBatchGetRowStatus(OtsProtocol2.RowInBatchGetRowResponse status) {
        if (status.getIsOk()) {
            Row row = OTSProtocolHelper.parseRow(status.getRow());
            ConsumedCapacity cc = OTSProtocolHelper.parseConsumedCapacity(status.getConsumed());
            return new BatchGetRowResult.RowStatus(row, cc);
        }
        Error error = new Error(status.getError().getCode(), status.getError().getMessage());
        return new BatchGetRowResult.RowStatus(error);
    }

    public static BatchWriteRowResult.RowStatus parseBatchWriteRowStatus(OtsProtocol2.RowInBatchWriteRowResponse status) {
        if (status.getIsOk()) {
            ConsumedCapacity cc = OTSProtocolHelper.parseConsumedCapacity(status.getConsumed());
            return new BatchWriteRowResult.RowStatus(cc);
        }
        Error error = new Error(status.getError().getCode(), status.getError().getMessage());
        return new BatchWriteRowResult.RowStatus(error);
    }
}

