/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ots.internal;

import com.aliyun.common.auth.ServiceCredentials;
import com.aliyun.common.comm.ServiceClient;
import com.aliyun.common.utils.CodingUtils;
import com.aliyun.openservices.ClientException;
import com.aliyun.openservices.HttpMethod;
import com.aliyun.openservices.ots.OTSException;
import com.aliyun.openservices.ots.OTSServiceConfiguration;
import com.aliyun.openservices.ots.internal.OTSOperation;
import com.aliyun.openservices.ots.internal.OTSResultParserFactory;
import com.aliyun.openservices.ots.internal.OTSUtil;
import com.aliyun.openservices.ots.internal.model.ResponseContentWithMeta;
import com.aliyun.openservices.ots.model.CreateTableRequest;
import com.aliyun.openservices.ots.model.CreateTableResult;
import com.aliyun.openservices.ots.model.DeleteTableRequest;
import com.aliyun.openservices.ots.model.DeleteTableResult;
import com.aliyun.openservices.ots.model.DescribeTableRequest;
import com.aliyun.openservices.ots.model.DescribeTableResult;
import com.aliyun.openservices.ots.model.ListTableResult;
import com.aliyun.openservices.ots.model.OTSProtocolHelper;
import com.aliyun.openservices.ots.model.OTSResultFactory;
import com.aliyun.openservices.ots.model.ReservedThroughput;
import com.aliyun.openservices.ots.model.TableMeta;
import com.aliyun.openservices.ots.model.UpdateTableRequest;
import com.aliyun.openservices.ots.model.UpdateTableResult;
import com.aliyun.openservices.ots.protocol.OtsProtocol2;
import com.google.protobuf.Message;
import java.net.URI;

public class OTSTableOperation
extends OTSOperation {
    private static final String ACTION_CREATE_TABLE = "CreateTable";
    private static final String ACTION_LIST_TABLE = "ListTable";
    private static final String ACTION_DELETE_TABLE = "DeleteTable";
    private static final String ACTION_DESCRIBE_TABLE = "DescribeTable";
    private static final String ACTION_UPDATE_TABLE = "UpdateTable";

    public OTSTableOperation(URI endpoint, String instanceName, ServiceClient client, ServiceCredentials credentials, OTSServiceConfiguration serviceConfig) {
        super(endpoint, instanceName, client, credentials, serviceConfig);
    }

    public OTSTableOperation(URI endpoint, String instanceName, ServiceClient client, ServiceCredentials credentials) {
        super(endpoint, instanceName, client, credentials, new OTSServiceConfiguration());
    }

    public ListTableResult listTables() throws OTSException, ClientException {
        ResponseContentWithMeta response = (ResponseContentWithMeta)this.invoke(ACTION_LIST_TABLE, HttpMethod.POST, null, OTSProtocolHelper.buildListTableRequest(), OTSResultParserFactory.createFactory().createProtocolBufferResultParser((Message)OtsProtocol2.ListTableResponse.getDefaultInstance()));
        OtsProtocol2.ListTableResponse listTableResponse = (OtsProtocol2.ListTableResponse)response.getMessage();
        return OTSResultFactory.createListTableResult(response, listTableResponse);
    }

    public CreateTableResult createTable(CreateTableRequest createTableRequest) {
        CodingUtils.assertParameterNotNull(createTableRequest, "createTableRequest");
        TableMeta tableMeta = createTableRequest.getTableMeta();
        ReservedThroughput tableCU = createTableRequest.getReservedThroughput();
        if (tableMeta.getPrimaryKey().size() == 0) {
            throw new IllegalArgumentException(OTSUtil.OTS_RESOURCE_MANAGER.getString("TableMetaHasNoPK"));
        }
        ResponseContentWithMeta response = (ResponseContentWithMeta)this.invoke(ACTION_CREATE_TABLE, HttpMethod.POST, null, OTSProtocolHelper.buildCreateTableRequest(tableMeta, tableCU), OTSResultParserFactory.createFactory().createProtocolBufferResultParser((Message)OtsProtocol2.CreateTableResponse.getDefaultInstance()));
        OtsProtocol2.CreateTableResponse createTableResponse = (OtsProtocol2.CreateTableResponse)response.getMessage();
        return OTSResultFactory.createCreateTableResult(response, createTableResponse);
    }

    public DescribeTableResult describeTable(DescribeTableRequest describeTableRequest) {
        CodingUtils.assertParameterNotNull(describeTableRequest, "createTableRequest");
        ResponseContentWithMeta response = (ResponseContentWithMeta)this.invoke(ACTION_DESCRIBE_TABLE, HttpMethod.POST, null, OTSProtocolHelper.buildDescribeTableRequest(describeTableRequest.getTableName()), OTSResultParserFactory.createFactory().createProtocolBufferResultParser((Message)OtsProtocol2.DescribeTableResponse.getDefaultInstance()));
        OtsProtocol2.DescribeTableResponse describeTableResponse = (OtsProtocol2.DescribeTableResponse)response.getMessage();
        return OTSResultFactory.createDescribeTableResult(response, describeTableResponse);
    }

    public DeleteTableResult deleteTable(DeleteTableRequest deleteTableRequest) {
        CodingUtils.assertParameterNotNull(deleteTableRequest, "deleteTableRequest");
        ResponseContentWithMeta response = (ResponseContentWithMeta)this.invoke(ACTION_DELETE_TABLE, HttpMethod.POST, null, OTSProtocolHelper.buildDescribeTableRequest(deleteTableRequest.getTableName()), OTSResultParserFactory.createFactory().createProtocolBufferResultParser((Message)OtsProtocol2.DeleteTableResponse.getDefaultInstance()));
        OtsProtocol2.DeleteTableResponse deleteTableResponse = (OtsProtocol2.DeleteTableResponse)response.getMessage();
        return OTSResultFactory.createDeleteTableResult(response, deleteTableResponse);
    }

    public UpdateTableResult updateTable(UpdateTableRequest updateTableRequest) {
        CodingUtils.assertParameterNotNull(updateTableRequest, "updateTableRequest");
        ResponseContentWithMeta response = (ResponseContentWithMeta)this.invoke(ACTION_UPDATE_TABLE, HttpMethod.POST, null, OTSProtocolHelper.buildUpdateTableReservedThroughputRequest(updateTableRequest.getTableName(), updateTableRequest.getReservedThrougputChange()), OTSResultParserFactory.createFactory().createProtocolBufferResultParser((Message)OtsProtocol2.UpdateTableResponse.getDefaultInstance()));
        OtsProtocol2.UpdateTableResponse updateTableResponse = (OtsProtocol2.UpdateTableResponse)response.getMessage();
        return OTSResultFactory.createUpdateTableResult(response, updateTableResponse);
    }
}

