/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ots.internal;

import com.aliyun.common.auth.RequestSigner;
import com.aliyun.common.auth.ServiceCredentials;
import com.aliyun.common.auth.ServiceSignature;
import com.aliyun.common.comm.RequestMessage;
import com.aliyun.common.utils.DateUtil;
import com.aliyun.common.utils.HttpUtil;
import com.aliyun.openservices.ClientException;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;

public class OTSRequestSigner
implements RequestSigner {
    private String otsAction;
    private ServiceCredentials credentials;

    public OTSRequestSigner(String otsAction, ServiceCredentials credentials) {
        assert (otsAction != null && credentials != null);
        this.otsAction = otsAction;
        this.credentials = credentials;
    }

    @Override
    public void sign(RequestMessage request) throws ClientException {
        OTSRequestSigner.addRequiredParameters(this.otsAction, request.getHeaders(), this.credentials);
        try {
            OTSRequestSigner.addSignature(this.otsAction, request.getMethod().toString(), request.getParameters(), request.getHeaders(), this.credentials);
        }
        catch (UnsupportedEncodingException e) {
            throw new ClientException("\u65e0\u6cd5\u8ba1\u7b97\u7b7e\u540d\uff1a" + e.getMessage());
        }
    }

    private static void addRequiredParameters(String action, Map<String, String> headers, ServiceCredentials credentials) {
        headers.put("x-ots-date", DateUtil.formatRfc822Date(new Date()));
        headers.put("x-ots-accesskeyid", credentials.getAccessKeyId());
    }

    private static void addSignature(String otsAction, String method, Map<String, String> queryParameters, Map<String, String> headers, ServiceCredentials credentials) throws UnsupportedEncodingException {
        headers.put("x-ots-signature", OTSRequestSigner.getSignature(otsAction, method, queryParameters, headers, credentials));
    }

    private static String getSignature(String action, String method, Map<String, String> queryParameters, Map<String, String> headers, ServiceCredentials credentials) throws UnsupportedEncodingException {
        StringBuilder canonicalizedOtsHeader = new StringBuilder(1000);
        Map<String, String> sortedMap = OTSRequestSigner.sortMap(headers);
        for (String key : sortedMap.keySet()) {
            if (!key.startsWith("x-ots-")) continue;
            canonicalizedOtsHeader.append(key).append(":").append(sortedMap.get(key)).append("\n");
        }
        StringBuilder sb = new StringBuilder(1000);
        sb.append("/").append(action).append("\n").append(method).append("\n").append(queryParameters.size() == 0 ? "" : HttpUtil.paramToQueryString(OTSRequestSigner.sortMap(queryParameters), "utf-8")).append("\n").append(canonicalizedOtsHeader.toString());
        return ServiceSignature.create().computeSignature(credentials.getAccessKeySecret(), sb.toString());
    }

    private static Map<String, String> sortMap(Map<String, String> unsortMap) {
        TreeMap<String, String> sortedMap = new TreeMap<String, String>();
        sortedMap.putAll(unsortMap);
        return sortedMap;
    }
}

