/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.oss.internal;

import com.aliyun.common.auth.ServiceCredentials;
import com.aliyun.common.comm.ExecutionContext;
import com.aliyun.common.comm.RequestMessage;
import com.aliyun.common.comm.ResponseMessage;
import com.aliyun.common.comm.ServiceClient;
import com.aliyun.common.utils.CodingUtils;
import com.aliyun.openservices.ClientException;
import com.aliyun.openservices.HttpMethod;
import com.aliyun.openservices.oss.OSSException;
import com.aliyun.openservices.oss.internal.OSSOperation;
import com.aliyun.openservices.oss.internal.OSSRequestMessageBuilder;
import com.aliyun.openservices.oss.internal.OSSUtils;
import com.aliyun.openservices.oss.internal.ResponseParser;
import com.aliyun.openservices.oss.model.AbortMultipartUploadRequest;
import com.aliyun.openservices.oss.model.CompleteMultipartUploadRequest;
import com.aliyun.openservices.oss.model.CompleteMultipartUploadResult;
import com.aliyun.openservices.oss.model.InitiateMultipartUploadRequest;
import com.aliyun.openservices.oss.model.InitiateMultipartUploadResult;
import com.aliyun.openservices.oss.model.ListMultipartUploadsRequest;
import com.aliyun.openservices.oss.model.ListPartsRequest;
import com.aliyun.openservices.oss.model.MultipartUploadListing;
import com.aliyun.openservices.oss.model.PartETag;
import com.aliyun.openservices.oss.model.PartListing;
import com.aliyun.openservices.oss.model.UploadPartRequest;
import com.aliyun.openservices.oss.model.UploadPartResult;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;

public class OSSMultipartOperation
extends OSSOperation {
    private static final int LIST_PART_MAX_PARTS = 1000;
    private static final String SUBRESOURCE_UPLOADS = "uploads";

    public OSSMultipartOperation(URI endpoint, ServiceClient client, ServiceCredentials cred) {
        super(endpoint, client, cred);
    }

    public void abortMultipartUpload(AbortMultipartUploadRequest abortMultipartUploadRequest) throws OSSException, ClientException {
        String objectKey = abortMultipartUploadRequest.getKey();
        String bucketName = abortMultipartUploadRequest.getBucketName();
        String uploadId = abortMultipartUploadRequest.getUploadId();
        this.assertBucketName(bucketName);
        this.assertObjectKey(objectKey);
        this.assertUploadIdNotNull(uploadId);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("uploadId", uploadId);
        RequestMessage request = new OSSRequestMessageBuilder().setEndpoint(this.getEndpoint()).setMethod(HttpMethod.DELETE).setBucket(bucketName).setKey(objectKey).setParameters(parameters).build();
        ExecutionContext context = this.createDefaultContext(request.getMethod(), bucketName, objectKey);
        this.send(request, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompleteMultipartUploadResult completeMultipartUpload(CompleteMultipartUploadRequest completeMultipartUploadRequest) throws OSSException, ClientException {
        byte[] inputBytes;
        String objectKey = completeMultipartUploadRequest.getKey();
        String bucketName = completeMultipartUploadRequest.getBucketName();
        String uploadId = completeMultipartUploadRequest.getUploadId();
        this.assertBucketName(bucketName);
        this.assertObjectKey(objectKey);
        this.assertUploadIdNotNull(uploadId);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "text/plain");
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("uploadId", uploadId);
        String multipartRequestXml = OSSMultipartOperation.buildMultipartRequestXml(completeMultipartUploadRequest.getPartETags());
        try {
            inputBytes = multipartRequestXml.getBytes("utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new ClientException(e);
        }
        ByteArrayInputStream input = new ByteArrayInputStream(inputBytes);
        RequestMessage request = new OSSRequestMessageBuilder().setEndpoint(this.getEndpoint()).setMethod(HttpMethod.POST).setBucket(bucketName).setKey(objectKey).setHeaders(headers).setParameters(parameters).setInputStream(input).setInputSize(inputBytes.length).build();
        ExecutionContext context = this.createDefaultContext(request.getMethod(), bucketName, objectKey);
        ResponseMessage response = this.send(request, context, true);
        try {
            CompleteMultipartUploadResult result;
            CompleteMultipartUploadResult completeMultipartUploadResult = result = ResponseParser.parseCompleteMultipartUpload(response.getContent());
            return completeMultipartUploadResult;
        }
        finally {
            OSSUtils.safeCloseResponse(response);
        }
    }

    private static String buildMultipartRequestXml(List<PartETag> eTags) throws IllegalArgumentException {
        StringBuffer xml = new StringBuffer();
        int size = eTags.size();
        xml.append("<CompleteMultipartUpload>");
        for (int i = 0; i < size; ++i) {
            PartETag part = eTags.get(i);
            String eTag = "&quot;" + part.getETag().replace("\"", "") + "&quot;";
            int partNumber = part.getPartNumber();
            xml.append("<Part>");
            xml.append("<PartNumber>" + partNumber + "</PartNumber>");
            xml.append("<ETag>" + eTag + "</ETag>");
            xml.append("</Part>");
        }
        xml.append("</CompleteMultipartUpload>");
        return xml.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InitiateMultipartUploadResult initiateMultipartUpload(InitiateMultipartUploadRequest initiateMultipartUploadRequest) throws OSSException, ClientException {
        String objectKey = initiateMultipartUploadRequest.getKey();
        String bucketName = initiateMultipartUploadRequest.getBucketName();
        this.assertBucketName(bucketName);
        this.assertObjectKey(objectKey);
        HashMap<String, String> headers = new HashMap<String, String>();
        if (initiateMultipartUploadRequest.getObjectMetadata() != null) {
            OSSUtils.populateRequestMetadata(headers, initiateMultipartUploadRequest.getObjectMetadata());
        }
        headers.remove("Content-Length");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(SUBRESOURCE_UPLOADS, null);
        RequestMessage request = new OSSRequestMessageBuilder().setEndpoint(this.getEndpoint()).setMethod(HttpMethod.POST).setBucket(bucketName).setKey(objectKey).setHeaders(headers).setParameters(params).setInputStream(new ByteArrayInputStream(new byte[0])).setInputSize(0L).build();
        ExecutionContext context = this.createDefaultContext(request.getMethod(), bucketName, objectKey);
        ResponseMessage response = this.send(request, context, true);
        try {
            InitiateMultipartUploadResult result;
            InitiateMultipartUploadResult initiateMultipartUploadResult = result = ResponseParser.parseInitiateMultipartUpload(response.getContent());
            return initiateMultipartUploadResult;
        }
        finally {
            OSSUtils.safeCloseResponse(response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MultipartUploadListing listMultipartUploads(ListMultipartUploadsRequest listMultipartUploadsRequest) throws OSSException, ClientException {
        String bucketName = listMultipartUploadsRequest.getBucketName();
        this.assertBucketName(bucketName);
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put(SUBRESOURCE_UPLOADS, null);
        if (listMultipartUploadsRequest.getDelimiter() != null) {
            params.put("delimiter", listMultipartUploadsRequest.getDelimiter());
        }
        if (listMultipartUploadsRequest.getKeyMarker() != null) {
            params.put("key-marker", listMultipartUploadsRequest.getKeyMarker());
        }
        if (listMultipartUploadsRequest.getMaxUploads() != null) {
            params.put("max-uploads", listMultipartUploadsRequest.getMaxUploads().toString());
        }
        if (listMultipartUploadsRequest.getPrefix() != null) {
            params.put("prefix", listMultipartUploadsRequest.getPrefix());
        }
        if (listMultipartUploadsRequest.getUploadIdMarker() != null) {
            params.put("upload-id-marker", listMultipartUploadsRequest.getUploadIdMarker());
        }
        RequestMessage request = new OSSRequestMessageBuilder().setEndpoint(this.getEndpoint()).setMethod(HttpMethod.GET).setBucket(bucketName).setParameters(params).build();
        ExecutionContext context = this.createDefaultContext(request.getMethod(), bucketName);
        ResponseMessage response = this.send(request, context, true);
        try {
            MultipartUploadListing result;
            MultipartUploadListing multipartUploadListing = result = ResponseParser.parseListMultipartUploads(response.getContent());
            return multipartUploadListing;
        }
        finally {
            OSSUtils.safeCloseResponse(response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PartListing listParts(ListPartsRequest listPartsRequest) throws OSSException, ClientException {
        String objectKey = listPartsRequest.getKey();
        String bucketName = listPartsRequest.getBucketName();
        String uploadId = listPartsRequest.getUploadId();
        this.assertBucketName(bucketName);
        this.assertObjectKey(objectKey);
        this.assertUploadIdNotNull(uploadId);
        Integer maxParts = listPartsRequest.getMaxParts();
        if (maxParts != null && (maxParts < 0 || maxParts > 1000)) {
            throw new IllegalArgumentException(OSSUtils.OSS_RESOURCE_MANAGER.getFormattedString("MaxPartsOutOfRange=", 1000));
        }
        Integer partNumberMarker = listPartsRequest.getPartNumberMarker();
        if (partNumberMarker != null && !this.isPartNumberInRange(partNumberMarker)) {
            throw new IllegalArgumentException(OSSUtils.OSS_RESOURCE_MANAGER.getString("PartNumberMarkerOutOfRange"));
        }
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        parameters.put("uploadId", uploadId);
        if (maxParts != null) {
            parameters.put("max-parts", maxParts.toString());
        }
        if (partNumberMarker != null) {
            parameters.put("part-number-marker", partNumberMarker.toString());
        }
        RequestMessage request = new OSSRequestMessageBuilder().setEndpoint(this.getEndpoint()).setMethod(HttpMethod.GET).setBucket(bucketName).setKey(objectKey).setParameters(parameters).build();
        ExecutionContext context = this.createDefaultContext(request.getMethod(), bucketName, objectKey);
        ResponseMessage response = this.send(request, context, true);
        try {
            PartListing result;
            PartListing partListing = result = ResponseParser.parseListParts(response.getContent());
            return partListing;
        }
        finally {
            OSSUtils.safeCloseResponse(response);
        }
    }

    public UploadPartResult uploadPart(UploadPartRequest uploadPartRequest) throws OSSException, ClientException {
        String bucketName = uploadPartRequest.getBucketName();
        String objectKey = uploadPartRequest.getKey();
        String uploadId = uploadPartRequest.getUploadId();
        this.assertBucketName(bucketName);
        this.assertObjectKey(objectKey);
        this.assertUploadIdNotNull(uploadId);
        long partSize = uploadPartRequest.getPartSize();
        int partNumber = uploadPartRequest.getPartNumber();
        if (uploadPartRequest.getInputStream() == null) {
            throw new IllegalArgumentException(OSSUtils.OSS_RESOURCE_MANAGER.getString("MustSetContentStream"));
        }
        if (partSize < 0L || partSize > 0x140000000L) {
            throw new IllegalArgumentException(OSSUtils.OSS_RESOURCE_MANAGER.getString("FileSizeOutOfRange"));
        }
        if (!this.isPartNumberInRange(partNumber)) {
            throw new IllegalArgumentException(OSSUtils.OSS_RESOURCE_MANAGER.getString("PartNumberOutOfRange"));
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Length", Long.toString(partSize));
        if (uploadPartRequest.getMd5Digest() != null) {
            headers.put("Content-MD5", uploadPartRequest.getMd5Digest());
        }
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("partNumber", Integer.toString(partNumber));
        params.put("uploadId", uploadId);
        RequestMessage request = new OSSRequestMessageBuilder().setEndpoint(this.getEndpoint()).setMethod(HttpMethod.PUT).setBucket(bucketName).setKey(objectKey).setParameters(params).setHeaders(headers).setInputStream(uploadPartRequest.getInputStream()).setInputSize(partSize).build();
        ExecutionContext context = this.createDefaultContext(request.getMethod(), bucketName, objectKey);
        ResponseMessage response = this.send(request, context);
        UploadPartResult result = new UploadPartResult();
        result.setPartNumber(partNumber);
        result.setETag(response.getHeaders().get("ETag"));
        return result;
    }

    private void assertBucketName(String bucketName) throws IllegalArgumentException, NullPointerException {
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
    }

    private void assertObjectKey(String key) throws IllegalArgumentException, NullPointerException {
        CodingUtils.assertParameterNotNull(key, "key");
        OSSUtils.ensureObjectKeyValid(key);
    }

    private void assertUploadIdNotNull(String uploadId) {
        if (uploadId == null || uploadId.trim().length() == 0) {
            throw new IllegalArgumentException(OSSUtils.OSS_RESOURCE_MANAGER.getString("MustSetUploadId"));
        }
    }

    private boolean isPartNumberInRange(Integer partNumber) {
        return partNumber > 0 && partNumber <= 10000;
    }
}

