/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.oss.internal;

import com.aliyun.common.auth.ServiceCredentials;
import com.aliyun.common.comm.ExecutionContext;
import com.aliyun.common.comm.RequestMessage;
import com.aliyun.common.comm.ResponseMessage;
import com.aliyun.common.comm.ServiceClient;
import com.aliyun.common.utils.CodingUtils;
import com.aliyun.openservices.HttpMethod;
import com.aliyun.openservices.oss.internal.OSSOperation;
import com.aliyun.openservices.oss.internal.OSSRequestMessageBuilder;
import com.aliyun.openservices.oss.internal.OSSUtils;
import com.aliyun.openservices.oss.internal.ResponseParser;
import com.aliyun.openservices.oss.model.OptionsRequest;
import com.aliyun.openservices.oss.model.SetBucketCORSRequest;
import java.io.ByteArrayInputStream;
import java.net.URI;
import java.util.LinkedHashMap;
import java.util.List;

public class CORSOperation
extends OSSOperation {
    public CORSOperation(URI endpoint, ServiceClient client, ServiceCredentials cred) {
        super(endpoint, client, cred);
    }

    public void setBucketCORS(SetBucketCORSRequest setBucketCORSRequest) {
        String bucketName = setBucketCORSRequest.getBucketName();
        List<SetBucketCORSRequest.CORSRule> corsRules = setBucketCORSRequest.getCorsRules();
        this.assertCreateBucketCORSRequestValid(setBucketCORSRequest);
        String xmlBody = this.buildBucketCORSXml(corsRules);
        byte[] inputBytes = xmlBody.getBytes();
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        parameters.put("cors", null);
        RequestMessage request = new OSSRequestMessageBuilder().setEndpoint(this.getEndpoint()).setMethod(HttpMethod.PUT).setBucket(bucketName).setParameters(parameters).setInputStream(new ByteArrayInputStream(inputBytes)).setInputSize(inputBytes.length).build();
        ExecutionContext context = this.createDefaultContext(request.getMethod(), bucketName);
        this.send(request, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SetBucketCORSRequest.CORSRule> getBucketCORSRules(String bucketName) {
        List<SetBucketCORSRequest.CORSRule> list;
        block3: {
            CodingUtils.assertParameterNotNull(bucketName, "bucketName");
            LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
            parameters.put("cors", null);
            ResponseMessage response = null;
            try {
                RequestMessage request = new OSSRequestMessageBuilder().setEndpoint(this.getEndpoint()).setMethod(HttpMethod.GET).setParameters(parameters).setBucket(bucketName).build();
                ExecutionContext context = this.createDefaultContext(request.getMethod(), bucketName);
                response = this.send(request, context, true);
                list = ResponseParser.parseListBucketCORS(response.getContent());
                if (response == null) break block3;
            }
            catch (Throwable throwable) {
                if (response != null) {
                    OSSUtils.safeCloseResponse(response);
                }
                throw throwable;
            }
            OSSUtils.safeCloseResponse(response);
        }
        return list;
    }

    public void deleteBucketCORS(String bucketName) {
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        parameters.put("cors", null);
        RequestMessage request = new OSSRequestMessageBuilder().setEndpoint(this.getEndpoint()).setMethod(HttpMethod.DELETE).setParameters(parameters).setBucket(bucketName).build();
        ExecutionContext context = this.createDefaultContext(request.getMethod(), bucketName);
        this.send(request, context);
    }

    public ResponseMessage optionsObject(OptionsRequest optionsRequest) {
        String bucketName = optionsRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        RequestMessage request = new OSSRequestMessageBuilder().setEndpoint(this.getEndpoint()).setMethod(HttpMethod.OPTIONS).setBucket(bucketName).setKey(optionsRequest.getObjectName()).addHeader("origin", optionsRequest.getOrigin()).addHeader("Access-Control-Request-Method", optionsRequest.getRequestMethod().name()).addHeader("Access-Control-Request-Headers", optionsRequest.getRequestHeaders()).build();
        ExecutionContext context = this.createDefaultContext(request.getMethod(), bucketName);
        return this.send(request, context);
    }

    private String buildBucketCORSXml(List<SetBucketCORSRequest.CORSRule> corsRules) {
        StringBuffer sbBuffer = new StringBuffer();
        sbBuffer.append("<CORSConfiguration>");
        for (SetBucketCORSRequest.CORSRule rule : corsRules) {
            sbBuffer.append("<CORSRule>");
            for (String allowedOrigin : rule.getAllowedOrigins()) {
                sbBuffer.append("<AllowedOrigin>" + allowedOrigin + "</AllowedOrigin>");
            }
            for (String allowedMethod : rule.getAllowedMethods()) {
                sbBuffer.append("<AllowedMethod>" + allowedMethod + "</AllowedMethod>");
            }
            if (rule.getAllowedHeaders().size() > 0) {
                for (String allowedHeader : rule.getAllowedHeaders()) {
                    sbBuffer.append("<AllowedHeader>" + allowedHeader + "</AllowedHeader>");
                }
            }
            if (rule.getExposeHeaders().size() > 0) {
                for (String exposeHeader : rule.getExposeHeaders()) {
                    sbBuffer.append("<ExposeHeader>" + exposeHeader + "</ExposeHeader>");
                }
            }
            if (null != rule.getMaxAgeSeconds()) {
                sbBuffer.append("<MaxAgeSeconds>" + rule.getMaxAgeSeconds() + "</MaxAgeSeconds>");
            }
            sbBuffer.append("</CORSRule>");
        }
        sbBuffer.append("</CORSConfiguration>");
        return sbBuffer.toString();
    }

    private void assertCreateBucketCORSRequestValid(SetBucketCORSRequest request) {
        String bucketName = request.getBucketName();
        List<SetBucketCORSRequest.CORSRule> corsRules = request.getCorsRules();
        CodingUtils.assertStringNotNullOrEmpty(bucketName, "bucketName");
        CodingUtils.assertListNotNullOrEmpty(corsRules, "corsRules");
        for (SetBucketCORSRequest.CORSRule rule : request.getCorsRules()) {
            CodingUtils.assertListNotNullOrEmpty(rule.getAllowedOrigins(), "allowedOrigin");
            CodingUtils.assertListNotNullOrEmpty(rule.getAllowedMethods(), "allowedMethod");
        }
    }
}

