/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.tablestore.agent.model;

import com.aliyun.openservices.tablestore.agent.model.Metadata;
import com.aliyun.openservices.tablestore.agent.util.TablestoreHelper;
import java.util.Arrays;
import lombok.Generated;

public class Document {
    private final String documentId;
    private String tenantId;
    private String text;
    private float[] embedding;
    private Metadata metadata;
    public static final String DOCUMENT_DEFAULT_TENANT_ID = "__default";
    public static final String DOCUMENT_DOCUMENT_ID = "document_id";
    public static final String DOCUMENT_TENANT_ID = "tenant_id";

    public Document(Document document) {
        this(document.getDocumentId(), document.getTenantId(), document.getText(), document.getEmbedding(), document.getMetadata());
    }

    public Document(String documentId) {
        this(documentId, DOCUMENT_DEFAULT_TENANT_ID);
    }

    public Document(String documentId, String tenantId) {
        this(documentId, tenantId, null, null, new Metadata());
    }

    public Document(String documentId, String tenantId, String text, float[] embedding, Metadata metadata) {
        this.documentId = documentId;
        this.tenantId = tenantId;
        this.text = text;
        this.embedding = embedding;
        this.metadata = metadata;
    }

    private String shortEmbedding() {
        return TablestoreHelper.maxOrNull(this.embedding == null ? null : TablestoreHelper.encodeEmbedding(this.embedding), 80, "]");
    }

    @Generated
    protected Document(DocumentBuilder<?, ?> b) {
        this.documentId = ((DocumentBuilder)b).documentId;
        this.tenantId = ((DocumentBuilder)b).tenantId;
        this.text = ((DocumentBuilder)b).text;
        this.embedding = ((DocumentBuilder)b).embedding;
        this.metadata = ((DocumentBuilder)b).metadata;
    }

    @Generated
    public static DocumentBuilder<?, ?> builder() {
        return new DocumentBuilderImpl();
    }

    @Generated
    public DocumentBuilder<?, ?> toBuilder() {
        return new DocumentBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public String toString() {
        return "Document(documentId=" + this.getDocumentId() + ", tenantId=" + this.getTenantId() + ", text=" + this.getText() + ", metadata=" + this.getMetadata() + ", embedding=" + this.shortEmbedding() + ")";
    }

    @Generated
    public String getDocumentId() {
        return this.documentId;
    }

    @Generated
    public String getTenantId() {
        return this.tenantId;
    }

    @Generated
    public String getText() {
        return this.text;
    }

    @Generated
    public float[] getEmbedding() {
        return this.embedding;
    }

    @Generated
    public Metadata getMetadata() {
        return this.metadata;
    }

    @Generated
    public Document setTenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    @Generated
    public Document setText(String text) {
        this.text = text;
        return this;
    }

    @Generated
    public Document setEmbedding(float[] embedding) {
        this.embedding = embedding;
        return this;
    }

    @Generated
    public Document setMetadata(Metadata metadata) {
        this.metadata = metadata;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Document)) {
            return false;
        }
        Document other = (Document)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$documentId = this.getDocumentId();
        String other$documentId = other.getDocumentId();
        if (this$documentId == null ? other$documentId != null : !this$documentId.equals(other$documentId)) {
            return false;
        }
        String this$tenantId = this.getTenantId();
        String other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        String this$text = this.getText();
        String other$text = other.getText();
        if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
            return false;
        }
        if (!Arrays.equals(this.getEmbedding(), other.getEmbedding())) {
            return false;
        }
        Metadata this$metadata = this.getMetadata();
        Metadata other$metadata = other.getMetadata();
        return !(this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Document;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $documentId = this.getDocumentId();
        result = result * 59 + ($documentId == null ? 43 : $documentId.hashCode());
        String $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        String $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        result = result * 59 + Arrays.hashCode(this.getEmbedding());
        Metadata $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        return result;
    }

    @Generated
    private static final class DocumentBuilderImpl
    extends DocumentBuilder<Document, DocumentBuilderImpl> {
        @Generated
        private DocumentBuilderImpl() {
        }

        @Override
        @Generated
        protected DocumentBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Document build() {
            return new Document(this);
        }
    }

    @Generated
    public static abstract class DocumentBuilder<C extends Document, B extends DocumentBuilder<C, B>> {
        @Generated
        private String documentId;
        @Generated
        private String tenantId;
        @Generated
        private String text;
        @Generated
        private float[] embedding;
        @Generated
        private Metadata metadata;

        @Generated
        protected B $fillValuesFrom(C instance) {
            DocumentBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(Document instance, DocumentBuilder<?, ?> b) {
            b.documentId(instance.documentId);
            b.tenantId(instance.tenantId);
            b.text(instance.text);
            b.embedding(instance.embedding);
            b.metadata(instance.metadata);
        }

        @Generated
        public B documentId(String documentId) {
            this.documentId = documentId;
            return this.self();
        }

        @Generated
        public B tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this.self();
        }

        @Generated
        public B text(String text) {
            this.text = text;
            return this.self();
        }

        @Generated
        public B embedding(float[] embedding) {
            this.embedding = embedding;
            return this.self();
        }

        @Generated
        public B metadata(Metadata metadata) {
            this.metadata = metadata;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "Document.DocumentBuilder(documentId=" + this.documentId + ", tenantId=" + this.tenantId + ", text=" + this.text + ", embedding=" + Arrays.toString(this.embedding) + ", metadata=" + this.metadata + ")";
        }
    }
}

