/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fescar.spring.annotation;

import com.alibaba.fescar.common.util.StringUtils;
import com.alibaba.fescar.config.ConfigurationFactory;
import com.alibaba.fescar.rm.RMClient;
import com.alibaba.fescar.spring.annotation.GlobalLock;
import com.alibaba.fescar.spring.annotation.GlobalTransactional;
import com.alibaba.fescar.spring.annotation.GlobalTransactionalInterceptor;
import com.alibaba.fescar.spring.annotation.MethodDesc;
import com.alibaba.fescar.spring.tcc.TccActionInterceptor;
import com.alibaba.fescar.spring.util.SpringProxyUtils;
import com.alibaba.fescar.spring.util.TCCBeanParserUtils;
import com.alibaba.fescar.tm.TMClient;
import com.alibaba.fescar.tm.api.DefaultFailureHandlerImpl;
import com.alibaba.fescar.tm.api.FailureHandler;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import org.aopalliance.intercept.MethodInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.Advisor;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.AdvisedSupport;
import org.springframework.aop.framework.autoproxy.AbstractAutoProxyCreator;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class GlobalTransactionScanner
extends AbstractAutoProxyCreator
implements InitializingBean,
ApplicationContextAware {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(GlobalTransactionScanner.class);
    private static final int AT_MODE = 1;
    private static final int MT_MODE = 2;
    private static final int ORDER_NUM = 1024;
    private static final int DEFAULT_MODE = 3;
    private static final Set<String> PROXYED_SET = new HashSet<String>();
    private static final FailureHandler DEFAULT_FAIL_HANDLER = new DefaultFailureHandlerImpl();
    private MethodInterceptor interceptor;
    private final String applicationId;
    private final String txServiceGroup;
    private final int mode;
    private final boolean disableGlobalTransaction = ConfigurationFactory.getInstance().getBoolean("service.disableGlobalTransaction", false);
    private final FailureHandler failureHandlerHook;
    private ApplicationContext applicationContext;

    public GlobalTransactionScanner(String txServiceGroup) {
        this(txServiceGroup, txServiceGroup, 3);
    }

    public GlobalTransactionScanner(String txServiceGroup, int mode) {
        this(txServiceGroup, txServiceGroup, mode);
    }

    public GlobalTransactionScanner(String applicationId, String txServiceGroup) {
        this(applicationId, txServiceGroup, 3);
    }

    public GlobalTransactionScanner(String applicationId, String txServiceGroup, int mode) {
        this(applicationId, txServiceGroup, mode, DEFAULT_FAIL_HANDLER);
    }

    public GlobalTransactionScanner(String applicationId, String txServiceGroup, FailureHandler failureHandlerHook) {
        this(applicationId, txServiceGroup, 3, failureHandlerHook);
    }

    public GlobalTransactionScanner(String applicationId, String txServiceGroup, int mode, FailureHandler failureHandlerHook) {
        this.setOrder(1024);
        this.setProxyTargetClass(true);
        this.applicationId = applicationId;
        this.txServiceGroup = txServiceGroup;
        this.mode = mode;
        this.failureHandlerHook = failureHandlerHook;
    }

    private void initClient() {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Initializing Global Transaction Clients ... ");
        }
        if (StringUtils.isNullOrEmpty((String)this.applicationId) || StringUtils.isNullOrEmpty((String)this.txServiceGroup)) {
            throw new IllegalArgumentException("applicationId: " + this.applicationId + ", txServiceGroup: " + this.txServiceGroup);
        }
        TMClient.init((String)this.applicationId, (String)this.txServiceGroup);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Transaction Manager Client is initialized. applicationId[" + this.applicationId + "] txServiceGroup[" + this.txServiceGroup + "]");
        }
        RMClient.init((String)this.applicationId, (String)this.txServiceGroup);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Resource Manager is initialized. applicationId[" + this.applicationId + "] txServiceGroup[" + this.txServiceGroup + "]");
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Global Transaction Clients are initialized. ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object wrapIfNecessary(Object bean, String beanName, Object cacheKey) {
        if (this.disableGlobalTransaction) {
            return bean;
        }
        try {
            Set<String> set = PROXYED_SET;
            synchronized (set) {
                if (PROXYED_SET.contains(beanName)) {
                    return bean;
                }
                this.interceptor = null;
                if (TCCBeanParserUtils.isTccAutoProxy(bean, beanName, this.applicationContext)) {
                    this.interceptor = new TccActionInterceptor(TCCBeanParserUtils.getRemotingDesc(beanName));
                } else {
                    Class<?> serviceInterface = SpringProxyUtils.findTargetClass(bean);
                    Method[] methods = serviceInterface.getMethods();
                    boolean shouldSkip = true;
                    Method[] methodArray = methods;
                    int n = methodArray.length;
                    for (int i = 0; i < n; ++i) {
                        Method method = methodArray[i];
                        GlobalTransactional trxAnno = method.getAnnotation(GlobalTransactional.class);
                        if (trxAnno != null) {
                            shouldSkip = false;
                            break;
                        }
                        GlobalLock lockAnno = method.getAnnotation(GlobalLock.class);
                        if (lockAnno == null) continue;
                        shouldSkip = false;
                        break;
                    }
                    if (shouldSkip) {
                        return bean;
                    }
                    if (this.interceptor == null) {
                        this.interceptor = new GlobalTransactionalInterceptor(this.failureHandlerHook);
                    }
                }
                LOGGER.info("Bean[" + bean.getClass().getName() + "] with name [" + beanName + "] would use interceptor [" + this.interceptor.getClass().getName() + "]");
                if (!AopUtils.isAopProxy((Object)bean)) {
                    bean = super.wrapIfNecessary(bean, beanName, cacheKey);
                } else {
                    Advisor[] advisor;
                    AdvisedSupport advised = SpringProxyUtils.getAdvisedSupport(bean);
                    for (Advisor avr : advisor = this.buildAdvisors(beanName, this.getAdvicesAndAdvisorsForBean(null, null, null))) {
                        advised.addAdvisor(0, avr);
                    }
                }
                PROXYED_SET.add(beanName);
                return bean;
            }
        }
        catch (Exception exx) {
            throw new RuntimeException(exx);
        }
    }

    private MethodDesc makeMethodDesc(GlobalTransactional anno, Method method) {
        return new MethodDesc(anno, method);
    }

    protected Object[] getAdvicesAndAdvisorsForBean(Class beanClass, String beanName, TargetSource customTargetSource) throws BeansException {
        return new Object[]{this.interceptor};
    }

    public void afterPropertiesSet() {
        if (this.disableGlobalTransaction) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Global transaction is disabled.");
            }
            return;
        }
        this.initClient();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

