/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fescar.rm;

import com.alibaba.fescar.common.exception.ShouldNeverHappenException;
import com.alibaba.fescar.core.exception.AbstractExceptionHandler;
import com.alibaba.fescar.core.exception.TransactionException;
import com.alibaba.fescar.core.model.BranchStatus;
import com.alibaba.fescar.core.model.BranchType;
import com.alibaba.fescar.core.model.ResourceManager;
import com.alibaba.fescar.core.protocol.AbstractMessage;
import com.alibaba.fescar.core.protocol.AbstractResultMessage;
import com.alibaba.fescar.core.protocol.transaction.AbstractTransactionRequest;
import com.alibaba.fescar.core.protocol.transaction.AbstractTransactionRequestToRM;
import com.alibaba.fescar.core.protocol.transaction.AbstractTransactionResponse;
import com.alibaba.fescar.core.protocol.transaction.BranchCommitRequest;
import com.alibaba.fescar.core.protocol.transaction.BranchCommitResponse;
import com.alibaba.fescar.core.protocol.transaction.BranchRollbackRequest;
import com.alibaba.fescar.core.protocol.transaction.BranchRollbackResponse;
import com.alibaba.fescar.core.protocol.transaction.RMInboundHandler;
import com.alibaba.fescar.core.rpc.RpcContext;
import com.alibaba.fescar.core.rpc.TransactionMessageHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRMHandler
extends AbstractExceptionHandler
implements RMInboundHandler,
TransactionMessageHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractRMHandler.class);

    public BranchCommitResponse handle(BranchCommitRequest request) {
        BranchCommitResponse response = new BranchCommitResponse();
        this.exceptionHandleTemplate((AbstractExceptionHandler.Callback)new AbstractExceptionHandler.Callback<BranchCommitRequest, BranchCommitResponse>(){

            public void execute(BranchCommitRequest request, BranchCommitResponse response) throws TransactionException {
                AbstractRMHandler.this.doBranchCommit(request, response);
            }
        }, (AbstractTransactionRequest)request, (AbstractTransactionResponse)response);
        return response;
    }

    public BranchRollbackResponse handle(BranchRollbackRequest request) {
        BranchRollbackResponse response = new BranchRollbackResponse();
        this.exceptionHandleTemplate((AbstractExceptionHandler.Callback)new AbstractExceptionHandler.Callback<BranchRollbackRequest, BranchRollbackResponse>(){

            public void execute(BranchRollbackRequest request, BranchRollbackResponse response) throws TransactionException {
                AbstractRMHandler.this.doBranchRollback(request, response);
            }
        }, (AbstractTransactionRequest)request, (AbstractTransactionResponse)response);
        return response;
    }

    protected void doBranchCommit(BranchCommitRequest request, BranchCommitResponse response) throws TransactionException {
        String xid = request.getXid();
        long branchId = request.getBranchId();
        String resourceId = request.getResourceId();
        String applicationData = request.getApplicationData();
        LOGGER.info("Branch committing: " + xid + " " + branchId + " " + resourceId + " " + applicationData);
        BranchStatus status = this.getResourceManager().branchCommit(request.getBranchType(), xid, branchId, resourceId, applicationData);
        response.setBranchStatus(status);
        LOGGER.info("Branch commit result: " + status);
    }

    protected void doBranchRollback(BranchRollbackRequest request, BranchRollbackResponse response) throws TransactionException {
        String xid = request.getXid();
        long branchId = request.getBranchId();
        String resourceId = request.getResourceId();
        String applicationData = request.getApplicationData();
        LOGGER.info("Branch rolling back: " + xid + " " + branchId + " " + resourceId);
        BranchStatus status = this.getResourceManager().branchRollback(request.getBranchType(), xid, branchId, resourceId, applicationData);
        response.setBranchStatus(status);
        LOGGER.info("Branch rollback result: " + status);
    }

    protected abstract ResourceManager getResourceManager();

    public AbstractResultMessage onRequest(AbstractMessage request, RpcContext context) {
        if (!(request instanceof AbstractTransactionRequestToRM)) {
            throw new IllegalArgumentException();
        }
        AbstractTransactionRequestToRM transactionRequest = (AbstractTransactionRequestToRM)request;
        transactionRequest.setRMInboundMessageHandler((RMInboundHandler)this);
        return transactionRequest.handle(context);
    }

    public void onResponse(AbstractResultMessage response, RpcContext context) {
        throw new ShouldNeverHappenException();
    }

    public abstract BranchType getBranchType();
}

