/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fescar.discovery.registry;

import com.alibaba.fescar.common.exception.ShouldNeverHappenException;
import com.alibaba.fescar.common.thread.NamedThreadFactory;
import com.alibaba.fescar.common.util.NetUtil;
import com.alibaba.fescar.common.util.StringUtils;
import com.alibaba.fescar.config.Configuration;
import com.alibaba.fescar.config.ConfigurationFactory;
import com.alibaba.fescar.discovery.registry.RedisListener;
import com.alibaba.fescar.discovery.registry.RegistryService;
import com.google.common.collect.Lists;
import java.lang.management.ManagementFactory;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPubSub;

public class RedisRegistryServiceImpl
implements RegistryService<RedisListener> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RedisRegistryServiceImpl.class);
    private static final String PRO_SERVER_ADDR_KEY = "serverAddr";
    private static final String REDIS_FILEKEY_PREFIX = "registry.redis.";
    private static final String DEFAULT_CLUSTER = "default";
    private static final String REGISTRY_CLUSTER_KEY = "cluster";
    private String clusterName;
    private static final String REDIS_DB = "db";
    private static final String REDIS_PASSWORD = "password";
    private static final ConcurrentMap<String, List<RedisListener>> LISTENER_SERVICE_MAP = new ConcurrentHashMap<String, List<RedisListener>>();
    private static final ConcurrentMap<String, Set<InetSocketAddress>> CLUSTER_ADDRESS_MAP = new ConcurrentHashMap<String, Set<InetSocketAddress>>();
    private static volatile RedisRegistryServiceImpl instance;
    private static volatile JedisPool jedisPool;
    private ExecutorService threadPoolExecutor = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new NamedThreadFactory("RedisRegistryService", 1));

    private RedisRegistryServiceImpl() {
        int minEvictableIdleTimeMillis;
        int timeBetweenEvictionRunsMillis;
        int numTestsPerEvictionRun;
        int maxWait;
        int maxTotal;
        int maxActive;
        int minIdle;
        Configuration fescarConfig = ConfigurationFactory.FILE_INSTANCE;
        this.clusterName = fescarConfig.getConfig("registry.redis.cluster", DEFAULT_CLUSTER);
        String password = fescarConfig.getConfig(this.getRedisPasswordFileKey());
        String serverAddr = fescarConfig.getConfig(this.getRedisAddrFileKey());
        String[] serverArr = serverAddr.split(":");
        String host = serverArr[0];
        int port = Integer.valueOf(serverArr[1]);
        int db = fescarConfig.getInt(this.getRedisDbFileKey());
        GenericObjectPoolConfig redisConfig = new GenericObjectPoolConfig();
        redisConfig.setTestOnBorrow(fescarConfig.getBoolean("registry.redis.test.on.borrow", true));
        redisConfig.setTestOnReturn(fescarConfig.getBoolean("registry.redis.test.on.return", false));
        redisConfig.setTestWhileIdle(fescarConfig.getBoolean("registry.redis.test.while.idle", false));
        int maxIdle = fescarConfig.getInt("registry.redis.max.idle", 0);
        if (maxIdle > 0) {
            redisConfig.setMaxIdle(maxIdle);
        }
        if ((minIdle = fescarConfig.getInt("registry.redis.min.idle", 0)) > 0) {
            redisConfig.setMinIdle(minIdle);
        }
        if ((maxActive = fescarConfig.getInt("registry.redis.max.active", 0)) > 0) {
            redisConfig.setMaxTotal(maxActive);
        }
        if ((maxTotal = fescarConfig.getInt("registry.redis.max.total", 0)) > 0) {
            redisConfig.setMaxTotal(maxTotal);
        }
        if ((maxWait = fescarConfig.getInt("registry.redis.max.wait", fescarConfig.getInt("registry.redis.timeout", 0))) > 0) {
            redisConfig.setMaxWaitMillis((long)maxWait);
        }
        if ((numTestsPerEvictionRun = fescarConfig.getInt("registry.redis.num.tests.per.eviction.run", 0)) > 0) {
            redisConfig.setNumTestsPerEvictionRun(numTestsPerEvictionRun);
        }
        if ((timeBetweenEvictionRunsMillis = fescarConfig.getInt("registry.redis.time.between.eviction.runs.millis", 0)) > 0) {
            redisConfig.setTimeBetweenEvictionRunsMillis((long)timeBetweenEvictionRunsMillis);
        }
        if ((minEvictableIdleTimeMillis = fescarConfig.getInt("registry.redis.min.evictable.idle.time.millis", 0)) > 0) {
            redisConfig.setMinEvictableIdleTimeMillis((long)minEvictableIdleTimeMillis);
        }
        jedisPool = StringUtils.isNullOrEmpty((String)password) ? new JedisPool(redisConfig, host, port, 2000, null, db) : new JedisPool(redisConfig, host, port, 2000, password, db);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RedisRegistryServiceImpl getInstance() {
        if (null != instance) return instance;
        Class<RedisRegistryServiceImpl> clazz = RedisRegistryServiceImpl.class;
        synchronized (RedisRegistryServiceImpl.class) {
            if (null != instance) return instance;
            instance = new RedisRegistryServiceImpl();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(InetSocketAddress address) {
        NetUtil.validAddress((InetSocketAddress)address);
        String serverAddr = NetUtil.toStringAddress((InetSocketAddress)address);
        try (Jedis jedis = jedisPool.getResource();){
            jedis.hset(this.getRedisRegistryKey(), serverAddr, ManagementFactory.getRuntimeMXBean().getName());
            jedis.publish(this.getRedisRegistryKey(), serverAddr + "-" + "register");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregister(InetSocketAddress address) {
        NetUtil.validAddress((InetSocketAddress)address);
        String serverAddr = NetUtil.toStringAddress((InetSocketAddress)address);
        try (Jedis jedis = jedisPool.getResource();){
            jedis.hdel(this.getRedisRegistryKey(), new String[]{serverAddr});
            jedis.publish(this.getRedisRegistryKey(), serverAddr + "-" + "unregister");
        }
    }

    @Override
    public void subscribe(final String cluster, RedisListener listener) {
        final String redisRegistryKey = REDIS_FILEKEY_PREFIX + cluster;
        LISTENER_SERVICE_MAP.putIfAbsent(cluster, new ArrayList());
        ((List)LISTENER_SERVICE_MAP.get(cluster)).add(listener);
        this.threadPoolExecutor.submit(new Runnable(){

            @Override
            public void run() {
                try (Jedis jedis = jedisPool.getResource();){
                    jedis.subscribe((JedisPubSub)new NotifySub((List)LISTENER_SERVICE_MAP.get(cluster)), new String[]{redisRegistryKey});
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                }
            }
        });
    }

    @Override
    public void unsubscribe(String cluster, RedisListener listener) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<InetSocketAddress> lookup(String key) {
        Configuration config = ConfigurationFactory.getInstance();
        final String clusterName = config.getConfig("service.vgroup_mapping." + key);
        if (null == clusterName) {
            return null;
        }
        if (!LISTENER_SERVICE_MAP.containsKey(clusterName)) {
            Map instances = null;
            try (Jedis jedis = jedisPool.getResource();){
                instances = jedis.hgetAll(this.getRedisRegistryKey());
            }
            if (null != instances) {
                HashSet<InetSocketAddress> newAddressList = new HashSet<InetSocketAddress>();
                for (Map.Entry instance : instances.entrySet()) {
                    String serverAddr = (String)instance.getKey();
                    newAddressList.add(NetUtil.toInetSocketAddress((String)serverAddr));
                }
                CLUSTER_ADDRESS_MAP.put(clusterName, newAddressList);
            }
            this.subscribe(clusterName, new RedisListener(){

                @Override
                public void onEvent(String msg) {
                    String eventType;
                    String[] msgr = msg.split("-");
                    String serverAddr = msgr[0];
                    switch (eventType = msgr[1]) {
                        case "register": {
                            ((Set)CLUSTER_ADDRESS_MAP.get(clusterName)).add(NetUtil.toInetSocketAddress((String)serverAddr));
                            break;
                        }
                        case "unregister": {
                            ((Set)CLUSTER_ADDRESS_MAP.get(clusterName)).remove(NetUtil.toInetSocketAddress((String)serverAddr));
                            break;
                        }
                        default: {
                            throw new ShouldNeverHappenException("unknow redis msg:" + msg);
                        }
                    }
                }
            });
        }
        return Lists.newArrayList((Iterable)((Iterable)CLUSTER_ADDRESS_MAP.get(clusterName)));
    }

    private String getRedisRegistryKey() {
        return REDIS_FILEKEY_PREFIX + this.clusterName;
    }

    private String getRedisAddrFileKey() {
        return "registry.redis.serverAddr";
    }

    private String getRedisPasswordFileKey() {
        return "registry.redis.password";
    }

    private String getRedisDbFileKey() {
        return "registry.redis.db";
    }

    private class NotifySub
    extends JedisPubSub {
        private final List<RedisListener> redisListeners;

        NotifySub(List<RedisListener> redisListeners) {
            this.redisListeners = redisListeners;
        }

        public void onMessage(String key, String msg) {
            for (RedisListener listener : this.redisListeners) {
                listener.onEvent(msg);
            }
        }
    }
}

