/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.writer;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONB;
import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.SymbolTable;
import com.alibaba.fastjson2.codec.BeanInfo;
import com.alibaba.fastjson2.codec.FieldInfo;
import com.alibaba.fastjson2.internal.asm.ASMUtils;
import com.alibaba.fastjson2.internal.asm.ClassWriter;
import com.alibaba.fastjson2.internal.asm.Label;
import com.alibaba.fastjson2.internal.asm.MethodWriter;
import com.alibaba.fastjson2.modules.ObjectWriterModule;
import com.alibaba.fastjson2.util.BeanUtils;
import com.alibaba.fastjson2.util.DynamicClassLoader;
import com.alibaba.fastjson2.util.IOUtils;
import com.alibaba.fastjson2.util.JDKUtils;
import com.alibaba.fastjson2.util.TypeUtils;
import com.alibaba.fastjson2.writer.FieldWriter;
import com.alibaba.fastjson2.writer.FieldWriterBigDecimalField;
import com.alibaba.fastjson2.writer.FieldWriterBigIntField;
import com.alibaba.fastjson2.writer.FieldWriterBoolValField;
import com.alibaba.fastjson2.writer.FieldWriterCharValField;
import com.alibaba.fastjson2.writer.FieldWriterDate;
import com.alibaba.fastjson2.writer.FieldWriterDateField;
import com.alibaba.fastjson2.writer.FieldWriterDoubleField;
import com.alibaba.fastjson2.writer.FieldWriterDoubleValField;
import com.alibaba.fastjson2.writer.FieldWriterEnum;
import com.alibaba.fastjson2.writer.FieldWriterFloatField;
import com.alibaba.fastjson2.writer.FieldWriterFloatValField;
import com.alibaba.fastjson2.writer.FieldWriterInt16ValField;
import com.alibaba.fastjson2.writer.FieldWriterInt32Val;
import com.alibaba.fastjson2.writer.FieldWriterInt64ValField;
import com.alibaba.fastjson2.writer.FieldWriterInt8ValField;
import com.alibaba.fastjson2.writer.FieldWriterList;
import com.alibaba.fastjson2.writer.FieldWriterListField;
import com.alibaba.fastjson2.writer.FieldWriterMapField;
import com.alibaba.fastjson2.writer.FieldWriterMillisField;
import com.alibaba.fastjson2.writer.FieldWriterObject;
import com.alibaba.fastjson2.writer.FieldWriterObjectArrayField;
import com.alibaba.fastjson2.writer.FieldWriterObjectArrayMethod;
import com.alibaba.fastjson2.writer.FieldWriterStringField;
import com.alibaba.fastjson2.writer.ObjectWriter;
import com.alibaba.fastjson2.writer.ObjectWriterAdapter;
import com.alibaba.fastjson2.writer.ObjectWriterBaseModule;
import com.alibaba.fastjson2.writer.ObjectWriterCreator;
import com.alibaba.fastjson2.writer.ObjectWriterCreatorASMUtils;
import com.alibaba.fastjson2.writer.ObjectWriterImplEnum;
import com.alibaba.fastjson2.writer.ObjectWriterImplInt64;
import com.alibaba.fastjson2.writer.ObjectWriterImplLocalDate;
import com.alibaba.fastjson2.writer.ObjectWriterImplOffsetDateTime;
import com.alibaba.fastjson2.writer.ObjectWriterProvider;
import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.function.Function;

public class ObjectWriterCreatorASM
extends ObjectWriterCreator {
    public static final ObjectWriterCreatorASM INSTANCE = new ObjectWriterCreatorASM(DynamicClassLoader.getInstance());
    protected static final AtomicLong seed = new AtomicLong();
    protected final DynamicClassLoader classLoader;
    static final String[] INTERFACES = new String[]{ASMUtils.TYPE_OBJECT_WRITER};
    static final String DESC_SYMBOL = ASMUtils.desc(SymbolTable.class);
    static final String METHOD_DESC_WRITE_VALUE = "(" + ASMUtils.DESC_JSON_WRITER + "Ljava/lang/Object;)V";
    static final String METHOD_DESC_WRITE = "(" + ASMUtils.DESC_JSON_WRITER + "Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/reflect/Type;J)V";
    static final String METHOD_DESC_WRITE_FIELD_NAME = "(" + ASMUtils.DESC_JSON_WRITER + ")V";
    static final String METHOD_DESC_WRITE_OBJECT = "(" + ASMUtils.DESC_JSON_WRITER + "Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/reflect/Type;J)V";
    static final String METHOD_DESC_WRITE_J = "(" + ASMUtils.DESC_JSON_WRITER + "J)V";
    static final String METHOD_DESC_WRITE_D = "(" + ASMUtils.DESC_JSON_WRITER + "D)V";
    static final String METHOD_DESC_WRITE_F = "(" + ASMUtils.DESC_JSON_WRITER + "F)V";
    static final String METHOD_DESC_WRITE_DATE_WITH_FIELD_NAME = "(" + ASMUtils.DESC_JSON_WRITER + "ZLjava/util/Date;)V";
    static final String METHOD_DESC_WRITE_Z = "(" + ASMUtils.DESC_JSON_WRITER + "Z)V";
    static final String METHOD_DESC_WRITE_ZARRAY = "(" + ASMUtils.DESC_JSON_WRITER + "[Z)V";
    static final String METHOD_DESC_WRITE_FARRAY = "(" + ASMUtils.DESC_JSON_WRITER + "[F)V";
    static final String METHOD_DESC_WRITE_DARRAY = "(" + ASMUtils.DESC_JSON_WRITER + "[D)V";
    static final String METHOD_DESC_WRITE_I = "(" + ASMUtils.DESC_JSON_WRITER + "I)V";
    static final String METHOD_DESC_WRITE_SArray = "(" + ASMUtils.DESC_JSON_WRITER + "[S)V";
    static final String METHOD_DESC_WRITE_BArray = "(" + ASMUtils.DESC_JSON_WRITER + "[B)V";
    static final String METHOD_DESC_WRITE_CArray = "(" + ASMUtils.DESC_JSON_WRITER + "[C)V";
    static final String METHOD_DESC_WRITE_ENUM = "(" + ASMUtils.DESC_JSON_WRITER + "Ljava/lang/Enum;)V";
    static final String METHOD_DESC_WRITE_LIST = "(" + ASMUtils.DESC_JSON_WRITER + "Ljava/util/List;)V";
    static final String METHOD_DESC_FIELD_WRITE_OBJECT = "(" + ASMUtils.DESC_JSON_WRITER + "Ljava/lang/Object;)Z";
    static final String METHOD_DESC_GET_OBJECT_WRITER = "(" + ASMUtils.DESC_JSON_WRITER + "Ljava/lang/Class;)" + ASMUtils.DESC_OBJECT_WRITER;
    static final String METHOD_DESC_GET_ITEM_WRITER = "(" + ASMUtils.DESC_JSON_WRITER + "Ljava/lang/reflect/Type;)" + ASMUtils.DESC_OBJECT_WRITER;
    static final String METHOD_DESC_WRITE_TYPE_INFO = "(" + ASMUtils.DESC_JSON_WRITER + ")Z";
    static final String METHOD_DESC_HAS_FILTER = "(" + ASMUtils.DESC_JSON_WRITER + ")Z";
    static final String METHOD_DESC_SET_PATH2 = "(" + ASMUtils.DESC_FIELD_WRITER + "Ljava/lang/Object;)Ljava/lang/String;";
    static final String METHOD_DESC_WRITE_REFERENCE = "(Ljava/lang/String;)V";
    static final String METHOD_DESC_IO_WRITE_REFERENCE = "([BILjava/lang/String;" + ASMUtils.DESC_JSON_WRITER + ")I";
    static final String METHOD_DESC_WRITE_CLASS_INFO = "(" + ASMUtils.DESC_JSON_WRITER + ")V";
    static final String METHOD_DESC_WRITE_FIELD_NAME_JSONB = "([BI" + ASMUtils.DESC_JSON_WRITER + ")I";
    static final String METHOD_DESC_WRITE_NAME_SYMBOL = "(" + DESC_SYMBOL + ")I";
    static final String METHOD_DESC_WRITE_LIST_VALUE_JSONB = "(" + ASMUtils.DESC_JSON_WRITER + "Ljava/util/List;)V";
    static final int THIS = 0;
    static final int JSON_WRITER = 1;
    static final String NOT_WRITE_DEFAULT_VALUE = "WRITE_DEFAULT_VALUE";
    static final String WRITE_NULLS = "WRITE_NULLS";
    static final String CONTEXT_FEATURES = "CONTEXT_FEATURES";
    static final String NAME_DIRECT = "NAME_DIRECT";

    static String fieldWriter(int i) {
        switch (i) {
            case 0: {
                return "fieldWriter0";
            }
            case 1: {
                return "fieldWriter1";
            }
            case 2: {
                return "fieldWriter2";
            }
            case 3: {
                return "fieldWriter3";
            }
            case 4: {
                return "fieldWriter4";
            }
            case 5: {
                return "fieldWriter5";
            }
            case 6: {
                return "fieldWriter6";
            }
            case 7: {
                return "fieldWriter7";
            }
            case 8: {
                return "fieldWriter8";
            }
            case 9: {
                return "fieldWriter9";
            }
            case 10: {
                return "fieldWriter10";
            }
            case 11: {
                return "fieldWriter11";
            }
            case 12: {
                return "fieldWriter12";
            }
            case 13: {
                return "fieldWriter13";
            }
            case 14: {
                return "fieldWriter14";
            }
            case 15: {
                return "fieldWriter15";
            }
        }
        String base = "fieldWriter";
        int size = IOUtils.stringSize(i);
        char[] chars = new char[base.length() + size];
        base.getChars(0, base.length(), chars, 0);
        IOUtils.getChars(i, chars.length, chars);
        return new String(chars);
    }

    public ObjectWriterCreatorASM() {
        this.classLoader = new DynamicClassLoader();
    }

    public ObjectWriterCreatorASM(ClassLoader classLoader) {
        this.classLoader = classLoader instanceof DynamicClassLoader ? (DynamicClassLoader)classLoader : new DynamicClassLoader(classLoader);
    }

    @Override
    public ObjectWriter createObjectWriter(List<FieldWriter> fieldWriters) {
        boolean allFunction = true;
        for (int i = 0; i < fieldWriters.size(); ++i) {
            if (fieldWriters.get(i).getFunction() != null) continue;
            allFunction = false;
            break;
        }
        if (!allFunction) {
            return super.createObjectWriter(fieldWriters);
        }
        ObjectWriterProvider provider = JSONFactory.getDefaultObjectWriterProvider();
        BeanInfo beanInfo = provider.createBeanInfo();
        return this.jitWriter(null, provider, beanInfo, fieldWriters, 0L);
    }

    @Override
    public ObjectWriter createObjectWriter(Class objectClass, long features, ObjectWriterProvider provider) {
        String simpleName;
        boolean match;
        boolean fieldBased;
        boolean record;
        int modifiers = objectClass.getModifiers();
        boolean externalClass = this.classLoader.isExternalClass(objectClass);
        boolean publicClass = Modifier.isPublic(modifiers);
        BeanInfo beanInfo = provider.createBeanInfo();
        provider.getBeanInfo(beanInfo, objectClass);
        if (beanInfo.serializer != null && ObjectWriter.class.isAssignableFrom(beanInfo.serializer)) {
            try {
                Constructor constructor = beanInfo.serializer.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                return (ObjectWriter)constructor.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new JSONException("create serializer error", e);
            }
        }
        long beanFeatures = beanInfo.writerFeatures;
        if (beanInfo.seeAlso != null) {
            beanFeatures &= JSONWriter.Feature.WriteClassName.mask ^ 0xFFFFFFFFFFFFFFFFL;
        }
        long writerFieldFeatures = features | beanFeatures | ((record = BeanUtils.isRecord(objectClass)) ? 0x4000000000000000L : 0L);
        boolean bl = fieldBased = (writerFieldFeatures & JSONWriter.Feature.FieldBased.mask) != 0L && !objectClass.isInterface() || !beanInfo.alphabetic;
        if (Throwable.class.isAssignableFrom(objectClass) || BeanUtils.isExtendedMap(objectClass) || beanInfo.rootName != null) {
            return super.createObjectWriter(objectClass, features, provider);
        }
        LinkedHashMap<String, FieldWriter> fieldWriterMap = new LinkedHashMap<String, FieldWriter>();
        if (!fieldBased || record) {
            ArrayList<FieldWriter> fieldWriterList = new ArrayList<FieldWriter>();
            boolean fieldWritersCreated = false;
            for (ObjectWriterModule module : provider.modules) {
                if (!module.createFieldWriters(this, objectClass, fieldWriterList)) continue;
                fieldWritersCreated = true;
                break;
            }
            if (fieldWritersCreated) {
                for (FieldWriter fieldWriter : fieldWriterList) {
                    Method method2 = fieldWriter.method;
                    if (method2 == null) {
                        return super.createObjectWriter(objectClass, writerFieldFeatures, provider);
                    }
                    fieldWriterMap.putIfAbsent(fieldWriter.fieldName, fieldWriter);
                }
            } else {
                FieldInfo fieldInfo = new FieldInfo();
                if (!record) {
                    BeanUtils.declaredFields(objectClass, field -> {
                        fieldInfo.init();
                        fieldInfo.isPrivate = (field.getModifiers() & 1) == 0;
                        fieldInfo.ignore = fieldInfo.isPrivate;
                        FieldWriter fieldWriter = this.createFieldWriter(objectClass, writerFieldFeatures, provider, beanInfo, fieldInfo, (Field)field);
                        if (fieldWriter != null) {
                            int cmp;
                            FieldWriter origin;
                            if (fieldInfo.writeUsing != null && fieldWriter instanceof FieldWriterObject) {
                                ((FieldWriterObject)fieldWriter).writeUsing = true;
                            }
                            if ((origin = fieldWriterMap.putIfAbsent(fieldWriter.fieldName, fieldWriter)) != null && (cmp = origin.compareTo(fieldWriter)) > 0) {
                                fieldWriterMap.put(fieldWriter.fieldName, fieldWriter);
                            }
                        }
                    });
                }
                Class mixIn = provider.getMixIn(objectClass);
                BeanUtils.getters(objectClass, mixIn, beanInfo.kotlin, method -> {
                    FieldWriter origin;
                    boolean jit;
                    boolean match;
                    fieldInfo.init();
                    fieldInfo.features |= writerFieldFeatures;
                    fieldInfo.format = beanInfo.format;
                    provider.getFieldInfo(beanInfo, fieldInfo, objectClass, (Method)method);
                    if (fieldInfo.ignore) {
                        return;
                    }
                    String fieldName = ObjectWriterCreatorASM.getFieldName(objectClass, provider, beanInfo, record, fieldInfo, method);
                    if (beanInfo.orders != null) {
                        match = false;
                        for (int i = 0; i < beanInfo.orders.length; ++i) {
                            if (!fieldName.equals(beanInfo.orders[i])) continue;
                            fieldInfo.ordinal = i;
                            match = true;
                        }
                        if (!match && fieldInfo.ordinal == 0) {
                            fieldInfo.ordinal = beanInfo.orders.length;
                        }
                    }
                    if (beanInfo.includes != null && beanInfo.includes.length > 0) {
                        match = false;
                        for (String include : beanInfo.includes) {
                            if (!include.equals(fieldName)) continue;
                            match = true;
                            break;
                        }
                        if (!match) {
                            return;
                        }
                    }
                    if ((beanInfo.writerFeatures & JSONWriter.Feature.WriteClassName.mask) != 0L && fieldName.equals(beanInfo.typeKey)) {
                        return;
                    }
                    Class<?> returnType = method.getReturnType();
                    if (TypeUtils.isFunction(returnType) || returnType == Void.TYPE) {
                        return;
                    }
                    method.setAccessible(true);
                    ObjectWriter writeUsingWriter = null;
                    if (fieldInfo.writeUsing != null) {
                        try {
                            Constructor<?> constructor = fieldInfo.writeUsing.getDeclaredConstructor(new Class[0]);
                            constructor.setAccessible(true);
                            writeUsingWriter = (ObjectWriter)constructor.newInstance(new Object[0]);
                        }
                        catch (Exception e) {
                            throw new JSONException("create writeUsing Writer error, method " + method.getName() + ", serializer " + fieldInfo.writeUsing.getName(), e);
                        }
                    }
                    if (writeUsingWriter == null && fieldInfo.fieldClassMixIn) {
                        writeUsingWriter = ObjectWriterBaseModule.VoidObjectWriter.INSTANCE;
                    }
                    FieldWriter fieldWriter = null;
                    boolean bl = jit = (fieldInfo.features & 0x40000000000000L) != 0L;
                    if (jit) {
                        try {
                            fieldWriter = this.createFieldWriterLambda(provider, objectClass, fieldName, fieldInfo.ordinal, fieldInfo.features, fieldInfo.format, fieldInfo.label, (Method)method, writeUsingWriter, fieldInfo.contentAs);
                        }
                        catch (Throwable e) {
                            this.jitErrorCount.incrementAndGet();
                            this.jitErrorLast = e;
                        }
                    }
                    if (fieldWriter == null) {
                        fieldWriter = this.createFieldWriter(provider, objectClass, fieldName, fieldInfo.ordinal, fieldInfo.features, fieldInfo.format, fieldInfo.locale, fieldInfo.label, (Method)method, writeUsingWriter, fieldInfo.contentAs);
                    }
                    if (fieldInfo.writeUsing != null && fieldWriter instanceof FieldWriterObject) {
                        ((FieldWriterObject)fieldWriter).writeUsing = true;
                    }
                    if ((origin = (FieldWriter)fieldWriterMap.putIfAbsent(fieldName, fieldWriter)) != null && origin.compareTo(fieldWriter) > 0) {
                        fieldWriterMap.put(fieldName, fieldWriter);
                    }
                    if (origin == null) {
                        FieldWriter sameNameFieldWriter;
                        String sameFieldName = null;
                        char firstChar = fieldName.charAt(0);
                        if (firstChar >= 'A' && firstChar <= 'Z') {
                            sameFieldName = (char)(firstChar + 32) + fieldName.substring(1);
                        } else if (firstChar >= 'a' && firstChar <= 'z') {
                            sameFieldName = (char)(firstChar - 32) + fieldName.substring(1);
                        }
                        if (sameFieldName != null && (sameNameFieldWriter = (FieldWriter)fieldWriterMap.get(sameFieldName)) != null && (sameNameFieldWriter.method == null || sameNameFieldWriter.method.equals(method))) {
                            fieldWriterMap.remove(sameFieldName);
                        }
                    }
                });
            }
        } else {
            FieldInfo fieldInfo = new FieldInfo();
            BeanUtils.declaredFields(objectClass, field -> {
                fieldInfo.init();
                FieldWriter fieldWriter = this.createFieldWriter(objectClass, writerFieldFeatures, provider, beanInfo, fieldInfo, (Field)field);
                if (fieldWriter != null) {
                    if (fieldInfo.writeUsing != null && fieldWriter instanceof FieldWriterObject) {
                        ((FieldWriterObject)fieldWriter).writeUsing = true;
                    }
                    fieldWriterMap.put(fieldWriter.fieldName, fieldWriter);
                }
            });
        }
        ArrayList<FieldWriter> fieldWriters = new ArrayList<FieldWriter>(fieldWriterMap.values());
        this.handleIgnores(beanInfo, fieldWriters);
        if (beanInfo.alphabetic) {
            try {
                Collections.sort(fieldWriters);
            }
            catch (Exception e) {
                StringBuilder msg = new StringBuilder("fieldWriters sort error, objectClass ").append(objectClass.getName()).append(", fields ");
                JSONArray array = new JSONArray();
                for (FieldWriter fieldWriter : fieldWriters) {
                    array.add(JSONObject.of("name", (Object)fieldWriter.fieldName, "type", (Object)fieldWriter.fieldClass, "ordinal", (Object)fieldWriter.ordinal, "field", (Object)fieldWriter.field, "method", (Object)fieldWriter.method));
                }
                msg.append(array);
                throw new JSONException(msg.toString(), e);
            }
        }
        boolean bl2 = match = fieldWriters.size() < 100 && !Throwable.class.isAssignableFrom(objectClass);
        if (!publicClass || externalClass) {
            for (FieldWriter fieldWriter : fieldWriters) {
                if (fieldWriter.method == null) continue;
                match = false;
                break;
            }
        }
        for (FieldWriter fieldWriter : fieldWriters) {
            if (fieldWriter.getInitWriter() == null && (fieldWriter.features & 0x1000000000000L) == 0L && (fieldWriter.features & 0x4000000000000L) == 0L) continue;
            match = false;
            break;
        }
        if (objectClass.getSuperclass() == Object.class && (simpleName = objectClass.getSimpleName()).indexOf(36) != -1 && simpleName.contains("$$")) {
            match = false;
        }
        if (fieldWriters.size() > 64) {
            match = false;
        }
        long writerFeatures = features | beanInfo.writerFeatures;
        if (!match) {
            return super.createObjectWriter(objectClass, features, provider);
        }
        this.setDefaultValue(fieldWriters, objectClass);
        return this.jitWriter(objectClass, provider, beanInfo, fieldWriters, writerFeatures);
    }

    private ObjectWriterAdapter jitWriter(Class objectClass, ObjectWriterProvider provider, BeanInfo beanInfo, List<FieldWriter> fieldWriters, long writerFeatures) {
        boolean disableArrayMapping;
        String objectWriterSupper;
        String classNameType;
        String classNameFull;
        List<FieldWriterGroup> fieldWriterGroups = ObjectWriterCreatorASM.buildGroups(beanInfo.writerFeatures, fieldWriters);
        ClassWriter cw = new ClassWriter(null);
        String className = "OWG_" + seed.incrementAndGet() + "_" + fieldWriters.size() + (objectClass == null ? "" : "_" + objectClass.getSimpleName());
        Package pkg = ObjectWriterCreatorASM.class.getPackage();
        if (pkg != null) {
            String packageName = pkg.getName();
            int packageNameLength = packageName.length();
            int charsLength = packageNameLength + 1 + className.length();
            char[] chars = new char[charsLength];
            packageName.getChars(0, packageName.length(), chars, 0);
            chars[packageNameLength] = 46;
            className.getChars(0, className.length(), chars, packageNameLength + 1);
            classNameFull = new String(chars);
            chars[packageNameLength] = 47;
            for (int i = 0; i < packageNameLength; ++i) {
                if (chars[i] != '.') continue;
                chars[i] = 47;
            }
            classNameType = new String(chars);
        } else {
            classNameType = className;
            classNameFull = className;
        }
        switch (fieldWriters.size()) {
            case 1: {
                objectWriterSupper = ASMUtils.TYPE_OBJECT_WRITER_1;
                break;
            }
            case 2: {
                objectWriterSupper = ASMUtils.TYPE_OBJECT_WRITER_2;
                break;
            }
            case 3: {
                objectWriterSupper = ASMUtils.TYPE_OBJECT_WRITER_3;
                break;
            }
            case 4: {
                objectWriterSupper = ASMUtils.TYPE_OBJECT_WRITER_4;
                break;
            }
            case 5: {
                objectWriterSupper = ASMUtils.TYPE_OBJECT_WRITER_5;
                break;
            }
            case 6: {
                objectWriterSupper = ASMUtils.TYPE_OBJECT_WRITER_6;
                break;
            }
            case 7: {
                objectWriterSupper = ASMUtils.TYPE_OBJECT_WRITER_7;
                break;
            }
            case 8: {
                objectWriterSupper = ASMUtils.TYPE_OBJECT_WRITER_8;
                break;
            }
            case 9: {
                objectWriterSupper = ASMUtils.TYPE_OBJECT_WRITER_9;
                break;
            }
            case 10: {
                objectWriterSupper = ASMUtils.TYPE_OBJECT_WRITER_10;
                break;
            }
            case 11: {
                objectWriterSupper = ASMUtils.TYPE_OBJECT_WRITER_11;
                break;
            }
            case 12: {
                objectWriterSupper = ASMUtils.TYPE_OBJECT_WRITER_12;
                break;
            }
            default: {
                objectWriterSupper = ASMUtils.TYPE_OBJECT_WRITER_ADAPTER;
            }
        }
        cw.visit(52, 49, classNameType, objectWriterSupper, INTERFACES);
        this.genFields(fieldWriters, cw, objectWriterSupper);
        this.genMethodInit(fieldWriters, cw, classNameType, objectWriterSupper);
        boolean disableJSONB = (writerFeatures & 0x1000000000000000L) != 0L;
        boolean bl = disableArrayMapping = (writerFeatures & 0x400000000000000L) != 0L;
        if (!disableJSONB) {
            this.genMethodWriteJSONB(provider, objectClass, fieldWriterGroups, fieldWriters, cw, classNameType, writerFeatures);
        }
        if ((writerFeatures & JSONWriter.Feature.BeanToArray.mask) != 0L && !disableJSONB) {
            this.genMethodWriteArrayMapping(provider, "write", objectClass, writerFeatures, fieldWriters, cw, classNameType);
        } else {
            this.genMethodWrite(provider, objectClass, fieldWriters, cw, classNameType, writerFeatures);
        }
        if (!disableJSONB) {
            this.genMethodWriteArrayMappingJSONB(provider, objectClass, writerFeatures, fieldWriterGroups, fieldWriters, cw, classNameType, writerFeatures);
        }
        if (!disableArrayMapping) {
            this.genMethodWriteArrayMapping(provider, "writeArrayMapping", objectClass, writerFeatures, fieldWriters, cw, classNameType);
        }
        byte[] code = cw.toByteArray();
        Class<?> deserClass = this.classLoader.defineClassPublic(classNameFull, code, 0, code.length);
        try {
            Constructor<?> constructor = deserClass.getConstructor(Class.class, String.class, String.class, Long.TYPE, List.class);
            ObjectWriterAdapter objectWriter = (ObjectWriterAdapter)constructor.newInstance(objectClass, beanInfo.typeKey, beanInfo.typeName, writerFeatures, fieldWriters);
            if (beanInfo.serializeFilters != null) {
                ObjectWriterCreatorASM.configSerializeFilters(beanInfo, objectWriter);
            }
            return objectWriter;
        }
        catch (Throwable e) {
            throw new JSONException("create objectWriter error, objectType " + objectClass, e);
        }
    }

    private void genMethodWrite(ObjectWriterProvider provider, Class objectType, List<FieldWriter> fieldWriters, ClassWriter cw, String classNameType, long objectFeatures) {
        boolean disableJSONB = (objectFeatures & 0x1000000000000000L) != 0L;
        boolean disableArrayMapping = (objectFeatures & 0x400000000000000L) != 0L;
        boolean disableAutoType = (objectFeatures & 0x800000000000000L) != 0L;
        MethodWriter mw = cw.visitMethod(1, "write", METHOD_DESC_WRITE, fieldWriters.size() < 6 ? 512 : 1024);
        int OBJECT = 2;
        int FIELD_NAME = 3;
        int FIELD_TYPE = 4;
        int FIELD_FEATURES = 5;
        int COMMA = 7;
        Label notSuper_ = new Label();
        MethodWriterContext mwc = new MethodWriterContext(provider, objectType, objectFeatures, classNameType, mw, 8, false);
        mwc.genVariantsMethodBefore(false);
        mwc.genIsEnabled(JSONWriter.Feature.IgnoreErrorGetter.mask | JSONWriter.Feature.UnquoteFieldName.mask, notSuper_);
        mw.aload(0);
        mw.aload(1);
        mw.aload(2);
        mw.aload(3);
        mw.aload(4);
        mw.lload(5);
        mw.invokespecial(ASMUtils.TYPE_OBJECT_WRITER_ADAPTER, "write", METHOD_DESC_WRITE_OBJECT);
        mw.return_();
        mw.visitLabel(notSuper_);
        if (!disableJSONB) {
            Label json_ = new Label();
            mw.aload(1);
            mw.getfield(ASMUtils.TYPE_JSON_WRITER, "jsonb", "Z");
            mw.ifeq(json_);
            if (!disableArrayMapping) {
                Label jsonb_ = new Label();
                mwc.genIsEnabled(JSONWriter.Feature.BeanToArray.mask, jsonb_);
                mw.aload(0);
                mw.aload(1);
                mw.aload(2);
                mw.aload(3);
                mw.aload(4);
                mw.lload(5);
                mw.invokevirtual(classNameType, "writeArrayMappingJSONB", METHOD_DESC_WRITE_OBJECT);
                mw.return_();
                mw.visitLabel(jsonb_);
            }
            mw.aload(0);
            mw.aload(1);
            mw.aload(2);
            mw.aload(3);
            mw.aload(4);
            mw.lload(5);
            mw.invokevirtual(classNameType, "writeJSONB", METHOD_DESC_WRITE_OBJECT);
            mw.return_();
            mw.visitLabel(json_);
        }
        if (!disableArrayMapping) {
            Label checkFilter_ = new Label();
            mwc.genIsEnabled(JSONWriter.Feature.BeanToArray.mask, checkFilter_);
            mw.aload(0);
            mw.aload(1);
            mw.aload(2);
            mw.aload(3);
            mw.aload(4);
            mw.lload(5);
            mw.invokevirtual(classNameType, "writeArrayMapping", METHOD_DESC_WRITE_OBJECT);
            mw.return_();
            mw.visitLabel(checkFilter_);
        }
        Label object_ = new Label();
        ObjectWriterCreatorASM.hashFilter(mw, fieldWriters, object_);
        mw.aload(0);
        mw.aload(1);
        mw.aload(2);
        mw.aload(3);
        mw.aload(4);
        mw.lload(5);
        mw.invokevirtual(classNameType, "writeWithFilter", METHOD_DESC_WRITE_OBJECT);
        mw.return_();
        mw.visitLabel(object_);
        Label LReturn = new Label();
        if (objectType == null || !Serializable.class.isAssignableFrom(objectType)) {
            Label endIgnoreNoneSerializable_ = new Label();
            mwc.genIsEnabled(JSONWriter.Feature.IgnoreNoneSerializable.mask, endIgnoreNoneSerializable_);
            mw.aload(1);
            mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "writeNull", "()V");
            mw.goto_(LReturn);
            mw.visitLabel(endIgnoreNoneSerializable_);
            Label endErrorOnNoneSerializable_ = new Label();
            mwc.genIsEnabled(JSONWriter.Feature.ErrorOnNoneSerializable.mask, endErrorOnNoneSerializable_);
            mw.aload(0);
            mw.invokevirtual(mwc.classNameType, "errorOnNoneSerializable", "()V");
            mw.goto_(LReturn);
            mw.visitLabel(endErrorOnNoneSerializable_);
        }
        mw.aload(1);
        mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "startObject", "()V");
        if (!disableAutoType) {
            mw.iconst_1();
            mw.istore(7);
            Label writeFields_ = new Label();
            ObjectWriterCreatorASM.isWriteTypeInfo(objectFeatures, mw, 2, 4, 5, writeFields_);
            mw.aload(0);
            mw.aload(1);
            mw.invokeinterface(ASMUtils.TYPE_OBJECT_WRITER, "writeTypeInfo", METHOD_DESC_WRITE_TYPE_INFO);
            mw.iconst_1();
            mw.ixor();
            mw.istore(7);
            mw.visitLabel(writeFields_);
        }
        for (int i = 0; i < fieldWriters.size(); ++i) {
            FieldWriter fieldWriter = fieldWriters.get(i);
            this.gwFieldValue(mwc, fieldWriter, 2, i);
        }
        mw.aload(1);
        mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "endObject", "()V");
        mw.visitLabel(LReturn);
        mw.return_();
        mw.visitMaxs(mwc.maxVariant + 1, mwc.maxVariant + 1);
    }

    private static void isWriteTypeInfo(long objectFeatures, MethodWriter mw, int OBJECT, int FIELD_TYPE, int FEILD_FEATURE, Label notWriteType) {
        if ((objectFeatures & JSONWriter.Feature.WriteClassName.mask) == 0L || (objectFeatures & JSONWriter.Feature.NotWriteRootClassName.mask) != 0L) {
            mw.aload(OBJECT);
            mw.ifnull(notWriteType);
            mw.aload(OBJECT);
            mw.invokevirtual("java/lang/Object", "getClass", "()Ljava/lang/Class;");
            mw.aload(FIELD_TYPE);
            mw.if_acmpeq(notWriteType);
            mw.aload(1);
            mw.aload(OBJECT);
            mw.aload(FIELD_TYPE);
            mw.lload(FEILD_FEATURE);
            mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "isWriteTypeInfo", "(Ljava/lang/Object;Ljava/lang/reflect/Type;J)Z");
            mw.ifeq(notWriteType);
        }
    }

    private void genMethodWriteJSONB(ObjectWriterProvider provider, Class objectType, List<FieldWriterGroup> fieldWriterGroups, List<FieldWriter> fieldWriters, ClassWriter cw, String classNameType, long objectFeatures) {
        MethodWriter mw = cw.visitMethod(1, "writeJSONB", METHOD_DESC_WRITE, fieldWriters.size() < 6 ? 512 : 1024);
        int OBJECT = 2;
        int FIELD_NAME = 3;
        int FIELD_TYPE = 4;
        int FIELD_FEATURES = 5;
        MethodWriterContext mwc = new MethodWriterContext(provider, objectType, objectFeatures, classNameType, mw, 7, true);
        mwc.genVariantsMethodBefore(true);
        Label return_ = new Label();
        if (objectType == null || !Serializable.class.isAssignableFrom(objectType)) {
            Label endIgnoreNoneSerializable_ = new Label();
            mwc.genIsEnabled(JSONWriter.Feature.IgnoreNoneSerializable.mask, endIgnoreNoneSerializable_);
            mw.aload(1);
            mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "writeNull", "()V");
            mw.goto_(return_);
            mw.visitLabel(endIgnoreNoneSerializable_);
            Label endErrorOnNoneSerializable_ = new Label();
            mwc.genIsEnabled(JSONWriter.Feature.ErrorOnNoneSerializable.mask, endErrorOnNoneSerializable_);
            mw.aload(0);
            mw.invokevirtual(mwc.classNameType, "errorOnNoneSerializable", "()V");
            mw.goto_(return_);
            mw.visitLabel(endErrorOnNoneSerializable_);
        }
        if ((objectFeatures & 0x800000000000000L) == 0L) {
            Label notWriteType = new Label();
            ObjectWriterCreatorASM.isWriteTypeInfo(objectFeatures, mw, 2, 4, 5, notWriteType);
            mw.aload(0);
            mw.aload(1);
            mw.invokevirtual(classNameType, "writeClassInfo", METHOD_DESC_WRITE_CLASS_INFO);
            mw.visitLabel(notWriteType);
        }
        Integer symbolTable = null;
        for (FieldWriterGroup group : fieldWriterGroups) {
            if (group.direct) {
                int OFFSET = mwc.var("offset");
                int BYTES = mwc.var("bytes");
                int FEATURES = mwc.var2(CONTEXT_FEATURES);
                mw.aload(1);
                mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "getOffset", "()I");
                mw.istore(OFFSET);
                if (symbolTable == null) {
                    symbolTable = mwc.var("symbolTable");
                    mw.aload(1);
                    mw.getfield(ASMUtils.TYPE_JSON_WRITER, "symbolTable", DESC_SYMBOL);
                    mw.astore(symbolTable);
                }
                int minCapacity = (group.start ? 0 : 1) + (group.end ? 0 : 1);
                for (FieldWriterRecord item : group.fieldWriters) {
                    minCapacity += item.fieldWriter.nameJSONB.length;
                    FieldWriter fieldWriter = item.fieldWriter;
                    Class fieldClass = fieldWriter.fieldClass;
                    if (ObjectWriterCreatorASM.isFieldVarIndex(mwc, fieldWriter)) {
                        this.sotreFieldValueToLocalVar(mwc, item.ordinal, fieldWriter, 2, mw);
                        continue;
                    }
                    minCapacity += this.fieldCapacity(fieldClass);
                }
                mw.aload(1);
                mw.iload(OFFSET);
                mw.visitLdcInsn(minCapacity);
                mw.iadd();
                ObjectWriterCreatorASM.fieldValueCapacity(objectFeatures, group.fieldWriters, mwc, mw, FEATURES);
                mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "ensureCapacity", "(I)Ljava/lang/Object;");
                mw.checkcast("[B");
                mw.astore(BYTES);
                if (group.start) {
                    ObjectWriterCreatorASM.gwWriteByte(mw, BYTES, OFFSET, (byte)-90);
                    mw.visitIincInsn(OFFSET, 1);
                }
                for (FieldWriterRecord item : group.fieldWriters) {
                    this.writeFieldValueDirectJSONB(objectFeatures, classNameType, mwc, item.fieldWriter, item.ordinal, mw, BYTES, OFFSET, 2, FEATURES, symbolTable, true);
                }
                if (group.end) {
                    ObjectWriterCreatorASM.gwWriteByte(mw, BYTES, OFFSET, (byte)-91);
                }
                mw.aload(1);
                mw.iload(OFFSET);
                if (group.end) {
                    mw.iconst_1();
                    mw.iadd();
                }
                mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "setOffset", "(I)V");
                continue;
            }
            if (group.start) {
                mw.aload(1);
                mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "startObject", "()V");
            }
            for (FieldWriterRecord item : group.fieldWriters) {
                this.gwFieldValueJSONB(mwc, item.fieldWriter, 2, item.ordinal);
            }
            if (!group.end) continue;
            mw.aload(1);
            mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "endObject", "()V");
        }
        mw.visitLabel(return_);
        mw.return_();
        mw.visitMaxs(mwc.maxVariant + 1, mwc.maxVariant + 1);
    }

    private static void gwFieldNameDirectJSONB(String classNameType, FieldWriter fieldWriter, int ordinal, MethodWriterContext mwc, int BYTES, int OFFSET) {
        Label L0 = new Label();
        Label L_NAME_END = new Label();
        MethodWriter mw = mwc.mw;
        mwc.genIsDisabled(JSONWriter.Feature.WriteNameAsSymbol.mask, L0);
        int SYMBOL_TABLE = mwc.var("symbolTable");
        Label L1 = new Label();
        mw.aload(SYMBOL_TABLE);
        mw.ifnull(L1);
        int SYMBOL = mwc.var("symbol");
        mw.aload(0);
        mw.getfield(classNameType, ObjectWriterCreatorASM.fieldWriter(ordinal), ASMUtils.DESC_FIELD_WRITER);
        mw.aload(SYMBOL_TABLE);
        mw.invokevirtual(ASMUtils.TYPE_FIELD_WRITER, "writeFieldNameSymbol", METHOD_DESC_WRITE_NAME_SYMBOL);
        mw.istore(SYMBOL);
        mw.iload(SYMBOL);
        mw.visitLdcInsn(-1);
        mw.if_icmpeq(L1);
        mw.aload(BYTES);
        mw.iload(OFFSET);
        mw.iload(SYMBOL);
        mw.ineg();
        mw.invokestatic(ASMUtils.TYPE_JSONB_IO, "writeSymbol", "([BII)I", true);
        mw.istore(OFFSET);
        mw.goto_(L_NAME_END);
        mw.visitLabel(L1);
        byte[] name = fieldWriter.nameJSONB;
        int i = 0;
        while (i + 8 <= name.length) {
            ObjectWriterCreatorASM.gwWriteLong(mw, BYTES, OFFSET, name, i);
            i += 8;
        }
        if (i + 4 <= name.length) {
            ObjectWriterCreatorASM.gwWriteInt(mw, BYTES, OFFSET, name, i);
            i += 4;
        }
        if (i + 2 <= name.length) {
            ObjectWriterCreatorASM.gwWriteShort(mw, BYTES, OFFSET, name, i);
            i += 2;
        }
        if (i + 1 <= name.length) {
            ObjectWriterCreatorASM.gwWriteByte(mw, BYTES, OFFSET, name, i);
        }
        mw.visitIincInsn(OFFSET, name.length);
        mw.goto_(L_NAME_END);
        mw.visitLabel(L0);
        mw.aload(0);
        mw.getfield(classNameType, ObjectWriterCreatorASM.fieldWriter(ordinal), ASMUtils.DESC_FIELD_WRITER);
        mw.aload(BYTES);
        mw.iload(OFFSET);
        mw.aload(1);
        mw.invokevirtual(ASMUtils.TYPE_FIELD_WRITER, "writeFieldNameJSONB", METHOD_DESC_WRITE_FIELD_NAME_JSONB);
        mw.istore(OFFSET);
        mw.visitLabel(L_NAME_END);
    }

    private static void gwWriteByte(MethodWriter mw, int BYTES, int OFFSET, byte value) {
        mw.aload(BYTES);
        mw.iload(OFFSET);
        mw.iconst_n(value);
        mw.bastore();
    }

    private static void gwWriteByte(MethodWriter mw, int BYTES, int OFFSET, byte[] name, int offset) {
        mw.aload(BYTES);
        mw.iload(OFFSET);
        if (offset != 0) {
            mw.iconst_n(offset);
            mw.iadd();
        }
        mw.iconst_n(name[offset]);
        mw.bastore();
    }

    private static void gwWriteShort(MethodWriter mw, int BYTES, int OFFSET, byte[] name, int offset) {
        short nameInt = IOUtils.getShortUnaligned(name, offset);
        mw.aload(BYTES);
        mw.iload(OFFSET);
        if (offset != 0) {
            mw.iconst_n(offset);
            mw.iadd();
        }
        mw.visitLdcInsn(nameInt);
        mw.invokestatic(ASMUtils.TYPE_IO_UTILS, "putShortUnaligned", "([BIS)V");
    }

    private static void gwWriteInt(MethodWriter mw, int BYTES, int OFFSET, byte[] name, int offset) {
        int nameInt = IOUtils.getIntUnaligned(name, offset);
        mw.aload(BYTES);
        mw.iload(OFFSET);
        if (offset != 0) {
            mw.iconst_n(offset);
            mw.iadd();
        }
        mw.visitLdcInsn(nameInt);
        mw.invokestatic(ASMUtils.TYPE_IO_UTILS, "putIntUnaligned", "([BII)V");
    }

    private static void gwWriteLong(MethodWriter mw, int BYTES, int OFFSET, byte[] name, int offset) {
        long nameInt = IOUtils.getLongUnaligned(name, offset);
        mw.aload(BYTES);
        mw.iload(OFFSET);
        if (offset != 0) {
            mw.iconst_n(offset);
            mw.iadd();
        }
        mw.visitLdcInsn(nameInt);
        mw.invokestatic(ASMUtils.TYPE_IO_UTILS, "putLongUnaligned", "([BIJ)V");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeFieldValueDirectJSONB(long objectFeatures, String classNameType, MethodWriterContext mwc, FieldWriter fieldWriter, int i, MethodWriter mw, int BYTES, int OFFSET, int OBJECT, int FEATURES, int SYMBOL_TABLE, boolean writeFieldName) {
        boolean needFeatures;
        String methodName;
        String methodDesc;
        Class fieldClass = fieldWriter.fieldClass;
        boolean field_var_index = ObjectWriterCreatorASM.isFieldVarIndex(mwc, fieldWriter);
        Integer FIELD_VALUE = null;
        Label endFieldValue_ = null;
        if (!fieldClass.isPrimitive() || writeFieldName) {
            endFieldValue_ = new Label();
            if (field_var_index) {
                FIELD_VALUE = mwc.var("field_" + i);
            } else {
                FIELD_VALUE = mwc.var(fieldClass);
                this.genGetObject(mwc, fieldWriter, i, OBJECT);
                mw.storeLocal(fieldClass, FIELD_VALUE);
            }
        }
        boolean pop = false;
        if ((Collection.class.isAssignableFrom(fieldClass) || fieldClass.isArray()) && !mwc.disableReferenceDetect()) {
            int REF_PATH = mwc.var("REF_PATH");
            if (endFieldValue_ == null) {
                endFieldValue_ = new Label();
            }
            Label endDetect_ = new Label();
            pop = true;
            mw.aload(FIELD_VALUE);
            mw.ifnull(endDetect_);
            mwc.genIsEnabled(JSONWriter.Feature.ReferenceDetection.mask, endDetect_);
            mw.aload(1);
            mw.aload(0);
            mw.getfield(classNameType, ObjectWriterCreatorASM.fieldWriter(i), ASMUtils.DESC_FIELD_WRITER);
            mw.aload(FIELD_VALUE);
            mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "setPath0", METHOD_DESC_SET_PATH2);
            mw.dup();
            mw.astore(REF_PATH);
            mw.ifnull(endDetect_);
            if (writeFieldName) {
                ObjectWriterCreatorASM.gwFieldNameDirectJSONB(classNameType, fieldWriter, i, mwc, BYTES, OFFSET);
            }
            mw.aload(BYTES);
            mw.iload(OFFSET);
            mw.aload(REF_PATH);
            mw.aload(1);
            mw.invokestatic(ASMUtils.TYPE_JSONB_IO, "writeReference", METHOD_DESC_IO_WRITE_REFERENCE, true);
            mw.istore(OFFSET);
            mw.aload(1);
            mw.aload(FIELD_VALUE);
            mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "popPath0", "(Ljava/lang/Object;)V");
            mw.goto_(endFieldValue_);
            mw.visitLabel(endDetect_);
        }
        if (writeFieldName) {
            if (!fieldClass.isPrimitive()) {
                Label L_NOT_NULL = new Label();
                mw.iload(mwc.var(WRITE_NULLS));
                mw.ifne(L_NOT_NULL);
                mw.aload(FIELD_VALUE);
                mw.ifnull(endFieldValue_);
                mw.visitLabel(L_NOT_NULL);
            } else {
                int WRITE_DEFAULT_VALUE = mwc.var(NOT_WRITE_DEFAULT_VALUE);
                Label L_NOT_DEFAULT_VALUE = new Label();
                if (fieldClass == Byte.TYPE || fieldClass == Short.TYPE || fieldClass == Integer.TYPE || fieldClass == Boolean.TYPE) {
                    mw.iload(FIELD_VALUE);
                    mw.ifne(L_NOT_DEFAULT_VALUE);
                    mw.iload(WRITE_DEFAULT_VALUE);
                    mw.ifne(endFieldValue_);
                    mw.visitLabel(L_NOT_DEFAULT_VALUE);
                } else if (fieldClass == Long.TYPE) {
                    mw.lload(FIELD_VALUE);
                    mw.lconst_0();
                    mw.lcmp();
                    mw.ifne(L_NOT_DEFAULT_VALUE);
                    mw.iload(WRITE_DEFAULT_VALUE);
                    mw.ifne(endFieldValue_);
                    mw.visitLabel(L_NOT_DEFAULT_VALUE);
                }
            }
            ObjectWriterCreatorASM.gwFieldNameDirectJSONB(classNameType, fieldWriter, i, mwc, BYTES, OFFSET);
        }
        if (Collection.class.isAssignableFrom(fieldClass)) {
            mw.aload(BYTES);
            mw.iload(OFFSET);
            mw.aload(FIELD_VALUE);
            mw.aload(0);
            mw.getfield(classNameType, ObjectWriterCreatorASM.fieldWriter(i), ASMUtils.DESC_FIELD_WRITER);
            mw.getfield(ASMUtils.TYPE_FIELD_WRITER, "fieldClass", "Ljava/lang/Class;");
            mw.aload(1);
            String methodDesc2 = "([BILjava/lang/Object;Ljava/lang/Class;" + ASMUtils.DESC_JSON_WRITER + ")I";
            mw.invokestatic(ASMUtils.TYPE_JSONB_IO, "checkAndWriteTypeName", methodDesc2, true);
            mw.istore(OFFSET);
        }
        if (fieldWriter instanceof FieldWriterEnum) {
            Label L0 = new Label();
            mw.aload(FIELD_VALUE);
            mw.ifnull(L0);
            mw.aload(SYMBOL_TABLE);
            mw.ifnull(L0);
            mw.aload(0);
            mw.getfield(classNameType, ObjectWriterCreatorASM.fieldWriter(i), ASMUtils.DESC_FIELD_WRITER);
            mw.aload(BYTES);
            mw.iload(OFFSET);
            mw.aload(FIELD_VALUE);
            mw.aload(SYMBOL_TABLE);
            mw.lload(FEATURES);
            methodDesc = "([BILjava/lang/Enum;" + DESC_SYMBOL + "J)I";
            mw.invokevirtual(ASMUtils.TYPE_FIELD_WRITER, "writeEnumValueJSONB", methodDesc);
            mw.istore(OFFSET);
            mw.goto_(endFieldValue_);
            mw.visitLabel(L0);
        }
        mw.aload(BYTES);
        mw.iload(OFFSET);
        if (FIELD_VALUE != null) {
            mw.loadLocal(fieldClass, FIELD_VALUE);
        } else {
            this.genGetObject(mwc, fieldWriter, i, OBJECT);
        }
        if (fieldClass == Boolean.TYPE) {
            methodName = "writeBoolean";
            methodDesc = "([BIZ)I";
        } else if (fieldClass == Byte.TYPE) {
            methodName = "writeInt8";
            methodDesc = "([BIB)I";
        } else if (fieldClass == Short.TYPE) {
            methodName = "writeInt16";
            methodDesc = "([BIS)I";
        } else if (fieldClass == Integer.TYPE) {
            methodName = "writeInt32";
            methodDesc = "([BII)I";
        } else if (fieldClass == Long.TYPE) {
            methodName = "writeInt64";
            methodDesc = "([BIJ)I";
        } else if (fieldClass == Float.TYPE) {
            methodName = "writeFloat";
            methodDesc = "([BIF)I";
        } else if (fieldClass == Double.TYPE) {
            methodName = "writeDouble";
            methodDesc = "([BID)I";
        } else if (fieldClass == Boolean.class) {
            methodName = "writeBoolean";
            methodDesc = "([BILjava/lang/Boolean;)I";
        } else if (fieldClass == Byte.class) {
            methodName = "writeInt8";
            methodDesc = "([BILjava/lang/Byte;J)I";
        } else if (fieldClass == Short.class) {
            methodName = "writeInt16";
            methodDesc = "([BILjava/lang/Short;J)I";
        } else if (fieldClass == Integer.class) {
            methodName = "writeInt32";
            methodDesc = "([BILjava/lang/Integer;J)I";
        } else if (fieldClass == Long.class) {
            methodName = "writeInt64";
            methodDesc = "([BILjava/lang/Long;J)I";
        } else if (fieldClass == Float.class) {
            methodName = "writeFloat";
            methodDesc = "([BILjava/lang/Float;J)I";
        } else if (fieldClass == Double.class) {
            methodName = "writeDouble";
            methodDesc = "([BILjava/lang/Double;J)I";
        } else if (fieldClass == String.class) {
            methodName = "writeString";
            methodDesc = "([BILjava/lang/String;)I";
        } else if (fieldWriter instanceof FieldWriterEnum) {
            methodName = "writeEnum";
            methodDesc = "([BILjava/lang/Enum;J)I";
        } else if (fieldClass == UUID.class) {
            methodName = "writeUUID";
            methodDesc = "([BILjava/util/UUID;)I";
        } else if (fieldClass == LocalDate.class) {
            methodName = "writeLocalDate";
            methodDesc = "([BILjava/time/LocalDate;)I";
        } else if (fieldClass == LocalTime.class) {
            methodName = "writeLocalTime";
            methodDesc = "([BILjava/time/LocalTime;)I";
        } else if (fieldClass == LocalDateTime.class) {
            methodName = "writeLocalDateTime";
            methodDesc = "([BILjava/time/LocalDateTime;)I";
        } else if (fieldClass == OffsetDateTime.class) {
            methodName = "writeOffsetDateTime";
            methodDesc = "([BILjava/time/OffsetDateTime;)I";
        } else if (fieldClass == OffsetTime.class) {
            methodName = "writeOffsetTime";
            methodDesc = "([BILjava/time/OffsetTime;)I";
        } else if (fieldClass == Instant.class) {
            methodName = "writeInstant";
            methodDesc = "([BILjava/time/Instant;)I";
        } else if (fieldClass == String[].class) {
            methodName = "writeString";
            methodDesc = "([BI[Ljava/lang/String;J)I";
        } else {
            if (!Collection.class.isAssignableFrom(fieldClass)) throw new JSONException("assert error " + fieldClass.getName());
            Class itemClass = fieldWriter.getItemClass();
            if (itemClass == String.class) {
                methodName = "writeString";
                methodDesc = "([BILjava/util/Collection;J)I";
            } else {
                if (itemClass != Long.class) throw new JSONException("assert error " + fieldClass.getName());
                methodName = "writeInt64";
                methodDesc = "([BILjava/util/Collection;J)I";
            }
        }
        boolean bl = needFeatures = fieldClass == Float.class || fieldClass == Double.class || fieldClass == Byte.class || fieldClass == Short.class || fieldClass == Integer.class || fieldClass == Long.class || fieldClass == String[].class || Collection.class.isAssignableFrom(fieldClass) || fieldWriter instanceof FieldWriterEnum;
        if (needFeatures) {
            mw.lload(FEATURES);
            long fieldFeatures = objectFeatures | fieldWriter.features;
            if (fieldFeatures != 0L) {
                mw.visitLdcInsn(fieldFeatures);
                mw.lor();
            }
        }
        mw.invokestatic(ASMUtils.TYPE_JSONB_IO, methodName, methodDesc, true);
        mw.istore(OFFSET);
        if (endFieldValue_ == null) return;
        if (pop) {
            mw.aload(1);
            mw.aload(FIELD_VALUE);
            mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "popPath0", "(Ljava/lang/Object;)V");
        }
        mw.visitLabel(endFieldValue_);
    }

    private void sotreFieldValueToLocalVar(MethodWriterContext mwc, int i, FieldWriter fieldWriter, int OBJECT, MethodWriter mw) {
        int FIELD_VALUE = mwc.var("field_" + i);
        this.genGetObject(mwc, fieldWriter, i, OBJECT);
        mw.astore(FIELD_VALUE);
    }

    private static boolean isFieldVarIndex(MethodWriterContext mwc, FieldWriter fieldWriter) {
        Class fieldClass = fieldWriter.fieldClass;
        return fieldClass == String.class || Collection.class.isAssignableFrom(fieldClass) || fieldClass == String[].class || fieldWriter instanceof FieldWriterEnum || Collection.class.isAssignableFrom(fieldClass) && !mwc.disableReferenceDetect();
    }

    private static void fieldValueCapacity(long objectFeatures, List<FieldWriterRecord> fieldWriters, MethodWriterContext mwc, MethodWriter mw, int FEATURES) {
        for (FieldWriterRecord item : fieldWriters) {
            int FIELD_VALUE;
            FieldWriter fieldWriter = item.fieldWriter;
            if (fieldWriter.fieldClass == String.class) {
                FIELD_VALUE = mwc.var("field_" + item.ordinal);
                mw.aload(FIELD_VALUE);
                mw.invokestatic(ASMUtils.TYPE_JSONB_IO, "stringCapacity", "(Ljava/lang/String;)I", true);
                mw.iadd();
                continue;
            }
            if (fieldWriter.fieldClass == String[].class) {
                FIELD_VALUE = mwc.var("field_" + item.ordinal);
                mw.aload(FIELD_VALUE);
                mw.invokestatic(ASMUtils.TYPE_JSONB_IO, "stringCapacity", "([Ljava/lang/String;)I", true);
                mw.iadd();
                continue;
            }
            if (fieldWriter instanceof FieldWriterEnum) {
                FIELD_VALUE = mwc.var("field_" + item.ordinal);
                mw.aload(FIELD_VALUE);
                mw.lload(FEATURES);
                long fieldFeatures = objectFeatures | fieldWriter.features;
                if (fieldFeatures != 0L) {
                    mw.visitLdcInsn(fieldFeatures);
                    mw.lor();
                }
                mw.invokestatic(ASMUtils.TYPE_JSONB_IO, "enumCapacity", "(Ljava/lang/Enum;J)I", true);
                mw.iadd();
                continue;
            }
            if (!Collection.class.isAssignableFrom(fieldWriter.fieldClass)) continue;
            FIELD_VALUE = mwc.var("field_" + item.ordinal);
            mw.aload(FIELD_VALUE);
            Class itemClass = fieldWriter.getItemClass();
            if (itemClass == String.class) {
                mw.invokestatic(ASMUtils.TYPE_JSONB_IO, "stringCapacity", "(Ljava/util/Collection;)I", true);
                mw.iadd();
                continue;
            }
            if (itemClass == Long.class) {
                mw.invokestatic(ASMUtils.TYPE_JSONB_IO, "int64Capacity", "(Ljava/util/Collection;)I", true);
                mw.iadd();
                continue;
            }
            throw new JSONException("assert error itemClass " + itemClass.getName());
        }
    }

    private void genMethodWriteArrayMappingJSONB(ObjectWriterProvider provider, Class objectType, long objectFeatures, List<FieldWriterGroup> fieldWriterGroups, List<FieldWriter> fieldWriters, ClassWriter cw, String classNameType, long features) {
        MethodWriter mw = cw.visitMethod(1, "writeArrayMappingJSONB", METHOD_DESC_WRITE, 512);
        MethodWriterContext mwc = new MethodWriterContext(provider, objectType, objectFeatures, classNameType, mw, 7, true);
        int OBJECT = 2;
        int FIELD_NAME = 3;
        int FIELD_TYPE = 4;
        int FIELD_FEATURES = 5;
        int OFFSET = mwc.var("offset");
        int BYTES = mwc.var("bytes");
        int FEATURES = mwc.var2(CONTEXT_FEATURES);
        if ((features & 0x800000000000000L) == 0L) {
            Label notWriteType = new Label();
            ObjectWriterCreatorASM.isWriteTypeInfo(objectFeatures, mw, 2, 4, 5, notWriteType);
            mw.aload(0);
            mw.aload(1);
            mw.invokevirtual(classNameType, "writeClassInfo", METHOD_DESC_WRITE_CLASS_INFO);
            mw.visitLabel(notWriteType);
        }
        int size = fieldWriters.size();
        mwc.genVariantsMethodBefore(true);
        for (FieldWriterGroup group : fieldWriterGroups) {
            if (group.direct) {
                mw.aload(1);
                mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "getOffset", "()I");
                mw.istore(OFFSET);
                int minCapacity = 6;
                for (FieldWriterRecord item : group.fieldWriters) {
                    FieldWriter fieldWriter = item.fieldWriter;
                    Class fieldClass = fieldWriter.fieldClass;
                    if (ObjectWriterCreatorASM.isFieldVarIndex(mwc, fieldWriter)) {
                        this.sotreFieldValueToLocalVar(mwc, item.ordinal, fieldWriter, 2, mw);
                        continue;
                    }
                    minCapacity += this.fieldCapacity(fieldClass);
                }
                mw.aload(1);
                mw.iload(OFFSET);
                mw.visitLdcInsn(minCapacity);
                mw.iadd();
                ObjectWriterCreatorASM.fieldValueCapacity(objectFeatures, group.fieldWriters, mwc, mw, FEATURES);
                mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "ensureCapacity", "(I)Ljava/lang/Object;");
                mw.checkcast("[B");
                mw.astore(BYTES);
                if (group.start) {
                    mw.aload(BYTES);
                    mw.iload(OFFSET);
                    mw.visitLdcInsn(fieldWriters.size());
                    mw.invokestatic(ASMUtils.TYPE_JSONB_IO, "startArray", "([BII)I", true);
                    mw.istore(OFFSET);
                }
                int symbolTable = mwc.var("symbolTable");
                mw.aload(1);
                mw.getfield(ASMUtils.TYPE_JSON_WRITER, "symbolTable", DESC_SYMBOL);
                mw.astore(symbolTable);
                for (FieldWriterRecord item : group.fieldWriters) {
                    FieldWriter fieldWriter = item.fieldWriter;
                    this.writeFieldValueDirectJSONB(objectFeatures, classNameType, mwc, fieldWriter, item.ordinal, mw, BYTES, OFFSET, 2, FEATURES, symbolTable, false);
                }
                mw.aload(1);
                mw.iload(OFFSET);
                mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "setOffset", "(I)V");
                continue;
            }
            if (group.start) {
                mw.aload(1);
                if (size <= 15) {
                    mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "startArray" + size, "()V");
                } else {
                    mw.iconst_n(size);
                    mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "startArray", "(I)V");
                }
            }
            for (FieldWriterRecord fieldWriter : group.fieldWriters) {
                this.gwValueJSONB(mwc, fieldWriter.fieldWriter, 2, fieldWriter.ordinal);
            }
        }
        mw.return_();
        mw.visitMaxs(mwc.maxVariant + 1, mwc.maxVariant + 1);
    }

    private int fieldCapacity(Class<?> fieldClass) {
        if (fieldClass == Boolean.TYPE || fieldClass == Boolean.class) {
            return 1;
        }
        if (fieldClass == Byte.TYPE || fieldClass == Byte.class) {
            return 2;
        }
        if (fieldClass == Short.TYPE || fieldClass == Short.class) {
            return 3;
        }
        if (fieldClass == Integer.TYPE || fieldClass == Integer.class || fieldClass == Float.TYPE || fieldClass == Float.class || fieldClass == LocalDate.class) {
            return 5;
        }
        if (fieldClass == Long.TYPE || fieldClass == Long.class || fieldClass == Double.TYPE || fieldClass == Double.class || fieldClass == LocalTime.class) {
            return 9;
        }
        if (fieldClass == LocalDateTime.class) {
            return 13;
        }
        if (fieldClass == Instant.class) {
            return 15;
        }
        if (fieldClass == UUID.class) {
            return 18;
        }
        if (fieldClass == OffsetDateTime.class || fieldClass == OffsetTime.class) {
            return 21;
        }
        throw new JSONException("assert error " + fieldClass.getName());
    }

    private void gwValueJSONB(MethodWriterContext mwc, FieldWriter fieldWriter, int OBJECT, int i) {
        long features = fieldWriter.features | mwc.objectFeatures;
        Class fieldClass = fieldWriter.fieldClass;
        boolean beanToArray = (features & JSONWriter.Feature.BeanToArray.mask) != 0L;
        boolean userDefineWriter = false;
        if ((fieldClass == Long.TYPE || fieldClass == Long.class || fieldClass == long[].class) && (mwc.provider.userDefineMask & 4L) != 0L) {
            boolean bl = userDefineWriter = mwc.provider.getObjectWriter(Long.class) != ObjectWriterImplInt64.INSTANCE;
        }
        if (fieldClass == Boolean.TYPE || fieldClass == boolean[].class || fieldClass == Character.TYPE || fieldClass == char[].class || fieldClass == Byte.TYPE || fieldClass == byte[].class || fieldClass == Short.TYPE || fieldClass == short[].class || fieldClass == Integer.TYPE || fieldClass == int[].class || fieldClass == Long.TYPE || fieldClass == long[].class && !userDefineWriter || fieldClass == Float.TYPE || fieldClass == float[].class || fieldClass == Double.TYPE || fieldClass == double[].class || fieldClass == String.class || fieldClass == Integer.class || fieldClass == Long.class || fieldClass == BigDecimal.class || fieldClass.isEnum()) {
            this.gwValue(mwc, fieldWriter, OBJECT, i, null);
        } else if (fieldClass == Date.class) {
            this.gwDate(mwc, fieldWriter, OBJECT, i);
        } else if (fieldWriter instanceof FieldWriterList) {
            this.gwListJSONB(mwc, fieldWriter, OBJECT, i);
        } else if (fieldClass.isArray()) {
            this.gwObjectA(mwc, fieldWriter, OBJECT, i);
        } else {
            this.gwObjectJSONB(fieldWriter, OBJECT, mwc, i, beanToArray);
        }
    }

    private void gwObjectJSONB(FieldWriter fieldWriter, int OBJECT, MethodWriterContext mwc, int i, boolean beanToArray) {
        boolean refDetection;
        Class fieldClass = fieldWriter.fieldClass;
        String fieldName = fieldWriter.fieldName;
        String classNameType = mwc.classNameType;
        MethodWriter mw = mwc.mw;
        int FIELD_VALUE = mwc.var(fieldClass);
        Label endIfNull_ = new Label();
        Label notNull_ = new Label();
        this.genGetObject(mwc, fieldWriter, i, OBJECT);
        mw.dup();
        mw.astore(FIELD_VALUE);
        mw.ifnonnull(notNull_);
        mw.aload(1);
        mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "writeNull", "()V");
        mw.goto_(endIfNull_);
        mw.visitLabel(notNull_);
        boolean bl = refDetection = !mwc.disableSupportArrayMapping() && !ObjectWriterProvider.isNotReferenceDetect(fieldClass);
        if (refDetection) {
            int REF_PATH = mwc.var("REF_PATH");
            Label endDetect_ = new Label();
            Label refSetPath_ = new Label();
            mwc.genIsEnabled(JSONWriter.Feature.ReferenceDetection.mask, endDetect_);
            if (fieldClass.isAssignableFrom(mwc.objectClass)) {
                mw.aload(OBJECT);
                mw.aload(FIELD_VALUE);
                mw.if_acmpne(refSetPath_);
                mw.aload(1);
                mw.visitLdcInsn("..");
                mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "writeReference", METHOD_DESC_WRITE_REFERENCE);
                mw.goto_(endIfNull_);
                mw.visitLabel(refSetPath_);
            }
            mw.aload(1);
            mw.aload(0);
            mw.getfield(classNameType, ObjectWriterCreatorASM.fieldWriter(i), ASMUtils.DESC_FIELD_WRITER);
            mw.aload(FIELD_VALUE);
            mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "setPath0", METHOD_DESC_SET_PATH2);
            mw.dup();
            mw.astore(REF_PATH);
            mw.ifnull(endDetect_);
            mw.aload(1);
            mw.aload(REF_PATH);
            mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "writeReference", METHOD_DESC_WRITE_REFERENCE);
            mw.aload(1);
            mw.aload(FIELD_VALUE);
            mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "popPath0", "(Ljava/lang/Object;)V");
            mw.goto_(endIfNull_);
            mw.visitLabel(endDetect_);
        }
        mw.aload(0);
        mw.getfield(classNameType, ObjectWriterCreatorASM.fieldWriter(i), ASMUtils.DESC_FIELD_WRITER);
        mw.aload(1);
        mw.aload(FIELD_VALUE);
        mw.invokevirtual("java/lang/Object", "getClass", "()Ljava/lang/Class;");
        mw.invokevirtual(ASMUtils.TYPE_FIELD_WRITER, "getObjectWriter", METHOD_DESC_GET_OBJECT_WRITER);
        mw.aload(1);
        mw.aload(FIELD_VALUE);
        mw.visitLdcInsn(fieldName);
        mwc.loadFieldType(i, fieldWriter.fieldType);
        mw.visitLdcInsn(fieldWriter.features);
        mw.invokeinterface(ASMUtils.TYPE_OBJECT_WRITER, beanToArray ? "writeJSONB" : "writeArrayMappingJSONB", METHOD_DESC_WRITE_OBJECT);
        if (refDetection) {
            mw.aload(1);
            mw.aload(FIELD_VALUE);
            mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "popPath0", "(Ljava/lang/Object;)V");
        }
        mw.visitLabel(endIfNull_);
    }

    private void gwListJSONB(MethodWriterContext mwc, FieldWriter fieldWriter, int OBJECT, int i) {
        ParameterizedType parameterizedType;
        Type[] actualTypeArguments;
        boolean disableReferenceDetect = mwc.disableReferenceDetect();
        Type fieldType = fieldWriter.fieldType;
        Class fieldClass = fieldWriter.fieldClass;
        String classNameType = mwc.classNameType;
        MethodWriter mw = mwc.mw;
        int LIST = mwc.var(fieldClass);
        int REF_PATH = mwc.var("REF_PATH");
        boolean listSimple = false;
        Class<?> itemClass = null;
        if (fieldType instanceof ParameterizedType && (actualTypeArguments = (parameterizedType = (ParameterizedType)fieldType).getActualTypeArguments()).length == 1) {
            Type itemType = actualTypeArguments[0];
            itemClass = TypeUtils.getClass(itemType);
            listSimple = itemType == String.class || itemType == Integer.class || itemType == Long.class;
        }
        Label endIfListNull_ = new Label();
        Label listNotNull_ = new Label();
        this.genGetObject(mwc, fieldWriter, i, OBJECT);
        mw.dup();
        mw.astore(LIST);
        mw.ifnonnull(listNotNull_);
        mw.aload(1);
        mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "writeNull", "()V");
        mw.goto_(endIfListNull_);
        mw.visitLabel(listNotNull_);
        if (!disableReferenceDetect) {
            Label endDetect_ = new Label();
            Label refSetPath_ = new Label();
            mwc.genIsEnabled(JSONWriter.Feature.ReferenceDetection.mask, endDetect_);
            if (fieldClass.isAssignableFrom(mwc.objectClass)) {
                mw.aload(OBJECT);
                mw.aload(LIST);
                mw.if_acmpne(refSetPath_);
                mw.aload(1);
                mw.visitLdcInsn("..");
                mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "writeReference", METHOD_DESC_WRITE_REFERENCE);
                mw.goto_(endIfListNull_);
                mw.visitLabel(refSetPath_);
            }
            mw.aload(0);
            mw.getfield(classNameType, ObjectWriterCreatorASM.fieldWriter(i), ASMUtils.DESC_FIELD_WRITER);
            mw.aload(LIST);
            mw.lload(mwc.var(CONTEXT_FEATURES));
            mw.invokevirtual(ASMUtils.TYPE_FIELD_WRITER, "isRefDetect", "(Ljava/lang/Object;J)Z");
            mw.ifeq(endDetect_);
            mw.aload(1);
            mw.aload(0);
            mw.getfield(classNameType, ObjectWriterCreatorASM.fieldWriter(i), ASMUtils.DESC_FIELD_WRITER);
            mw.aload(LIST);
            mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "setPath0", METHOD_DESC_SET_PATH2);
            mw.dup();
            mw.astore(REF_PATH);
            mw.ifnull(endDetect_);
            mw.aload(1);
            mw.aload(REF_PATH);
            mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "writeReference", METHOD_DESC_WRITE_REFERENCE);
            mw.aload(1);
            mw.aload(LIST);
            mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "popPath0", "(Ljava/lang/Object;)V");
            mw.goto_(endIfListNull_);
            mw.visitLabel(endDetect_);
        }
        if (listSimple) {
            ObjectWriterCreatorASM.gwListSimpleType(mwc, i, mw, fieldClass, itemClass, LIST);
        } else {
            int PREVIOUS_CLASS = mwc.var("ITEM_CLASS");
            int ITEM_OBJECT_WRITER = mwc.var("ITEM_OBJECT_WRITER");
            mw.aconst_null();
            mw.dup();
            mw.astore(PREVIOUS_CLASS);
            mw.astore(ITEM_OBJECT_WRITER);
            mw.aload(0);
            mw.getfield(classNameType, ObjectWriterCreatorASM.fieldWriter(i), ASMUtils.DESC_FIELD_WRITER);
            mw.aload(1);
            mw.aload(LIST);
            mw.invokevirtual(ASMUtils.TYPE_FIELD_WRITER, "writeListValueJSONB", METHOD_DESC_WRITE_LIST);
        }
        if (!disableReferenceDetect) {
            mw.aload(1);
            mw.aload(LIST);
            mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "popPath0", "(Ljava/lang/Object;)V");
        }
        mw.visitLabel(endIfListNull_);
    }

    private void gwDate(MethodWriterContext mwc, FieldWriter fieldWriter, int OBJECT, int i) {
        MethodWriter mw = mwc.mw;
        mw.aload(0);
        mw.getfield(mwc.classNameType, ObjectWriterCreatorASM.fieldWriter(i), ASMUtils.DESC_FIELD_WRITER);
        mw.aload(1);
        mw.iconst_0();
        this.genGetObject(mwc, fieldWriter, i, OBJECT);
        mw.invokevirtual(ASMUtils.TYPE_FIELD_WRITER, "writeDate", METHOD_DESC_WRITE_DATE_WITH_FIELD_NAME);
    }

    private void gwValue(MethodWriterContext mwc, FieldWriter fieldWriter, int OBJECT, int i, Integer LOCAL_FIELD_VALUE) {
        String methodDesc;
        String methodName;
        boolean writeAsString;
        MethodWriter mw = mwc.mw;
        Class fieldClass = fieldWriter.fieldClass;
        if (fieldClass == String.class) {
            this.genGetObject(mwc, fieldWriter, i, OBJECT);
            mw.checkcast("java/lang/String");
            int FIELD_VALUE = mwc.var("FIELD_VALUE_" + fieldWriter.fieldClass.getName());
            mw.astore(FIELD_VALUE);
            ObjectWriterCreatorASM.gwString(mwc, false, true, FIELD_VALUE);
            return;
        }
        mw.aload(1);
        if (LOCAL_FIELD_VALUE != null) {
            mw.loadLocal(fieldClass, LOCAL_FIELD_VALUE);
        } else {
            this.genGetObject(mwc, fieldWriter, i, OBJECT);
        }
        if (fieldWriter.decimalFormat != null) {
            if (fieldClass == Double.TYPE) {
                mw.aload(0);
                mw.getfield(mwc.classNameType, ObjectWriterCreatorASM.fieldWriter(i), ASMUtils.DESC_FIELD_WRITER);
                mw.getfield(ASMUtils.TYPE_FIELD_WRITER, "decimalFormat", "Ljava/text/DecimalFormat;");
                mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "writeDouble", "(DLjava/text/DecimalFormat;)V");
            } else if (fieldClass == Float.TYPE) {
                mw.aload(0);
                mw.getfield(mwc.classNameType, ObjectWriterCreatorASM.fieldWriter(i), ASMUtils.DESC_FIELD_WRITER);
                mw.getfield(ASMUtils.TYPE_FIELD_WRITER, "decimalFormat", "Ljava/text/DecimalFormat;");
                mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "writeFloat", "(FLjava/text/DecimalFormat;)V");
            } else if (fieldClass == BigDecimal.class) {
                mw.visitLdcInsn(fieldWriter.features);
                mw.aload(0);
                mw.getfield(mwc.classNameType, ObjectWriterCreatorASM.fieldWriter(i), ASMUtils.DESC_FIELD_WRITER);
                mw.getfield(ASMUtils.TYPE_FIELD_WRITER, "decimalFormat", "Ljava/text/DecimalFormat;");
                mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "writeDecimal", "(Ljava/math/BigDecimal;JLjava/text/DecimalFormat;)V");
            } else {
                throw new UnsupportedOperationException();
            }
            return;
        }
        boolean bl = writeAsString = (fieldWriter.features & JSONWriter.Feature.WriteNonStringValueAsString.mask) != 0L;
        if (fieldClass == Integer.TYPE && !writeAsString) {
            String format = fieldWriter.format;
            if ("string".equals(format)) {
                mw.invokestatic("java/lang/Integer", "toString", "(I)Ljava/lang/String;");
                mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "writeString", METHOD_DESC_WRITE_REFERENCE);
            } else if (format != null) {
                mw.visitLdcInsn(format);
                mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "writeInt32", "(ILjava/lang/String;)V");
            } else {
                mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "writeInt32", "(I)V");
            }
            return;
        }
        if (fieldClass == Boolean.TYPE) {
            methodName = "writeBool";
            methodDesc = "(Z)V";
        } else if (fieldClass == Character.TYPE) {
            methodName = "writeChar";
            methodDesc = "(C)V";
        } else if (fieldClass == Byte.TYPE) {
            methodName = writeAsString ? "writeString" : "writeInt8";
            methodDesc = "(B)V";
        } else if (fieldClass == Short.TYPE) {
            methodName = writeAsString ? "writeString" : "writeInt16";
            methodDesc = "(S)V";
        } else if (fieldClass == Integer.TYPE) {
            methodName = writeAsString ? "writeString" : "writeInt32";
            methodDesc = "(I)V";
        } else if (fieldClass == Integer.class) {
            methodName = "writeInt32";
            methodDesc = "(Ljava/lang/Integer;)V";
        } else if (fieldClass == Long.TYPE) {
            methodName = writeAsString ? "writeString" : "writeInt64";
            methodDesc = "(J)V";
        } else if (fieldClass == Long.class) {
            methodName = "writeInt64";
            methodDesc = "(Ljava/lang/Long;)V";
        } else if (fieldClass == Float.TYPE) {
            methodName = writeAsString ? "writeString" : "writeFloat";
            methodDesc = "(F)V";
        } else if (fieldClass == Double.TYPE) {
            methodName = writeAsString ? "writeString" : "writeDouble";
            methodDesc = "(D)V";
        } else if (fieldClass == boolean[].class) {
            methodName = "writeBool";
            methodDesc = "([Z)V";
        } else if (fieldClass == char[].class) {
            methodName = "writeString";
            methodDesc = "([C)V";
        } else if (fieldClass == byte[].class) {
            methodName = "writeBinary";
            methodDesc = "([B)V";
        } else if (fieldClass == short[].class) {
            methodName = "writeInt16";
            methodDesc = "([S)V";
        } else if (fieldClass == int[].class) {
            methodName = "writeInt32";
            methodDesc = "([I)V";
        } else if (fieldClass == long[].class && mwc.provider.getObjectWriter(Long.class) == ObjectWriterImplInt64.INSTANCE) {
            methodName = "writeInt64";
            methodDesc = "([J)V";
        } else if (fieldClass == float[].class) {
            methodName = "writeFloat";
            methodDesc = "([F)V";
        } else if (fieldClass == double[].class) {
            methodName = "writeDouble";
            methodDesc = "([D)V";
        } else if (fieldClass == BigDecimal.class) {
            methodName = "writeDecimal";
            methodDesc = "(Ljava/math/BigDecimal;JLjava/text/DecimalFormat;)V";
            mw.visitLdcInsn(fieldWriter.features);
            mw.aconst_null();
        } else if (Enum.class.isAssignableFrom(fieldClass)) {
            methodName = "writeEnum";
            methodDesc = "(Ljava/lang/Enum;)V";
        } else {
            throw new UnsupportedOperationException();
        }
        mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, methodName, methodDesc);
    }

    private void gwObjectA(MethodWriterContext mwc, FieldWriter fieldWriter, int OBJECT, int i) {
        MethodWriter mw = mwc.mw;
        if (fieldWriter.fieldClass == String[].class) {
            mw.aload(1);
            this.genGetObject(mwc, fieldWriter, i, OBJECT);
            mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "writeString", "([Ljava/lang/String;)V");
        } else {
            mw.aload(0);
            mw.getfield(mwc.classNameType, ObjectWriterCreatorASM.fieldWriter(i), ASMUtils.DESC_FIELD_WRITER);
            mw.aload(1);
            mw.aload(OBJECT);
            mw.invokevirtual(ASMUtils.TYPE_FIELD_WRITER, "writeValue", METHOD_DESC_WRITE_VALUE);
        }
    }

    private void genMethodWriteArrayMapping(ObjectWriterProvider provider, String methodName, Class objectType, long objectFeatures, List<FieldWriter> fieldWriters, ClassWriter cw, String classNameType) {
        MethodWriter mw = cw.visitMethod(1, methodName, METHOD_DESC_WRITE, 512);
        int OBJECT = 2;
        int FIELD_NAME = 3;
        int FIELD_TYPE = 4;
        int FIELD_FEATURES = 5;
        Label jsonb_ = new Label();
        mw.aload(1);
        mw.getfield(ASMUtils.TYPE_JSON_WRITER, "jsonb", "Z");
        mw.ifeq(jsonb_);
        mw.aload(0);
        mw.aload(1);
        mw.aload(2);
        mw.aload(3);
        mw.aload(4);
        mw.lload(5);
        mw.invokevirtual(classNameType, "writeArrayMappingJSONB", METHOD_DESC_WRITE_OBJECT);
        mw.return_();
        mw.visitLabel(jsonb_);
        Label object_ = new Label();
        ObjectWriterCreatorASM.hashFilter(mw, fieldWriters, object_);
        mw.aload(0);
        mw.aload(1);
        mw.aload(2);
        mw.aload(3);
        mw.aload(4);
        mw.lload(5);
        mw.invokespecial(ASMUtils.TYPE_OBJECT_WRITER_ADAPTER, methodName, METHOD_DESC_WRITE);
        mw.return_();
        mw.visitLabel(object_);
        mw.aload(1);
        mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "startArray", "()V");
        MethodWriterContext mwc = new MethodWriterContext(provider, objectType, objectFeatures, classNameType, mw, 7, false);
        for (int i = 0; i < fieldWriters.size(); ++i) {
            if (i != 0) {
                mw.aload(1);
                mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "writeComma", "()V");
            }
            this.gwFieldValueArrayMapping(fieldWriters.get(i), mwc, 2, i);
        }
        mw.aload(1);
        mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "endArray", "()V");
        mw.return_();
        mw.visitMaxs(mwc.maxVariant + 1, mwc.maxVariant + 1);
    }

    private static void hashFilter(MethodWriter mw, List<FieldWriter> fieldWriters, Label object_) {
        boolean containsNoneFieldGetter = false;
        for (FieldWriter fieldWriter : fieldWriters) {
            if (fieldWriter.method == null || (fieldWriter.features & 0x10000000000000L) != 0L) continue;
            containsNoneFieldGetter = true;
            break;
        }
        mw.aload(0);
        mw.aload(1);
        mw.invokevirtual(ASMUtils.TYPE_OBJECT_WRITER_ADAPTER, containsNoneFieldGetter ? "hasFilter" : "hasFilter0", METHOD_DESC_HAS_FILTER);
        mw.ifeq(object_);
    }

    private void gwFieldValueArrayMapping(FieldWriter fieldWriter, MethodWriterContext mwc, int OBJECT, int i) {
        Class objectType = mwc.objectClass;
        Class fieldClass = fieldWriter.fieldClass;
        String TYPE_OBJECT = objectType == null ? "java/lang/Object" : ASMUtils.type(objectType);
        boolean userDefineWriter = false;
        if ((fieldClass == Long.TYPE || fieldClass == Long.class || fieldClass == long[].class) && (mwc.provider.userDefineMask & 4L) != 0L) {
            boolean bl = userDefineWriter = mwc.provider.getObjectWriter(Long.class) != ObjectWriterImplInt64.INSTANCE;
        }
        if (fieldClass == Boolean.TYPE || fieldClass == boolean[].class || fieldClass == Character.TYPE || fieldClass == char[].class || fieldClass == Byte.TYPE || fieldClass == byte[].class || fieldClass == Short.TYPE || fieldClass == short[].class || fieldClass == Integer.TYPE || fieldClass == int[].class || fieldClass == Long.TYPE || fieldClass == long[].class && !userDefineWriter || fieldClass == Float.TYPE || fieldClass == float[].class || fieldClass == Double.TYPE || fieldClass == double[].class || fieldClass == String.class || fieldClass == Integer.class || fieldClass == Long.class || fieldClass == BigDecimal.class || fieldClass.isEnum()) {
            this.gwValue(mwc, fieldWriter, OBJECT, i, null);
        } else if (fieldClass == Date.class) {
            this.gwDate(mwc, fieldWriter, OBJECT, i);
        } else if (fieldWriter instanceof FieldWriterList) {
            this.gwList(mwc, OBJECT, i, fieldWriter);
        } else {
            this.gwObject(mwc, OBJECT, i, fieldWriter, TYPE_OBJECT);
        }
    }

    private void gwObject(MethodWriterContext mwc, int OBJECT, int i, FieldWriter fieldWriter, String TYPE_OBJECT) {
        Class fieldClass = fieldWriter.fieldClass;
        String fieldName = fieldWriter.fieldName;
        MethodWriter mw = mwc.mw;
        int FIELD_VALUE = mwc.var(fieldClass);
        int REF_PATH = mwc.var("REF_PATH");
        Label endIfNull_ = new Label();
        Label notNull_ = new Label();
        this.genGetObject(mwc, fieldWriter, i, OBJECT);
        mw.dup();
        mw.astore(FIELD_VALUE);
        mw.ifnonnull(notNull_);
        mw.aload(1);
        mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "writeNull", "()V");
        mw.goto_(endIfNull_);
        mw.visitLabel(notNull_);
        if (fieldClass == Double.class || fieldClass == Float.class || fieldClass == BigDecimal.class) {
            mw.aload(1);
            if (fieldWriter.decimalFormat != null) {
                mw.aload(FIELD_VALUE);
                if (fieldClass == Double.class) {
                    mw.invokevirtual("java/lang/Double", "doubleValue", "()D");
                    mw.aload(0);
                    mw.getfield(mwc.classNameType, ObjectWriterCreatorASM.fieldWriter(i), ASMUtils.DESC_FIELD_WRITER);
                    mw.getfield(ASMUtils.TYPE_FIELD_WRITER, "decimalFormat", "Ljava/text/DecimalFormat;");
                    mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "writeDouble", "(DLjava/text/DecimalFormat;)V");
                } else if (fieldClass == Float.class) {
                    mw.invokevirtual("java/lang/Float", "floatValue", "()F");
                    mw.aload(0);
                    mw.getfield(mwc.classNameType, ObjectWriterCreatorASM.fieldWriter(i), ASMUtils.DESC_FIELD_WRITER);
                    mw.getfield(ASMUtils.TYPE_FIELD_WRITER, "decimalFormat", "Ljava/text/DecimalFormat;");
                    mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "writeFloat", "(FLjava/text/DecimalFormat;)V");
                } else {
                    long features = fieldWriter.features;
                    mw.visitLdcInsn(features);
                    mw.aload(0);
                    mw.getfield(mwc.classNameType, ObjectWriterCreatorASM.fieldWriter(i), ASMUtils.DESC_FIELD_WRITER);
                    mw.getfield(ASMUtils.TYPE_FIELD_WRITER, "decimalFormat", "Ljava/text/DecimalFormat;");
                    mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "writeDecimal", "(Ljava/math/BigDecimal;JLjava/text/DecimalFormat;)V");
                }
            } else {
                mw.aload(FIELD_VALUE);
                if (fieldClass == Double.class) {
                    mw.invokevirtual("java/lang/Double", "doubleValue", "()D");
                    mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "writeDouble", "(D)V");
                } else if (fieldClass == Float.class) {
                    mw.invokevirtual("java/lang/Float", "floatValue", "()F");
                    mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "writeFloat", "(F)V");
                } else {
                    long features = fieldWriter.features;
                    mw.visitLdcInsn(features);
                    mw.aconst_null();
                    mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "writeDecimal", "(Ljava/math/BigDecimal;JLjava/text/DecimalFormat;)V");
                }
            }
        } else {
            boolean refDetection;
            boolean bl = refDetection = !ObjectWriterProvider.isNotReferenceDetect(fieldClass);
            if (refDetection) {
                Label endDetect_ = new Label();
                Label refSetPath_ = new Label();
                mw.aload(1);
                mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "isRefDetect", "()Z");
                mw.ifeq(endDetect_);
                if (fieldClass.isAssignableFrom(mwc.objectClass)) {
                    mw.aload(OBJECT);
                    mw.aload(FIELD_VALUE);
                    mw.if_acmpne(refSetPath_);
                    mw.aload(1);
                    mw.visitLdcInsn("..");
                    mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "writeReference", METHOD_DESC_WRITE_REFERENCE);
                    mw.goto_(endIfNull_);
                    mw.visitLabel(refSetPath_);
                }
                mw.aload(1);
                mw.aload(0);
                mw.getfield(mwc.classNameType, ObjectWriterCreatorASM.fieldWriter(i), ASMUtils.DESC_FIELD_WRITER);
                mw.aload(FIELD_VALUE);
                mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "setPath0", METHOD_DESC_SET_PATH2);
                mw.dup();
                mw.astore(REF_PATH);
                mw.ifnull(endDetect_);
                mw.aload(1);
                mw.aload(REF_PATH);
                mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "writeReference", METHOD_DESC_WRITE_REFERENCE);
                mw.aload(1);
                mw.aload(FIELD_VALUE);
                mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "popPath0", "(Ljava/lang/Object;)V");
                mw.goto_(endIfNull_);
                mw.visitLabel(endDetect_);
            }
            if (fieldClass == String[].class) {
                mw.aload(1);
                mw.aload(FIELD_VALUE);
                mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "writeString", "([Ljava/lang/String;)V");
            } else {
                mw.aload(0);
                mw.getfield(mwc.classNameType, ObjectWriterCreatorASM.fieldWriter(i), ASMUtils.DESC_FIELD_WRITER);
                mw.aload(1);
                mw.aload(FIELD_VALUE);
                mw.invokevirtual("java/lang/Object", "getClass", "()Ljava/lang/Class;");
                mw.invokevirtual(ASMUtils.TYPE_FIELD_WRITER, "getObjectWriter", METHOD_DESC_GET_OBJECT_WRITER);
                mw.aload(1);
                mw.aload(FIELD_VALUE);
                mw.visitLdcInsn(fieldWriter.fieldName);
                mwc.loadFieldType(i, fieldWriter.fieldType);
                mw.visitLdcInsn(fieldWriter.features);
                mw.invokeinterface(ASMUtils.TYPE_OBJECT_WRITER, "write", METHOD_DESC_WRITE_OBJECT);
            }
            if (refDetection) {
                mw.aload(1);
                mw.aload(FIELD_VALUE);
                mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "popPath0", "(Ljava/lang/Object;)V");
            }
        }
        mw.visitLabel(endIfNull_);
    }

    private void gwList(MethodWriterContext mwc, int OBJECT, int i, FieldWriter fieldWriter) {
        ParameterizedType parameterizedType;
        Type[] actualTypeArguments;
        Type fieldType = fieldWriter.fieldType;
        Class fieldClass = fieldWriter.fieldClass;
        int LIST = mwc.var(fieldClass);
        MethodWriter mw = mwc.mw;
        boolean listSimple = false;
        Class<?> itemClass = null;
        if (fieldType instanceof ParameterizedType && (actualTypeArguments = (parameterizedType = (ParameterizedType)fieldType).getActualTypeArguments()).length == 1) {
            Type itemType = actualTypeArguments[0];
            itemClass = TypeUtils.getMapping(itemType);
            listSimple = itemType == String.class || itemType == Integer.class || itemType == Long.class;
        }
        Label L_END_IF_LIST_NULL = new Label();
        Label L_LIST_NOT_NULL = new Label();
        this.genGetObject(mwc, fieldWriter, i, OBJECT);
        mw.dup();
        mw.astore(LIST);
        mw.ifnonnull(L_LIST_NOT_NULL);
        mw.aload(1);
        mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "writeNull", "()V");
        mw.goto_(L_END_IF_LIST_NULL);
        mw.visitLabel(L_LIST_NOT_NULL);
        if (listSimple) {
            this.genGetObject(mwc, fieldWriter, i, OBJECT);
            mw.astore(LIST);
            ObjectWriterCreatorASM.gwListSimpleType(mwc, i, mw, fieldClass, itemClass, LIST);
        } else {
            int LIST_SIZE = mwc.var("LIST_SIZE");
            int J = mwc.var("J");
            int ITEM_CLASS = mwc.var(Class.class);
            int PREVIOUS_CLASS = mwc.var("PREVIOUS_CLASS");
            int ITEM_OBJECT_WRITER = mwc.var("ITEM_OBJECT_WRITER");
            mw.aconst_null();
            mw.dup();
            mw.astore(PREVIOUS_CLASS);
            mw.astore(ITEM_OBJECT_WRITER);
            mw.aload(LIST);
            mw.invokeinterface("java/util/List", "size", "()I");
            mw.istore(LIST_SIZE);
            mw.aload(1);
            mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "startArray", "()V");
            Label for_start_j_ = new Label();
            Label for_end_j_ = new Label();
            Label for_inc_j_ = new Label();
            Label notFirst_ = new Label();
            mw.iconst_0();
            mw.istore(J);
            mw.visitLabel(for_start_j_);
            mw.iload(J);
            mw.iload(LIST_SIZE);
            mw.if_icmpge(for_end_j_);
            mw.iload(J);
            mw.ifeq(notFirst_);
            mw.aload(1);
            mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "writeComma", "()V");
            mw.visitLabel(notFirst_);
            int ITEM = mwc.var(itemClass);
            Label L_NOT_NULL = new Label();
            Label L_CLASS_EQ = new Label();
            mw.aload(LIST);
            mw.iload(J);
            mw.invokeinterface("java/util/List", "get", "(I)Ljava/lang/Object;");
            mw.dup();
            mw.astore(ITEM);
            mw.ifnonnull(L_NOT_NULL);
            mw.aload(1);
            mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "writeNull", "()V");
            mw.goto_(for_inc_j_);
            mw.visitLabel(L_NOT_NULL);
            mw.aload(ITEM);
            mw.invokevirtual("java/lang/Object", "getClass", "()Ljava/lang/Class;");
            mw.dup();
            mw.astore(ITEM_CLASS);
            mw.aload(PREVIOUS_CLASS);
            mw.if_acmpeq(L_CLASS_EQ);
            mw.aload(0);
            mw.getfield(mwc.classNameType, ObjectWriterCreatorASM.fieldWriter(i), ASMUtils.DESC_FIELD_WRITER);
            mw.aload(1);
            mw.aload(ITEM_CLASS);
            mw.invokevirtual(ASMUtils.TYPE_FIELD_WRITER, "getItemWriter", METHOD_DESC_GET_ITEM_WRITER);
            mw.astore(ITEM_OBJECT_WRITER);
            mw.aload(ITEM_CLASS);
            mw.astore(PREVIOUS_CLASS);
            mw.visitLabel(L_CLASS_EQ);
            mw.aload(ITEM_OBJECT_WRITER);
            mw.aload(1);
            mw.aload(ITEM);
            mw.iload(J);
            mw.invokestatic("java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;");
            mwc.loadFieldType(i, fieldType);
            mw.visitLdcInsn(fieldWriter.features);
            mw.invokeinterface(ASMUtils.TYPE_OBJECT_WRITER, "write", METHOD_DESC_WRITE_OBJECT);
            mw.visitLabel(for_inc_j_);
            mw.visitIincInsn(J, 1);
            mw.goto_(for_start_j_);
            mw.visitLabel(for_end_j_);
            mw.aload(1);
            mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "endArray", "()V");
        }
        mw.visitLabel(L_END_IF_LIST_NULL);
    }

    private void gwFieldValue(MethodWriterContext mwc, FieldWriter fieldWriter, int OBJECT, int i) {
        Class fieldClass = fieldWriter.fieldClass;
        if (fieldClass == Boolean.TYPE) {
            this.gwFieldValueBooleanV(mwc, fieldWriter, OBJECT, i, false);
        } else if (fieldClass == boolean[].class || fieldClass == byte[].class || fieldClass == char[].class || fieldClass == short[].class || fieldClass == float[].class || fieldClass == double[].class) {
            this.gwFieldValueArray(mwc, fieldWriter, OBJECT, i);
        } else if (fieldClass == Character.TYPE || fieldClass == Byte.TYPE || fieldClass == Integer.TYPE || fieldClass == Short.TYPE || fieldClass == Float.TYPE) {
            this.gwFieldValueInt32V(mwc, fieldWriter, OBJECT, i, false);
        } else if (fieldClass == int[].class) {
            this.gwFieldValueIntVA(mwc, fieldWriter, OBJECT, i, false);
        } else if (fieldClass == Long.TYPE || fieldClass == Double.TYPE) {
            this.gwFieldValueInt64V(mwc, fieldWriter, OBJECT, i, true);
        } else if (fieldClass == long[].class && mwc.provider.getObjectWriter(Long.class) == ObjectWriterImplInt64.INSTANCE) {
            this.gwFieldValueInt64VA(mwc, fieldWriter, OBJECT, i, false);
        } else if (fieldClass == Integer.class) {
            this.gwInt32(mwc, fieldWriter, OBJECT, i);
        } else if (fieldClass == Long.class) {
            this.gwInt64(mwc, fieldWriter, OBJECT, i);
        } else if (fieldClass == Float.class) {
            this.gwFloat(mwc, fieldWriter, OBJECT, i);
        } else if (fieldClass == Double.class) {
            this.gwDouble(mwc, fieldWriter, OBJECT, i);
        } else if (fieldClass == String.class) {
            this.gwFieldValueString(mwc, fieldWriter, OBJECT, i);
        } else if (fieldClass.isEnum() && BeanUtils.getEnumValueField(fieldClass, mwc.provider) == null && !(fieldWriter instanceof FieldWriterObject)) {
            this.gwFieldValueEnum(mwc, fieldWriter, OBJECT, i);
        } else if (fieldClass == Date.class) {
            this.gwFieldValueDate(mwc, fieldWriter, OBJECT, i);
        } else if (fieldClass == List.class) {
            this.gwFieldValueList(mwc, fieldWriter, OBJECT, i);
        } else {
            this.gwFieldValueObject(mwc, fieldWriter, OBJECT, i, false);
        }
    }

    private void gwFieldValueEnum(MethodWriterContext mwc, FieldWriter fieldWriter, int OBJECT, int i) {
        Class fieldClass = fieldWriter.fieldClass;
        MethodWriter mw = mwc.mw;
        int FIELD_VALUE = mwc.var(fieldClass);
        this.genGetObject(mwc, fieldWriter, i, OBJECT);
        mw.dup();
        mw.astore(FIELD_VALUE);
        Label null_ = new Label();
        Label notNull_ = new Label();
        mw.ifnull(null_);
        mw.aload(0);
        mw.getfield(mwc.classNameType, ObjectWriterCreatorASM.fieldWriter(i), ASMUtils.DESC_FIELD_WRITER);
        mw.aload(1);
        mw.aload(FIELD_VALUE);
        mw.invokevirtual(ASMUtils.TYPE_FIELD_WRITER, "writeEnum", METHOD_DESC_WRITE_ENUM);
        mw.goto_(notNull_);
        mw.visitLabel(null_);
        mw.iload(mwc.var(WRITE_NULLS));
        mw.ifeq(notNull_);
        this.gwFieldName(mwc, fieldWriter, i);
        mw.aload(1);
        mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "writeNull", "()V");
        mw.visitLabel(notNull_);
    }

    private void gwFieldValueObject(MethodWriterContext mwc, FieldWriter fieldWriter, int OBJECT, int i, boolean jsonb) {
        String WRITE_NULL_METHOD;
        Label notWriteEmptyArrayEnd_;
        Class fieldClass = fieldWriter.fieldClass;
        Type fieldType = fieldWriter.fieldType;
        String fieldName = fieldWriter.fieldName;
        boolean disableReferenceDetect = mwc.disableReferenceDetect();
        boolean refDetection = !disableReferenceDetect && !ObjectWriterProvider.isNotReferenceDetect(fieldClass);
        int FIELD_VALUE = mwc.var(fieldClass);
        Integer REF_PATH = null;
        if (refDetection) {
            REF_PATH = mwc.var("REF_PATH");
        }
        long features = fieldWriter.features | mwc.objectFeatures;
        MethodWriter mw = mwc.mw;
        Label null_ = new Label();
        Label notNull_ = new Label();
        if (fieldWriter.unwrapped() || (fieldWriter.features & JSONWriter.Feature.WriteNonStringValueAsString.mask) != 0L) {
            mw.aload(0);
            mw.getfield(mwc.classNameType, ObjectWriterCreatorASM.fieldWriter(i), ASMUtils.DESC_FIELD_WRITER);
            mw.aload(1);
            mw.aload(OBJECT);
            mw.invokevirtual(ASMUtils.TYPE_FIELD_WRITER, "write", METHOD_DESC_FIELD_WRITE_OBJECT);
            mw.pop();
            mw.goto_(notNull_);
        }
        if (fieldWriter.backReference) {
            mw.aload(1);
            mw.aload(OBJECT);
            mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "containsReference", "(Ljava/lang/Object;)Z");
            mw.ifne(notNull_);
        }
        this.genGetObject(mwc, fieldWriter, i, OBJECT);
        mw.dup();
        mw.astore(FIELD_VALUE);
        mw.ifnull(null_);
        if (Map.class.isAssignableFrom(fieldClass)) {
            Label ignoreEmptyEnd_ = null;
            if ((fieldWriter.features & JSONWriter.Feature.IgnoreEmpty.mask) == 0L) {
                ignoreEmptyEnd_ = new Label();
                mwc.genIsEnabled(JSONWriter.Feature.IgnoreEmpty.mask, ignoreEmptyEnd_);
            }
            mw.aload(FIELD_VALUE);
            mw.invokeinterface("java/util/Map", "isEmpty", "()Z");
            mw.ifne(notNull_);
            if (ignoreEmptyEnd_ != null) {
                mw.visitLabel(ignoreEmptyEnd_);
            }
        }
        if (!Serializable.class.isAssignableFrom(fieldClass) && fieldClass != List.class) {
            mw.aload(1);
            if (!fieldWriter.isFieldClassSerializable()) {
                mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "isIgnoreNoneSerializable", "()Z");
            } else {
                mw.aload(FIELD_VALUE);
                mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "isIgnoreNoneSerializable", "(Ljava/lang/Object;)Z");
            }
            mw.ifne(notNull_);
        }
        if (refDetection) {
            Label endDetect_ = new Label();
            Label refSetPath_ = new Label();
            int REF_DETECT = mwc.var("REF_DETECT");
            if (fieldClass == Object.class) {
                mw.aload(1);
                mw.aload(FIELD_VALUE);
                mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "isRefDetect", "(Ljava/lang/Object;)Z");
            } else {
                mwc.genIsEnabled(JSONWriter.Feature.ReferenceDetection.mask, null);
            }
            mw.dup();
            mw.istore(REF_DETECT);
            mw.ifeq(endDetect_);
            if (fieldClass.isAssignableFrom(mwc.objectClass)) {
                mw.aload(OBJECT);
                mw.aload(FIELD_VALUE);
                mw.if_acmpne(refSetPath_);
                this.gwFieldName(mwc, fieldWriter, i);
                mw.aload(1);
                mw.visitLdcInsn("..");
                mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "writeReference", METHOD_DESC_WRITE_REFERENCE);
                mw.goto_(notNull_);
                mw.visitLabel(refSetPath_);
            }
            mw.aload(1);
            mw.aload(0);
            mw.getfield(mwc.classNameType, ObjectWriterCreatorASM.fieldWriter(i), ASMUtils.DESC_FIELD_WRITER);
            mw.aload(FIELD_VALUE);
            mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "setPath0", METHOD_DESC_SET_PATH2);
            mw.dup();
            mw.astore(REF_PATH);
            mw.ifnull(endDetect_);
            this.gwFieldName(mwc, fieldWriter, i);
            mw.aload(1);
            mw.aload(REF_PATH);
            mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "writeReference", METHOD_DESC_WRITE_REFERENCE);
            mw.aload(1);
            mw.aload(FIELD_VALUE);
            mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "popPath0", "(Ljava/lang/Object;)V");
            mw.goto_(null_);
            mw.visitLabel(endDetect_);
            if ("this$0".equals(fieldName) || "this$1".equals(fieldName) || "this$2".equals(fieldName)) {
                mw.iload(REF_DETECT);
                mw.ifeq(null_);
            }
        }
        if (Object[].class.isAssignableFrom(fieldClass)) {
            notWriteEmptyArrayEnd_ = new Label();
            mwc.genIsEnabled(JSONWriter.Feature.NotWriteEmptyArray.mask, notWriteEmptyArrayEnd_);
            mw.aload(FIELD_VALUE);
            mw.checkcast("[Ljava/lang/Object;");
            mw.arraylength();
            mw.ifne(notWriteEmptyArrayEnd_);
            mw.goto_(notNull_);
            mw.visitLabel(notWriteEmptyArrayEnd_);
        } else if (Collection.class.isAssignableFrom(fieldClass)) {
            notWriteEmptyArrayEnd_ = new Label();
            if ((features & JSONWriter.Feature.NotWriteEmptyArray.mask) == 0L) {
                mwc.genIsEnabled(JSONWriter.Feature.NotWriteEmptyArray.mask, notWriteEmptyArrayEnd_);
            }
            mw.aload(FIELD_VALUE);
            mw.checkcast("java/util/Collection");
            mw.invokeinterface("java/util/Collection", "isEmpty", "()Z");
            mw.ifeq(notWriteEmptyArrayEnd_);
            mw.goto_(notNull_);
            mw.visitLabel(notWriteEmptyArrayEnd_);
        }
        this.gwFieldName(mwc, fieldWriter, i);
        Class itemClass = fieldWriter.getItemClass();
        if (fieldClass == BigDecimal.class) {
            mw.aload(1);
            mw.aload(FIELD_VALUE);
            mw.visitLdcInsn(features);
            if (fieldWriter.decimalFormat != null) {
                mw.aload(0);
                mw.getfield(mwc.classNameType, ObjectWriterCreatorASM.fieldWriter(i), ASMUtils.DESC_FIELD_WRITER);
                mw.getfield(ASMUtils.TYPE_FIELD_WRITER, "decimalFormat", "Ljava/text/DecimalFormat;");
            } else {
                mw.aconst_null();
            }
            mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "writeDecimal", "(Ljava/math/BigDecimal;JLjava/text/DecimalFormat;)V");
        } else if (fieldClass == BigInteger.class) {
            mw.aload(1);
            mw.aload(FIELD_VALUE);
            if (features == 0L) {
                mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "writeBigInt", "(Ljava/math/BigInteger;)V");
            } else {
                mw.visitLdcInsn(features);
                mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "writeBigInt", "(Ljava/math/BigInteger;J)V");
            }
        } else if (fieldClass == UUID.class) {
            mw.aload(1);
            mw.aload(FIELD_VALUE);
            mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "writeUUID", "(Ljava/util/UUID;)V");
        } else if (fieldClass == LocalDate.class && fieldWriter.format == null && mwc.provider.getObjectWriter(LocalDate.class) == ObjectWriterImplLocalDate.INSTANCE) {
            mw.aload(1);
            mw.aload(FIELD_VALUE);
            mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "writeLocalDate", "(Ljava/time/LocalDate;)V");
        } else if (fieldClass == OffsetDateTime.class && fieldWriter.format == null && mwc.provider.getObjectWriter(OffsetDateTime.class) == ObjectWriterImplOffsetDateTime.INSTANCE) {
            mw.aload(1);
            mw.aload(FIELD_VALUE);
            mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "writeOffsetDateTime", "(Ljava/time/OffsetDateTime;)V");
        } else if (fieldClass == String[].class) {
            mw.aload(1);
            mw.aload(FIELD_VALUE);
            mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "writeString", "([Ljava/lang/String;)V");
        } else if (fieldClass == List.class && (itemClass == String.class || itemClass == Integer.class || itemClass == Long.class)) {
            ObjectWriterCreatorASM.gwListSimpleType(mwc, i, mw, fieldClass, itemClass, FIELD_VALUE);
        } else {
            mw.aload(0);
            mw.getfield(mwc.classNameType, ObjectWriterCreatorASM.fieldWriter(i), ASMUtils.DESC_FIELD_WRITER);
            mw.aload(1);
            mw.aload(FIELD_VALUE);
            mw.invokevirtual("java/lang/Object", "getClass", "()Ljava/lang/Class;");
            mw.invokevirtual(ASMUtils.TYPE_FIELD_WRITER, "getObjectWriter", METHOD_DESC_GET_OBJECT_WRITER);
            mw.aload(1);
            mw.aload(FIELD_VALUE);
            mw.visitLdcInsn(fieldName);
            mwc.loadFieldType(i, fieldType);
            mw.visitLdcInsn(features);
            String writeMethod = jsonb ? ((features & JSONWriter.Feature.BeanToArray.mask) != 0L ? "writeArrayMappingJSONB" : "writeJSONB") : ((features & JSONWriter.Feature.BeanToArray.mask) != 0L ? "writeArrayMapping" : "write");
            mw.invokeinterface(ASMUtils.TYPE_OBJECT_WRITER, writeMethod, METHOD_DESC_WRITE_OBJECT);
        }
        if (refDetection) {
            int REF_DETECT = mwc.var("REF_DETECT");
            Label endDetect_ = new Label();
            mw.iload(REF_DETECT);
            mw.ifeq(endDetect_);
            mw.aload(1);
            mw.aload(FIELD_VALUE);
            mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "popPath0", "(Ljava/lang/Object;)V");
            mw.visitLabel(endDetect_);
        }
        mw.goto_(notNull_);
        mw.visitLabel(null_);
        if ((features & JSONWriter.Feature.WriteNulls.mask) == 0L) {
            long nullFeatures = JSONWriter.Feature.WriteNulls.mask;
            if (fieldClass == AtomicLongArray.class || fieldClass == AtomicIntegerArray.class || Collection.class.isAssignableFrom(fieldClass) || fieldClass.isArray()) {
                nullFeatures |= JSONWriter.Feature.WriteNullListAsEmpty.mask;
                nullFeatures |= JSONWriter.Feature.NullAsDefaultValue.mask;
            } else if (Number.class.isAssignableFrom(fieldClass)) {
                nullFeatures |= JSONWriter.Feature.WriteNullNumberAsZero.mask;
                nullFeatures |= JSONWriter.Feature.NullAsDefaultValue.mask;
            } else if (fieldClass == Boolean.class) {
                nullFeatures |= JSONWriter.Feature.WriteNullBooleanAsFalse.mask;
                nullFeatures |= JSONWriter.Feature.NullAsDefaultValue.mask;
            } else if (fieldClass == String.class) {
                nullFeatures |= JSONWriter.Feature.WriteNullStringAsEmpty.mask;
                nullFeatures |= JSONWriter.Feature.NullAsDefaultValue.mask;
            } else {
                nullFeatures |= JSONWriter.Feature.NullAsDefaultValue.mask;
            }
            mwc.genIsEnabled(fieldWriter.features, nullFeatures, notNull_);
        }
        this.gwFieldName(mwc, fieldWriter, i);
        mw.aload(1);
        String WRITE_NULL_DESC = "()V";
        if (fieldClass == AtomicLongArray.class || fieldClass == AtomicIntegerArray.class || Collection.class.isAssignableFrom(fieldClass) || fieldClass.isArray()) {
            WRITE_NULL_METHOD = "writeArrayNull";
        } else if (fieldClass == Float.class || fieldClass == Double.class || fieldClass == BigDecimal.class) {
            WRITE_NULL_METHOD = "writeDecimalNull";
            WRITE_NULL_DESC = "(J)V";
            mw.lload(mwc.var2(CONTEXT_FEATURES));
            mw.visitLdcInsn(fieldWriter.features);
            mw.lor();
        } else if (Number.class.isAssignableFrom(fieldClass)) {
            WRITE_NULL_METHOD = "writeNumberNull";
            WRITE_NULL_DESC = "(J)V";
            mw.lload(mwc.var2(CONTEXT_FEATURES));
            mw.visitLdcInsn(fieldWriter.features);
            mw.lor();
        } else if (fieldClass == Boolean.class) {
            if ((fieldWriter.features & JSONWriter.Feature.WriteNullBooleanAsFalse.mask) != 0L) {
                WRITE_NULL_METHOD = "writeBool";
                WRITE_NULL_DESC = "(Z)V";
                mw.iconst_0();
            } else {
                WRITE_NULL_METHOD = "writeBooleanNull";
            }
        } else if (fieldClass == String.class || fieldClass == Appendable.class || fieldClass == StringBuffer.class || fieldClass == StringBuilder.class) {
            WRITE_NULL_METHOD = "writeStringNull";
        } else {
            WRITE_NULL_METHOD = "writeObjectNull";
            WRITE_NULL_DESC = "(Ljava/lang/Class;)V";
            mwc.loadFieldClass(i, fieldClass);
        }
        mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, WRITE_NULL_METHOD, WRITE_NULL_DESC);
        mw.visitLabel(notNull_);
    }

    private void gwFieldValueList(MethodWriterContext mwc, FieldWriter fieldWriter, int OBJECT, int i) {
        ParameterizedType parameterizedType;
        Type[] actualTypeArguments;
        boolean disableReferenceDetect = mwc.disableReferenceDetect();
        Type fieldType = fieldWriter.fieldType;
        Class fieldClass = fieldWriter.fieldClass;
        MethodWriter mw = mwc.mw;
        int LIST = mwc.var(fieldClass);
        int REF_PATH = -1;
        if (!disableReferenceDetect) {
            REF_PATH = mwc.var("REF_PATH");
        }
        Class<?> itemClass = null;
        boolean listSimple = false;
        if ((fieldWriter.features & JSONWriter.Feature.WriteNonStringValueAsString.mask) == 0L && fieldType instanceof ParameterizedType && (actualTypeArguments = (parameterizedType = (ParameterizedType)fieldType).getActualTypeArguments()).length == 1) {
            Type arg0 = actualTypeArguments[0];
            itemClass = TypeUtils.getClass(arg0);
            listSimple = arg0 == String.class || arg0 == Integer.class || arg0 == Long.class;
        }
        int FIELD_VALUE = mwc.var(fieldClass);
        this.genGetObject(mwc, fieldWriter, i, OBJECT);
        mw.dup();
        mw.astore(FIELD_VALUE);
        Label null_ = new Label();
        Label notNull_ = new Label();
        mw.ifnull(null_);
        Label ignoreEmptyEnd_ = null;
        if ((fieldWriter.features & JSONWriter.Feature.IgnoreEmpty.mask) == 0L) {
            ignoreEmptyEnd_ = new Label();
            mwc.genIsEnabled(JSONWriter.Feature.IgnoreEmpty.mask, ignoreEmptyEnd_);
        }
        mw.aload(FIELD_VALUE);
        mw.invokeinterface("java/util/Collection", "isEmpty", "()Z");
        mw.ifne(notNull_);
        if (ignoreEmptyEnd_ != null) {
            mw.visitLabel(ignoreEmptyEnd_);
        }
        if (!disableReferenceDetect) {
            Label endDetect_ = new Label();
            Label refSetPath_ = new Label();
            mwc.genIsEnabled(JSONWriter.Feature.ReferenceDetection.mask, endDetect_);
            if (fieldClass.isAssignableFrom(mwc.objectClass)) {
                mw.aload(OBJECT);
                mw.aload(LIST);
                mw.if_acmpne(refSetPath_);
                mw.aload(1);
                mw.visitLdcInsn("..");
                mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "writeReference", METHOD_DESC_WRITE_REFERENCE);
                mw.goto_(notNull_);
                mw.visitLabel(refSetPath_);
            }
            mw.aload(0);
            mw.getfield(mwc.classNameType, ObjectWriterCreatorASM.fieldWriter(i), ASMUtils.DESC_FIELD_WRITER);
            mw.aload(LIST);
            mw.lload(mwc.var(CONTEXT_FEATURES));
            mw.invokevirtual(ASMUtils.TYPE_FIELD_WRITER, "isRefDetect", "(Ljava/lang/Object;J)Z");
            mw.ifeq(endDetect_);
            mw.aload(1);
            mw.aload(0);
            mw.getfield(mwc.classNameType, ObjectWriterCreatorASM.fieldWriter(i), ASMUtils.DESC_FIELD_WRITER);
            mw.aload(LIST);
            mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "setPath0", METHOD_DESC_SET_PATH2);
            mw.dup();
            mw.astore(REF_PATH);
            mw.ifnull(endDetect_);
            this.gwFieldName(mwc, fieldWriter, i);
            mw.aload(1);
            mw.aload(REF_PATH);
            mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "writeReference", METHOD_DESC_WRITE_REFERENCE);
            mw.aload(1);
            mw.aload(LIST);
            mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "popPath0", "(Ljava/lang/Object;)V");
            mw.goto_(notNull_);
            mw.visitLabel(endDetect_);
        }
        Label notWriteEmptyArrayEnd_ = new Label();
        mwc.genIsEnabled(JSONWriter.Feature.NotWriteEmptyArray.mask, notWriteEmptyArrayEnd_);
        mw.aload(LIST);
        mw.invokeinterface("java/util/Collection", "isEmpty", "()Z");
        mw.ifeq(notWriteEmptyArrayEnd_);
        mw.goto_(notNull_);
        mw.visitLabel(notWriteEmptyArrayEnd_);
        if (listSimple) {
            this.gwFieldName(mwc, fieldWriter, i);
            ObjectWriterCreatorASM.gwListSimpleType(mwc, i, mw, fieldClass, itemClass, FIELD_VALUE);
        } else {
            this.gwFieldName(mwc, fieldWriter, i);
            mw.aload(0);
            mw.getfield(mwc.classNameType, ObjectWriterCreatorASM.fieldWriter(i), ASMUtils.DESC_FIELD_WRITER);
            mw.aload(1);
            mw.aload(FIELD_VALUE);
            mw.invokevirtual(ASMUtils.TYPE_FIELD_WRITER, mwc.jsonb ? "writeListValueJSONB" : "writeListValue", METHOD_DESC_WRITE_LIST);
        }
        if (!disableReferenceDetect) {
            mw.aload(1);
            mw.aload(LIST);
            mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "popPath0", "(Ljava/lang/Object;)V");
        }
        mw.goto_(notNull_);
        mw.visitLabel(null_);
        mwc.genIsEnabled(fieldWriter.features, JSONWriter.Feature.WriteNulls.mask | JSONWriter.Feature.NullAsDefaultValue.mask | JSONWriter.Feature.WriteNullListAsEmpty.mask, notNull_);
        this.gwFieldName(mwc, fieldWriter, i);
        mw.aload(1);
        mw.lload(mwc.var2(CONTEXT_FEATURES));
        mw.visitLdcInsn(fieldWriter.features);
        mw.lor();
        mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "writeArrayNull", "(J)V");
        mw.visitLabel(notNull_);
    }

    private void gwFieldValueJSONB(MethodWriterContext mwc, FieldWriter fieldWriter, int OBJECT, int i) {
        boolean writeAsString;
        Class fieldClass = fieldWriter.fieldClass;
        boolean bl = writeAsString = (fieldWriter.features & JSONWriter.Feature.WriteNonStringValueAsString.mask) != 0L;
        if (fieldClass == Boolean.TYPE) {
            this.gwFieldValueBooleanV(mwc, fieldWriter, OBJECT, i, true);
        } else if (fieldClass == boolean[].class || fieldClass == byte[].class || fieldClass == char[].class || fieldClass == short[].class || fieldClass == float[].class || fieldClass == double[].class) {
            this.gwFieldValueArray(mwc, fieldWriter, OBJECT, i);
        } else if (fieldClass == Character.TYPE || fieldClass == Byte.TYPE || fieldClass == Short.TYPE || fieldClass == Integer.TYPE || fieldClass == Float.TYPE) {
            this.gwFieldValueInt32V(mwc, fieldWriter, OBJECT, i, true);
        } else if (fieldClass == int[].class) {
            this.gwFieldValueIntVA(mwc, fieldWriter, OBJECT, i, true);
        } else if (fieldClass == Long.TYPE || fieldClass == Double.TYPE) {
            this.gwFieldValueInt64V(mwc, fieldWriter, OBJECT, i, true);
        } else if (fieldClass == long[].class && mwc.provider.getObjectWriter(Long.class) == ObjectWriterImplInt64.INSTANCE) {
            this.gwFieldValueInt64VA(mwc, fieldWriter, OBJECT, i, true);
        } else if (fieldClass == Integer.class) {
            this.gwInt32(mwc, fieldWriter, OBJECT, i);
        } else if (fieldClass == Long.class) {
            this.gwInt64(mwc, fieldWriter, OBJECT, i);
        } else if (fieldClass == String.class) {
            this.gwFieldValueString(mwc, fieldWriter, OBJECT, i);
        } else if (fieldClass.isEnum()) {
            this.gwFieldValueArray(mwc, fieldWriter, OBJECT, i);
        } else if (fieldClass == Date.class) {
            this.gwFieldValueDate(mwc, fieldWriter, OBJECT, i);
        } else {
            this.gwFieldValueObject(mwc, fieldWriter, OBJECT, i, true);
        }
    }

    private void gwInt32(MethodWriterContext mwc, FieldWriter fieldWriter, int OBJECT, int i) {
        boolean writeAsString;
        String classNameType = mwc.classNameType;
        MethodWriter mw = mwc.mw;
        Class fieldClass = fieldWriter.fieldClass;
        int FIELD_VALUE = mwc.var(fieldClass);
        Label endIfNull_ = new Label();
        Label notNull_ = new Label();
        Label writeNullValue_ = new Label();
        this.genGetObject(mwc, fieldWriter, i, OBJECT);
        mw.dup();
        mw.astore(FIELD_VALUE);
        mw.ifnonnull(notNull_);
        boolean bl = writeAsString = (fieldWriter.features & JSONWriter.Feature.WriteNonStringValueAsString.mask) != 0L;
        if ((fieldWriter.features & (JSONWriter.Feature.WriteNulls.mask | JSONWriter.Feature.NullAsDefaultValue.mask | JSONWriter.Feature.WriteNullNumberAsZero.mask)) == 0L) {
            mwc.genIsEnabled(JSONWriter.Feature.WriteNulls.mask | JSONWriter.Feature.NullAsDefaultValue.mask | JSONWriter.Feature.WriteNullNumberAsZero.mask, writeNullValue_, endIfNull_);
            mw.visitLabel(writeNullValue_);
            this.gwFieldName(mwc, fieldWriter, i);
            mw.aload(1);
            mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "writeNumberNull", "()V");
        } else {
            this.gwFieldName(mwc, fieldWriter, i);
            mw.aload(1);
            long features = fieldWriter.features;
            if ((features & (JSONWriter.Feature.WriteNullNumberAsZero.mask | JSONWriter.Feature.NullAsDefaultValue.mask)) != 0L) {
                mw.visitLdcInsn(0);
                mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "writeInt32", "(I)V");
            } else {
                mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "writeNull", "()V");
            }
        }
        mw.goto_(endIfNull_);
        mw.visitLabel(notNull_);
        if (writeAsString) {
            mw.aload(0);
            mw.getfield(classNameType, ObjectWriterCreatorASM.fieldWriter(i), ASMUtils.DESC_FIELD_WRITER);
            mw.aload(1);
            mw.aload(FIELD_VALUE);
            mw.invokevirtual("java/lang/Integer", "intValue", "()I");
            mw.invokevirtual(ASMUtils.TYPE_FIELD_WRITER, "writeInt32", METHOD_DESC_WRITE_I);
        } else {
            this.gwFieldName(mwc, fieldWriter, i);
            mw.aload(1);
            mw.aload(FIELD_VALUE);
            mw.invokevirtual("java/lang/Integer", "intValue", "()I");
            mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "writeInt32", "(I)V");
        }
        mw.visitLabel(endIfNull_);
    }

    private void gwInt64(MethodWriterContext mwc, FieldWriter fieldWriter, int OBJECT, int i) {
        MethodWriter mw = mwc.mw;
        Class fieldClass = fieldWriter.fieldClass;
        String classNameType = mwc.classNameType;
        int FIELD_VALUE = mwc.var(fieldClass);
        Label endIfNull_ = new Label();
        Label notNull_ = new Label();
        Label writeNullValue_ = new Label();
        this.genGetObject(mwc, fieldWriter, i, OBJECT);
        mw.dup();
        mw.astore(FIELD_VALUE);
        mw.ifnonnull(notNull_);
        if ((fieldWriter.features & (JSONWriter.Feature.WriteNulls.mask | JSONWriter.Feature.NullAsDefaultValue.mask | JSONWriter.Feature.WriteNullNumberAsZero.mask)) == 0L) {
            mwc.genIsEnabled(JSONWriter.Feature.WriteNulls.mask | JSONWriter.Feature.NullAsDefaultValue.mask | JSONWriter.Feature.WriteNullNumberAsZero.mask, writeNullValue_, endIfNull_);
            mw.visitLabel(writeNullValue_);
            this.gwFieldName(mwc, fieldWriter, i);
            mw.aload(1);
            mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "writeInt64Null", "()V");
        } else {
            this.gwFieldName(mwc, fieldWriter, i);
            mw.aload(1);
            long features = fieldWriter.features;
            if ((features & (JSONWriter.Feature.WriteNullNumberAsZero.mask | JSONWriter.Feature.NullAsDefaultValue.mask)) != 0L) {
                mw.lconst_0();
                mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "writeInt64", "(J)V");
            } else {
                mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "writeNull", "()V");
            }
        }
        mw.goto_(endIfNull_);
        mw.visitLabel(notNull_);
        if ((fieldWriter.features & (JSONWriter.Feature.WriteNonStringValueAsString.mask | JSONWriter.Feature.WriteLongAsString.mask | JSONWriter.Feature.BrowserCompatible.mask)) == 0L) {
            this.gwFieldName(mwc, fieldWriter, i);
            mw.aload(1);
            mw.aload(FIELD_VALUE);
            mw.invokevirtual("java/lang/Long", "longValue", "()J");
            mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "writeInt64", "(J)V");
        } else {
            mw.aload(0);
            mw.getfield(classNameType, ObjectWriterCreatorASM.fieldWriter(i), ASMUtils.DESC_FIELD_WRITER);
            mw.aload(1);
            mw.aload(FIELD_VALUE);
            mw.invokevirtual("java/lang/Long", "longValue", "()J");
            mw.invokevirtual(ASMUtils.TYPE_FIELD_WRITER, "writeInt64", METHOD_DESC_WRITE_J);
        }
        mw.visitLabel(endIfNull_);
    }

    private void gwDouble(MethodWriterContext mwc, FieldWriter fieldWriter, int OBJECT, int i) {
        boolean jsonb = mwc.jsonb;
        MethodWriter mw = mwc.mw;
        Class fieldClass = fieldWriter.fieldClass;
        String classNameType = mwc.classNameType;
        int FIELD_VALUE = mwc.var(fieldClass);
        Label endIfNull_ = new Label();
        Label notNull_ = new Label();
        Label writeNullValue_ = new Label();
        this.genGetObject(mwc, fieldWriter, i, OBJECT);
        mw.dup();
        mw.astore(FIELD_VALUE);
        mw.ifnonnull(notNull_);
        if ((fieldWriter.features & (JSONWriter.Feature.WriteNulls.mask | JSONWriter.Feature.NullAsDefaultValue.mask | JSONWriter.Feature.WriteNullNumberAsZero.mask)) == 0L) {
            mwc.genIsEnabled(JSONWriter.Feature.WriteNulls.mask | JSONWriter.Feature.NullAsDefaultValue.mask | JSONWriter.Feature.WriteNullNumberAsZero.mask, writeNullValue_, endIfNull_);
            mw.visitLabel(writeNullValue_);
            this.gwFieldName(mwc, fieldWriter, i);
            mw.aload(1);
            mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "writeDecimalNull", "()V");
        } else {
            this.gwFieldName(mwc, fieldWriter, i);
            mw.aload(1);
            long features = fieldWriter.features;
            if ((features & JSONWriter.Feature.WriteNullNumberAsZero.mask) != 0L) {
                mw.visitLdcInsn(0);
                mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "writeInt32", "(I)V");
            } else if ((features & JSONWriter.Feature.NullAsDefaultValue.mask) != 0L) {
                mw.visitLdcInsn(0);
                mw.i2d();
                mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "writeDouble", "(D)V");
            } else {
                mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "writeNull", "()V");
            }
        }
        mw.goto_(endIfNull_);
        mw.visitLabel(notNull_);
        if (jsonb && (fieldWriter.features & JSONWriter.Feature.WriteNonStringValueAsString.mask) == 0L) {
            this.gwFieldName(mwc, fieldWriter, i);
            mw.aload(1);
            mw.aload(FIELD_VALUE);
            mw.invokevirtual("java/lang/Double", "doubleValue", "()D");
            mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "writeDouble", "(D)V");
        } else {
            mw.aload(0);
            mw.getfield(classNameType, ObjectWriterCreatorASM.fieldWriter(i), ASMUtils.DESC_FIELD_WRITER);
            mw.aload(1);
            mw.aload(FIELD_VALUE);
            mw.invokevirtual("java/lang/Double", "doubleValue", "()D");
            mw.invokevirtual(ASMUtils.TYPE_FIELD_WRITER, "writeDouble", METHOD_DESC_WRITE_D);
        }
        mw.visitLabel(endIfNull_);
    }

    private void gwFloat(MethodWriterContext mwc, FieldWriter fieldWriter, int OBJECT, int i) {
        boolean jsonb = mwc.jsonb;
        MethodWriter mw = mwc.mw;
        Class fieldClass = fieldWriter.fieldClass;
        String classNameType = mwc.classNameType;
        int FIELD_VALUE = mwc.var(fieldClass);
        Label endIfNull_ = new Label();
        Label notNull_ = new Label();
        Label writeNullValue_ = new Label();
        this.genGetObject(mwc, fieldWriter, i, OBJECT);
        mw.dup();
        mw.astore(FIELD_VALUE);
        mw.ifnonnull(notNull_);
        if ((fieldWriter.features & (JSONWriter.Feature.WriteNulls.mask | JSONWriter.Feature.NullAsDefaultValue.mask | JSONWriter.Feature.WriteNullNumberAsZero.mask)) == 0L) {
            mwc.genIsEnabled(JSONWriter.Feature.WriteNulls.mask | JSONWriter.Feature.NullAsDefaultValue.mask | JSONWriter.Feature.WriteNullNumberAsZero.mask, writeNullValue_, endIfNull_);
            mw.visitLabel(writeNullValue_);
            this.gwFieldName(mwc, fieldWriter, i);
            mw.aload(1);
            mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "writeDecimalNull", "()V");
        } else {
            this.gwFieldName(mwc, fieldWriter, i);
            mw.aload(1);
            long features = fieldWriter.features;
            if ((features & JSONWriter.Feature.WriteNullNumberAsZero.mask) != 0L) {
                mw.visitLdcInsn(0);
                mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "writeInt32", "(I)V");
            } else if ((features & JSONWriter.Feature.NullAsDefaultValue.mask) != 0L) {
                mw.visitLdcInsn(0);
                mw.i2f();
                mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "writeFloat", "(F)V");
            } else {
                mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "writeNull", "()V");
            }
        }
        mw.goto_(endIfNull_);
        mw.visitLabel(notNull_);
        if (jsonb) {
            this.gwFieldName(mwc, fieldWriter, i);
            mw.aload(1);
            mw.aload(FIELD_VALUE);
            mw.invokevirtual("java/lang/Float", "floatValue", "()F");
            mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "writeFloat", "(D)V");
        } else {
            mw.aload(0);
            mw.getfield(classNameType, ObjectWriterCreatorASM.fieldWriter(i), ASMUtils.DESC_FIELD_WRITER);
            mw.aload(1);
            mw.aload(FIELD_VALUE);
            mw.invokevirtual("java/lang/Float", "floatValue", "()F");
            mw.invokevirtual(ASMUtils.TYPE_FIELD_WRITER, "writeFloat", METHOD_DESC_WRITE_F);
        }
        mw.visitLabel(endIfNull_);
    }

    private static void gwListSimpleType(MethodWriterContext mwc, int i, MethodWriter mw, Class<?> fieldClass, Class itemClass, int FIELD_VALUE) {
        if (mwc.jsonb) {
            mw.aload(1);
            mw.aload(FIELD_VALUE);
            mwc.loadFieldClass(i, fieldClass);
            mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "checkAndWriteTypeName", "(Ljava/lang/Object;Ljava/lang/Class;)V");
        }
        if (itemClass == Integer.class) {
            mw.aload(1);
            mw.aload(FIELD_VALUE);
            mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "writeListInt32", "(Ljava/util/List;)V");
            return;
        }
        if (itemClass == Long.class) {
            mw.aload(1);
            mw.aload(FIELD_VALUE);
            mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "writeListInt64", "(Ljava/util/List;)V");
            return;
        }
        if (itemClass == String.class) {
            mw.aload(1);
            mw.aload(FIELD_VALUE);
            mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "writeString", "(Ljava/util/List;)V");
            return;
        }
        throw new JSONException("TOOD " + itemClass.getName());
    }

    static void gwString(MethodWriterContext mwc, boolean symbol, boolean checkNull, int STR) {
        MethodWriter mw = mwc.mw;
        Label notNull_ = new Label();
        Label endNull_ = new Label();
        if (checkNull) {
            mw.aload(STR);
            mw.ifnonnull(notNull_);
            mw.aload(1);
            mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "writeStringNull", "()V");
            mw.goto_(endNull_);
            mw.visitLabel(notNull_);
        }
        if (!(JDKUtils.JVM_VERSION != 8 || JDKUtils.OPENJ9 || JDKUtils.FIELD_STRING_VALUE_ERROR || symbol)) {
            mw.aload(1);
            mw.getstatic(ObjectWriterCreatorASMUtils.TYPE_UNSAFE_UTILS, "UNSAFE", "Lsun/misc/Unsafe;");
            mw.aload(STR);
            mw.visitLdcInsn(JDKUtils.FIELD_STRING_VALUE_OFFSET);
            mw.invokevirtual("sun/misc/Unsafe", "getObject", "(Ljava/lang/Object;J)Ljava/lang/Object;");
            mw.checkcast("[C");
            mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "writeString", "([C)V");
        } else if (JDKUtils.JVM_VERSION > 8 && !JDKUtils.OPENJ9 && JDKUtils.FIELD_STRING_CODER_OFFSET != -1L && JDKUtils.FIELD_STRING_VALUE_OFFSET != -1L && !symbol) {
            Label utf16_ = new Label();
            Label end_ = new Label();
            mw.aload(1);
            mw.getstatic(ObjectWriterCreatorASMUtils.TYPE_UNSAFE_UTILS, "UNSAFE", "Lsun/misc/Unsafe;");
            mw.aload(STR);
            mw.visitLdcInsn(JDKUtils.FIELD_STRING_VALUE_OFFSET);
            mw.invokevirtual("sun/misc/Unsafe", "getObject", "(Ljava/lang/Object;J)Ljava/lang/Object;");
            mw.checkcast("[B");
            mw.getstatic(ObjectWriterCreatorASMUtils.TYPE_UNSAFE_UTILS, "UNSAFE", "Lsun/misc/Unsafe;");
            mw.aload(STR);
            mw.visitLdcInsn(JDKUtils.FIELD_STRING_CODER_OFFSET);
            mw.invokevirtual("sun/misc/Unsafe", "getByte", "(Ljava/lang/Object;J)B");
            mw.ifne(utf16_);
            mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "writeStringLatin1", "([B)V");
            mw.goto_(end_);
            mw.visitLabel(utf16_);
            mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "writeStringUTF16", "([B)V");
            mw.visitLabel(end_);
        } else {
            mw.aload(1);
            mw.aload(STR);
            mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, symbol ? "writeSymbol" : "writeString", METHOD_DESC_WRITE_REFERENCE);
        }
        if (checkNull) {
            mw.visitLabel(endNull_);
        }
    }

    private void gwFieldValueDate(MethodWriterContext mwc, FieldWriter fieldWriter, int OBJECT, int i) {
        MethodWriter mw = mwc.mw;
        Class fieldClass = fieldWriter.fieldClass;
        Label null_ = new Label();
        Label writeNull_ = new Label();
        Label endIfNull_ = new Label();
        int FIELD_VALUE = mwc.var(fieldClass);
        this.genGetObject(mwc, fieldWriter, i, OBJECT);
        mw.dup();
        mw.astore(FIELD_VALUE);
        mw.ifnull(null_);
        mw.aload(0);
        mw.getfield(mwc.classNameType, ObjectWriterCreatorASM.fieldWriter(i), ASMUtils.DESC_FIELD_WRITER);
        mw.aload(1);
        mw.aload(FIELD_VALUE);
        mw.invokevirtual("java/util/Date", "getTime", "()J");
        mw.invokevirtual(ASMUtils.TYPE_FIELD_WRITER, "writeDate", METHOD_DESC_WRITE_J);
        mw.goto_(endIfNull_);
        mw.visitLabel(null_);
        if ((fieldWriter.features & JSONWriter.Feature.WriteNulls.mask) == 0L) {
            mw.iload(mwc.var(WRITE_NULLS));
            mw.ifne(writeNull_);
            mw.goto_(endIfNull_);
        }
        mw.visitLabel(writeNull_);
        this.gwFieldName(mwc, fieldWriter, i);
        mw.aload(1);
        mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "writeNull", "()V");
        mw.visitLabel(endIfNull_);
    }

    private void gwFieldValueArray(MethodWriterContext mwc, FieldWriter fieldWriter, int OBJECT, int i) {
        String methodDesc;
        String methodName;
        MethodWriter mw = mwc.mw;
        Class fieldClass = fieldWriter.fieldClass;
        if (fieldClass == char[].class) {
            methodName = "writeString";
            methodDesc = METHOD_DESC_WRITE_CArray;
        } else if (fieldClass == boolean[].class) {
            methodName = "writeBool";
            methodDesc = METHOD_DESC_WRITE_ZARRAY;
        } else if (fieldClass == byte[].class) {
            methodName = "writeBinary";
            methodDesc = METHOD_DESC_WRITE_BArray;
        } else if (fieldClass == short[].class) {
            methodName = "writeInt16";
            methodDesc = METHOD_DESC_WRITE_SArray;
        } else if (fieldClass == float[].class) {
            methodName = "writeFloat";
            methodDesc = METHOD_DESC_WRITE_FARRAY;
        } else if (fieldClass == double[].class) {
            methodName = "writeDouble";
            methodDesc = METHOD_DESC_WRITE_DARRAY;
        } else if (fieldClass.isEnum()) {
            methodName = "writeEnumJSONB";
            methodDesc = METHOD_DESC_WRITE_ENUM;
        } else {
            throw new UnsupportedOperationException();
        }
        mw.aload(0);
        mw.getfield(mwc.classNameType, ObjectWriterCreatorASM.fieldWriter(i), ASMUtils.DESC_FIELD_WRITER);
        mw.aload(1);
        this.genGetObject(mwc, fieldWriter, i, OBJECT);
        mw.invokevirtual(ASMUtils.TYPE_FIELD_WRITER, methodName, methodDesc);
    }

    private void gwFieldName(MethodWriterContext mwc, FieldWriter fieldWriter, int i) {
        MethodWriter mw = mwc.mw;
        String classNameType = mwc.classNameType;
        Label labelElse = new Label();
        Label labelEnd = new Label();
        boolean writeDirect = false;
        if (!mwc.jsonb) {
            int length;
            byte[] fieldNameUTF8 = fieldWriter.fieldName.getBytes(StandardCharsets.UTF_8);
            boolean asciiName = true;
            for (int j = 0; j < fieldNameUTF8.length; ++j) {
                if (fieldNameUTF8[j] >= 0) continue;
                asciiName = false;
                break;
            }
            if ((length = fieldNameUTF8.length) >= 2 && length <= 16 && asciiName) {
                String methodName;
                Number name1 = 0;
                Number name1SQ = 0;
                String methodDesc = "(J)V";
                byte[] bytes = new byte[8];
                switch (length) {
                    case 2: {
                        bytes[0] = 34;
                        System.arraycopy(fieldNameUTF8, 0, bytes, 1, 2);
                        bytes[3] = 34;
                        bytes[4] = 58;
                        methodName = "writeName2Raw";
                        break;
                    }
                    case 3: {
                        bytes[0] = 34;
                        System.arraycopy(fieldNameUTF8, 0, bytes, 1, 3);
                        bytes[4] = 34;
                        bytes[5] = 58;
                        methodName = "writeName3Raw";
                        break;
                    }
                    case 4: {
                        bytes[0] = 34;
                        System.arraycopy(fieldNameUTF8, 0, bytes, 1, 4);
                        bytes[5] = 34;
                        bytes[6] = 58;
                        methodName = "writeName4Raw";
                        break;
                    }
                    case 5: {
                        bytes[0] = 34;
                        System.arraycopy(fieldNameUTF8, 0, bytes, 1, 5);
                        bytes[6] = 34;
                        bytes[7] = 58;
                        methodName = "writeName5Raw";
                        break;
                    }
                    case 6: {
                        bytes[0] = 34;
                        System.arraycopy(fieldNameUTF8, 0, bytes, 1, 6);
                        bytes[7] = 34;
                        methodName = "writeName6Raw";
                        break;
                    }
                    case 7: {
                        bytes[0] = 34;
                        System.arraycopy(fieldNameUTF8, 0, bytes, 1, 7);
                        methodName = "writeName7Raw";
                        break;
                    }
                    case 8: {
                        bytes = fieldNameUTF8;
                        methodName = "writeName8Raw";
                        break;
                    }
                    case 9: {
                        bytes[0] = 34;
                        System.arraycopy(fieldNameUTF8, 0, bytes, 1, 7);
                        methodDesc = "(JI)V";
                        byte[] name1Bytes = new byte[]{fieldNameUTF8[7], fieldNameUTF8[8], 34, 58};
                        name1 = JDKUtils.UNSAFE.getInt(name1Bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET);
                        name1Bytes[2] = 39;
                        name1SQ = JDKUtils.UNSAFE.getInt(name1Bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET);
                        methodName = "writeName9Raw";
                        break;
                    }
                    case 10: {
                        bytes[0] = 34;
                        System.arraycopy(fieldNameUTF8, 0, bytes, 1, 7);
                        methodDesc = "(JJ)V";
                        byte[] name1Bytes = new byte[8];
                        name1Bytes[0] = fieldNameUTF8[7];
                        name1Bytes[1] = fieldNameUTF8[8];
                        name1Bytes[2] = fieldNameUTF8[9];
                        name1Bytes[3] = 34;
                        name1Bytes[4] = 58;
                        name1 = JDKUtils.UNSAFE.getLong(name1Bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET);
                        name1Bytes[3] = 39;
                        name1SQ = JDKUtils.UNSAFE.getLong(name1Bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET);
                        methodName = "writeName10Raw";
                        break;
                    }
                    case 11: {
                        bytes[0] = 34;
                        System.arraycopy(fieldNameUTF8, 0, bytes, 1, 7);
                        methodDesc = "(JJ)V";
                        byte[] name1Bytes = new byte[8];
                        name1Bytes[0] = fieldNameUTF8[7];
                        name1Bytes[1] = fieldNameUTF8[8];
                        name1Bytes[2] = fieldNameUTF8[9];
                        name1Bytes[3] = fieldNameUTF8[10];
                        name1Bytes[4] = 34;
                        name1Bytes[5] = 58;
                        name1 = JDKUtils.UNSAFE.getLong(name1Bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET);
                        name1Bytes[4] = 39;
                        name1SQ = JDKUtils.UNSAFE.getLong(name1Bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET);
                        methodName = "writeName11Raw";
                        break;
                    }
                    case 12: {
                        bytes[0] = 34;
                        System.arraycopy(fieldNameUTF8, 0, bytes, 1, 7);
                        methodDesc = "(JJ)V";
                        byte[] name1Bytes = new byte[8];
                        name1Bytes[0] = fieldNameUTF8[7];
                        name1Bytes[1] = fieldNameUTF8[8];
                        name1Bytes[2] = fieldNameUTF8[9];
                        name1Bytes[3] = fieldNameUTF8[10];
                        name1Bytes[4] = fieldNameUTF8[11];
                        name1Bytes[5] = 34;
                        name1Bytes[6] = 58;
                        name1 = JDKUtils.UNSAFE.getLong(name1Bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET);
                        name1Bytes[5] = 39;
                        name1SQ = JDKUtils.UNSAFE.getLong(name1Bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET);
                        methodName = "writeName12Raw";
                        break;
                    }
                    case 13: {
                        bytes[0] = 34;
                        System.arraycopy(fieldNameUTF8, 0, bytes, 1, 7);
                        methodDesc = "(JJ)V";
                        byte[] name1Bytes = new byte[]{fieldNameUTF8[7], fieldNameUTF8[8], fieldNameUTF8[9], fieldNameUTF8[10], fieldNameUTF8[11], fieldNameUTF8[12], 34, 58};
                        name1 = JDKUtils.UNSAFE.getLong(name1Bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET);
                        name1Bytes[6] = 39;
                        name1SQ = JDKUtils.UNSAFE.getLong(name1Bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET);
                        methodName = "writeName13Raw";
                        break;
                    }
                    case 14: {
                        bytes[0] = 34;
                        System.arraycopy(fieldNameUTF8, 0, bytes, 1, 7);
                        methodDesc = "(JJ)V";
                        byte[] name1Bytes = new byte[]{fieldNameUTF8[7], fieldNameUTF8[8], fieldNameUTF8[9], fieldNameUTF8[10], fieldNameUTF8[11], fieldNameUTF8[12], fieldNameUTF8[13], 34};
                        name1 = JDKUtils.UNSAFE.getLong(name1Bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET);
                        name1Bytes[7] = 39;
                        name1SQ = JDKUtils.UNSAFE.getLong(name1Bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET);
                        methodName = "writeName14Raw";
                        break;
                    }
                    case 15: {
                        bytes[0] = 34;
                        System.arraycopy(fieldNameUTF8, 0, bytes, 1, 7);
                        methodDesc = "(JJ)V";
                        name1SQ = name1 = Long.valueOf(JDKUtils.UNSAFE.getLong(fieldNameUTF8, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 7L));
                        methodName = "writeName15Raw";
                        break;
                    }
                    case 16: {
                        System.arraycopy(fieldNameUTF8, 0, bytes, 0, 8);
                        methodDesc = "(JJ)V";
                        name1SQ = name1 = Long.valueOf(JDKUtils.UNSAFE.getLong(fieldNameUTF8, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 8L));
                        methodName = "writeName16Raw";
                        break;
                    }
                    default: {
                        throw new IllegalStateException("length : " + length);
                    }
                }
                long nameIn64 = JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET);
                for (int j = 0; j < bytes.length; ++j) {
                    if (bytes[j] != 34) continue;
                    bytes[j] = 39;
                }
                long nameIn64SQ = JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET);
                mw.aload(1);
                mwc.ldcIFEQ(NAME_DIRECT, nameIn64, nameIn64SQ);
                if ("(JI)V".equals(methodDesc) || "(JJ)V".equals(methodDesc)) {
                    mwc.ldcIFEQ(NAME_DIRECT, name1, name1SQ);
                }
                mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, methodName, methodDesc);
                return;
            }
        } else {
            byte[] fieldNameUTF8 = JSONB.toBytes(fieldWriter.fieldName);
            int length = fieldNameUTF8.length;
            String methodName = null;
            String methodDesc = "(J)V";
            byte[] bytes = Arrays.copyOf(fieldNameUTF8, 16);
            switch (length) {
                case 2: {
                    methodName = "writeName2Raw";
                    break;
                }
                case 3: {
                    methodName = "writeName3Raw";
                    break;
                }
                case 4: {
                    methodName = "writeName4Raw";
                    break;
                }
                case 5: {
                    methodName = "writeName5Raw";
                    break;
                }
                case 6: {
                    methodName = "writeName6Raw";
                    break;
                }
                case 7: {
                    methodName = "writeName7Raw";
                    break;
                }
                case 8: {
                    methodName = "writeName8Raw";
                    break;
                }
                case 9: {
                    methodName = "writeName9Raw";
                    methodDesc = "(JI)V";
                    break;
                }
                case 10: {
                    methodName = "writeName10Raw";
                    methodDesc = "(JJ)V";
                    break;
                }
                case 11: {
                    methodName = "writeName11Raw";
                    methodDesc = "(JJ)V";
                    break;
                }
                case 12: {
                    methodName = "writeName12Raw";
                    methodDesc = "(JJ)V";
                    break;
                }
                case 13: {
                    methodName = "writeName13Raw";
                    methodDesc = "(JJ)V";
                    break;
                }
                case 14: {
                    methodName = "writeName14Raw";
                    methodDesc = "(JJ)V";
                    break;
                }
                case 15: {
                    methodName = "writeName15Raw";
                    methodDesc = "(JJ)V";
                    break;
                }
                case 16: {
                    methodName = "writeName16Raw";
                    methodDesc = "(JJ)V";
                    break;
                }
            }
            if (methodName != null) {
                mw.iload(mwc.var(NAME_DIRECT));
                mw.ifeq(labelElse);
                long nameIn64 = JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET);
                mw.aload(1);
                mw.visitLdcInsn(nameIn64);
                if ("(JI)V".equals(methodDesc)) {
                    int name1 = JDKUtils.UNSAFE.getInt(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 8L);
                    mw.visitLdcInsn(name1);
                } else if ("(JJ)V".equals(methodDesc)) {
                    long name1 = JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 8L);
                    mw.visitLdcInsn(name1);
                }
                mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, methodName, methodDesc);
                mw.goto_(labelEnd);
                writeDirect = true;
            }
        }
        if (writeDirect) {
            mw.visitLabel(labelElse);
        }
        mw.aload(0);
        mw.getfield(classNameType, ObjectWriterCreatorASM.fieldWriter(i), ASMUtils.DESC_FIELD_WRITER);
        mw.aload(1);
        mw.invokevirtual(ASMUtils.TYPE_FIELD_WRITER, mwc.jsonb ? "writeFieldNameJSONB" : "writeFieldName", METHOD_DESC_WRITE_FIELD_NAME);
        if (writeDirect) {
            mw.visitLabel(labelEnd);
        }
    }

    private void gwFieldValueInt64VA(MethodWriterContext mwc, FieldWriter fieldWriter, int OBJECT, int i, boolean jsonb) {
        MethodWriter mw = mwc.mw;
        Class fieldClass = fieldWriter.fieldClass;
        int FIELD_VALUE = mwc.var(fieldClass);
        Label endIfNull_ = new Label();
        Label notNull_ = new Label();
        Label writeNullValue_ = new Label();
        this.genGetObject(mwc, fieldWriter, i, OBJECT);
        mw.dup();
        mw.astore(FIELD_VALUE);
        mw.ifnonnull(notNull_);
        mw.iload(mwc.var(WRITE_NULLS));
        mw.ifne(writeNullValue_);
        mw.goto_(endIfNull_);
        mw.visitLabel(writeNullValue_);
        this.gwFieldName(mwc, fieldWriter, i);
        mw.aload(1);
        mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "writeArrayNull", "()V");
        mw.goto_(endIfNull_);
        mw.visitLabel(notNull_);
        this.gwFieldName(mwc, fieldWriter, i);
        boolean writeAsString = (fieldWriter.features & JSONWriter.Feature.WriteNonStringValueAsString.mask) != 0L;
        mw.aload(1);
        mw.aload(FIELD_VALUE);
        mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, writeAsString ? "writeString" : "writeInt64", "([J)V");
        mw.visitLabel(endIfNull_);
    }

    private void gwFieldValueInt64V(MethodWriterContext mwc, FieldWriter fieldWriter, int OBJECT, int i, boolean jsonb) {
        MethodWriter mw = mwc.mw;
        String format = fieldWriter.format;
        String classNameType = mwc.classNameType;
        Class fieldClass = fieldWriter.fieldClass;
        int FIELD_VALUE = mwc.var(fieldClass);
        int WRITE_DEFAULT_VALUE = mwc.var(NOT_WRITE_DEFAULT_VALUE);
        Label notDefaultValue_ = new Label();
        Label endWriteValue_ = new Label();
        this.genGetObject(mwc, fieldWriter, i, OBJECT);
        mw.dup2();
        mw.storeLocal(fieldClass, FIELD_VALUE);
        mw.cmpWithZero(fieldClass);
        mw.ifne(notDefaultValue_);
        if (fieldWriter.defaultValue == null) {
            mw.iload(WRITE_DEFAULT_VALUE);
            mw.ifeq(notDefaultValue_);
            mw.goto_(endWriteValue_);
        }
        mw.visitLabel(notDefaultValue_);
        if (fieldClass == Long.TYPE) {
            boolean writeDate;
            boolean bl = writeDate = "iso8601".equals(format) || fieldWriter instanceof FieldWriterDate;
            if (writeDate || (fieldWriter.features & (JSONWriter.Feature.WriteNonStringValueAsString.mask | JSONWriter.Feature.WriteLongAsString.mask | JSONWriter.Feature.BrowserCompatible.mask)) != 0L) {
                mw.aload(0);
                mw.getfield(classNameType, ObjectWriterCreatorASM.fieldWriter(i), ASMUtils.DESC_FIELD_WRITER);
                mw.aload(1);
                mw.lload(FIELD_VALUE);
                mw.invokevirtual(ASMUtils.TYPE_FIELD_WRITER, writeDate ? "writeDate" : "writeInt64", METHOD_DESC_WRITE_J);
            } else {
                this.gwFieldName(mwc, fieldWriter, i);
                mw.aload(1);
                mw.lload(FIELD_VALUE);
                mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "writeInt64", "(J)V");
            }
        } else if (fieldClass == Double.TYPE) {
            this.gwFieldName(mwc, fieldWriter, i);
            this.gwValue(mwc, fieldWriter, OBJECT, i, FIELD_VALUE);
        } else {
            throw new UnsupportedOperationException();
        }
        mw.visitLabel(endWriteValue_);
    }

    void gwFieldValueIntVA(MethodWriterContext mwc, FieldWriter fieldWriter, int OBJECT, int i, boolean jsonb) {
        MethodWriter mw = mwc.mw;
        Class fieldClass = fieldWriter.fieldClass;
        int FIELD_VALUE = mwc.var(fieldClass);
        Label endIfNull_ = new Label();
        Label notNull_ = new Label();
        Label writeNullValue_ = new Label();
        this.genGetObject(mwc, fieldWriter, i, OBJECT);
        mw.dup();
        mw.astore(FIELD_VALUE);
        mw.ifnonnull(notNull_);
        mw.iload(mwc.var(WRITE_NULLS));
        mw.ifne(writeNullValue_);
        mw.goto_(endIfNull_);
        mw.visitLabel(writeNullValue_);
        this.gwFieldName(mwc, fieldWriter, i);
        mw.aload(1);
        mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "writeArrayNull", "()V");
        mw.goto_(endIfNull_);
        mw.visitLabel(notNull_);
        this.gwFieldName(mwc, fieldWriter, i);
        boolean writeAsString = (fieldWriter.features & JSONWriter.Feature.WriteNonStringValueAsString.mask) != 0L;
        mw.aload(1);
        mw.aload(FIELD_VALUE);
        mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, writeAsString ? "writeString" : "writeInt32", "([I)V");
        mw.visitLabel(endIfNull_);
    }

    private void gwFieldValueInt32V(MethodWriterContext mwc, FieldWriter fieldWriter, int OBJECT, int i, boolean jsonb) {
        MethodWriter mw = mwc.mw;
        String format = fieldWriter.format;
        String classNameType = mwc.classNameType;
        Class fieldClass = fieldWriter.fieldClass;
        int FIELD_VALUE = mwc.var(fieldClass);
        int WRITE_DEFAULT_VALUE = mwc.var(NOT_WRITE_DEFAULT_VALUE);
        Label notDefaultValue_ = new Label();
        Label endWriteValue_ = new Label();
        this.genGetObject(mwc, fieldWriter, i, OBJECT);
        mw.dup(fieldClass);
        mw.storeLocal(fieldClass, FIELD_VALUE);
        mw.cmpWithZero(fieldClass);
        mw.ifne(notDefaultValue_);
        if (fieldWriter.defaultValue == null) {
            mw.iload(WRITE_DEFAULT_VALUE);
            mw.ifeq(notDefaultValue_);
            mw.goto_(endWriteValue_);
        }
        mw.visitLabel(notDefaultValue_);
        this.gwFieldName(mwc, fieldWriter, i);
        this.gwValue(mwc, fieldWriter, OBJECT, i, FIELD_VALUE);
        mw.visitLabel(endWriteValue_);
    }

    private void gwFieldValueBooleanV(MethodWriterContext mwc, FieldWriter fieldWriter, int OBJECT, int i, boolean jsonb) {
        MethodWriter mw = mwc.mw;
        String classNameType = mwc.classNameType;
        int FIELD_VALUE = mwc.var(Boolean.TYPE);
        int WRITE_DEFAULT_VALUE = mwc.var(NOT_WRITE_DEFAULT_VALUE);
        Label notDefaultValue_ = new Label();
        Label endWriteValue_ = new Label();
        this.genGetObject(mwc, fieldWriter, i, OBJECT);
        mw.dup();
        mw.istore(FIELD_VALUE);
        mw.ifne(notDefaultValue_);
        if (fieldWriter.defaultValue == null) {
            mw.iload(WRITE_DEFAULT_VALUE);
            mw.ifeq(notDefaultValue_);
            mw.goto_(endWriteValue_);
        }
        mw.visitLabel(notDefaultValue_);
        mw.aload(0);
        mw.getfield(classNameType, ObjectWriterCreatorASM.fieldWriter(i), ASMUtils.DESC_FIELD_WRITER);
        mw.aload(1);
        mw.iload(FIELD_VALUE);
        mw.invokevirtual(ASMUtils.TYPE_FIELD_WRITER, "writeBool", METHOD_DESC_WRITE_Z);
        mw.visitLabel(endWriteValue_);
    }

    private void gwFieldValueString(MethodWriterContext mwc, FieldWriter fieldWriter, int OBJECT, int i) {
        boolean jsonb = mwc.jsonb;
        long features = fieldWriter.features | mwc.objectFeatures;
        MethodWriter mw = mwc.mw;
        Class fieldClass = fieldWriter.fieldClass;
        String format = fieldWriter.format;
        int FIELD_VALUE = mwc.var(fieldClass);
        Label null_ = new Label();
        Label endIfNull_ = new Label();
        this.genGetObject(mwc, fieldWriter, i, OBJECT);
        mw.dup();
        mw.astore(FIELD_VALUE);
        mw.ifnull(null_);
        if ("trim".equals(format)) {
            mw.aload(FIELD_VALUE);
            mw.invokevirtual("java/lang/String", "trim", "()Ljava/lang/String;");
            mw.astore(FIELD_VALUE);
        }
        Label ignoreEmptyEnd_ = null;
        if ((features & JSONWriter.Feature.IgnoreEmpty.mask) == 0L) {
            ignoreEmptyEnd_ = new Label();
            mwc.genIsEnabled(JSONWriter.Feature.IgnoreEmpty.mask, ignoreEmptyEnd_);
        }
        mw.aload(FIELD_VALUE);
        mw.invokevirtual("java/lang/String", "isEmpty", "()Z");
        mw.ifne(endIfNull_);
        if (ignoreEmptyEnd_ != null) {
            mw.visitLabel(ignoreEmptyEnd_);
        }
        this.gwFieldName(mwc, fieldWriter, i);
        boolean symbol = jsonb && "symbol".equals(format);
        ObjectWriterCreatorASM.gwString(mwc, symbol, false, FIELD_VALUE);
        mw.goto_(endIfNull_);
        mw.visitLabel(null_);
        Label writeNullValue_ = new Label();
        Label writeNull_ = new Label();
        long defaultValueMask = JSONWriter.Feature.NullAsDefaultValue.mask | JSONWriter.Feature.WriteNullNumberAsZero.mask | JSONWriter.Feature.WriteNullBooleanAsFalse.mask | JSONWriter.Feature.WriteNullListAsEmpty.mask | JSONWriter.Feature.WriteNullStringAsEmpty.mask;
        if ((features & (JSONWriter.Feature.WriteNulls.mask | defaultValueMask)) == 0L) {
            mwc.genIsEnabled(JSONWriter.Feature.WriteNulls.mask | JSONWriter.Feature.NullAsDefaultValue.mask | JSONWriter.Feature.WriteNullStringAsEmpty.mask, writeNull_, endIfNull_);
        }
        mw.visitLabel(writeNull_);
        if (fieldWriter.defaultValue == null) {
            mwc.genIsDisabled(JSONWriter.Feature.NotWriteDefaultValue.mask, endIfNull_);
        }
        this.gwFieldName(mwc, fieldWriter, i);
        if ((features & defaultValueMask) == 0L) {
            long mask = JSONWriter.Feature.NullAsDefaultValue.mask;
            if (fieldClass == String.class) {
                mask |= JSONWriter.Feature.WriteNullStringAsEmpty.mask;
            } else if (fieldClass == Boolean.class) {
                mask |= JSONWriter.Feature.WriteNullBooleanAsFalse.mask;
            } else if (Number.class.isAssignableFrom(fieldClass)) {
                mask |= JSONWriter.Feature.WriteNullNumberAsZero.mask;
            } else if (Collection.class.isAssignableFrom(fieldClass)) {
                mask |= JSONWriter.Feature.WriteNullListAsEmpty.mask;
            }
            mw.aload(1);
            mw.visitLdcInsn(mask);
            mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "isEnabled", "(J)Z");
            mw.ifeq(writeNullValue_);
        }
        mw.aload(1);
        mw.visitLdcInsn("");
        mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "writeString", METHOD_DESC_WRITE_REFERENCE);
        mw.goto_(endIfNull_);
        mw.visitLabel(writeNullValue_);
        mw.aload(1);
        mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "writeStringNull", "()V");
        mw.visitLabel(endIfNull_);
    }

    private void genMethodInit(List<FieldWriter> fieldWriters, ClassWriter cw, String classNameType, String objectWriterSupper) {
        MethodWriter mw = cw.visitMethod(1, "<init>", "(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;JLjava/util/List;)V", 64);
        mw.aload(0);
        mw.aload(1);
        mw.aload(2);
        mw.aload(3);
        mw.lload(4);
        mw.aload(6);
        mw.invokespecial(objectWriterSupper, "<init>", "(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;JLjava/util/List;)V");
        if (objectWriterSupper == ASMUtils.TYPE_OBJECT_WRITER_ADAPTER) {
            for (int i = 0; i < fieldWriters.size(); ++i) {
                mw.aload(0);
                mw.dup();
                mw.getfield(ASMUtils.TYPE_OBJECT_WRITER_ADAPTER, "fieldWriterArray", ASMUtils.DESC_FIELD_WRITER_ARRAY);
                mw.iconst_n(i);
                mw.aaload();
                mw.checkcast(ASMUtils.TYPE_FIELD_WRITER);
                mw.putfield(classNameType, ObjectWriterCreatorASM.fieldWriter(i), ASMUtils.DESC_FIELD_WRITER);
            }
        }
        mw.return_();
        mw.visitMaxs(7, 7);
    }

    private void genFields(List<FieldWriter> fieldWriters, ClassWriter cw, String objectWriterSupper) {
        if (objectWriterSupper != ASMUtils.TYPE_OBJECT_WRITER_ADAPTER) {
            return;
        }
        for (int i = 0; i < fieldWriters.size(); ++i) {
            cw.visitField(1, ObjectWriterCreatorASM.fieldWriter(i), ASMUtils.DESC_FIELD_WRITER);
        }
    }

    @Override
    public <T> FieldWriter<T> createFieldWriter(ObjectWriterProvider provider, String fieldName, int ordinal, long features, String format, Locale locale, String label, Field field, ObjectWriter initObjectWriter, Class<?> contentAs) {
        Class<?> declaringClass = field.getDeclaringClass();
        if (Throwable.class.isAssignableFrom(declaringClass) || declaringClass.getName().startsWith("java.lang")) {
            return super.createFieldWriter(provider, fieldName, ordinal, features, format, locale, label, field, initObjectWriter, contentAs);
        }
        Class<Object> fieldClass = field.getType();
        Class fieldType = field.getGenericType();
        if (initObjectWriter != null) {
            if (fieldClass == Byte.TYPE) {
                fieldClass = Byte.class;
                fieldType = Byte.class;
            } else if (fieldClass == Short.TYPE) {
                fieldClass = Short.class;
                fieldType = Short.class;
            } else if (fieldClass == Float.TYPE) {
                fieldClass = Float.class;
                fieldType = Float.class;
            } else if (fieldClass == Double.TYPE) {
                fieldClass = Double.class;
                fieldType = Double.class;
            } else if (fieldClass == Boolean.TYPE) {
                fieldClass = Boolean.class;
                fieldType = Boolean.class;
            }
            FieldWriterObject objImp = new FieldWriterObject(fieldName, ordinal, features, format, locale, label, (Type)((Object)fieldType), fieldClass, field, null);
            objImp.initValueClass = fieldClass;
            if (initObjectWriter != ObjectWriterBaseModule.VoidObjectWriter.INSTANCE) {
                objImp.initObjectWriter = initObjectWriter;
            }
            return objImp;
        }
        if (fieldClass == Boolean.TYPE) {
            return new FieldWriterBoolValField(fieldName, ordinal, features, format, label, field, fieldClass);
        }
        if (fieldClass == Byte.TYPE) {
            return new FieldWriterInt8ValField(fieldName, ordinal, features, format, label, field);
        }
        if (fieldClass == Short.TYPE) {
            return new FieldWriterInt16ValField(fieldName, ordinal, features, format, label, field);
        }
        if (fieldClass == Integer.TYPE) {
            return new FieldWriterInt32Val(fieldName, ordinal, features, format, label, field);
        }
        if (fieldClass == Long.TYPE) {
            if (format == null || format.isEmpty() || "string".equals(format)) {
                return new FieldWriterInt64ValField(fieldName, ordinal, features, format, label, field);
            }
            return new FieldWriterMillisField(fieldName, ordinal, features, format, label, field);
        }
        if (fieldClass == Float.TYPE) {
            return new FieldWriterFloatValField(fieldName, ordinal, features, format, label, field);
        }
        if (fieldClass == Float.class) {
            return new FieldWriterFloatField(fieldName, ordinal, features, format, label, field);
        }
        if (fieldClass == Double.TYPE) {
            return new FieldWriterDoubleValField(fieldName, ordinal, format, label, field);
        }
        if (fieldClass == Double.class) {
            return new FieldWriterDoubleField(fieldName, ordinal, features, format, label, field);
        }
        if (fieldClass == Character.TYPE) {
            return new FieldWriterCharValField(fieldName, ordinal, features, format, label, field);
        }
        if (fieldClass == BigInteger.class) {
            return new FieldWriterBigIntField(fieldName, ordinal, features, format, label, field);
        }
        if (fieldClass == BigDecimal.class) {
            return new FieldWriterBigDecimalField(fieldName, ordinal, features, format, label, field);
        }
        if (fieldClass == Date.class) {
            if (format != null && (format = format.trim()).isEmpty()) {
                format = null;
            }
            return new FieldWriterDateField(fieldName, ordinal, features, format, label, field);
        }
        if (fieldClass == String.class) {
            return new FieldWriterStringField(fieldName, ordinal, features, format, label, field);
        }
        if (fieldClass.isEnum()) {
            String[] enumAnnotationNames;
            Member enumValueField;
            ObjectWriter objectWriter;
            BeanInfo beanInfo = provider.createBeanInfo();
            provider.getBeanInfo(beanInfo, fieldClass);
            boolean writeEnumAsJavaBean = beanInfo.writeEnumAsJavaBean;
            if (!writeEnumAsJavaBean && (objectWriter = (ObjectWriter)provider.cache.get(fieldClass)) != null && !(objectWriter instanceof ObjectWriterImplEnum)) {
                writeEnumAsJavaBean = true;
            }
            if ((enumValueField = BeanUtils.getEnumValueField(fieldClass, provider)) == null && !writeEnumAsJavaBean && (enumAnnotationNames = BeanUtils.getEnumAnnotationNames(fieldClass)) == null) {
                return new FieldWriterEnum(fieldName, ordinal, features, format, label, (Type)((Object)fieldType), (Class<? extends Enum>)fieldClass, field, null);
            }
        }
        if (fieldClass == List.class || fieldClass == ArrayList.class) {
            Type itemType = null;
            if (fieldType instanceof ParameterizedType) {
                itemType = ((ParameterizedType)((Object)fieldType)).getActualTypeArguments()[0];
            }
            return this.createFieldWriterList(provider, fieldName, ordinal, features, format, label, field, contentAs, itemType, (Type)((Object)fieldType), fieldClass);
        }
        if (Map.class.isAssignableFrom(fieldClass)) {
            return new FieldWriterMapField(fieldName, ordinal, features, format, locale, label, field.getGenericType(), fieldClass, field, null, contentAs);
        }
        if (fieldClass.isArray()) {
            Class<?> itemClass = fieldClass.getComponentType();
            if (declaringClass == Throwable.class && "stackTrace".equals(fieldName)) {
                try {
                    Method method = Throwable.class.getMethod("getStackTrace", new Class[0]);
                    return new FieldWriterObjectArrayMethod(fieldName, itemClass, ordinal, features, format, label, (Type)((Object)fieldType), (Class)fieldClass, field, method);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
        }
        if (fieldClass == BigDecimal[].class) {
            return new FieldWriterObjectArrayField(fieldName, (Type)((Object)BigDecimal.class), ordinal, features, format, label, (Type)((Object)BigDecimal[].class), BigDecimal[].class, field);
        }
        if (fieldClass == Float[].class) {
            return new FieldWriterObjectArrayField(fieldName, (Type)((Object)Float.class), ordinal, features, format, label, (Type)((Object)Float[].class), Float[].class, field);
        }
        if (fieldClass == Double[].class) {
            return new FieldWriterObjectArrayField(fieldName, (Type)((Object)Float.class), ordinal, features, format, label, (Type)((Object)Double[].class), Double[].class, field);
        }
        if (TypeUtils.isFunction(fieldClass)) {
            return null;
        }
        return new FieldWriterObject(fieldName, ordinal, features, format, locale, label, field.getGenericType(), fieldClass, field, null);
    }

    private FieldWriter createFieldWriterList(ObjectWriterProvider provider, String fieldName, int ordinal, long features, String format, String label, Field field, Class<?> contentAs, Type itemType, Type fieldType, Class<?> fieldClass) {
        FieldWriterListField fieldWriter = this.jitFieldWriterList(provider, fieldName, ordinal, features, format, label, field, contentAs, itemType, fieldType, fieldClass);
        if (fieldWriter == null) {
            fieldWriter = new FieldWriterListField(fieldName, itemType, ordinal, features, format, label, fieldType, fieldClass, field, contentAs);
        }
        return fieldWriter;
    }

    private FieldWriter jitFieldWriterList(ObjectWriterProvider provider, String fieldName, int ordinal, long features, String format, String label, Field field, Class<?> contentAs, Type itemType, Type fieldType, Class<?> fieldClass) {
        boolean direct = false;
        List<FieldWriter> fieldWriters = null;
        Class<?> itemClass = TypeUtils.getClass(itemType);
        if (itemClass != null && field != null && field.getDeclaringClass() != itemClass) {
            ObjectWriter fieldValueWriter = provider.getObjectWriterFromCache(itemType, itemClass, JSONWriter.Feature.FieldBased.isEnabled(features));
            if (fieldValueWriter == null && itemClass != null) {
                fieldValueWriter = super.createObjectWriter(itemClass, features, provider);
            }
            fieldWriters = fieldValueWriter.getFieldWriters();
            List<FieldWriterGroup> groups = ObjectWriterCreatorASM.buildGroups(fieldValueWriter.getFeatures(), fieldWriters);
            if (groups.size() == 1 && ((FieldWriterGroup)groups.get((int)0)).direct) {
                direct = true;
            }
            for (FieldWriter fieldWriter : fieldWriters) {
                if (fieldWriter.method == null && fieldWriter.field == null && fieldWriter.getFunction() == null) {
                    direct = false;
                    break;
                }
                Class cls = fieldWriter.fieldClass;
                if (cls == Boolean.TYPE || cls == Boolean.class || cls == Byte.TYPE || cls == Byte.class || cls == Short.TYPE || cls == Short.class || cls == Integer.TYPE || cls == Integer.class || cls == Long.TYPE || cls == Long.class || cls == Float.TYPE || cls == Float.class || cls == Double.TYPE || cls == Double.class || cls == LocalDate.class || cls == LocalTime.class || cls == LocalDateTime.class || cls == OffsetDateTime.class || cls == OffsetTime.class || cls == Instant.class || cls == UUID.class) continue;
                direct = false;
                break;
            }
        }
        if (direct) {
            String classNameType;
            String classNameFull;
            int capacity = 6;
            for (FieldWriter fieldWriter : fieldWriters) {
                capacity = this.fieldCapacity(fieldWriter.fieldClass);
            }
            ClassWriter cw = new ClassWriter(null);
            String className = "OWF_" + seed.incrementAndGet() + "_" + fieldWriters.size() + "_" + itemClass.getSimpleName();
            Package pkg = ObjectWriterCreatorASM.class.getPackage();
            if (pkg != null) {
                String packageName = pkg.getName();
                int packageNameLength = packageName.length();
                int charsLength = packageNameLength + 1 + className.length();
                char[] chars = new char[charsLength];
                packageName.getChars(0, packageName.length(), chars, 0);
                chars[packageNameLength] = 46;
                className.getChars(0, className.length(), chars, packageNameLength + 1);
                classNameFull = new String(chars);
                chars[packageNameLength] = 47;
                for (int i = 0; i < packageNameLength; ++i) {
                    if (chars[i] != '.') continue;
                    chars[i] = 47;
                }
                classNameType = new String(chars);
            } else {
                classNameType = className;
                classNameFull = className;
            }
            String supperType = ASMUtils.type(FieldWriterListField.class);
            cw.visit(52, 49, classNameType, supperType, INTERFACES);
            String initDesc = "(Ljava/lang/String;Ljava/lang/reflect/Type;IJLjava/lang/String;Ljava/lang/String;Ljava/lang/reflect/Type;Ljava/lang/Class;Ljava/lang/reflect/Field;Ljava/lang/Class;)V";
            MethodWriter mw = cw.visitMethod(1, "<init>", initDesc, 64);
            mw.aload(0);
            mw.aload(1);
            mw.aload(2);
            mw.iload(3);
            mw.lload(4);
            mw.aload(6);
            mw.aload(7);
            mw.aload(8);
            mw.aload(9);
            mw.aload(10);
            mw.aload(11);
            mw.invokespecial(supperType, "<init>", initDesc);
            mw.return_();
            mw.visitMaxs(12, 12);
            MethodWriter mw2 = cw.visitMethod(1, "writeListValueJSONB", METHOD_DESC_WRITE_LIST_VALUE_JSONB, fieldWriters.size() < 6 ? 512 : 1024);
            MethodWriterContext mwc = new MethodWriterContext(provider, itemClass, features, classNameType, mw2, 8, false);
            int LIST = 2;
            int OFFSET = mwc.var("offset");
            int BYTES = mwc.var("bytes");
            int FEATURES = mwc.var2(CONTEXT_FEATURES);
            int symbolTable = mwc.var("symbolTable");
            mw2.aload(1);
            mw2.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "getOffset", "()I");
            mw2.istore(OFFSET);
            mw2.aload(1);
            mw2.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "getFeatures", "()J");
            mw2.lstore(FEATURES);
            Label L_SUPPER = new Label();
            if (!provider.isDisableReferenceDetect()) {
                mw2.lload(FEATURES);
                mw2.visitLdcInsn(JSONWriter.Feature.ReferenceDetection.mask);
                mw2.land();
                mw2.lconst_0();
                mw2.lcmp();
                mw2.ifne(L_SUPPER);
            }
            mw2.aload(1);
            mw2.getfield(ASMUtils.TYPE_JSON_WRITER, "symbolTable", DESC_SYMBOL);
            mw2.astore(symbolTable);
            int SIZE = mwc.var("size");
            mw2.aload(LIST);
            mw2.invokeinterface("java/util/List", "size", "()I");
            mw2.istore(SIZE);
            mw2.aload(1);
            mw2.iload(OFFSET);
            mw2.iconst_5();
            mw2.iadd();
            mw2.visitLdcInsn(capacity);
            mw2.iload(SIZE);
            mw2.imul();
            mw2.iadd();
            mw2.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "ensureCapacity", "(I)Ljava/lang/Object;");
            mw2.checkcast("[B");
            mw2.astore(BYTES);
            mw2.aload(BYTES);
            mw2.iload(OFFSET);
            mw2.iload(SIZE);
            mw2.invokestatic(ASMUtils.TYPE_JSONB_IO, "startArray", "([BII)I", true);
            mw2.istore(OFFSET);
            Label L0 = new Label();
            Label L1 = new Label();
            Label L3 = new Label();
            int I = mwc.var("I");
            mw2.iconst_0();
            mw2.istore(I);
            mw2.visitLabel(L0);
            mw2.iload(I);
            mw2.iload(SIZE);
            mw2.if_icmpge(L3);
            mw2.aload(BYTES);
            mw2.iload(OFFSET);
            mw2.visitLdcInsn(fieldWriters.size());
            mw2.invokestatic(ASMUtils.TYPE_JSONB_IO, "startArray", "([BII)I", true);
            mw2.istore(OFFSET);
            int ITEM = mwc.var("ITEM");
            mw2.aload(LIST);
            mw2.iload(I);
            mw2.invokeinterface("java/util/List", "get", "(I)Ljava/lang/Object;");
            mw2.astore(ITEM);
            mw2.aload(ITEM);
            mw2.ifnonnull(L1);
            mw2.aload(BYTES);
            mw2.iload(OFFSET);
            mw2.bipush(-81);
            mw2.bastore();
            mw2.visitIincInsn(OFFSET, 1);
            mw2.goto_(L0);
            mw2.visitLabel(L1);
            mw2.aload(ITEM);
            mw2.invokevirtual("java/lang/Object", "getClass", "()Ljava/lang/Class;");
            mw2.aload(0);
            mw2.getfield(ASMUtils.TYPE_FIELD_WRITER, "fieldClass", "Ljava/lang/Class;");
            mw2.if_acmpeq(L_SUPPER);
            for (int i = 0; i < fieldWriters.size(); ++i) {
                FieldWriter fieldWriter = fieldWriters.get(i);
                this.writeFieldValueDirectJSONB(features, classNameType, mwc, fieldWriter, i, mw2, BYTES, OFFSET, ITEM, FEATURES, symbolTable, false);
            }
            mw2.visitIincInsn(I, 1);
            mw2.goto_(L0);
            mw2.visitLabel(L3);
            mw2.aload(1);
            mw2.iload(OFFSET);
            mw2.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "setOffset", "(I)V");
            mw2.return_();
            mw2.visitLabel(L_SUPPER);
            mw2.aload(0);
            mw2.aload(1);
            mw2.aload(LIST);
            mw2.invokespecial(ASMUtils.type(FieldWriterList.class), "writeListValueJSONB", METHOD_DESC_WRITE_LIST_VALUE_JSONB);
            mw2.return_();
            mw2.visitMaxs(mwc.maxVariant + 1, mwc.maxVariant + 1);
            byte[] code = cw.toByteArray();
            Class<?> deserClass = this.classLoader.defineClassPublic(classNameFull, code, 0, code.length);
            try {
                Constructor<?> constructor = deserClass.getConstructor(String.class, Type.class, Integer.TYPE, Long.TYPE, String.class, String.class, Type.class, Class.class, Field.class, Class.class);
                return (FieldWriterListField)constructor.newInstance(fieldName, itemType, ordinal, features, format, label, fieldType, fieldClass, field, contentAs);
            }
            catch (Throwable e) {
                throw new JSONException("create objectWriter error, objectType " + itemClass, e);
            }
        }
        return null;
    }

    void genGetObject(MethodWriterContext mwc, FieldWriter fieldWriter, int i, int OBJECT) {
        String methodDes;
        String methodName;
        MethodWriter mw = mwc.mw;
        Class objectClass = mwc.objectClass;
        String TYPE_OBJECT = objectClass == null ? "java/lang/Object" : ASMUtils.type(objectClass);
        Class fieldClass = fieldWriter.fieldClass;
        AccessibleObject member = fieldWriter.method != null ? fieldWriter.method : fieldWriter.field;
        Function function = fieldWriter.getFunction();
        if (member == null && function != null) {
            mw.aload(0);
            mw.getfield(mwc.classNameType, ObjectWriterCreatorASM.fieldWriter(i), ASMUtils.DESC_FIELD_WRITER);
            mw.invokevirtual(ASMUtils.TYPE_FIELD_WRITER, "getFunction", "()Ljava/util/function/Function;");
            mw.aload(OBJECT);
            mw.invokeinterface(ASMUtils.type(Function.class), "apply", "(Ljava/lang/Object;)Ljava/lang/Object;");
            mw.checkcast(ASMUtils.type(fieldClass));
            return;
        }
        if (member instanceof Method) {
            mw.aload(OBJECT);
            mw.checkcast(TYPE_OBJECT);
            if (objectClass.isInterface()) {
                mw.invokeinterface(TYPE_OBJECT, member.getName(), "()" + ASMUtils.desc(fieldClass));
            } else {
                mw.invokevirtual(TYPE_OBJECT, member.getName(), "()" + ASMUtils.desc(fieldClass));
            }
            return;
        }
        if (Modifier.isPublic(objectClass.getModifiers()) && Modifier.isPublic(member.getModifiers()) && !this.classLoader.isExternalClass(objectClass)) {
            mw.aload(OBJECT);
            mw.checkcast(TYPE_OBJECT);
            mw.getfield(TYPE_OBJECT, member.getName(), ASMUtils.desc(fieldClass));
            return;
        }
        Field field = (Field)member;
        String castToType = null;
        if (fieldClass == Integer.TYPE) {
            methodName = "getInt";
            methodDes = "(Ljava/lang/Object;J)I";
        } else if (fieldClass == Long.TYPE) {
            methodName = "getLong";
            methodDes = "(Ljava/lang/Object;J)J";
        } else if (fieldClass == Float.TYPE) {
            methodName = "getFloat";
            methodDes = "(Ljava/lang/Object;J)F";
        } else if (fieldClass == Double.TYPE) {
            methodName = "getDouble";
            methodDes = "(Ljava/lang/Object;J)D";
        } else if (fieldClass == Character.TYPE) {
            methodName = "getChar";
            methodDes = "(Ljava/lang/Object;J)C";
        } else if (fieldClass == Byte.TYPE) {
            methodName = "getByte";
            methodDes = "(Ljava/lang/Object;J)B";
        } else if (fieldClass == Short.TYPE) {
            methodName = "getShort";
            methodDes = "(Ljava/lang/Object;J)S";
        } else if (fieldClass == Boolean.TYPE) {
            methodName = "getBoolean";
            methodDes = "(Ljava/lang/Object;J)Z";
        } else {
            methodName = "getObject";
            methodDes = "(Ljava/lang/Object;J)Ljava/lang/Object;";
            if (fieldClass.isEnum()) {
                castToType = "java/lang/Enum";
            } else if (ObjectWriterProvider.isPrimitiveOrEnum(fieldClass)) {
                castToType = ASMUtils.type(fieldClass);
            } else if (fieldClass.isArray() && ObjectWriterProvider.isPrimitiveOrEnum(fieldClass.getComponentType())) {
                castToType = ASMUtils.type(fieldClass);
            } else if (Map.class.isAssignableFrom(fieldClass)) {
                castToType = "java/util/Map";
            } else if (List.class.isAssignableFrom(fieldClass)) {
                castToType = "java/util/List";
            } else if (Collection.class.isAssignableFrom(fieldClass)) {
                castToType = "java/util/Collection";
            }
        }
        mw.getstatic(ObjectWriterCreatorASMUtils.TYPE_UNSAFE_UTILS, "UNSAFE", "Lsun/misc/Unsafe;");
        mw.aload(OBJECT);
        mw.visitLdcInsn(JDKUtils.UNSAFE.objectFieldOffset(field));
        mw.invokevirtual("sun/misc/Unsafe", methodName, methodDes);
        if (castToType != null) {
            mw.checkcast(castToType);
        }
    }

    static List<FieldWriterGroup> buildGroups(long beanFeatures, List<FieldWriter> fieldWriters) {
        ArrayList<FieldWriterGroup> groups = new ArrayList<FieldWriterGroup>();
        if (fieldWriters.isEmpty()) {
            FieldWriterGroup group = new FieldWriterGroup(true, false);
            group.end = true;
            groups.add(group);
            return groups;
        }
        FieldWriterGroup group = null;
        for (int i = 0; i < fieldWriters.size(); ++i) {
            FieldWriter item = fieldWriters.get(i);
            boolean direct = ObjectWriterCreatorASM.supportDirectWrite(beanFeatures, item);
            if (group == null || group.direct != direct) {
                group = new FieldWriterGroup(i == 0, direct);
                groups.add(group);
            }
            group.fieldWriters.add(new FieldWriterRecord(item, i));
            if (i != fieldWriters.size() - 1) continue;
            group.end = true;
        }
        return groups;
    }

    static boolean supportDirectWrite(long beanFeatures, FieldWriter fieldWriter) {
        if (JSONWriter.Feature.WriteNonStringValueAsString.mask == (beanFeatures & JSONWriter.Feature.WriteNonStringValueAsString.mask) || fieldWriter.format != null) {
            return false;
        }
        Class fieldClass = fieldWriter.fieldClass;
        if (Collection.class.isAssignableFrom(fieldClass)) {
            Class itemClass = fieldWriter.getItemClass();
            return itemClass == String.class || itemClass == Long.class;
        }
        return fieldClass == Byte.TYPE || fieldClass == Byte.class || fieldClass == Short.TYPE || fieldClass == Short.class || fieldClass == Integer.TYPE || fieldClass == Integer.class || fieldClass == Long.TYPE || fieldClass == Long.class || fieldClass == Float.TYPE || fieldClass == Float.class || fieldClass == Double.TYPE || fieldClass == Double.class || fieldClass == Boolean.TYPE || fieldClass == Boolean.class || fieldClass == String.class || fieldClass == String[].class || fieldClass == UUID.class || fieldClass == LocalDate.class || fieldClass == LocalDateTime.class || fieldClass == LocalTime.class || fieldClass == OffsetDateTime.class || fieldClass == OffsetTime.class || fieldClass == Instant.class || fieldWriter instanceof FieldWriterEnum;
    }

    static class MethodWriterContext {
        final ObjectWriterProvider provider;
        final Class objectClass;
        final long objectFeatures;
        final String classNameType;
        final MethodWriter mw;
        final Map<Object, Integer> variants = new LinkedHashMap<Object, Integer>();
        final boolean jsonb;
        int maxVariant;

        public MethodWriterContext(ObjectWriterProvider provider, Class objectClass, long objectFeatures, String classNameType, MethodWriter mw, int maxVariant, boolean jsonb) {
            this.provider = provider;
            this.objectClass = objectClass;
            this.objectFeatures = objectFeatures;
            this.classNameType = classNameType;
            this.mw = mw;
            this.jsonb = jsonb;
            this.maxVariant = maxVariant;
        }

        int var(Object key) {
            Integer var = this.variants.get(key);
            if (var == null) {
                var = this.maxVariant;
                this.variants.put(key, var);
                this.maxVariant = key == Long.TYPE || key == Double.TYPE ? (this.maxVariant += 2) : ++this.maxVariant;
            }
            return var;
        }

        int var2(Object key) {
            Integer var = this.variants.get(key);
            if (var == null) {
                var = this.maxVariant;
                this.variants.put(key, var);
                this.maxVariant += 2;
            }
            return var;
        }

        void genVariantsMethodBefore(boolean jsonb) {
            Label l1;
            Label notDefault_ = new Label();
            Label LEnd = new Label();
            this.mw.aload(1);
            this.mw.invokevirtual(ASMUtils.TYPE_JSON_WRITER, "getFeatures", "()J");
            this.mw.lstore(this.var2(ObjectWriterCreatorASM.CONTEXT_FEATURES));
            if (!jsonb) {
                l1 = new Label();
                Label l2 = new Label();
                this.mw.aload(1);
                this.mw.getfield(ASMUtils.TYPE_JSON_WRITER, "useSingleQuote", "Z");
                this.mw.ifne(l1);
                this.mw.lload(this.var2(ObjectWriterCreatorASM.CONTEXT_FEATURES));
                this.mw.visitLdcInsn(JSONWriter.Feature.UnquoteFieldName.mask | JSONWriter.Feature.UseSingleQuotes.mask);
                this.mw.land();
                this.mw.lconst_0();
                this.mw.lcmp();
                this.mw.ifne(l1);
                this.mw.iconst_1();
                this.mw.goto_(l2);
                this.mw.visitLabel(l1);
                this.mw.iconst_0();
                this.mw.visitLabel(l2);
                this.mw.istore(this.var2(ObjectWriterCreatorASM.NAME_DIRECT));
            } else {
                l1 = new Label();
                Label l2 = new Label();
                this.mw.aload(1);
                this.mw.getfield(ASMUtils.TYPE_JSON_WRITER, "symbolTable", DESC_SYMBOL);
                this.mw.ifnonnull(l1);
                this.mw.lload(this.var2(ObjectWriterCreatorASM.CONTEXT_FEATURES));
                this.mw.visitLdcInsn(JSONWriter.Feature.WriteNameAsSymbol.mask);
                this.mw.land();
                this.mw.lconst_0();
                this.mw.lcmp();
                this.mw.ifne(l1);
                this.mw.iconst_1();
                this.mw.goto_(l2);
                this.mw.visitLabel(l1);
                this.mw.iconst_0();
                this.mw.visitLabel(l2);
                this.mw.istore(this.var2(ObjectWriterCreatorASM.NAME_DIRECT));
            }
            this.genIsEnabledAndAssign(JSONWriter.Feature.NotWriteDefaultValue.mask, this.var(ObjectWriterCreatorASM.NOT_WRITE_DEFAULT_VALUE));
            this.mw.iload(this.var(ObjectWriterCreatorASM.NOT_WRITE_DEFAULT_VALUE));
            this.mw.ifeq(notDefault_);
            this.mw.iconst_0();
            this.mw.istore(this.var(ObjectWriterCreatorASM.WRITE_NULLS));
            this.mw.goto_(LEnd);
            this.mw.visitLabel(notDefault_);
            long features = JSONWriter.Feature.WriteNulls.mask | JSONWriter.Feature.NullAsDefaultValue.mask;
            this.genIsEnabledAndAssign(features, this.var(ObjectWriterCreatorASM.WRITE_NULLS));
            this.mw.visitLabel(LEnd);
        }

        void genIsEnabled(long features, Label elseLabel) {
            this.mw.lload(this.var2(ObjectWriterCreatorASM.CONTEXT_FEATURES));
            this.mw.visitLdcInsn(features);
            this.mw.land();
            this.mw.lconst_0();
            this.mw.lcmp();
            if (elseLabel != null) {
                this.mw.ifeq(elseLabel);
            }
        }

        void genIsEnabled(long fieldFeatures, long features, Label elseLabel) {
            this.mw.lload(this.var2(ObjectWriterCreatorASM.CONTEXT_FEATURES));
            this.mw.visitLdcInsn(fieldFeatures);
            this.mw.lor();
            this.mw.visitLdcInsn(features);
            this.mw.land();
            this.mw.lconst_0();
            this.mw.lcmp();
            if (elseLabel != null) {
                this.mw.ifeq(elseLabel);
            }
        }

        void genIsDisabled(long features, Label elseLabel) {
            this.mw.lload(this.var2(ObjectWriterCreatorASM.CONTEXT_FEATURES));
            this.mw.visitLdcInsn(features);
            this.mw.land();
            this.mw.lconst_0();
            this.mw.lcmp();
            this.mw.ifne(elseLabel);
        }

        void genIsEnabled(long features, Label trueLabel, Label falseLabel) {
            this.mw.lload(this.var2(ObjectWriterCreatorASM.CONTEXT_FEATURES));
            this.mw.visitLdcInsn(features);
            this.mw.land();
            this.mw.lconst_0();
            this.mw.lcmp();
            this.mw.ifeq(falseLabel);
            this.mw.goto_(trueLabel);
        }

        void genIsEnabledAndAssign(long features, int var) {
            this.mw.lload(this.var2(ObjectWriterCreatorASM.CONTEXT_FEATURES));
            this.mw.visitLdcInsn(features);
            this.mw.land();
            this.mw.lconst_0();
            this.mw.lcmp();
            this.mw.istore(var);
        }

        private void loadFieldType(int fieldIndex, Type fieldType) {
            if (fieldType instanceof Class && fieldType.getTypeName().startsWith("java")) {
                this.mw.visitLdcInsn((Class)fieldType);
                return;
            }
            this.mw.aload(0);
            this.mw.getfield(this.classNameType, ObjectWriterCreatorASM.fieldWriter(fieldIndex), ASMUtils.DESC_FIELD_WRITER);
            this.mw.getfield(ASMUtils.TYPE_FIELD_WRITER, "fieldType", "Ljava/lang/reflect/Type;");
        }

        private void loadFieldClass(int fieldIndex, Class fieldClass) {
            if (fieldClass.getName().startsWith("java")) {
                this.mw.visitLdcInsn(fieldClass);
                return;
            }
            this.mw.aload(0);
            this.mw.getfield(this.classNameType, ObjectWriterCreatorASM.fieldWriter(fieldIndex), ASMUtils.DESC_FIELD_WRITER);
            this.mw.getfield(ASMUtils.TYPE_FIELD_WRITER, "fieldClass", "Ljava/lang/Class;");
        }

        private void ldcIFEQ(String varName, Number name1, Number name1SQ) {
            if (name1.longValue() == name1SQ.longValue()) {
                this.mw.visitLdcInsn(name1);
                return;
            }
            Label L1 = new Label();
            Label L2 = new Label();
            this.mw.iload(this.var(varName));
            this.mw.ifeq(L1);
            this.mw.visitLdcInsn(name1);
            this.mw.goto_(L2);
            this.mw.visitLabel(L1);
            this.mw.visitLdcInsn(name1SQ);
            this.mw.visitLabel(L2);
        }

        public boolean disableSupportArrayMapping() {
            return (this.objectFeatures & 0x400000000000000L) != 0L;
        }

        public boolean disableReferenceDetect() {
            return (this.objectFeatures & 0x200000000000000L) != 0L;
        }

        public boolean disableSmartMatch() {
            return (this.objectFeatures & 0x400000000000000L) != 0L;
        }

        public boolean disableAutoType() {
            return (this.objectFeatures & 0x800000000000000L) != 0L;
        }

        public boolean disableJSONB() {
            return (this.objectFeatures & 0x1000000000000000L) != 0L;
        }
    }

    static class FieldWriterGroup {
        final boolean start;
        final boolean direct;
        boolean end;
        final List<FieldWriterRecord> fieldWriters = new ArrayList<FieldWriterRecord>();

        public FieldWriterGroup(boolean start, boolean direct) {
            this.start = start;
            this.direct = direct;
        }
    }

    static final class FieldWriterRecord {
        final FieldWriter fieldWriter;
        final int ordinal;

        public FieldWriterRecord(FieldWriter fieldWriter, int ordinal) {
            this.fieldWriter = fieldWriter;
            this.ordinal = ordinal;
        }

        static List<FieldWriterRecord> of(List<FieldWriter> fieldWriters) {
            ArrayList<FieldWriterRecord> records = new ArrayList<FieldWriterRecord>();
            for (int i = 0; i < fieldWriters.size(); ++i) {
                records.add(new FieldWriterRecord(fieldWriters.get(i), i));
            }
            return records;
        }
    }
}

