/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONReaderASCII;
import com.alibaba.fastjson2.JSONReaderJSONB;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.JSONWriterUTF8;
import com.alibaba.fastjson2.reader.ValueConsumer;
import com.alibaba.fastjson2.util.DateUtils;
import com.alibaba.fastjson2.util.IOUtils;
import com.alibaba.fastjson2.util.JDKUtils;
import com.alibaba.fastjson2.util.TypeUtils;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Base64;
import java.util.Date;
import java.util.List;
import java.util.UUID;

class JSONReaderUTF8
extends JSONReader {
    static final int REF = JDKUtils.BIG_ENDIAN ? 611476838 : 1717924388;
    static final int ESCAPE_INDEX_NOT_SET = -2;
    protected int nextEscapeIndex = -2;
    protected final byte[] bytes;
    protected final int length;
    protected final int start;
    protected final int end;
    protected int nameBegin;
    protected int nameEnd;
    protected int nameLength;
    protected boolean nameAscii;
    protected int referenceBegin;
    protected final InputStream in;
    protected JSONFactory.CacheItem cacheItem;
    protected char[] charBuf;

    JSONReaderUTF8(JSONReader.Context ctx, InputStream is) {
        super(ctx, false, true);
        int cacheIndex = System.identityHashCode(Thread.currentThread()) & JSONFactory.CACHE_ITEMS.length - 1;
        this.cacheItem = JSONFactory.CACHE_ITEMS[cacheIndex];
        byte[] bytes = JSONFactory.BYTES_UPDATER.getAndSet(this.cacheItem, null);
        int bufferSize = ctx.bufferSize;
        if (bytes == null) {
            bytes = new byte[bufferSize];
        }
        int off = 0;
        try {
            int n;
            while ((n = is.read(bytes, off, bytes.length - off)) != -1) {
                if ((off += n) != bytes.length) continue;
                bytes = Arrays.copyOf(bytes, bytes.length + bufferSize);
            }
        }
        catch (IOException ioe) {
            throw new JSONException("read error", ioe);
        }
        this.bytes = bytes;
        this.offset = 0;
        this.length = off;
        this.in = is;
        this.start = 0;
        this.end = this.length;
        this.next();
        if (this.ch == '/') {
            this.skipComment();
        }
    }

    JSONReaderUTF8(JSONReader.Context ctx, ByteBuffer buffer) {
        super(ctx, false, true);
        int cacheIndex = System.identityHashCode(Thread.currentThread()) & JSONFactory.CACHE_ITEMS.length - 1;
        this.cacheItem = JSONFactory.CACHE_ITEMS[cacheIndex];
        byte[] bytes = JSONFactory.BYTES_UPDATER.getAndSet(this.cacheItem, null);
        int remaining = buffer.remaining();
        if (bytes == null || bytes.length < remaining) {
            bytes = new byte[remaining];
        }
        buffer.get(bytes, 0, remaining);
        this.bytes = bytes;
        this.offset = 0;
        this.length = remaining;
        this.in = null;
        this.start = 0;
        this.end = this.length;
        this.next();
        if (this.ch == '/') {
            this.skipComment();
        }
    }

    JSONReaderUTF8(JSONReader.Context ctx, byte[] bytes, int offset, int length) {
        super(ctx, false, true);
        this.bytes = bytes;
        this.offset = offset;
        this.length = length;
        this.in = null;
        this.start = offset;
        this.end = offset + length;
        this.cacheItem = null;
        this.next();
    }

    static int indexOfSlash(JSONReaderUTF8 jsonReader, byte[] bytes, int offset, int end) {
        int slashIndex = jsonReader.nextEscapeIndex;
        if (slashIndex == -2 || slashIndex != -1 && slashIndex < offset) {
            jsonReader.nextEscapeIndex = slashIndex = IOUtils.indexOfSlash(bytes, offset, end);
        }
        return slashIndex;
    }

    private void char_utf8(int ch, int offset) {
        byte[] bytes = this.bytes;
        switch ((ch & 0xFF) >> 4) {
            case 12: 
            case 13: {
                ch = JSONReaderUTF8.char2_utf8(ch & 0xFF, bytes[offset++], offset);
                break;
            }
            case 14: {
                ch = JSONReaderUTF8.char2_utf8(ch & 0xFF, bytes[offset], bytes[offset + 1], offset);
                offset += 2;
                break;
            }
            default: {
                if (ch >> 3 == -2) {
                    byte c2 = bytes[offset];
                    byte c3 = bytes[offset + 1];
                    byte c4 = bytes[offset + 2];
                    ch = ch << 18 ^ c2 << 12 ^ c3 << 6 ^ (c4 ^ 0x381F80);
                    offset += 3;
                    break;
                }
                throw new JSONException("malformed input around byte " + offset);
            }
        }
        this.ch = (char)ch;
        this.offset = offset;
    }

    static int char2_utf8(int ch, int char2, int offset) {
        if ((char2 & 0xC0) != 128) {
            throw new JSONException("malformed input around byte " + offset);
        }
        return (ch & 0x1F) << 6 | char2 & 0x3F;
    }

    static int char2_utf8(int ch, int char2, int char3, int offset) {
        if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
            throw new JSONException("malformed input around byte " + offset);
        }
        return (ch & 0xF) << 12 | (char2 & 0x3F) << 6 | char3 & 0x3F;
    }

    static void char2_utf8(byte[] bytes, int offset, int c, char[] chars, int charPos) {
        if (c >> 3 == -2) {
            byte c2 = bytes[offset + 1];
            byte c3 = bytes[offset + 2];
            byte c4 = bytes[offset + 3];
            int uc = c << 18 ^ c2 << 12 ^ c3 << 6 ^ (c4 ^ 0x381F80);
            if ((c2 & 0xC0) != 128 || (c3 & 0xC0) != 128 || (c4 & 0xC0) != 128 || uc < 65536 || uc >= 0x110000) {
                throw new JSONException("malformed input around byte " + offset);
            }
            chars[charPos] = (char)((uc >>> 10) + 55232);
            chars[charPos + 1] = (char)((uc & 0x3FF) + 56320);
            return;
        }
        throw new JSONException("malformed input around byte " + offset);
    }

    @Override
    public final boolean nextIfMatch(char e) {
        byte[] bytes = this.bytes;
        int offset = this.offset;
        char ch = this.ch;
        while (ch <= ' ' && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == this.end ? (char)'\u001a' : bytes[offset++];
        }
        if (ch != e) {
            return false;
        }
        char c = ch = offset == this.end ? (char)'\u001a' : bytes[offset++];
        while (ch == '\u0000' || ch <= ' ' && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == this.end ? (char)'\u001a' : bytes[offset++];
        }
        if (ch < '\u0000') {
            this.char_utf8(ch, offset);
            return true;
        }
        this.offset = offset;
        this.ch = ch;
        if (ch == '/') {
            this.skipComment();
        }
        return true;
    }

    @Override
    public final boolean nextIfComma() {
        byte[] bytes = this.bytes;
        int offset = this.offset;
        int ch = this.ch;
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == this.end ? 26 : bytes[offset++];
        }
        if (ch != 44) {
            this.offset = offset;
            this.ch = (char)ch;
            return false;
        }
        int n = ch = offset == this.end ? 26 : bytes[offset++];
        while (ch == 0 || ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == this.end ? 26 : bytes[offset++];
        }
        if (ch < 0) {
            this.char_utf8(ch, offset);
            return true;
        }
        this.offset = offset;
        this.ch = (char)ch;
        if (ch == 47) {
            this.skipComment();
        }
        return true;
    }

    @Override
    public final boolean nextIfArrayStart() {
        int ch = this.ch;
        if (ch != 91) {
            return false;
        }
        byte[] bytes = this.bytes;
        int offset = this.offset;
        int n = ch = offset == this.end ? 26 : bytes[offset++];
        while (ch == 0 || ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == this.end ? 26 : bytes[offset++];
        }
        if (ch < 0) {
            this.char_utf8(ch, offset);
            return true;
        }
        this.ch = (char)ch;
        this.offset = offset;
        if (ch == 47) {
            this.skipComment();
        }
        return true;
    }

    @Override
    public final boolean nextIfArrayEnd() {
        int ch = this.ch;
        byte[] bytes = this.bytes;
        int offset = this.offset;
        if (ch != 93) {
            return false;
        }
        int n = ch = offset == this.end ? 26 : bytes[offset++];
        while (ch == 0 || ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == this.end ? 26 : bytes[offset++];
        }
        if (ch == 44) {
            this.comma = true;
            int n2 = ch = offset == this.end ? 26 : bytes[offset++];
            while (ch == 0 || ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                ch = offset == this.end ? 26 : bytes[offset++];
            }
        }
        if (ch < 0) {
            this.char_utf8(ch, offset);
            return true;
        }
        this.ch = (char)ch;
        this.offset = offset;
        if (ch == 47) {
            this.skipComment();
        }
        return true;
    }

    @Override
    public final boolean nextIfSet() {
        byte[] bytes = this.bytes;
        int offset = this.offset;
        int ch = this.ch;
        if (ch == 83 && offset + 1 < this.end && bytes[offset] == 101 && bytes[offset + 1] == 116) {
            int n = ch = (offset += 2) == this.end ? 26 : bytes[offset++];
            while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                ch = offset == this.end ? 26 : bytes[offset++];
            }
            this.offset = offset;
            this.ch = (char)ch;
            return true;
        }
        return false;
    }

    @Override
    public final boolean nextIfInfinity() {
        byte[] bytes = this.bytes;
        int offset = this.offset;
        int ch = this.ch;
        if (ch == 73 && offset + 6 < this.end && bytes[offset] == 110 && bytes[offset + 1] == 102 && bytes[offset + 2] == 105 && bytes[offset + 3] == 110 && bytes[offset + 4] == 105 && bytes[offset + 5] == 116 && bytes[offset + 6] == 121) {
            int n = ch = (offset += 7) == this.end ? 26 : bytes[offset++];
            while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                ch = offset == this.end ? 26 : bytes[offset++];
            }
            this.offset = offset;
            this.ch = (char)ch;
            return true;
        }
        return false;
    }

    @Override
    public boolean nextIfObjectStart() {
        int ch = this.ch;
        if (ch != 123) {
            return false;
        }
        byte[] bytes = this.bytes;
        int offset = this.offset;
        int n = ch = offset == this.end ? 26 : bytes[offset++];
        while (ch == 0 || ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == this.end ? 26 : bytes[offset++];
        }
        if (ch < 0) {
            this.char_utf8(ch, offset);
            return true;
        }
        this.ch = (char)ch;
        this.offset = offset;
        if (ch == 47) {
            this.skipComment();
        }
        return true;
    }

    @Override
    public final boolean nextIfObjectEnd() {
        int ch = this.ch;
        byte[] bytes = this.bytes;
        int offset = this.offset;
        if (ch != 125) {
            return false;
        }
        int n = ch = offset == this.end ? 26 : bytes[offset++];
        while (ch == 0 || ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == this.end ? 26 : bytes[offset++];
        }
        if (ch == 44) {
            this.comma = true;
            int n2 = ch = offset == this.end ? 26 : bytes[offset++];
            while (ch == 0 || ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                ch = offset == this.end ? 26 : bytes[offset++];
            }
        }
        if (ch < 0) {
            this.char_utf8(ch, offset);
            return true;
        }
        this.ch = (char)ch;
        this.offset = offset;
        if (ch == 47) {
            this.skipComment();
        }
        return true;
    }

    @Override
    public void next() {
        int ch;
        byte[] bytes = this.bytes;
        int offset = this.offset;
        int n = ch = offset >= this.end ? 26 : bytes[offset++];
        while (ch == 0 || ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == this.end ? 26 : bytes[offset++];
        }
        if (ch < 0) {
            this.char_utf8(ch, offset);
            return;
        }
        this.offset = offset;
        this.ch = (char)ch;
        if (ch == 47) {
            this.skipComment();
        }
    }

    @Override
    public final void nextWithoutComment() {
        int ch;
        byte[] bytes = this.bytes;
        int offset = this.offset;
        int n = ch = offset >= this.end ? 26 : bytes[offset++];
        while (ch == 0 || ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == this.end ? 26 : bytes[offset++];
        }
        if (ch < 0) {
            this.char_utf8(ch, offset);
            return;
        }
        this.offset = offset;
        this.ch = (char)ch;
    }

    @Override
    public long readFieldNameHashCodeUnquote() {
        long hashCode;
        this.nameEscape = false;
        int offset = this.offset;
        int end = this.end;
        byte[] bytes = this.bytes;
        int ch = this.ch;
        this.nameBegin = offset - 1;
        int first = ch;
        long nameValue = 0L;
        int i = 0;
        block34: while (offset <= end) {
            switch (ch) {
                case 8: 
                case 9: 
                case 10: 
                case 12: 
                case 13: 
                case 26: 
                case 32: 
                case 33: 
                case 38: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 58: 
                case 60: 
                case 61: 
                case 62: 
                case 91: 
                case 93: 
                case 123: 
                case 124: 
                case 125: {
                    this.nameLength = i;
                    int n = this.nameEnd = ch == 26 ? offset : offset - 1;
                    if (ch > 32 || (1L << ch & 0x100003700L) == 0L) break block34;
                    ch = (char)(offset == end ? 26 : (char)bytes[offset++]);
                    break block34;
                }
                default: {
                    if (ch == 92) {
                        this.nameEscape = true;
                        ch = (char)bytes[offset++];
                        switch (ch) {
                            case 117: {
                                ch = IOUtils.hexDigit4(bytes, JSONReaderJSONB.check3(offset, end));
                                offset += 4;
                                break;
                            }
                            case 120: {
                                ch = JSONReaderUTF8.char2(bytes[offset], bytes[offset + 1]);
                                offset += 2;
                                break;
                            }
                            case 34: 
                            case 42: 
                            case 43: 
                            case 45: 
                            case 46: 
                            case 47: 
                            case 58: 
                            case 60: 
                            case 61: 
                            case 62: 
                            case 64: 
                            case 92: {
                                break;
                            }
                            default: {
                                ch = this.char1(ch);
                            }
                        }
                    }
                    if (ch < 0) {
                        switch ((ch & 0xFF) >> 4) {
                            case 12: 
                            case 13: {
                                ch = JSONReaderUTF8.char2_utf8(ch & 0xFF, bytes[offset++], offset);
                                break;
                            }
                            case 14: {
                                ch = JSONReaderUTF8.char2_utf8(ch & 0xFF, bytes[offset], bytes[offset + 1], offset);
                                offset += 2;
                                break;
                            }
                            default: {
                                if (ch >> 3 == -2) {
                                    byte c2 = bytes[offset];
                                    byte c3 = bytes[offset + 1];
                                    byte c4 = bytes[offset + 2];
                                    ch = ch << 18 ^ c2 << 12 ^ c3 << 6 ^ (c4 ^ 0x381F80);
                                    break;
                                }
                                throw new JSONException("malformed input around byte " + offset);
                            }
                        }
                    }
                    if (ch > 255 || i >= 8 || i == 0 && ch == 0) {
                        nameValue = 0L;
                        ch = first;
                        offset = this.nameBegin + 1;
                        break block34;
                    }
                    byte c = (byte)ch;
                    switch (i) {
                        case 0: {
                            nameValue = c;
                            break;
                        }
                        case 1: {
                            nameValue = (long)(c << 8) + (nameValue & 0xFFL);
                            break;
                        }
                        case 2: {
                            nameValue = (long)(c << 16) + (nameValue & 0xFFFFL);
                            break;
                        }
                        case 3: {
                            nameValue = (long)(c << 24) + (nameValue & 0xFFFFFFL);
                            break;
                        }
                        case 4: {
                            nameValue = ((long)c << 32) + (nameValue & 0xFFFFFFFFL);
                            break;
                        }
                        case 5: {
                            nameValue = ((long)c << 40) + (nameValue & 0xFFFFFFFFFFL);
                            break;
                        }
                        case 6: {
                            nameValue = ((long)c << 48) + (nameValue & 0xFFFFFFFFFFFFL);
                            break;
                        }
                        case 7: {
                            nameValue = ((long)c << 56) + (nameValue & 0xFFFFFFFFFFFFFFL);
                            break;
                        }
                    }
                    ch = offset == end ? 26 : bytes[offset++];
                    ++i;
                    continue block34;
                }
            }
        }
        if (nameValue != 0L) {
            hashCode = nameValue;
        } else {
            hashCode = -3750763034362895579L;
            int i2 = 0;
            block35: while (true) {
                if (ch == 92) {
                    this.nameEscape = true;
                    ch = bytes[offset++];
                    switch (ch) {
                        case 117: {
                            ch = IOUtils.hexDigit4(bytes, JSONReaderJSONB.check3(offset, end));
                            offset += 4;
                            break;
                        }
                        case 120: {
                            ch = JSONReaderUTF8.char2(bytes[offset], bytes[offset + 1]);
                            offset += 2;
                            break;
                        }
                        case 34: 
                        case 42: 
                        case 43: 
                        case 45: 
                        case 46: 
                        case 47: 
                        case 58: 
                        case 60: 
                        case 61: 
                        case 62: 
                        case 64: 
                        case 92: {
                            break;
                        }
                        default: {
                            ch = this.char1(ch);
                        }
                    }
                    hashCode ^= (long)ch;
                    hashCode *= 1099511628211L;
                    ch = offset == end ? 26 : bytes[offset++];
                } else {
                    switch (ch) {
                        case 8: 
                        case 9: 
                        case 10: 
                        case 12: 
                        case 13: 
                        case 26: 
                        case 32: 
                        case 33: 
                        case 40: 
                        case 41: 
                        case 42: 
                        case 43: 
                        case 44: 
                        case 45: 
                        case 46: 
                        case 47: 
                        case 58: 
                        case 60: 
                        case 61: 
                        case 62: 
                        case 91: 
                        case 93: 
                        case 123: 
                        case 125: {
                            this.nameLength = i2;
                            int n = this.nameEnd = ch == 26 ? offset : offset - 1;
                            while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                                ch = offset == end ? 26 : bytes[offset++];
                            }
                            break block35;
                        }
                        default: {
                            if (ch < 0) {
                                switch ((ch & 0xFF) >> 4) {
                                    case 12: 
                                    case 13: {
                                        ch = JSONReaderUTF8.char2_utf8(ch & 0xFF, bytes[offset++], offset);
                                        this.nameAscii = false;
                                        break;
                                    }
                                    case 14: {
                                        ch = JSONReaderUTF8.char2_utf8(ch & 0xFF, bytes[offset], bytes[offset + 1], offset);
                                        offset += 2;
                                        this.nameAscii = false;
                                        break;
                                    }
                                    default: {
                                        if (ch >> 3 == -2) {
                                            byte c2 = bytes[offset];
                                            byte c3 = bytes[offset + 1];
                                            byte c4 = bytes[offset + 2];
                                            ch = ch << 18 ^ c2 << 12 ^ c3 << 6 ^ (c4 ^ 0x381F80);
                                            offset += 3;
                                            this.nameAscii = false;
                                            break;
                                        }
                                        throw new JSONException("malformed input around byte " + offset);
                                    }
                                }
                            }
                            if (ch > 65535) {
                                int c0 = (ch >>> 10) + 55232;
                                hashCode ^= (long)c0;
                                hashCode *= 1099511628211L;
                                int c1 = (ch & 0x3FF) + 56320;
                                hashCode ^= (long)c1;
                            } else {
                                hashCode ^= (long)ch;
                            }
                            hashCode *= 1099511628211L;
                            ch = offset == end ? 26 : bytes[offset++];
                        }
                    }
                }
                ++i2;
            }
        }
        if (ch == 58) {
            ch = (char)(offset == end ? 26 : (char)bytes[offset++]);
            char c = (char)ch;
            while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                ch = offset == end ? 26 : bytes[offset++];
            }
        }
        this.offset = offset;
        this.ch = (char)ch;
        return hashCode;
    }

    @Override
    public final int getRawInt() {
        if (this.offset + 3 < this.bytes.length) {
            return JDKUtils.UNSAFE.getInt(this.bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)this.offset - 1L);
        }
        return 0;
    }

    @Override
    public final long getRawLong() {
        if (this.offset + 8 < this.bytes.length) {
            return JDKUtils.UNSAFE.getLong(this.bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)this.offset - 1L);
        }
        return 0L;
    }

    @Override
    public final boolean nextIfName8Match2() {
        int c;
        byte[] bytes = this.bytes;
        int offset = this.offset;
        if ((offset += 9) >= this.end || bytes[offset - 2] != 34 || bytes[offset - 1] != 58) {
            return false;
        }
        while ((c = bytes[offset] & 0xFF) <= 32 && (1L << c & 0x100003700L) != 0L) {
            ++offset;
        }
        this.offset = offset + 1;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfName8Match1() {
        int c;
        byte[] bytes = this.bytes;
        int offset = this.offset;
        if ((offset += 8) >= this.end || bytes[offset - 1] != 58) {
            return false;
        }
        while ((c = bytes[offset] & 0xFF) <= 32 && (1L << c & 0x100003700L) != 0L) {
            ++offset;
        }
        this.offset = offset + 1;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfName8Match0() {
        int c;
        byte[] bytes = this.bytes;
        int offset = this.offset;
        if ((offset += 7) == this.end) {
            this.ch = (char)26;
            return false;
        }
        while ((c = bytes[offset] & 0xFF) <= 32 && (1L << c & 0x100003700L) != 0L) {
            ++offset;
        }
        this.offset = offset + 1;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match2() {
        int c;
        byte[] bytes = this.bytes;
        int offset = this.offset + 4;
        if (offset >= this.end || bytes[offset - 1] != 58) {
            return false;
        }
        while ((c = bytes[offset++] & 0xFF) <= 32 && (1L << c & 0x100003700L) != 0L) {
        }
        this.offset = offset;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match3() {
        int c;
        byte[] bytes = this.bytes;
        int offset = this.offset + 5;
        if (offset >= this.end || bytes[offset - 2] != 34 || bytes[offset - 1] != 58) {
            return false;
        }
        while ((c = bytes[offset] & 0xFF) <= 32 && (1L << c & 0x100003700L) != 0L) {
            ++offset;
        }
        this.offset = offset + 1;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match4(byte c4) {
        int c;
        byte[] bytes = this.bytes;
        int offset = this.offset + 6;
        if (offset >= this.end || bytes[offset - 3] != c4 || bytes[offset - 2] != 34 || bytes[offset - 1] != 58) {
            return false;
        }
        while ((c = bytes[offset++] & 0xFF) <= 32 && (1L << c & 0x100003700L) != 0L) {
        }
        this.offset = offset;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match5(int name1) {
        int c;
        byte[] bytes = this.bytes;
        int offset = this.offset + 7;
        if (offset >= this.end || JDKUtils.UNSAFE.getInt(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 4L) != name1) {
            return false;
        }
        while ((c = bytes[offset++] & 0xFF) <= 32 && (1L << c & 0x100003700L) != 0L) {
        }
        this.offset = offset;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match6(int name1) {
        int c;
        byte[] bytes = this.bytes;
        int offset = this.offset + 8;
        if (offset >= this.end || JDKUtils.UNSAFE.getInt(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 5L) != name1 || bytes[offset - 1] != 58) {
            return false;
        }
        while ((c = bytes[offset++] & 0xFF) <= 32 && (1L << c & 0x100003700L) != 0L) {
        }
        this.offset = offset;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match7(int name1) {
        int c;
        byte[] bytes = this.bytes;
        int offset = this.offset + 9;
        if (offset >= this.end || JDKUtils.UNSAFE.getInt(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 6L) != name1 || bytes[offset - 2] != 34 || bytes[offset - 1] != 58) {
            return false;
        }
        while ((c = bytes[offset++] & 0xFF) <= 32 && (1L << c & 0x100003700L) != 0L) {
        }
        this.offset = offset;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match8(int name1, byte c8) {
        int c;
        int offset = this.offset + 10;
        byte[] bytes = this.bytes;
        if (offset >= this.end || JDKUtils.UNSAFE.getInt(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 7L) != name1 || bytes[offset - 3] != c8 || bytes[offset - 2] != 34 || bytes[offset - 1] != 58) {
            return false;
        }
        while ((c = bytes[offset++] & 0xFF) <= 32 && (1L << c & 0x100003700L) != 0L) {
        }
        this.offset = offset;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match9(long name1) {
        int c;
        byte[] bytes = this.bytes;
        int offset = this.offset + 11;
        if (offset >= this.end || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 8L) != name1) {
            return false;
        }
        while ((c = bytes[offset++] & 0xFF) <= 32 && (1L << c & 0x100003700L) != 0L) {
        }
        this.offset = offset;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match10(long name1) {
        int c;
        byte[] bytes = this.bytes;
        int offset = this.offset + 12;
        if (offset >= this.end || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 9L) != name1 || bytes[offset - 1] != 58) {
            return false;
        }
        while ((c = bytes[offset++] & 0xFF) <= 32 && (1L << c & 0x100003700L) != 0L) {
        }
        this.offset = offset;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match11(long name1) {
        int c;
        byte[] bytes = this.bytes;
        int offset = this.offset + 13;
        if (offset >= this.end || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 10L) != name1 || bytes[offset - 2] != 34 || bytes[offset - 1] != 58) {
            return false;
        }
        while ((c = bytes[offset++] & 0xFF) <= 32 && (1L << c & 0x100003700L) != 0L) {
        }
        this.offset = offset;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match12(long name1, byte name2) {
        int c;
        byte[] bytes = this.bytes;
        int offset = this.offset + 14;
        if (offset >= this.end || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 11L) != name1 || bytes[offset - 3] != name2 || bytes[offset - 2] != 34 || bytes[offset - 1] != 58) {
            return false;
        }
        while ((c = bytes[offset++] & 0xFF) <= 32 && (1L << c & 0x100003700L) != 0L) {
        }
        this.offset = offset;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match13(long name1, int name2) {
        int c;
        byte[] bytes = this.bytes;
        int offset = this.offset + 15;
        if (offset >= this.end || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 12L) != name1 || JDKUtils.UNSAFE.getInt(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 4L) != name2) {
            return false;
        }
        while ((c = bytes[offset++] & 0xFF) <= 32 && (1L << c & 0x100003700L) != 0L) {
        }
        this.offset = offset;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match14(long name1, int name2) {
        int c;
        byte[] bytes = this.bytes;
        int offset = this.offset + 16;
        if (offset >= this.end || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 13L) != name1 || JDKUtils.UNSAFE.getInt(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 5L) != name2 || bytes[offset - 1] != 58) {
            return false;
        }
        while ((c = bytes[offset++] & 0xFF) <= 32 && (1L << c & 0x100003700L) != 0L) {
        }
        this.offset = offset;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match15(long name1, int name2) {
        int c;
        byte[] bytes = this.bytes;
        int offset = this.offset + 17;
        if (offset >= this.end || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 14L) != name1 || JDKUtils.UNSAFE.getInt(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 6L) != name2 || bytes[offset - 2] != 34 || bytes[offset - 1] != 58) {
            return false;
        }
        while ((c = bytes[offset++] & 0xFF) <= 32 && (1L << c & 0x100003700L) != 0L) {
        }
        this.offset = offset;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match16(long name1, int name2, byte name3) {
        int c;
        byte[] bytes = this.bytes;
        int offset = this.offset + 18;
        if (offset >= this.end || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 15L) != name1 || JDKUtils.UNSAFE.getInt(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 7L) != name2 || bytes[offset - 3] != name3 || bytes[offset - 2] != 34 || bytes[offset - 1] != 58) {
            return false;
        }
        while ((c = bytes[offset++] & 0xFF) <= 32 && (1L << c & 0x100003700L) != 0L) {
        }
        this.offset = offset;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match17(long name1, long name2) {
        int c;
        byte[] bytes = this.bytes;
        int offset = this.offset + 19;
        if (offset >= this.end) {
            return false;
        }
        if (JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 16L) != name1 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 8L) != name2) {
            return false;
        }
        while ((c = bytes[offset++] & 0xFF) <= 32 && (1L << c & 0x100003700L) != 0L) {
        }
        this.offset = offset;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match18(long name1, long name2) {
        int c;
        byte[] bytes = this.bytes;
        int offset = this.offset + 20;
        if (offset >= this.end) {
            return false;
        }
        if (JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 17L) != name1 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 9L) != name2 || bytes[offset - 1] != 58) {
            return false;
        }
        while ((c = bytes[offset++] & 0xFF) <= 32 && (1L << c & 0x100003700L) != 0L) {
        }
        this.offset = offset;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match19(long name1, long name2) {
        int c;
        byte[] bytes = this.bytes;
        int offset = this.offset + 21;
        if (offset >= this.end) {
            return false;
        }
        if (JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 18L) != name1 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 10L) != name2 || bytes[offset - 2] != 34 || bytes[offset - 1] != 58) {
            return false;
        }
        while ((c = bytes[offset++] & 0xFF) <= 32 && (1L << c & 0x100003700L) != 0L) {
        }
        this.offset = offset;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match20(long name1, long name2, byte name3) {
        int c;
        byte[] bytes = this.bytes;
        int offset = this.offset + 22;
        if (offset >= this.end) {
            return false;
        }
        if (JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 19L) != name1 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 11L) != name2 || bytes[offset - 3] != name3 || bytes[offset - 2] != 34 || bytes[offset - 1] != 58) {
            return false;
        }
        while ((c = bytes[offset++] & 0xFF) <= 32 && (1L << c & 0x100003700L) != 0L) {
        }
        this.offset = offset;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match21(long name1, long name2, int name3) {
        int c;
        byte[] bytes = this.bytes;
        int offset = this.offset + 23;
        if (offset >= this.end) {
            return false;
        }
        if (JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 20L) != name1 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 12L) != name2 || JDKUtils.UNSAFE.getInt(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 4L) != name3) {
            return false;
        }
        while ((c = bytes[offset++] & 0xFF) <= 32 && (1L << c & 0x100003700L) != 0L) {
        }
        this.offset = offset;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match22(long name1, long name2, int name3) {
        int c;
        byte[] bytes = this.bytes;
        int offset = this.offset + 24;
        if (offset >= this.end) {
            return false;
        }
        if (JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 21L) != name1 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 13L) != name2 || JDKUtils.UNSAFE.getInt(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 5L) != name3 || bytes[offset - 1] != 58) {
            return false;
        }
        while ((c = bytes[offset++] & 0xFF) <= 32 && (1L << c & 0x100003700L) != 0L) {
        }
        this.offset = offset;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match23(long name1, long name2, int name3) {
        int c;
        byte[] bytes = this.bytes;
        int offset = this.offset + 25;
        if (offset >= this.end) {
            return false;
        }
        if (JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 22L) != name1 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 14L) != name2 || JDKUtils.UNSAFE.getInt(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 6L) != name3 || bytes[offset - 2] != 34 || bytes[offset - 1] != 58) {
            return false;
        }
        while ((c = bytes[offset++] & 0xFF) <= 32 && (1L << c & 0x100003700L) != 0L) {
        }
        this.offset = offset;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match24(long name1, long name2, int name3, byte name4) {
        int c;
        byte[] bytes = this.bytes;
        int offset = this.offset + 26;
        if (offset >= this.end) {
            return false;
        }
        if (JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 23L) != name1 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 15L) != name2 || JDKUtils.UNSAFE.getInt(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 7L) != name3 || bytes[offset - 3] != name4 || bytes[offset - 2] != 34 || bytes[offset - 1] != 58) {
            return false;
        }
        while ((c = bytes[offset++] & 0xFF) <= 32 && (1L << c & 0x100003700L) != 0L) {
        }
        this.offset = offset;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match25(long name1, long name2, long name3) {
        int c;
        byte[] bytes = this.bytes;
        int offset = this.offset + 27;
        if (offset >= this.end || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 24L) != name1 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 16L) != name2 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 8L) != name3) {
            return false;
        }
        while ((c = bytes[offset++] & 0xFF) <= 32 && (1L << c & 0x100003700L) != 0L) {
        }
        this.offset = offset;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match26(long name1, long name2, long name3) {
        int c;
        byte[] bytes = this.bytes;
        int offset = this.offset + 28;
        if (offset >= this.end || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 25L) != name1 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 17L) != name2 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 9L) != name3 || bytes[offset - 1] != 58) {
            return false;
        }
        while ((c = bytes[offset++] & 0xFF) <= 32 && (1L << c & 0x100003700L) != 0L) {
        }
        this.offset = offset;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match27(long name1, long name2, long name3) {
        int c;
        byte[] bytes = this.bytes;
        int offset = this.offset + 29;
        if (offset >= this.end || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 26L) != name1 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 18L) != name2 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 10L) != name3 || bytes[offset - 2] != 34 || bytes[offset - 1] != 58) {
            return false;
        }
        while ((c = bytes[offset++] & 0xFF) <= 32 && (1L << c & 0x100003700L) != 0L) {
        }
        this.offset = offset;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match28(long name1, long name2, long name3, byte c29) {
        int c;
        byte[] bytes = this.bytes;
        int offset = this.offset + 30;
        if (offset >= this.end || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 27L) != name1 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 19L) != name2 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 11L) != name3 || bytes[offset - 3] != c29 || bytes[offset - 2] != 34 || bytes[offset - 1] != 58) {
            return false;
        }
        while ((c = bytes[offset++] & 0xFF) <= 32 && (1L << c & 0x100003700L) != 0L) {
        }
        this.offset = offset;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match29(long name1, long name2, long name3, int name4) {
        int c;
        byte[] bytes = this.bytes;
        int offset = this.offset + 31;
        if (offset >= this.end || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 28L) != name1 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 20L) != name2 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 12L) != name3 || JDKUtils.UNSAFE.getInt(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 4L) != name4) {
            return false;
        }
        while ((c = bytes[offset++] & 0xFF) <= 32 && (1L << c & 0x100003700L) != 0L) {
        }
        this.offset = offset;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match30(long name1, long name2, long name3, int name4) {
        int c;
        byte[] bytes = this.bytes;
        int offset = this.offset + 32;
        if (offset >= this.end || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 29L) != name1 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 21L) != name2 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 13L) != name3 || JDKUtils.UNSAFE.getInt(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 5L) != name4 || bytes[offset - 1] != 58) {
            return false;
        }
        while ((c = bytes[offset++] & 0xFF) <= 32 && (1L << c & 0x100003700L) != 0L) {
        }
        this.offset = offset;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match31(long name1, long name2, long name3, int name4) {
        int c;
        byte[] bytes = this.bytes;
        int offset = this.offset + 33;
        if (offset >= this.end || bytes[offset - 2] != 34 || bytes[offset - 1] != 58 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 30L) != name1 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 22L) != name2 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 14L) != name3 || JDKUtils.UNSAFE.getInt(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 6L) != name4) {
            return false;
        }
        while ((c = bytes[offset++] & 0xFF) <= 32 && (1L << c & 0x100003700L) != 0L) {
        }
        this.offset = offset;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match32(long name1, long name2, long name3, int name4, byte c32) {
        int c;
        byte[] bytes = this.bytes;
        int offset = this.offset + 34;
        if (offset >= this.end) {
            return false;
        }
        if (JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 31L) != name1 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 23L) != name2 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 15L) != name3 || JDKUtils.UNSAFE.getInt(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 7L) != name4 || bytes[offset - 3] != c32 || bytes[offset - 2] != 34 || bytes[offset - 1] != 58) {
            return false;
        }
        while ((c = bytes[offset++] & 0xFF) <= 32 && (1L << c & 0x100003700L) != 0L) {
        }
        this.offset = offset;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match33(long name1, long name2, long name3, long name4) {
        int c;
        byte[] bytes = this.bytes;
        int offset = this.offset + 35;
        if (offset >= this.end || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 32L) != name1 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 24L) != name2 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 16L) != name3 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 8L) != name4) {
            return false;
        }
        while ((c = bytes[offset++] & 0xFF) <= 32 && (1L << c & 0x100003700L) != 0L) {
        }
        this.offset = offset;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match34(long name1, long name2, long name3, long name4) {
        int c;
        byte[] bytes = this.bytes;
        int offset = this.offset + 36;
        if (offset >= this.end || bytes[offset - 1] != 58 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 33L) != name1 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 25L) != name2 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 17L) != name3 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 9L) != name4) {
            return false;
        }
        while ((c = bytes[offset++] & 0xFF) <= 32 && (1L << c & 0x100003700L) != 0L) {
        }
        this.offset = offset;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match35(long name1, long name2, long name3, long name4) {
        int c;
        byte[] bytes = this.bytes;
        int offset = this.offset + 37;
        if (offset >= this.end) {
            return false;
        }
        if (JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 34L) != name1 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 26L) != name2 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 18L) != name3 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 10L) != name4 || bytes[offset - 2] != 34 || bytes[offset - 1] != 58) {
            return false;
        }
        while ((c = bytes[offset++] & 0xFF) <= 32 && (1L << c & 0x100003700L) != 0L) {
        }
        this.offset = offset;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match36(long name1, long name2, long name3, long name4, byte c36) {
        int c;
        byte[] bytes = this.bytes;
        int offset = this.offset + 38;
        if (offset >= this.end) {
            return false;
        }
        if (JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 35L) != name1 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 27L) != name2 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 19L) != name3 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 11L) != name4 || bytes[offset - 3] != c36 || bytes[offset - 2] != 34 || bytes[offset - 1] != 58) {
            return false;
        }
        while ((c = bytes[offset++] & 0xFF) <= 32 && (1L << c & 0x100003700L) != 0L) {
        }
        this.offset = offset;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match37(long name1, long name2, long name3, long name4, int name5) {
        int c;
        byte[] bytes = this.bytes;
        int offset = this.offset + 39;
        if (offset >= this.end) {
            return false;
        }
        if (JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 36L) != name1 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 28L) != name2 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 20L) != name3 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 12L) != name4 || JDKUtils.UNSAFE.getInt(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 4L) != name5) {
            return false;
        }
        while ((c = bytes[offset++] & 0xFF) <= 32 && (1L << c & 0x100003700L) != 0L) {
        }
        this.offset = offset;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match38(long name1, long name2, long name3, long name4, int name5) {
        int c;
        byte[] bytes = this.bytes;
        int offset = this.offset + 40;
        if (offset >= this.end) {
            return false;
        }
        if (JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 37L) != name1 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 29L) != name2 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 21L) != name3 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 13L) != name4 || JDKUtils.UNSAFE.getInt(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 5L) != name5 || bytes[offset - 1] != 58) {
            return false;
        }
        while ((c = bytes[offset++] & 0xFF) <= 32 && (1L << c & 0x100003700L) != 0L) {
        }
        this.offset = offset;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match39(long name1, long name2, long name3, long name4, int name5) {
        int c;
        byte[] bytes = this.bytes;
        int offset = this.offset + 41;
        if (offset >= this.end) {
            return false;
        }
        if (JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 38L) != name1 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 30L) != name2 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 22L) != name3 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 14L) != name4 || JDKUtils.UNSAFE.getInt(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 6L) != name5 || bytes[offset - 2] != 34 || bytes[offset - 1] != 58) {
            return false;
        }
        while ((c = bytes[offset++] & 0xFF) <= 32 && (1L << c & 0x100003700L) != 0L) {
        }
        this.offset = offset;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match40(long name1, long name2, long name3, long name4, int name5, byte c40) {
        int c;
        byte[] bytes = this.bytes;
        int offset = this.offset + 42;
        if (offset >= this.end) {
            return false;
        }
        if (JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 39L) != name1 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 31L) != name2 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 23L) != name3 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 15L) != name4 || JDKUtils.UNSAFE.getInt(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 7L) != name5 || bytes[offset - 3] != c40 || bytes[offset - 2] != 34 || bytes[offset - 1] != 58) {
            return false;
        }
        while ((c = bytes[offset++] & 0xFF) <= 32 && (1L << c & 0x100003700L) != 0L) {
        }
        this.offset = offset;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match41(long name1, long name2, long name3, long name4, long name5) {
        int c;
        byte[] bytes = this.bytes;
        int offset = this.offset + 43;
        if (offset >= this.end) {
            return false;
        }
        if (JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 40L) != name1 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 32L) != name2 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 24L) != name3 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 16L) != name4 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 8L) != name5) {
            return false;
        }
        while ((c = bytes[offset++] & 0xFF) <= 32 && (1L << c & 0x100003700L) != 0L) {
        }
        this.offset = offset;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match42(long name1, long name2, long name3, long name4, long name5) {
        int c;
        byte[] bytes = this.bytes;
        int offset = this.offset + 44;
        if (offset >= this.end) {
            return false;
        }
        if (JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 41L) != name1 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 33L) != name2 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 25L) != name3 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 17L) != name4 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 9L) != name5 || bytes[offset - 1] != 58) {
            return false;
        }
        while ((c = bytes[offset++] & 0xFF) <= 32 && (1L << c & 0x100003700L) != 0L) {
        }
        this.offset = offset;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match43(long name1, long name2, long name3, long name4, long name5) {
        int c;
        byte[] bytes = this.bytes;
        int offset = this.offset + 45;
        if (offset >= this.end) {
            return false;
        }
        if (JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 42L) != name1 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 34L) != name2 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 26L) != name3 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 18L) != name4 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 10L) != name5 || bytes[offset - 2] != 34 || bytes[offset - 1] != 58) {
            return false;
        }
        while ((c = bytes[offset++] & 0xFF) <= 32 && (1L << c & 0x100003700L) != 0L) {
        }
        this.offset = offset;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfValue4Match2() {
        int c;
        byte[] bytes = this.bytes;
        int offset = this.offset + 3;
        if (offset >= this.end) {
            return false;
        }
        if ((c = bytes[offset++] & 0xFF) != 44 && c != 125 && c != 93) {
            return false;
        }
        if (c == 44) {
            this.comma = true;
            int n = c = offset == this.end ? 26 : bytes[offset++] & 0xFF;
        }
        while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
            c = bytes[offset++] & 0xFF;
        }
        this.offset = offset;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfValue4Match3() {
        byte[] bytes = this.bytes;
        int offset = this.offset + 4;
        if (offset >= this.end) {
            return false;
        }
        if (bytes[offset - 1] != 34) {
            return false;
        }
        int c = bytes[offset] & 0xFF;
        if (c != 44 && c != 125 && c != 93) {
            return false;
        }
        if (c == 44) {
            this.comma = true;
            int n = c = ++offset == this.end ? 26 : bytes[offset] & 0xFF;
        }
        while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
            c = bytes[++offset] & 0xFF;
        }
        this.offset = offset + 1;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfValue4Match4(byte c4) {
        byte[] bytes = this.bytes;
        int offset = this.offset + 5;
        if (offset >= this.end) {
            return false;
        }
        if (bytes[offset - 2] != c4 || bytes[offset - 1] != 34) {
            return false;
        }
        int c = bytes[offset] & 0xFF;
        if (c != 44 && c != 125 && c != 93) {
            return false;
        }
        if (c == 44) {
            this.comma = true;
            int n = c = ++offset == this.end ? 26 : bytes[offset] & 0xFF;
        }
        while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
            c = bytes[++offset] & 0xFF;
        }
        this.offset = offset + 1;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfValue4Match5(byte c4, byte c5) {
        byte[] bytes = this.bytes;
        int offset = this.offset + 6;
        if (offset >= this.end) {
            return false;
        }
        if (bytes[offset - 3] != c4 || bytes[offset - 2] != c5 || bytes[offset - 1] != 34) {
            return false;
        }
        int c = bytes[offset] & 0xFF;
        if (c != 44 && c != 125 && c != 93) {
            return false;
        }
        if (c == 44) {
            this.comma = true;
            int n = c = ++offset == this.end ? 26 : bytes[offset] & 0xFF;
        }
        while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
            c = bytes[++offset] & 0xFF;
        }
        this.offset = offset + 1;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfValue4Match6(int name1) {
        byte[] bytes = this.bytes;
        int offset = this.offset + 7;
        if (offset >= this.end) {
            return false;
        }
        if (JDKUtils.UNSAFE.getInt(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 4L) != name1) {
            return false;
        }
        int c = bytes[offset] & 0xFF;
        if (c != 44 && c != 125 && c != 93) {
            return false;
        }
        if (c == 44) {
            this.comma = true;
            int n = c = ++offset == this.end ? 26 : bytes[offset] & 0xFF;
        }
        while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
            c = bytes[++offset] & 0xFF;
        }
        this.offset = offset + 1;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfValue4Match7(int name1) {
        byte[] bytes = this.bytes;
        int offset = this.offset + 8;
        if (offset >= this.end) {
            return false;
        }
        if (JDKUtils.UNSAFE.getInt(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 5L) != name1 || bytes[offset - 1] != 34) {
            return false;
        }
        int c = bytes[offset] & 0xFF;
        if (c != 44 && c != 125 && c != 93) {
            return false;
        }
        if (c == 44) {
            this.comma = true;
            int n = c = ++offset == this.end ? 26 : bytes[offset] & 0xFF;
        }
        while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
            c = bytes[++offset] & 0xFF;
        }
        this.offset = offset + 1;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfValue4Match8(int name1, byte c8) {
        byte[] bytes = this.bytes;
        int offset = this.offset + 9;
        if (offset >= this.end) {
            return false;
        }
        if (JDKUtils.UNSAFE.getInt(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 6L) != name1 || bytes[offset - 2] != c8 || bytes[offset - 1] != 34) {
            return false;
        }
        int c = bytes[offset] & 0xFF;
        if (c != 44 && c != 125 && c != 93) {
            return false;
        }
        if (c == 44) {
            this.comma = true;
            int n = c = ++offset == this.end ? 26 : bytes[offset] & 0xFF;
        }
        while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
            c = bytes[++offset] & 0xFF;
        }
        this.offset = offset + 1;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfValue4Match9(int name1, byte c8, byte c9) {
        byte[] bytes = this.bytes;
        int offset = this.offset + 10;
        if (offset >= this.end) {
            return false;
        }
        if (JDKUtils.UNSAFE.getInt(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 7L) != name1 || bytes[offset - 3] != c8 || bytes[offset - 2] != c9 || bytes[offset - 1] != 34) {
            return false;
        }
        int c = bytes[offset] & 0xFF;
        if (c != 44 && c != 125 && c != 93) {
            return false;
        }
        if (c == 44) {
            this.comma = true;
            int n = c = ++offset == this.end ? 26 : bytes[offset] & 0xFF;
        }
        while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
            c = bytes[++offset] & 0xFF;
        }
        this.offset = offset + 1;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfValue4Match10(long name1) {
        byte[] bytes = this.bytes;
        int offset = this.offset + 11;
        if (offset >= this.end) {
            return false;
        }
        if (JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 8L) != name1) {
            return false;
        }
        int c = bytes[offset] & 0xFF;
        if (c != 44 && c != 125 && c != 93) {
            return false;
        }
        if (c == 44) {
            this.comma = true;
            int n = c = ++offset == this.end ? 26 : bytes[offset] & 0xFF;
        }
        while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
            c = bytes[++offset] & 0xFF;
        }
        this.offset = offset + 1;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfValue4Match11(long name1) {
        byte[] bytes = this.bytes;
        int offset = this.offset + 12;
        if (offset >= this.end) {
            return false;
        }
        if (JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 9L) != name1 || bytes[offset - 1] != 34) {
            return false;
        }
        int c = bytes[offset] & 0xFF;
        if (c != 44 && c != 125 && c != 93) {
            return false;
        }
        if (c == 44) {
            this.comma = true;
            int n = c = ++offset == this.end ? 26 : bytes[offset] & 0xFF;
        }
        while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
            c = bytes[++offset] & 0xFF;
        }
        this.offset = offset + 1;
        this.ch = (char)c;
        return true;
    }

    @Override
    public long readFieldNameHashCode() {
        long hashCode;
        byte c1;
        byte[] bytes = this.bytes;
        int ch = this.ch;
        if (ch == 47) {
            this.skipComment();
            ch = this.ch;
        }
        if (ch == 39 && (this.context.features & JSONReader.Feature.DisableSingleQuote.mask) != 0L) {
            throw this.notSupportName();
        }
        if (ch != 34 && ch != 39) {
            String preFieldName;
            if ((this.context.features & JSONReader.Feature.AllowUnQuotedFieldNames.mask) != 0L && JSONReaderUTF8.isFirstIdentifier(ch)) {
                return this.readFieldNameHashCodeUnquote();
            }
            if (ch == 125 || this.isNull()) {
                return -1L;
            }
            String errorMsg = ch == 91 && this.nameBegin > 0 && (preFieldName = this.getFieldName()) != null ? "illegal fieldName input " + ch + ", previous fieldName " + preFieldName : "illegal fieldName input" + ch;
            throw new JSONException(this.info(errorMsg));
        }
        int quote = ch;
        this.nameAscii = true;
        this.nameEscape = false;
        int offset = this.nameBegin = this.offset;
        int end = this.end;
        long nameValue = 0L;
        if (offset + 9 < end) {
            byte c0 = bytes[offset];
            if (c0 == quote) {
                nameValue = 0L;
            } else {
                c1 = bytes[offset + 1];
                if (c1 == quote && c0 != 92 && c0 > 0) {
                    nameValue = c0;
                    this.nameLength = 1;
                    this.nameEnd = offset + 1;
                    offset += 2;
                } else {
                    int c2 = bytes[offset + 2];
                    if (c2 == quote && c0 != 92 && c1 != 92 && c0 >= 0 && c1 > 0) {
                        nameValue = (c1 << 8) + c0;
                        this.nameLength = 2;
                        this.nameEnd = offset + 2;
                        offset += 3;
                    } else {
                        byte c3 = bytes[offset + 3];
                        if (c3 == quote && c0 != 92 && c1 != 92 && c2 != 92 && c0 >= 0 && c1 >= 0 && c2 > 0) {
                            nameValue = (c2 << 16) + (c1 << 8) + c0;
                            this.nameLength = 3;
                            this.nameEnd = offset + 3;
                            offset += 4;
                        } else {
                            byte c4 = bytes[offset + 4];
                            if (c4 == quote && c0 != 92 && c1 != 92 && c2 != 92 && c3 != 92 && c0 >= 0 && c1 >= 0 && c2 >= 0 && c3 > 0) {
                                nameValue = (c3 << 24) + (c2 << 16) + (c1 << 8) + c0;
                                this.nameLength = 4;
                                this.nameEnd = offset + 4;
                                offset += 5;
                            } else {
                                byte c5 = bytes[offset + 5];
                                if (c5 == quote && c0 != 92 && c1 != 92 && c2 != 92 && c3 != 92 && c4 != 92 && c0 >= 0 && c1 >= 0 && c2 >= 0 && c3 >= 0 && c4 > 0) {
                                    nameValue = ((long)c4 << 32) + (long)(c3 << 24) + (long)(c2 << 16) + (long)(c1 << 8) + (long)c0;
                                    this.nameLength = 5;
                                    this.nameEnd = offset + 5;
                                    offset += 6;
                                } else {
                                    byte c6 = bytes[offset + 6];
                                    if (c6 == quote && c0 != 92 && c1 != 92 && c2 != 92 && c3 != 92 && c4 != 92 && c5 != 92 && c0 >= 0 && c1 >= 0 && c2 >= 0 && c3 >= 0 && c4 >= 0 && c5 > 0) {
                                        nameValue = ((long)c5 << 40) + ((long)c4 << 32) + (long)(c3 << 24) + (long)(c2 << 16) + (long)(c1 << 8) + (long)c0;
                                        this.nameLength = 6;
                                        this.nameEnd = offset + 6;
                                        offset += 7;
                                    } else {
                                        byte c7 = bytes[offset + 7];
                                        if (c7 == quote && c0 != 92 && c1 != 92 && c2 != 92 && c3 != 92 && c4 != 92 && c5 != 92 && c6 != 92 && c0 >= 0 && c1 >= 0 && c2 >= 0 && c3 >= 0 && c4 >= 0 && c5 >= 0 && c6 > 0) {
                                            nameValue = ((long)c6 << 48) + ((long)c5 << 40) + ((long)c4 << 32) + (long)(c3 << 24) + (long)(c2 << 16) + (long)(c1 << 8) + (long)c0;
                                            this.nameLength = 7;
                                            this.nameEnd = offset + 7;
                                            offset += 8;
                                        } else if (bytes[offset + 8] == quote && c0 != 92 && c1 != 92 && c2 != 92 && c3 != 92 && c4 != 92 && c5 != 92 && c6 != 92 && c7 != 92 && c0 >= 0 && c1 >= 0 && c2 >= 0 && c3 >= 0 && c4 >= 0 && c5 >= 0 && c6 >= 0 && c7 > 0) {
                                            nameValue = ((long)c7 << 56) + ((long)c6 << 48) + ((long)c5 << 40) + ((long)c4 << 32) + (long)(c3 << 24) + (long)(c2 << 16) + (long)(c1 << 8) + (long)c0;
                                            this.nameLength = 8;
                                            this.nameEnd = offset + 8;
                                            offset += 9;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        if (nameValue == 0L) {
            int i = 0;
            while (offset < end) {
                ch = bytes[offset];
                if (ch == quote) {
                    if (i == 0) {
                        offset = this.nameBegin;
                        break;
                    }
                    this.nameLength = i;
                    this.nameEnd = offset++;
                    break;
                }
                if (ch == 92) {
                    this.nameEscape = true;
                    ch = bytes[++offset];
                    switch (ch) {
                        case 117: {
                            ch = IOUtils.hexDigit4(bytes, JSONReaderJSONB.check3(offset + 1, end));
                            offset += 4;
                            break;
                        }
                        case 120: {
                            ch = JSONReaderUTF8.char2(bytes[offset + 1], bytes[offset + 2]);
                            offset += 2;
                            break;
                        }
                        default: {
                            ch = this.char1(ch);
                        }
                    }
                    if (ch > 255) {
                        this.nameAscii = false;
                    }
                } else if (ch == -61 || ch == -62) {
                    c1 = bytes[++offset];
                    ch = (char)((ch & 0x1F) << 6 | c1 & 0x3F);
                    this.nameAscii = false;
                }
                if (ch > 255 || ch < 0 || i >= 8 || i == 0 && ch == 0) {
                    nameValue = 0L;
                    offset = this.nameBegin;
                    break;
                }
                switch (i) {
                    case 0: {
                        nameValue = (byte)ch;
                        break;
                    }
                    case 1: {
                        nameValue = (long)((byte)ch << 8) + (nameValue & 0xFFL);
                        break;
                    }
                    case 2: {
                        nameValue = (long)((byte)ch << 16) + (nameValue & 0xFFFFL);
                        break;
                    }
                    case 3: {
                        nameValue = (long)((byte)ch << 24) + (nameValue & 0xFFFFFFL);
                        break;
                    }
                    case 4: {
                        nameValue = ((long)((byte)ch) << 32) + (nameValue & 0xFFFFFFFFL);
                        break;
                    }
                    case 5: {
                        nameValue = ((long)((byte)ch) << 40) + (nameValue & 0xFFFFFFFFFFL);
                        break;
                    }
                    case 6: {
                        nameValue = ((long)((byte)ch) << 48) + (nameValue & 0xFFFFFFFFFFFFL);
                        break;
                    }
                    case 7: {
                        nameValue = ((long)((byte)ch) << 56) + (nameValue & 0xFFFFFFFFFFFFFFL);
                        break;
                    }
                }
                ++offset;
                ++i;
            }
        }
        if (nameValue != 0L) {
            hashCode = nameValue;
        } else {
            hashCode = -3750763034362895579L;
            int i = 0;
            while (true) {
                if ((ch = bytes[offset]) == 92) {
                    this.nameEscape = true;
                    ch = bytes[++offset];
                    switch (ch) {
                        case 117: {
                            ch = IOUtils.hexDigit4(bytes, JSONReaderJSONB.check3(offset + 1, end));
                            offset += 4;
                            break;
                        }
                        case 120: {
                            ch = JSONReaderUTF8.char2(bytes[offset + 1], bytes[offset + 2]);
                            offset += 2;
                            break;
                        }
                        default: {
                            ch = this.char1(ch);
                        }
                    }
                    ++offset;
                    hashCode ^= (long)ch;
                    hashCode *= 1099511628211L;
                } else {
                    if (ch == quote) {
                        this.nameLength = i;
                        this.nameEnd = offset++;
                        break;
                    }
                    if (ch >= 0) {
                        ++offset;
                    } else {
                        switch ((ch &= 0xFF) >> 4) {
                            case 12: 
                            case 13: {
                                ch = JSONReaderUTF8.char2_utf8(ch, bytes[offset + 1], offset);
                                offset += 2;
                                this.nameAscii = false;
                                break;
                            }
                            case 14: {
                                ch = JSONReaderUTF8.char2_utf8(ch, bytes[offset + 1], bytes[offset + 2], offset);
                                offset += 3;
                                this.nameAscii = false;
                                break;
                            }
                            default: {
                                throw new JSONException("malformed input around byte " + offset);
                            }
                        }
                    }
                    hashCode ^= (long)ch;
                    hashCode *= 1099511628211L;
                }
                ++i;
            }
        }
        int n = ch = offset == end ? 26 : bytes[offset++];
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == end ? 26 : bytes[offset++];
        }
        if (ch != 58) {
            throw new JSONException(this.info("expect ':', but " + ch));
        }
        int n2 = ch = offset == end ? 26 : bytes[offset++];
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == end ? 26 : bytes[offset++];
        }
        this.offset = offset;
        this.ch = (char)ch;
        return hashCode;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public long readValueHashCode() {
        long hashCode;
        int end;
        int offset;
        byte[] bytes;
        int ch;
        block37: {
            block36: {
                ch = this.ch;
                if (ch != 34 && ch != 39) {
                    return -1L;
                }
                bytes = this.bytes;
                int quote = ch;
                this.nameAscii = true;
                this.nameEscape = false;
                offset = this.nameBegin = this.offset;
                end = this.end;
                long nameValue = 0L;
                int i = 0;
                while (offset < end) {
                    ch = bytes[offset];
                    if (ch == quote) {
                        if (i == 0) {
                            nameValue = 0L;
                            offset = this.nameBegin;
                            break;
                        }
                        this.nameLength = i;
                        this.nameEnd = offset++;
                        break;
                    }
                    if (ch == 92) {
                        this.nameEscape = true;
                        ch = bytes[++offset];
                        switch (ch) {
                            case 117: {
                                ch = IOUtils.hexDigit4(bytes, JSONReaderJSONB.check3(offset + 1, end));
                                offset += 4;
                                break;
                            }
                            case 120: {
                                ch = JSONReaderUTF8.char2(bytes[offset + 1], bytes[offset + 2]);
                                offset += 2;
                                break;
                            }
                            default: {
                                ch = this.char1(ch);
                                break;
                            }
                        }
                    } else if (ch == -61 || ch == -62) {
                        ch = (char)((ch & 0x1F) << 6 | bytes[++offset] & 0x3F);
                    }
                    if (ch > 255 || ch < 0 || i >= 8 || i == 0 && ch == 0) {
                        nameValue = 0L;
                        offset = this.nameBegin;
                        break;
                    }
                    switch (i) {
                        case 0: {
                            nameValue = (byte)ch;
                            break;
                        }
                        case 1: {
                            nameValue = (long)((byte)ch << 8) + (nameValue & 0xFFL);
                            break;
                        }
                        case 2: {
                            nameValue = (long)((byte)ch << 16) + (nameValue & 0xFFFFL);
                            break;
                        }
                        case 3: {
                            nameValue = (long)((byte)ch << 24) + (nameValue & 0xFFFFFFL);
                            break;
                        }
                        case 4: {
                            nameValue = ((long)((byte)ch) << 32) + (nameValue & 0xFFFFFFFFL);
                            break;
                        }
                        case 5: {
                            nameValue = ((long)((byte)ch) << 40) + (nameValue & 0xFFFFFFFFFFL);
                            break;
                        }
                        case 6: {
                            nameValue = ((long)((byte)ch) << 48) + (nameValue & 0xFFFFFFFFFFFFL);
                            break;
                        }
                        case 7: {
                            nameValue = ((long)((byte)ch) << 56) + (nameValue & 0xFFFFFFFFFFFFFFL);
                            break;
                        }
                    }
                    ++offset;
                    ++i;
                }
                if (nameValue == 0L) break block36;
                hashCode = nameValue;
                break block37;
            }
            hashCode = -3750763034362895579L;
            int i = 0;
            while (true) {
                block39: {
                    block41: {
                        block40: {
                            block38: {
                                if ((ch = bytes[offset]) != 92) break block38;
                                this.nameEscape = true;
                                ch = bytes[++offset];
                                switch (ch) {
                                    case 117: {
                                        ch = IOUtils.hexDigit4(bytes, JSONReaderJSONB.check3(offset + 1, end));
                                        offset += 4;
                                        break;
                                    }
                                    case 120: {
                                        ch = JSONReaderUTF8.char2(bytes[offset + 1], bytes[offset + 2]);
                                        offset += 2;
                                        break;
                                    }
                                    default: {
                                        ch = this.char1(ch);
                                    }
                                }
                                ++offset;
                                hashCode ^= (long)ch;
                                hashCode *= 1099511628211L;
                                break block39;
                            }
                            if (ch == 34) {
                                this.nameLength = i;
                                this.nameEnd = offset++;
                                break;
                            }
                            if (ch < 0) break block40;
                            ++offset;
                            break block41;
                        }
                        switch ((ch & 0xFF) >> 4) {
                            case 12: 
                            case 13: {
                                ch = JSONReaderUTF8.char2_utf8(ch, bytes[offset + 1], offset);
                                offset += 2;
                                this.nameAscii = false;
                                break;
                            }
                            case 14: {
                                ch = JSONReaderUTF8.char2_utf8(ch, bytes[offset + 1], bytes[offset + 2], offset);
                                offset += 3;
                                this.nameAscii = false;
                                break;
                            }
                            default: {
                                if (ch >> 3 != -2) throw new JSONException("malformed input around byte " + offset);
                                int n = ++offset;
                                byte c2 = bytes[n];
                                int n2 = ++offset;
                                byte c3 = bytes[n2];
                                int n3 = ++offset;
                                ++offset;
                                byte c4 = bytes[n3];
                                int uc = ch << 18 ^ c2 << 12 ^ c3 << 6 ^ (c4 ^ 0x381F80);
                                if ((c2 & 0xC0) != 128 || (c3 & 0xC0) != 128 || (c4 & 0xC0) != 128 || uc < 65536 || uc >= 0x110000) {
                                    throw new JSONException("malformed input around byte " + offset);
                                }
                                char x1 = (char)((uc >>> 10) + 55232);
                                char x2 = (char)((uc & 0x3FF) + 56320);
                                hashCode ^= (long)x1;
                                hashCode *= 1099511628211L;
                                hashCode ^= (long)x2;
                                hashCode *= 1099511628211L;
                                ++i;
                                break block39;
                            }
                        }
                    }
                    hashCode ^= (long)ch;
                    hashCode *= 1099511628211L;
                }
                ++i;
            }
        }
        int n = ch = offset == end ? 26 : bytes[offset++];
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == end ? 26 : bytes[offset++];
        }
        this.comma = ch == 44;
        if (this.comma) {
            int n4 = ch = offset == end ? 26 : bytes[offset++];
            while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                ch = offset == end ? 26 : bytes[offset++];
            }
        }
        this.offset = offset;
        this.ch = (char)ch;
        return hashCode;
    }

    @Override
    public long getNameHashCodeLCase() {
        byte c1;
        int ch;
        long hashCode = -3750763034362895579L;
        int offset = this.nameBegin;
        int end = this.end;
        int quote = 34;
        byte[] bytes = this.bytes;
        if (offset > 0 && bytes[offset - 1] == 39) {
            quote = 39;
        }
        long nameValue = 0L;
        int i = 0;
        while (offset < end) {
            ch = bytes[offset];
            if (ch == 92) {
                ch = bytes[++offset];
                switch (ch) {
                    case 117: {
                        ch = IOUtils.hexDigit4(bytes, JSONReaderJSONB.check3(offset + 1, end));
                        offset += 4;
                        break;
                    }
                    case 120: {
                        ch = JSONReaderUTF8.char2(bytes[offset + 1], bytes[offset + 2]);
                        offset += 2;
                        break;
                    }
                    default: {
                        ch = this.char1(ch);
                        break;
                    }
                }
            } else if (ch == -61 || ch == -62) {
                ch = (ch & 0x1F) << 6 | bytes[++offset] & 0x3F;
            } else if (ch == quote) break;
            if (i >= 8 || ch > 255 || ch < 0 || i == 0 && ch == 0) {
                nameValue = 0L;
                offset = this.nameBegin;
                break;
            }
            if (ch != 95 && ch != 45 && ch != 32 || (c1 = bytes[offset + 1]) == 34 || c1 == 39 || c1 == ch) {
                if (ch >= 65 && ch <= 90) {
                    ch = (char)(ch + 32);
                }
                switch (i) {
                    case 0: {
                        nameValue = (byte)ch;
                        break;
                    }
                    case 1: {
                        nameValue = (long)((byte)ch << 8) + (nameValue & 0xFFL);
                        break;
                    }
                    case 2: {
                        nameValue = (long)((byte)ch << 16) + (nameValue & 0xFFFFL);
                        break;
                    }
                    case 3: {
                        nameValue = (long)((byte)ch << 24) + (nameValue & 0xFFFFFFL);
                        break;
                    }
                    case 4: {
                        nameValue = ((long)((byte)ch) << 32) + (nameValue & 0xFFFFFFFFL);
                        break;
                    }
                    case 5: {
                        nameValue = ((long)((byte)ch) << 40) + (nameValue & 0xFFFFFFFFFFL);
                        break;
                    }
                    case 6: {
                        nameValue = ((long)((byte)ch) << 48) + (nameValue & 0xFFFFFFFFFFFFL);
                        break;
                    }
                    case 7: {
                        nameValue = ((long)((byte)ch) << 56) + (nameValue & 0xFFFFFFFFFFFFFFL);
                        break;
                    }
                }
                ++i;
            }
            ++offset;
        }
        if (nameValue != 0L) {
            return nameValue;
        }
        if (this.nameAscii && !this.nameEscape) {
            for (i = this.nameBegin; i < this.nameEnd; ++i) {
                ch = bytes[i];
                if (ch >= 65 && ch <= 90) {
                    ch += 32;
                }
                if ((ch == 95 || ch == 45 || ch == 32) && (c1 = bytes[i + 1]) != 34 && c1 != 39 && c1 != ch) continue;
                hashCode ^= (long)ch;
                hashCode *= 1099511628211L;
            }
            return hashCode;
        }
        while (true) {
            int ch2;
            if ((ch2 = bytes[offset]) == 92) {
                ch2 = bytes[++offset];
                switch (ch2) {
                    case 117: {
                        ch2 = IOUtils.hexDigit4(bytes, JSONReaderJSONB.check3(offset + 1, end));
                        offset += 4;
                        break;
                    }
                    case 120: {
                        ch2 = JSONReaderUTF8.char2(bytes[offset + 1], bytes[offset + 2]);
                        offset += 2;
                        break;
                    }
                    default: {
                        ch2 = this.char1(ch2);
                    }
                }
                ++offset;
            } else {
                if (ch2 == quote) break;
                if (ch2 >= 0) {
                    if (ch2 >= 65 && ch2 <= 90) {
                        ch2 += 32;
                    }
                    ++offset;
                } else {
                    switch ((ch2 &= 0xFF) >> 4) {
                        case 12: 
                        case 13: {
                            byte c2 = bytes[offset + 1];
                            ch2 = (ch2 & 0x1F) << 6 | c2 & 0x3F;
                            offset += 2;
                            break;
                        }
                        case 14: {
                            byte c2 = bytes[offset + 1];
                            byte c3 = bytes[offset + 2];
                            ch2 = (ch2 & 0xF) << 12 | (c2 & 0x3F) << 6 | c3 & 0x3F;
                            offset += 3;
                            break;
                        }
                        default: {
                            throw new JSONException("malformed input around byte " + offset);
                        }
                    }
                }
            }
            if (ch2 == 95 || ch2 == 45 || ch2 == 32) continue;
            hashCode ^= (long)ch2;
            hashCode *= 1099511628211L;
        }
        return hashCode;
    }

    final String getLatin1String(int offset, int length) {
        if (JDKUtils.ANDROID_SDK_INT >= 34) {
            return new String(this.bytes, offset, length, StandardCharsets.ISO_8859_1);
        }
        char[] charBuf = this.charBuf;
        if (charBuf == null) {
            if (this.cacheItem == null) {
                int cacheIndex = System.identityHashCode(Thread.currentThread()) & JSONFactory.CACHE_ITEMS.length - 1;
                this.cacheItem = JSONFactory.CACHE_ITEMS[cacheIndex];
            }
            this.charBuf = charBuf = (char[])JSONFactory.CHARS_UPDATER.getAndSet(this.cacheItem, null);
        }
        if (charBuf == null || charBuf.length < length) {
            this.charBuf = charBuf = new char[length];
        }
        for (int i = 0; i < length; ++i) {
            charBuf[i] = (char)(this.bytes[offset + i] & 0xFF);
        }
        return new String(charBuf, 0, length);
    }

    @Override
    public String getFieldName() {
        byte[] bytes = this.bytes;
        int offset = this.nameBegin;
        int length = this.nameEnd - offset;
        if (!this.nameEscape) {
            if (this.nameAscii) {
                if (JDKUtils.STRING_CREATOR_JDK8 != null) {
                    return JDKUtils.asciiStringJDK8(bytes, offset, length);
                }
                if (JDKUtils.STRING_CREATOR_JDK11 != null) {
                    return JDKUtils.STRING_CREATOR_JDK11.apply(Arrays.copyOfRange(bytes, offset, this.nameEnd), JDKUtils.LATIN1);
                }
                if (JDKUtils.ANDROID) {
                    return this.getLatin1String(offset, length);
                }
            }
            return new String(bytes, offset, length, this.nameAscii ? StandardCharsets.ISO_8859_1 : StandardCharsets.UTF_8);
        }
        char[] chars = new char[this.nameLength];
        int i = 0;
        int end = this.end;
        while (offset < this.nameEnd) {
            int ch = bytes[offset];
            if (ch < 0) {
                switch ((ch &= 0xFF) >> 4) {
                    case 12: 
                    case 13: {
                        ch = JSONReaderUTF8.char2_utf8(ch, bytes[offset + 1], offset);
                        offset += 2;
                        break;
                    }
                    case 14: {
                        ch = JSONReaderUTF8.char2_utf8(ch, bytes[offset + 1], bytes[offset + 2], offset);
                        offset += 3;
                        break;
                    }
                    default: {
                        throw new JSONException("malformed input around byte " + offset);
                    }
                }
                chars[i] = (char)ch;
            } else {
                if (ch == 92) {
                    ch = (char)bytes[++offset];
                    switch (ch) {
                        case 117: {
                            ch = IOUtils.hexDigit4(bytes, JSONReaderJSONB.check3(offset + 1, end));
                            offset += 4;
                            break;
                        }
                        case 120: {
                            ch = JSONReaderUTF8.char2(bytes[offset + 1], bytes[offset + 2]);
                            offset += 2;
                            break;
                        }
                        case 34: 
                        case 42: 
                        case 43: 
                        case 45: 
                        case 46: 
                        case 47: 
                        case 58: 
                        case 60: 
                        case 61: 
                        case 62: 
                        case 64: 
                        case 92: {
                            break;
                        }
                        default: {
                            ch = this.char1(ch);
                            break;
                        }
                    }
                } else if (ch == 34) break;
                chars[i] = (char)ch;
                ++offset;
            }
            ++i;
        }
        return new String(chars);
    }

    @Override
    public String readFieldName() {
        char quote = this.ch;
        if (quote == '\'' && (this.context.features & JSONReader.Feature.DisableSingleQuote.mask) != 0L) {
            throw this.notSupportName();
        }
        if (quote != '\"' && quote != '\'') {
            if ((this.context.features & JSONReader.Feature.AllowUnQuotedFieldNames.mask) != 0L && JSONReaderUTF8.isFirstIdentifier(quote)) {
                return this.readFieldNameUnquote();
            }
            return null;
        }
        byte[] bytes = this.bytes;
        this.nameAscii = true;
        this.nameEscape = false;
        int offset = this.nameBegin = this.offset;
        int end = this.end;
        int nameBegin = this.nameBegin;
        int i = 0;
        while (offset < end) {
            byte by = bytes[offset];
            if (by == 92) {
                this.nameEscape = true;
                offset += (by = bytes[offset + 1]) == 117 ? 6 : (by == 120 ? 4 : 2);
            } else {
                if (by == quote) {
                    int n;
                    int n2;
                    int n3;
                    this.nameLength = i;
                    this.nameEnd = offset++;
                    if (offset < end) {
                        int n4 = bytes[offset] & 0xFF;
                    } else {
                        int n5 = 26;
                    }
                    while (n3 <= 32 && (1L << n3 & 0x100003700L) != 0L) {
                        n3 = bytes[++offset] & 0xFF;
                    }
                    if (n3 != 58) {
                        throw JSONReaderUTF8.syntaxError(offset, n3);
                    }
                    int n6 = n2 = ++offset == end ? 26 : bytes[offset++];
                    while (n <= 32 && (1L << n & 0x100003700L) != 0L) {
                        n = offset == end ? 26 : bytes[offset++];
                    }
                    this.offset = offset;
                    this.ch = (char)n;
                    break;
                }
                if (by >= 0) {
                    ++offset;
                } else {
                    if (this.nameAscii) {
                        this.nameAscii = false;
                    }
                    switch ((by & 0xFF) >> 4) {
                        case 12: 
                        case 13: {
                            offset += 2;
                            break;
                        }
                        case 14: {
                            offset += 3;
                            break;
                        }
                        default: {
                            if (by >> 3 == -2) {
                                offset += 4;
                                break;
                            }
                            throw JSONReaderUTF8.syntaxError(offset, by);
                        }
                    }
                }
            }
            ++i;
        }
        if (this.nameEnd < nameBegin) {
            throw JSONReaderUTF8.syntaxError(offset, this.ch);
        }
        int length = this.nameEnd - nameBegin;
        if (!this.nameEscape) {
            if (this.nameAscii) {
                long l = -1L;
                long nameValue1 = -1L;
                switch (length) {
                    case 1: {
                        return TypeUtils.toString((char)(bytes[nameBegin] & 0xFF));
                    }
                    case 2: {
                        return TypeUtils.toString((char)(bytes[nameBegin] & 0xFF), (char)(bytes[nameBegin + 1] & 0xFF));
                    }
                    case 3: {
                        l = (bytes[nameBegin + 2] << 16) + (bytes[nameBegin + 1] << 8) + bytes[nameBegin];
                        break;
                    }
                    case 4: {
                        l = (bytes[nameBegin + 3] << 24) + (bytes[nameBegin + 2] << 16) + (bytes[nameBegin + 1] << 8) + bytes[nameBegin];
                        break;
                    }
                    case 5: {
                        l = ((long)bytes[nameBegin + 4] << 32) + ((long)bytes[nameBegin + 3] << 24) + ((long)bytes[nameBegin + 2] << 16) + ((long)bytes[nameBegin + 1] << 8) + (long)bytes[nameBegin];
                        break;
                    }
                    case 6: {
                        l = ((long)bytes[nameBegin + 5] << 40) + ((long)bytes[nameBegin + 4] << 32) + ((long)bytes[nameBegin + 3] << 24) + ((long)bytes[nameBegin + 2] << 16) + ((long)bytes[nameBegin + 1] << 8) + (long)bytes[nameBegin];
                        break;
                    }
                    case 7: {
                        l = ((long)bytes[nameBegin + 6] << 48) + ((long)bytes[nameBegin + 5] << 40) + ((long)bytes[nameBegin + 4] << 32) + ((long)bytes[nameBegin + 3] << 24) + ((long)bytes[nameBegin + 2] << 16) + ((long)bytes[nameBegin + 1] << 8) + (long)bytes[nameBegin];
                        break;
                    }
                    case 8: {
                        l = ((long)bytes[nameBegin + 7] << 56) + ((long)bytes[nameBegin + 6] << 48) + ((long)bytes[nameBegin + 5] << 40) + ((long)bytes[nameBegin + 4] << 32) + ((long)bytes[nameBegin + 3] << 24) + ((long)bytes[nameBegin + 2] << 16) + ((long)bytes[nameBegin + 1] << 8) + (long)bytes[nameBegin];
                        break;
                    }
                    case 9: {
                        l = bytes[nameBegin];
                        nameValue1 = ((long)bytes[nameBegin + 8] << 56) + ((long)bytes[nameBegin + 7] << 48) + ((long)bytes[nameBegin + 6] << 40) + ((long)bytes[nameBegin + 5] << 32) + ((long)bytes[nameBegin + 4] << 24) + ((long)bytes[nameBegin + 3] << 16) + ((long)bytes[nameBegin + 2] << 8) + (long)bytes[nameBegin + 1];
                        break;
                    }
                    case 10: {
                        l = (bytes[nameBegin + 1] << 8) + bytes[nameBegin];
                        nameValue1 = ((long)bytes[nameBegin + 9] << 56) + ((long)bytes[nameBegin + 8] << 48) + ((long)bytes[nameBegin + 7] << 40) + ((long)bytes[nameBegin + 6] << 32) + ((long)bytes[nameBegin + 5] << 24) + ((long)bytes[nameBegin + 4] << 16) + ((long)bytes[nameBegin + 3] << 8) + (long)bytes[nameBegin + 2];
                        break;
                    }
                    case 11: {
                        l = (bytes[nameBegin + 2] << 16) + (bytes[nameBegin + 1] << 8) + bytes[nameBegin];
                        nameValue1 = ((long)bytes[nameBegin + 10] << 56) + ((long)bytes[nameBegin + 9] << 48) + ((long)bytes[nameBegin + 8] << 40) + ((long)bytes[nameBegin + 7] << 32) + ((long)bytes[nameBegin + 6] << 24) + ((long)bytes[nameBegin + 5] << 16) + ((long)bytes[nameBegin + 4] << 8) + (long)bytes[nameBegin + 3];
                        break;
                    }
                    case 12: {
                        l = (bytes[nameBegin + 3] << 24) + (bytes[nameBegin + 2] << 16) + (bytes[nameBegin + 1] << 8) + bytes[nameBegin];
                        nameValue1 = ((long)bytes[nameBegin + 11] << 56) + ((long)bytes[nameBegin + 10] << 48) + ((long)bytes[nameBegin + 9] << 40) + ((long)bytes[nameBegin + 8] << 32) + ((long)bytes[nameBegin + 7] << 24) + ((long)bytes[nameBegin + 6] << 16) + ((long)bytes[nameBegin + 5] << 8) + (long)bytes[nameBegin + 4];
                        break;
                    }
                    case 13: {
                        l = ((long)bytes[nameBegin + 4] << 32) + ((long)bytes[nameBegin + 3] << 24) + ((long)bytes[nameBegin + 2] << 16) + ((long)bytes[nameBegin + 1] << 8) + (long)bytes[nameBegin];
                        nameValue1 = ((long)bytes[nameBegin + 12] << 56) + ((long)bytes[nameBegin + 11] << 48) + ((long)bytes[nameBegin + 10] << 40) + ((long)bytes[nameBegin + 9] << 32) + ((long)bytes[nameBegin + 8] << 24) + ((long)bytes[nameBegin + 7] << 16) + ((long)bytes[nameBegin + 6] << 8) + (long)bytes[nameBegin + 5];
                        break;
                    }
                    case 14: {
                        l = ((long)bytes[nameBegin + 5] << 40) + ((long)bytes[nameBegin + 4] << 32) + ((long)bytes[nameBegin + 3] << 24) + ((long)bytes[nameBegin + 2] << 16) + ((long)bytes[nameBegin + 1] << 8) + (long)bytes[nameBegin];
                        nameValue1 = ((long)bytes[nameBegin + 13] << 56) + ((long)bytes[nameBegin + 12] << 48) + ((long)bytes[nameBegin + 11] << 40) + ((long)bytes[nameBegin + 10] << 32) + ((long)bytes[nameBegin + 9] << 24) + ((long)bytes[nameBegin + 8] << 16) + ((long)bytes[nameBegin + 7] << 8) + (long)bytes[nameBegin + 6];
                        break;
                    }
                    case 15: {
                        l = ((long)bytes[nameBegin + 6] << 48) + ((long)bytes[nameBegin + 5] << 40) + ((long)bytes[nameBegin + 4] << 32) + ((long)bytes[nameBegin + 3] << 24) + ((long)bytes[nameBegin + 2] << 16) + ((long)bytes[nameBegin + 1] << 8) + (long)bytes[nameBegin];
                        nameValue1 = ((long)bytes[nameBegin + 14] << 56) + ((long)bytes[nameBegin + 13] << 48) + ((long)bytes[nameBegin + 12] << 40) + ((long)bytes[nameBegin + 11] << 32) + ((long)bytes[nameBegin + 10] << 24) + ((long)bytes[nameBegin + 9] << 16) + ((long)bytes[nameBegin + 8] << 8) + (long)bytes[nameBegin + 7];
                        break;
                    }
                    case 16: {
                        l = ((long)bytes[nameBegin + 7] << 56) + ((long)bytes[nameBegin + 6] << 48) + ((long)bytes[nameBegin + 5] << 40) + ((long)bytes[nameBegin + 4] << 32) + ((long)bytes[nameBegin + 3] << 24) + ((long)bytes[nameBegin + 2] << 16) + ((long)bytes[nameBegin + 1] << 8) + (long)bytes[nameBegin];
                        nameValue1 = ((long)bytes[nameBegin + 15] << 56) + ((long)bytes[nameBegin + 14] << 48) + ((long)bytes[nameBegin + 13] << 40) + ((long)bytes[nameBegin + 12] << 32) + ((long)bytes[nameBegin + 11] << 24) + ((long)bytes[nameBegin + 10] << 16) + ((long)bytes[nameBegin + 9] << 8) + (long)bytes[nameBegin + 8];
                        break;
                    }
                }
                if (l != -1L) {
                    if (nameValue1 != -1L) {
                        long nameValue01 = l ^ nameValue1;
                        int indexMask = (int)(nameValue01 ^ nameValue01 >>> 32) & JSONFactory.NAME_CACHE2.length - 1;
                        JSONFactory.NameCacheEntry2 entry = JSONFactory.NAME_CACHE2[indexMask];
                        if (entry == null) {
                            String name = JDKUtils.STRING_CREATOR_JDK8 != null ? JDKUtils.asciiStringJDK8(bytes, nameBegin, length) : (JDKUtils.ANDROID ? this.getLatin1String(nameBegin, length) : new String(bytes, nameBegin, length, StandardCharsets.ISO_8859_1));
                            JSONFactory.NAME_CACHE2[indexMask] = new JSONFactory.NameCacheEntry2(name, l, nameValue1);
                            return name;
                        }
                        if (entry.value0 == l && entry.value1 == nameValue1) {
                            return entry.name;
                        }
                    } else {
                        int indexMask = (int)(l ^ l >>> 32) & JSONFactory.NAME_CACHE.length - 1;
                        JSONFactory.NameCacheEntry entry = JSONFactory.NAME_CACHE[indexMask];
                        if (entry == null) {
                            String name = JDKUtils.STRING_CREATOR_JDK8 != null ? JDKUtils.asciiStringJDK8(bytes, nameBegin, length) : (JDKUtils.ANDROID ? this.getLatin1String(nameBegin, length) : new String(bytes, nameBegin, length, StandardCharsets.ISO_8859_1));
                            JSONFactory.NAME_CACHE[indexMask] = new JSONFactory.NameCacheEntry(name, l);
                            return name;
                        }
                        if (entry.value == l) {
                            return entry.name;
                        }
                    }
                }
                if (JDKUtils.STRING_CREATOR_JDK8 != null) {
                    return JDKUtils.asciiStringJDK8(bytes, nameBegin, length);
                }
                if (JDKUtils.ANDROID) {
                    return this.getLatin1String(nameBegin, this.nameEnd - nameBegin);
                }
                if (JDKUtils.STRING_CREATOR_JDK11 != null) {
                    return JDKUtils.STRING_CREATOR_JDK11.apply(Arrays.copyOfRange(bytes, nameBegin, this.nameEnd), JDKUtils.LATIN1);
                }
            }
            if (this.nameAscii && JDKUtils.ANDROID) {
                return this.getLatin1String(nameBegin, length);
            }
            return new String(bytes, nameBegin, length, this.nameAscii ? StandardCharsets.ISO_8859_1 : StandardCharsets.UTF_8);
        }
        return this.getFieldName();
    }

    @Override
    public final int readInt32Value() {
        int d;
        int result;
        int ch = this.ch;
        int offset = this.offset;
        int end = this.end;
        byte[] bytes = this.bytes;
        int quote = 0;
        if (ch == 34 || ch == 39) {
            quote = ch;
            ch = bytes[offset++];
        }
        int fc = ch;
        int n = ch >= 48 && ch <= 57 ? 48 - ch : (result = ch == 45 || ch == 43 ? 0 : 1);
        while (offset + 1 < end && (d = IOUtils.digit2(bytes, offset)) != -1 && -21474836 <= result & result <= 0) {
            result = result * 100 - d;
            offset += 2;
        }
        if (offset < end && IOUtils.isDigit(ch = bytes[offset]) && -214748364 <= result & result <= 0) {
            result = result * 10 + 48 - ch;
            ++offset;
        }
        int n2 = ch = offset == end ? 26 : bytes[offset++];
        if (!(result > 0 || Integer.MIN_VALUE >= result && fc != 45 || !INT_VALUE_END[ch & 0xFF] || quote != 0 && ch != quote)) {
            if (quote != 0) {
                int n3 = ch = offset == end ? 26 : bytes[offset++];
            }
            if (ch == 76 || ch == 70 || ch == 68 || ch == 66 || ch == 83) {
                int n4 = ch = offset == end ? 26 : bytes[offset++];
            }
            while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                ch = offset == end ? 26 : bytes[offset++];
            }
            this.comma = ch == 44;
            if (this.comma) {
                ch = (char)(offset == end ? 26 : (char)bytes[offset++]);
                char c = (char)ch;
                while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                    ch = offset == end ? 26 : bytes[offset++];
                }
            }
            this.ch = (char)ch;
            this.offset = offset;
            return fc == 45 ? result : -result;
        }
        return this.readInt32ValueOverflow();
    }

    @Override
    public final Integer readInt32() {
        char ch = this.ch;
        if ((ch == '\"' || ch == '\'' || ch == 'n') && this.nextIfNullOrEmptyString()) {
            return null;
        }
        return this.readInt32Value();
    }

    @Override
    public final long readInt64Value() {
        int d;
        long result;
        int ch = this.ch;
        int offset = this.offset;
        int end = this.end;
        byte[] bytes = this.bytes;
        int quote = 0;
        if (ch == 34 || ch == 39) {
            quote = ch;
            ch = bytes[offset++];
        }
        int fc = ch;
        long l = ch >= 48 && ch <= 57 ? (long)(48 - ch) : (result = ch == 45 || ch == 43 ? 0L : 1L);
        while (offset + 1 < end && (d = IOUtils.digit2(bytes, offset)) != -1 && -92233720368547758L <= result & result <= 0L) {
            result = result * 100L - (long)d;
            offset += 2;
        }
        if (offset < end && IOUtils.isDigit(ch = bytes[offset]) && -922337203685477580L <= result & result <= 0L) {
            result = result * 10L + 48L - (long)ch;
            ++offset;
        }
        int n = ch = offset == end ? 26 : bytes[offset++];
        if (!(result > 0L || Long.MIN_VALUE >= result && fc != 45 || !INT_VALUE_END[ch & 0xFF] || quote != 0 && ch != quote)) {
            if (quote != 0) {
                int n2 = ch = offset == end ? 26 : bytes[offset++];
            }
            if (ch == 76 || ch == 70 || ch == 68 || ch == 66 || ch == 83) {
                int n3 = ch = offset == end ? 26 : bytes[offset++];
            }
            while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                ch = offset == end ? 26 : bytes[offset++];
            }
            this.comma = ch == 44;
            if (this.comma) {
                ch = (char)(offset == end ? 26 : (char)bytes[offset++]);
                char c = (char)ch;
                while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                    ch = offset == end ? 26 : bytes[offset++];
                }
            }
            this.ch = (char)ch;
            this.offset = offset;
            return fc == 45 ? result : -result;
        }
        return this.readInt64ValueOverflow();
    }

    @Override
    public final Long readInt64() {
        char ch = this.ch;
        if ((ch == '\"' || ch == '\'' || ch == 'n') && this.nextIfNullOrEmptyString()) {
            return null;
        }
        return this.readInt64Value();
    }

    @Override
    public final double readDoubleValue() {
        long result;
        double doubleValue = 0.0;
        byte[] bytes = this.bytes;
        int quote = 0;
        int ch = this.ch;
        int offset = this.offset;
        int end = this.end;
        if (ch == 34 || ch == 39) {
            quote = ch;
            ch = offset == end ? 26 : bytes[offset++];
        }
        boolean wasNull = false;
        if (quote != 0 && ch == quote) {
            ch = offset == end ? 26 : bytes[offset++];
            wasNull = true;
            result = 0L;
        } else {
            int d;
            int fc = ch;
            long l = ch >= 48 && ch <= 57 ? (long)(48 - ch) : (result = ch == 45 || ch == 43 ? 0L : 1L);
            while (result <= 0L && offset + 1 < end && (d = IOUtils.digit2(bytes, offset)) != -1) {
                if (-92233720368547758L <= result) {
                    result = result * 100L - (long)d;
                    offset += 2;
                    continue;
                }
                result = 1L;
            }
            if (result <= 0L && offset < end && IOUtils.isDigit(ch = bytes[offset])) {
                if (-922337203685477580L <= result) {
                    result = result * 10L + 48L - (long)ch;
                    ++offset;
                } else {
                    result = 1L;
                }
            }
            int scale = 0;
            if (result <= 0L && offset < end && bytes[offset] == 46) {
                ++offset;
                while (result <= 0L && offset + 1 < end && (d = IOUtils.digit2(bytes, offset)) != -1) {
                    if (-92233720368547758L <= result) {
                        result = result * 100L - (long)d;
                        offset += 2;
                        scale += 2;
                        continue;
                    }
                    result = 1L;
                }
                if (result <= 0L && offset < end && IOUtils.isDigit(ch = bytes[offset])) {
                    if (-922337203685477580L <= result) {
                        result = result * 10L + 48L - (long)ch;
                        ++offset;
                        ++scale;
                    } else {
                        result = 1L;
                    }
                }
            }
            if (result <= 0L) {
                int n = ch = offset == end ? 26 : bytes[offset++];
            }
            if (result <= 0L) {
                if (ch == 101 || ch == 69) {
                    ch = offset == end ? 26 : bytes[offset++];
                    boolean negativeExp = ch == 45;
                    if (negativeExp || ch == 43) {
                        ch = offset == end ? 26 : bytes[offset++];
                    } else if (ch == 44) {
                        throw this.numberError();
                    }
                    if (IOUtils.isDigit(ch)) {
                        int expValue = ch - 48;
                        while (offset < end && IOUtils.isDigit(ch = bytes[offset])) {
                            d = ch - 48;
                            if ((expValue = expValue * 10 + d) > 2047) {
                                throw new JSONException("too large exp value : " + expValue);
                            }
                            ++offset;
                        }
                        if (negativeExp) {
                            expValue = -expValue;
                        }
                        scale -= expValue;
                        ch = offset == end ? 26 : bytes[offset++];
                    } else {
                        result = 1L;
                    }
                } else if (ch == 76 || ch == 70 || ch == 68 || ch == 66 || ch == 83) {
                    int n = ch = offset == end ? 26 : bytes[offset++];
                }
            }
            if (result <= 0L && quote != 0) {
                if (ch == quote) {
                    ch = offset == end ? 26 : bytes[offset++];
                } else {
                    result = 1L;
                }
            }
            if (result <= 0L) {
                boolean value = true;
                if (scale == 0) {
                    doubleValue = result;
                } else if ((long)((double)result) == result) {
                    if (0 < scale && scale < JSONFactory.DOUBLE_10_POW.length) {
                        doubleValue = (double)result / JSONFactory.DOUBLE_10_POW[scale];
                    } else if (0 > scale && scale > -JSONFactory.DOUBLE_10_POW.length) {
                        doubleValue = (double)result * JSONFactory.DOUBLE_10_POW[-scale];
                    } else {
                        value = false;
                    }
                } else {
                    value = false;
                }
                if (!value) {
                    if (scale > 0 && scale < 64) {
                        doubleValue = TypeUtils.doubleValue(fc == 45 ? -1 : 1, Math.abs(result), scale);
                    } else {
                        result = 1L;
                    }
                } else if (fc != 45) {
                    if (doubleValue != 0.0) {
                        doubleValue = -doubleValue;
                    }
                } else if (result == 0L) {
                    doubleValue = -doubleValue;
                }
            }
        }
        if (result > 0L) {
            this.readNumber0();
            return this.getDoubleValue();
        }
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == end ? 26 : bytes[offset++];
        }
        this.comma = ch == 44;
        if (this.comma) {
            int n = ch = offset == end ? 26 : bytes[offset++];
            while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                ch = offset == end ? 26 : bytes[offset++];
            }
        }
        this.wasNull = wasNull;
        this.ch = (char)ch;
        this.offset = offset;
        return doubleValue;
    }

    @Override
    public final float readFloatValue() {
        long result;
        float floatValue = 0.0f;
        byte[] bytes = this.bytes;
        int quote = 0;
        int ch = this.ch;
        int offset = this.offset;
        int end = this.end;
        if (ch == 34 || ch == 39) {
            quote = ch;
            ch = offset == end ? 26 : bytes[offset++];
        }
        boolean wasNull = false;
        if (quote != 0 && ch == quote) {
            ch = offset == end ? 26 : bytes[offset++];
            wasNull = true;
            result = 0L;
        } else {
            int d;
            int fc = ch;
            long l = ch >= 48 && ch <= 57 ? (long)(48 - ch) : (result = ch == 45 || ch == 43 ? 0L : 1L);
            while (result <= 0L && offset + 1 < end && (d = IOUtils.digit2(bytes, offset)) != -1) {
                if (-92233720368547758L <= result) {
                    result = result * 100L - (long)d;
                    offset += 2;
                    continue;
                }
                result = 1L;
            }
            if (result <= 0L && offset < end && IOUtils.isDigit(ch = bytes[offset])) {
                if (-922337203685477580L <= result) {
                    result = result * 10L + 48L - (long)ch;
                    ++offset;
                } else {
                    result = 1L;
                }
            }
            int scale = 0;
            if (result <= 0L && offset < end && bytes[offset] == 46) {
                ++offset;
                while (result <= 0L && offset + 1 < end && (d = IOUtils.digit2(bytes, offset)) != -1) {
                    if (-92233720368547758L <= result) {
                        result = result * 100L - (long)d;
                        offset += 2;
                        scale += 2;
                        continue;
                    }
                    result = 1L;
                }
                if (result <= 0L && offset < end && IOUtils.isDigit(ch = bytes[offset])) {
                    if (-922337203685477580L <= result) {
                        result = result * 10L + 48L - (long)ch;
                        ++offset;
                        ++scale;
                    } else {
                        result = 1L;
                    }
                }
            }
            if (result <= 0L) {
                int n = ch = offset == end ? 26 : bytes[offset++];
            }
            if (result <= 0L) {
                if (ch == 101 || ch == 69) {
                    ch = offset == end ? 26 : bytes[offset++];
                    boolean negativeExp = ch == 45;
                    if (negativeExp || ch == 43) {
                        ch = offset == end ? 26 : bytes[offset++];
                    } else if (ch == 44) {
                        throw this.numberError();
                    }
                    if (IOUtils.isDigit(ch)) {
                        int expValue = ch - 48;
                        while (offset < end && IOUtils.isDigit(ch = bytes[offset])) {
                            d = ch - 48;
                            if ((expValue = expValue * 10 + d) > 2047) {
                                throw new JSONException("too large exp value : " + expValue);
                            }
                            ++offset;
                        }
                        if (negativeExp) {
                            expValue = -expValue;
                        }
                        scale -= expValue;
                        ch = offset == end ? 26 : bytes[offset++];
                    } else {
                        result = 1L;
                    }
                } else if (ch == 76 || ch == 70 || ch == 68 || ch == 66 || ch == 83) {
                    int n = ch = offset == end ? 26 : bytes[offset++];
                }
            }
            if (result <= 0L && quote != 0) {
                if (ch == quote) {
                    ch = offset == end ? 26 : bytes[offset++];
                } else {
                    result = 1L;
                }
            }
            if (result <= 0L) {
                boolean value = true;
                if (scale == 0) {
                    floatValue = result;
                } else if ((long)((float)result) == result) {
                    if (0 < scale && scale < JSONFactory.FLOAT_10_POW.length) {
                        floatValue = (float)result / JSONFactory.FLOAT_10_POW[scale];
                    } else if (0 > scale && scale > -JSONFactory.FLOAT_10_POW.length) {
                        floatValue = (float)result * JSONFactory.FLOAT_10_POW[-scale];
                    } else {
                        value = false;
                    }
                } else {
                    value = false;
                }
                if (!value) {
                    if (scale > 0 && scale < 128) {
                        floatValue = TypeUtils.floatValue(fc == 45 ? -1 : 1, Math.abs(result), scale);
                    } else {
                        result = 1L;
                    }
                } else if (fc != 45) {
                    if (floatValue != 0.0f) {
                        floatValue = -floatValue;
                    }
                } else if (result == 0L) {
                    floatValue = -floatValue;
                }
            }
        }
        if (result > 0L) {
            this.readNumber0();
            return this.getFloatValue();
        }
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == end ? 26 : bytes[offset++];
        }
        this.comma = ch == 44;
        if (this.comma) {
            int n = ch = offset == end ? 26 : bytes[offset++];
            while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                ch = offset == end ? 26 : bytes[offset++];
            }
        }
        this.wasNull = wasNull;
        this.ch = (char)ch;
        this.offset = offset;
        return floatValue;
    }

    @Override
    public final void readString(ValueConsumer consumer, boolean quoted) {
        int offset;
        char quote = this.ch;
        int start = offset = this.offset;
        this.valueEscape = false;
        byte[] bytes = this.bytes;
        int i = 0;
        while (true) {
            byte c;
            if ((c = bytes[offset]) == 92) {
                this.valueEscape = true;
                c = bytes[++offset];
                switch (c) {
                    case 117: {
                        offset += 4;
                        break;
                    }
                    case 120: {
                        offset += 2;
                        break;
                    }
                }
                ++offset;
            } else if (c >= 0) {
                if (c == quote) break;
                ++offset;
            } else {
                switch ((c & 0xFF) >> 4) {
                    case 12: 
                    case 13: {
                        offset += 2;
                        break;
                    }
                    case 14: {
                        offset += 3;
                        break;
                    }
                    default: {
                        if (c >> 3 == -2) {
                            offset += 4;
                            ++i;
                            break;
                        }
                        throw new JSONException("malformed input around byte " + offset);
                    }
                }
            }
            ++i;
        }
        int valueLength = i;
        if (this.valueEscape) {
            int bytesMaxiumLength = offset - this.offset;
            char[] chars = new char[valueLength];
            offset = start;
            int i2 = 0;
            int end = this.end;
            while (true) {
                int c;
                if ((c = bytes[offset]) == 92) {
                    c = bytes[++offset];
                    switch (c) {
                        case 117: {
                            c = IOUtils.hexDigit4(bytes, JSONReaderJSONB.check3(offset + 1, end));
                            offset += 4;
                            break;
                        }
                        case 120: {
                            c = JSONReaderUTF8.char2(bytes[offset + 1], bytes[offset + 2]);
                            offset += 2;
                            break;
                        }
                        case 34: 
                        case 92: {
                            break;
                        }
                        default: {
                            c = this.char1(c);
                            break;
                        }
                    }
                } else if (c == 34) break;
                if (c >= 0) {
                    chars[i2] = (char)c;
                    ++offset;
                } else {
                    switch ((c & 0xFF) >> 4) {
                        case 12: 
                        case 13: {
                            chars[i2] = (char)((c & 0x1F) << 6 | bytes[offset + 1] & 0x3F);
                            offset += 2;
                            break;
                        }
                        case 14: {
                            chars[i2] = (char)((c & 0xF) << 12 | (bytes[offset + 1] & 0x3F) << 6 | bytes[offset + 2] & 0x3F);
                            offset += 3;
                            break;
                        }
                        default: {
                            if (c >> 3 == -2) {
                                byte c2 = bytes[offset + 1];
                                byte c3 = bytes[offset + 2];
                                byte c4 = bytes[offset + 3];
                                offset += 4;
                                int uc = c << 18 ^ c2 << 12 ^ c3 << 6 ^ (c4 ^ 0x381F80);
                                if ((c2 & 0xC0) != 128 || (c3 & 0xC0) != 128 || (c4 & 0xC0) != 128 || uc < 65536 || uc >= 0x110000) {
                                    throw new JSONException("malformed input around byte " + offset);
                                }
                                chars[i2++] = (char)((uc >>> 10) + 55232);
                                chars[i2] = (char)((uc & 0x3FF) + 56320);
                                break;
                            }
                            throw new JSONException("malformed input around byte " + offset);
                        }
                    }
                }
                ++i2;
            }
            if (quoted) {
                JSONWriter jsonWriter = JSONWriterUTF8.of();
                jsonWriter.writeString(chars, 0, chars.length);
                byte[] buf = jsonWriter.getBytes();
                consumer.accept(buf, 0, buf.length);
            } else {
                byte[] buf = new byte[bytesMaxiumLength];
                int bytesLength = IOUtils.encodeUTF8(chars, 0, chars.length, buf, 0);
                consumer.accept(buf, 0, bytesLength);
            }
        } else {
            int consumLen;
            int consumStart = quoted ? this.offset - 1 : this.offset;
            int n = consumLen = quoted ? offset - this.offset + 2 : offset - this.offset;
            if (quoted && quote == '\'') {
                byte[] quotedBytes = new byte[consumLen];
                System.arraycopy(bytes, this.offset - 1, quotedBytes, 0, consumLen);
                quotedBytes[0] = 34;
                quotedBytes[quotedBytes.length - 1] = 34;
                consumer.accept(quotedBytes, 0, quotedBytes.length);
            } else {
                consumer.accept(bytes, consumStart, consumLen);
            }
        }
        byte b = bytes[++offset];
        while (b <= 32 && (1L << b & 0x100003700L) != 0L) {
            b = bytes[++offset];
        }
        this.comma = b == 44;
        if (this.comma) {
            this.offset = offset + 1;
            this.next();
        } else {
            this.offset = offset + 1;
            this.ch = (char)b;
        }
    }

    protected void readString0() {
        String str;
        int offset;
        char quote = this.ch;
        int start = offset = this.offset;
        int end = this.end;
        boolean ascii = true;
        this.valueEscape = false;
        byte[] bytes = this.bytes;
        int i = 0;
        while (true) {
            byte c;
            if ((c = bytes[offset]) == 92) {
                this.valueEscape = true;
                offset += (c = bytes[offset + 1]) == 117 ? 6 : (c == 120 ? 4 : 2);
            } else if (c >= 0) {
                if (c == quote) break;
                ++offset;
            } else {
                switch ((c & 0xFF) >> 4) {
                    case 12: 
                    case 13: {
                        offset += 2;
                        ascii = false;
                        break;
                    }
                    case 14: {
                        offset += 3;
                        ascii = false;
                        break;
                    }
                    default: {
                        if (c >> 3 == -2) {
                            offset += 4;
                            ++i;
                            ascii = false;
                            break;
                        }
                        throw new JSONException("malformed input around byte " + offset);
                    }
                }
            }
            ++i;
        }
        int valueLength = i;
        if (this.valueEscape) {
            char[] chars = new char[valueLength];
            offset = start;
            int i2 = 0;
            while (true) {
                int c;
                if ((c = bytes[offset]) == 92) {
                    c = bytes[++offset];
                    switch (c) {
                        case 117: {
                            c = IOUtils.hexDigit4(bytes, JSONReaderJSONB.check3(offset + 1, end));
                            offset += 4;
                            break;
                        }
                        case 120: {
                            c = JSONReaderUTF8.char2(bytes[offset + 1], bytes[offset + 2]);
                            offset += 2;
                            break;
                        }
                        case 34: 
                        case 92: {
                            break;
                        }
                        default: {
                            c = this.char1(c);
                        }
                    }
                    chars[i2] = (char)c;
                    ++offset;
                } else {
                    if (c == 34) break;
                    if (c >= 0) {
                        chars[i2] = (char)c;
                        ++offset;
                    } else {
                        switch ((c & 0xFF) >> 4) {
                            case 12: 
                            case 13: {
                                int n = ++offset;
                                ++offset;
                                byte c2 = bytes[n];
                                chars[i2] = (char)((c & 0x1F) << 6 | c2 & 0x3F);
                                break;
                            }
                            case 14: {
                                int n = ++offset;
                                byte c2 = bytes[n];
                                int n2 = ++offset;
                                ++offset;
                                byte c3 = bytes[n2];
                                chars[i2] = (char)((c & 0xF) << 12 | (c2 & 0x3F) << 6 | c3 & 0x3F);
                                break;
                            }
                            default: {
                                byte c3;
                                byte c2;
                                if (c >> 3 == -2) {
                                    int n = ++offset;
                                    c2 = bytes[n];
                                    int n3 = ++offset;
                                    c3 = bytes[n3];
                                    int n4 = ++offset;
                                    ++offset;
                                    byte c4 = bytes[n4];
                                    int uc = c << 18 ^ c2 << 12 ^ c3 << 6 ^ (c4 ^ 0x381F80);
                                    if ((c2 & 0xC0) != 128 || (c3 & 0xC0) != 128 || (c4 & 0xC0) != 128 || uc < 65536 || uc >= 0x110000) {
                                        throw new JSONException("malformed input around byte " + offset);
                                    }
                                    chars[i2++] = (char)((uc >>> 10) + 55232);
                                    chars[i2] = (char)((uc & 0x3FF) + 56320);
                                    break;
                                }
                                throw new JSONException("malformed input around byte " + offset);
                            }
                        }
                    }
                }
                ++i2;
            }
            str = new String(chars);
        } else if (ascii) {
            int strlen = offset - this.offset;
            str = JDKUtils.ANDROID ? this.getLatin1String(this.offset, strlen) : new String(bytes, this.offset, strlen, StandardCharsets.ISO_8859_1);
        } else {
            str = new String(bytes, this.offset, offset - this.offset, StandardCharsets.UTF_8);
        }
        byte ch = bytes[++offset];
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = bytes[++offset];
        }
        this.comma = ch == 44;
        this.offset = offset + 1;
        if (ch == 44) {
            this.next();
        } else {
            this.ch = (char)ch;
        }
        this.stringValue = str;
    }

    @Override
    public final boolean skipName() {
        this.offset = JSONReaderUTF8.skipName(this, this.bytes, this.offset, this.end);
        return true;
    }

    private static int skipName(JSONReaderUTF8 jsonReader, byte[] bytes, int offset, int end) {
        int ch;
        char quote = jsonReader.ch;
        if (jsonReader.checkNameBegin(quote)) {
            return jsonReader.offset;
        }
        int index = IOUtils.indexOfQuote(bytes, quote, offset, end);
        if (index == -1) {
            throw jsonReader.error("invalid escape character EOI");
        }
        int slashIndex = JSONReaderUTF8.indexOfSlash(jsonReader, bytes, offset, end);
        if (slashIndex == -1 || slashIndex > index) {
            offset = index + 1;
            ch = offset == end ? 26 : bytes[offset++];
        } else {
            offset = JSONReaderUTF8.skipStringEscaped(jsonReader, bytes, slashIndex, quote);
            int n = ch = offset == end ? 26 : bytes[offset++];
        }
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == end ? 26 : bytes[offset++];
        }
        if (ch != 58) {
            throw JSONReaderUTF8.syntaxError(ch);
        }
        int n = ch = offset == end ? 26 : bytes[offset++];
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == end ? 26 : bytes[offset++];
        }
        jsonReader.ch = (char)ch;
        return offset;
    }

    private static int skipNumber(JSONReaderUTF8 jsonReader, byte[] bytes, int offset, int end) {
        int ch = jsonReader.ch;
        if (ch == 45 || ch == 43) {
            if (offset < end) {
                ch = bytes[offset++];
            } else {
                throw jsonReader.error();
            }
        }
        boolean dot = ch == 46;
        boolean num = false;
        if (!dot && ch >= 48 && ch <= 57) {
            num = true;
            do {
                int n = ch = offset == end ? 26 : bytes[offset++];
            } while (ch >= 48 && ch <= 57);
        }
        if (num && ch == 76 | ch == 70 | ch == 68 | ch == 66 | ch == 83) {
            ch = bytes[offset++];
        } else {
            boolean small = false;
            if (ch == 46) {
                small = true;
                int n = ch = offset == end ? 26 : bytes[offset++];
                while (ch >= 48 && ch <= 57) {
                    ch = offset == end ? 26 : bytes[offset++];
                }
            }
            if (!num && !small) {
                throw JSONReaderUTF8.numberError(offset, ch);
            }
            if (ch == 101 || ch == 69) {
                ch = bytes[offset++];
                boolean eSign = false;
                if (ch == 43 || ch == 45) {
                    eSign = true;
                    if (offset < end) {
                        ch = bytes[offset++];
                    } else {
                        throw JSONReaderUTF8.numberError(offset, ch);
                    }
                }
                if (ch >= 48 && ch <= 57) {
                    do {
                        int n = ch = offset == end ? 26 : bytes[offset++];
                    } while (ch >= 48 && ch <= 57);
                } else if (eSign) {
                    throw JSONReaderUTF8.numberError(offset, ch);
                }
            }
            if (ch == 70 || ch == 68) {
                int n = ch = offset == end ? 26 : bytes[offset++];
            }
        }
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == end ? 26 : bytes[offset++];
        }
        boolean comma = false;
        if (ch == 44) {
            comma = true;
            int n = ch = offset == end ? 26 : bytes[offset++];
            while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                ch = offset == end ? 26 : bytes[offset++];
            }
            if (ch == 125 || ch == 93 || ch == 26) {
                throw jsonReader.error(offset, ch);
            }
        } else if (ch != 125 && ch != 93 && ch != 26) {
            throw jsonReader.error(offset, ch);
        }
        jsonReader.comma = comma;
        jsonReader.ch = (char)ch;
        return offset;
    }

    private static int skipString(JSONReaderUTF8 jsonReader, byte[] bytes, int offset, int end) {
        int ch = jsonReader.ch;
        int quote = ch;
        int index = IOUtils.indexOfQuote(bytes, quote, offset, end);
        if (index == -1) {
            throw jsonReader.error("invalid escape character EOI");
        }
        int slashIndex = JSONReaderUTF8.indexOfSlash(jsonReader, bytes, offset, end);
        if (slashIndex == -1 || slashIndex > index) {
            offset = index + 1;
            ch = offset == end ? 26 : bytes[offset++];
        } else {
            offset = JSONReaderUTF8.skipStringEscaped(jsonReader, bytes, slashIndex, quote);
            int n = ch = offset == end ? 26 : bytes[offset++];
        }
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == end ? 26 : bytes[offset++];
        }
        boolean comma = false;
        if (ch == 44) {
            comma = true;
            int n = ch = offset == end ? 26 : bytes[offset++];
            while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                ch = offset == end ? 26 : bytes[offset++];
            }
            if (ch == 125 || ch == 93 || ch == 26) {
                throw jsonReader.error(offset, ch);
            }
        } else if (ch != 125 && ch != 93 && ch != 26) {
            throw jsonReader.error(offset, ch);
        }
        jsonReader.comma = comma;
        jsonReader.ch = (char)ch;
        return offset;
    }

    private static int skipStringEscaped(JSONReaderUTF8 jsonReader, byte[] bytes, int offset, int quote) {
        byte ch = bytes[offset++];
        while (true) {
            if (ch == 92) {
                if ((ch = bytes[offset++]) == 117) {
                    offset += 4;
                } else if (ch == 120) {
                    offset += 2;
                } else if (ch != 92 && ch != 34) {
                    jsonReader.char1(ch);
                }
                ch = bytes[offset++];
                continue;
            }
            if (ch == quote) {
                return offset;
            }
            ch = bytes[offset++];
        }
    }

    private static int skipObject(JSONReaderUTF8 jsonReader, byte[] bytes, int offset, int end) {
        int ch;
        offset = JSONReaderUTF8.next(jsonReader, bytes, offset, end);
        int i = 0;
        while (jsonReader.ch != '}') {
            if (i != 0 && !jsonReader.comma) {
                throw jsonReader.valueError();
            }
            offset = JSONReaderUTF8.skipName(jsonReader, bytes, offset, end);
            offset = JSONReaderUTF8.skipValue(jsonReader, bytes, offset, end);
            ++i;
        }
        int n = ch = offset == end ? 26 : bytes[offset++];
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == end ? 26 : bytes[offset++];
        }
        boolean comma = false;
        if (ch == 44) {
            comma = true;
            int n2 = ch = offset == end ? 26 : bytes[offset++];
            while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                ch = offset == end ? 26 : bytes[offset++];
            }
            if (ch == 125 || ch == 93 || ch == 26) {
                throw jsonReader.error(offset, ch);
            }
        } else if (ch != 125 && ch != 93 && ch != 26) {
            throw jsonReader.error(offset, ch);
        }
        jsonReader.comma = comma;
        jsonReader.ch = (char)ch;
        return offset;
    }

    public static int next(JSONReaderUTF8 jsonReader, byte[] bytes, int offset, int end) {
        int ch;
        int n = ch = offset == end ? 26 : bytes[offset++];
        while (ch == 0 || ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == end ? 26 : bytes[offset++];
        }
        if (ch < 0) {
            jsonReader.char_utf8(ch, offset);
            return jsonReader.offset;
        }
        jsonReader.ch = (char)ch;
        if (ch == 47) {
            jsonReader.offset = offset;
            jsonReader.skipComment();
            return jsonReader.offset;
        }
        return offset;
    }

    private static int skipArray(JSONReaderUTF8 jsonReader, byte[] bytes, int offset, int end) {
        int ch;
        offset = JSONReaderUTF8.next(jsonReader, bytes, offset, end);
        int i = 0;
        while (jsonReader.ch != ']') {
            if (i != 0 && !jsonReader.comma) {
                throw jsonReader.valueError();
            }
            offset = JSONReaderUTF8.skipValue(jsonReader, bytes, offset, end);
            ++i;
        }
        int n = ch = offset == end ? 26 : bytes[offset++];
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == end ? 26 : bytes[offset++];
        }
        boolean comma = false;
        if (ch == 44) {
            comma = true;
            int n2 = ch = offset == end ? 26 : bytes[offset++];
            while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                ch = offset == end ? 26 : bytes[offset++];
            }
        }
        if (!comma && ch != 125 && ch != 93 && ch != 26) {
            throw jsonReader.error(offset, ch);
        }
        if (comma && (ch == 125 || ch == 93 || ch == 26)) {
            throw jsonReader.error(offset, ch);
        }
        jsonReader.comma = comma;
        jsonReader.ch = (char)ch;
        return offset;
    }

    private static int skipFalse(JSONReaderUTF8 jsonReader, byte[] bytes, int offset, int end) {
        int ch;
        if (offset + 4 > end || IOUtils.notALSE(bytes, offset)) {
            throw jsonReader.error();
        }
        int n = ch = (offset += 4) == end ? 26 : bytes[offset++];
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == end ? 26 : bytes[offset++];
        }
        boolean comma = false;
        if (ch == 44) {
            comma = true;
            int n2 = ch = offset == end ? 26 : bytes[offset++];
            while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                ch = offset == end ? 26 : bytes[offset++];
            }
            if (ch == 125 || ch == 93 || ch == 26) {
                throw jsonReader.error(offset, ch);
            }
        } else if (ch != 125 && ch != 93 && ch != 26) {
            throw jsonReader.error(offset, ch);
        }
        jsonReader.comma = comma;
        jsonReader.ch = (char)ch;
        return offset;
    }

    private static int skipTrue(JSONReaderUTF8 jsonReader, byte[] bytes, int offset, int end) {
        int ch;
        if (offset + 3 > end || IOUtils.notTRUE(bytes, offset - 1)) {
            throw jsonReader.error();
        }
        int n = ch = (offset += 3) == end ? 26 : bytes[offset++];
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == end ? 26 : bytes[offset++];
        }
        boolean comma = false;
        if (ch == 44) {
            comma = true;
            int n2 = ch = offset == end ? 26 : bytes[offset++];
            while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                ch = offset == end ? 26 : bytes[offset++];
            }
            if (ch == 125 || ch == 93 || ch == 26) {
                throw jsonReader.error(offset, ch);
            }
        } else if (ch != 125 && ch != 93 && ch != 26) {
            throw jsonReader.error(offset, ch);
        }
        jsonReader.comma = comma;
        jsonReader.ch = (char)ch;
        return offset;
    }

    private static int skipNull(JSONReaderUTF8 jsonReader, byte[] bytes, int offset, int end) {
        int ch;
        if (offset + 3 > end || IOUtils.notNULL(bytes, offset - 1)) {
            throw jsonReader.error();
        }
        int n = ch = (offset += 3) == end ? 26 : bytes[offset++];
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == end ? 26 : bytes[offset++];
        }
        boolean comma = false;
        if (ch == 44) {
            comma = true;
            int n2 = ch = offset == end ? 26 : bytes[offset++];
            while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                ch = offset == end ? 26 : bytes[offset++];
            }
            if (ch == 125 || ch == 93 || ch == 26) {
                throw jsonReader.error(offset, ch);
            }
        } else if (ch != 125 && ch != 93 && ch != 26) {
            throw jsonReader.error(offset, ch);
        }
        jsonReader.comma = comma;
        jsonReader.ch = (char)ch;
        return offset;
    }

    private static int skipSet(JSONReaderUTF8 jsonReader, byte[] bytes, int offset, int end) {
        if (JSONReaderUTF8.nextIfSet(jsonReader, bytes, offset, end)) {
            return JSONReaderUTF8.skipArray(jsonReader, bytes, jsonReader.offset, end);
        }
        throw jsonReader.error();
    }

    private static boolean nextIfSet(JSONReaderUTF8 jsonReader, byte[] chars, int offset, int end) {
        if (offset + 1 < end && chars[offset] == 101 && chars[offset + 1] == 116) {
            int ch;
            int n = ch = (offset += 2) == end ? 26 : chars[offset++];
            while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                ch = offset == end ? 26 : chars[offset++];
            }
            jsonReader.offset = offset;
            jsonReader.ch = (char)ch;
            return true;
        }
        return false;
    }

    private static int skipValue(JSONReaderUTF8 jsonReader, byte[] bytes, int offset, int end) {
        switch (jsonReader.ch) {
            case 't': {
                return JSONReaderUTF8.skipTrue(jsonReader, bytes, offset, end);
            }
            case 'f': {
                return JSONReaderUTF8.skipFalse(jsonReader, bytes, offset, end);
            }
            case 'n': {
                return JSONReaderUTF8.skipNull(jsonReader, bytes, offset, end);
            }
            case '\"': 
            case '\'': {
                return JSONReaderUTF8.skipString(jsonReader, bytes, offset, end);
            }
            case '{': {
                return JSONReaderUTF8.skipObject(jsonReader, bytes, offset, end);
            }
            case '[': {
                return JSONReaderUTF8.skipArray(jsonReader, bytes, offset, end);
            }
            case 'S': {
                return JSONReaderUTF8.skipSet(jsonReader, bytes, offset, end);
            }
        }
        return JSONReaderUTF8.skipNumber(jsonReader, bytes, offset, end);
    }

    @Override
    public final void skipValue() {
        this.offset = JSONReaderUTF8.skipValue(this, this.bytes, this.offset, this.end);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public final String getString() {
        if (this.stringValue != null) {
            return this.stringValue;
        }
        bytes = this.bytes;
        offset = this.nameBegin;
        end = this.end;
        length = this.nameEnd - offset;
        if (!this.nameEscape) {
            if (JDKUtils.ANDROID) {
                return this.getLatin1String(offset, length);
            }
            return new String(bytes, offset, length, this.nameAscii != false ? StandardCharsets.ISO_8859_1 : StandardCharsets.UTF_8);
        }
        chars = new char[this.nameLength];
        i = 0;
        while (true) {
            block19: {
                block18: {
                    if ((c = bytes[offset]) >= '\u0000') break block18;
                    switch ((c & 255) >> 4) {
                        case 12: 
                        case 13: {
                            char2 = bytes[offset + 1];
                            if ((char2 & 192) != 128) {
                                throw new JSONException("malformed input around byte " + offset);
                            }
                            c = (char)((c & 31) << 6 | char2 & 63);
                            offset += 2;
                            break;
                        }
                        case 14: {
                            char2 = bytes[offset + 1];
                            char3 = bytes[offset + 2];
                            if ((char2 & 192) != 128 || (char3 & 192) != 128) {
                                throw new JSONException("malformed input around byte " + (offset + 2));
                            }
                            c = (char)((c & 15) << 12 | (char2 & 63) << 6 | char3 & 63);
                            offset += 3;
                            break;
                        }
                        default: {
                            if (c >> 3 != -2) ** GOTO lbl43
                            c2 = bytes[offset + 1];
                            c3 = bytes[offset + 2];
                            c4 = bytes[offset + 3];
                            offset += 4;
                            uc = c << 18 ^ c2 << 12 ^ c3 << 6 ^ (c4 ^ 3678080);
                            if ((c2 & 192) != 128 || (c3 & 192) != 128 || (c4 & 192) != 128 || uc < 65536 || uc >= 0x110000) {
                                throw new JSONException("malformed input around byte " + offset);
                            }
                            chars[i++] = (char)((uc >>> 10) + 55232);
                            chars[i] = (char)((uc & 1023) + 56320);
                            break block19;
lbl43:
                            // 1 sources

                            c = (char)(c & 255);
                            ++offset;
                        }
                    }
                    chars[i] = c;
                    break block19;
                }
                if (c == '\\') {
                    c = (char)bytes[++offset];
                    switch (c) {
                        case 'u': {
                            c = (char)IOUtils.hexDigit4(bytes, JSONReaderJSONB.check3(offset + 1, end));
                            offset += 4;
                            break;
                        }
                        case 'x': {
                            c1 = bytes[offset + 1];
                            c2 = bytes[offset + 2];
                            c = JSONReaderUTF8.char2(c1, c2);
                            offset += 2;
                            break;
                        }
                        case '\"': 
                        case '\\': {
                            break;
                        }
                        default: {
                            c = this.char1(c);
                            break;
                        }
                    }
                } else if (c == '\"') break;
                chars[i] = c;
                ++offset;
            }
            ++i;
        }
        this.stringValue = new String(chars);
        return this.stringValue;
    }

    @Override
    public final void skipComment() {
        boolean multi;
        int ch;
        int offset = this.offset;
        if (offset + 1 >= this.end) {
            throw new JSONException(this.info());
        }
        byte[] bytes = this.bytes;
        if ((ch = bytes[offset++]) == 42) {
            multi = true;
        } else if (ch == 47) {
            multi = false;
        } else {
            throw new JSONException(this.info("parse comment error"));
        }
        ch = bytes[offset++];
        while (true) {
            boolean endOfComment = false;
            if (multi) {
                if (ch == 42 && offset <= this.end && bytes[offset] == 47) {
                    ++offset;
                    endOfComment = true;
                }
            } else {
                boolean bl = endOfComment = ch == 10;
            }
            if (endOfComment) {
                if (offset >= this.end) {
                    ch = 26;
                    break;
                }
                ch = bytes[offset];
                while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                    if (++offset >= this.end) {
                        ch = 26;
                        break;
                    }
                    ch = bytes[offset];
                }
                ++offset;
                break;
            }
            if (offset >= this.end) {
                ch = 26;
                break;
            }
            ch = bytes[offset++];
        }
        this.ch = (char)ch;
        this.offset = offset;
        if (ch == 47) {
            this.skipComment();
        }
    }

    static boolean containsSlashOrQuote(long v, long quote) {
        long x22 = v ^ quote;
        long x5c = v ^ 0x5C5C5C5C5C5C5C5CL;
        return (((x22 = x22 - 0x101010101010101L & (x22 ^ 0xFFFFFFFFFFFFFFFFL)) | (x5c = x5c - 0x101010101010101L & (x5c ^ 0xFFFFFFFFFFFFFFFFL))) & 0x8080808080808080L) != 0L;
    }

    @Override
    public String readString() {
        char quote = this.ch;
        if (quote == '\"' || quote == '\'') {
            String str;
            char ch;
            long v;
            int offset;
            byte[] bytes = this.bytes;
            int start = offset = this.offset;
            int end = this.end;
            long byteVectorQuote = quote == '\'' ? 0x2727272727272727L : 0x2222222222222222L;
            boolean ascii = true;
            this.valueEscape = false;
            int i = 0;
            int upperBound = offset + (end - offset & 0xFFFFFFF8);
            while (offset < upperBound && ((v = IOUtils.getLongLE(bytes, offset)) & 0x8080808080808080L) == 0L && !JSONReaderUTF8.containsSlashOrQuote(v, byteVectorQuote)) {
                offset += 8;
                i += 8;
            }
            while (true) {
                if (offset >= end) {
                    throw new JSONException("invalid escape character EOI");
                }
                byte c = bytes[offset];
                if (c == 92) {
                    this.valueEscape = true;
                    offset += (c = bytes[offset + 1]) == 117 ? 6 : (c == 120 ? 4 : 2);
                    if (ascii && (c == 117 || c == 120)) {
                        ascii = false;
                    }
                } else if (c >= 0) {
                    if (c == quote) break;
                    ++offset;
                } else {
                    ascii = false;
                    switch ((c & 0xFF) >> 4) {
                        case 12: 
                        case 13: {
                            offset += 2;
                            break;
                        }
                        case 14: {
                            offset += 3;
                            break;
                        }
                        default: {
                            if (c >> 3 == -2) {
                                offset += 4;
                                ++i;
                                break;
                            }
                            throw new JSONException("malformed input around byte " + offset);
                        }
                    }
                }
                ++i;
            }
            int valueLength = i;
            if (this.valueEscape) {
                int i2;
                if (ascii && JDKUtils.STRING_CREATOR_JDK11 != null) {
                    byte[] chars = new byte[valueLength];
                    offset = start;
                    i2 = 0;
                    while (true) {
                        if ((ch = bytes[offset]) == '\\') {
                            ch = bytes[++offset];
                            switch (ch) {
                                case '\"': 
                                case '\\': {
                                    break;
                                }
                                case 'b': {
                                    ch = '\b';
                                    break;
                                }
                                case 't': {
                                    ch = '\t';
                                    break;
                                }
                                case 'n': {
                                    ch = '\n';
                                    break;
                                }
                                case 'f': {
                                    ch = '\f';
                                    break;
                                }
                                case 'r': {
                                    ch = '\r';
                                    break;
                                }
                                default: {
                                    ch = this.char1(ch);
                                    break;
                                }
                            }
                        } else if (ch == quote) break;
                        chars[i2] = ch;
                        ++offset;
                        ++i2;
                    }
                    str = JDKUtils.STRING_CREATOR_JDK11.apply(chars, JDKUtils.LATIN1);
                } else {
                    char[] chars = new char[valueLength];
                    offset = start;
                    i2 = 0;
                    while (true) {
                        if ((ch = bytes[offset]) == '\\') {
                            ch = bytes[++offset];
                            switch (ch) {
                                case 'u': {
                                    ch = IOUtils.hexDigit4(bytes, JSONReaderJSONB.check3(offset + 1, end));
                                    offset += 4;
                                    break;
                                }
                                case 'x': {
                                    ch = JSONReaderUTF8.char2(bytes[offset + 1], bytes[offset + 2]);
                                    offset += 2;
                                    break;
                                }
                                case '\"': 
                                case '\\': {
                                    break;
                                }
                                case 'b': {
                                    ch = '\b';
                                    break;
                                }
                                case 't': {
                                    ch = '\t';
                                    break;
                                }
                                case 'n': {
                                    ch = '\n';
                                    break;
                                }
                                case 'f': {
                                    ch = '\f';
                                    break;
                                }
                                case 'r': {
                                    ch = '\r';
                                    break;
                                }
                                default: {
                                    ch = this.char1(ch);
                                }
                            }
                            chars[i2] = ch;
                            ++offset;
                        } else {
                            if (ch == quote) break;
                            if (ch >= '\u0000') {
                                chars[i2] = ch;
                                ++offset;
                            } else {
                                switch ((ch & 0xFF) >> 4) {
                                    case 12: 
                                    case 13: {
                                        chars[i2] = (char)((ch & 0x1F) << 6 | bytes[offset + 1] & 0x3F);
                                        offset += 2;
                                        break;
                                    }
                                    case 14: {
                                        chars[i2] = (char)((ch & 0xF) << 12 | (bytes[offset + 1] & 0x3F) << 6 | (bytes[offset + 2] & 0x3F) << 0);
                                        offset += 3;
                                        break;
                                    }
                                    default: {
                                        JSONReaderUTF8.char2_utf8(bytes, offset, ch, chars, i2);
                                        offset += 4;
                                        ++i2;
                                    }
                                }
                            }
                        }
                        ++i2;
                    }
                    str = new String(chars);
                }
            } else {
                int strlen;
                str = ascii ? ((strlen = offset - start) == 1 ? TypeUtils.toString((char)(bytes[start] & 0xFF)) : (strlen == 2 ? TypeUtils.toString((char)(bytes[start] & 0xFF), (char)(bytes[start + 1] & 0xFF)) : (JDKUtils.STRING_CREATOR_JDK11 != null ? JDKUtils.STRING_CREATOR_JDK11.apply(Arrays.copyOfRange(this.bytes, this.offset, offset), JDKUtils.LATIN1) : new String(bytes, start, offset - start, StandardCharsets.US_ASCII)))) : new String(bytes, start, offset - start, StandardCharsets.UTF_8);
            }
            long features = this.context.features;
            if ((features & 0x8004000L) != 0L) {
                str = JSONReaderUTF8.stringValue(str, features);
            }
            char c = ch = ++offset == end ? (char)'\u001a' : bytes[offset++];
            while (ch <= ' ' && (1L << ch & 0x100003700L) != 0L) {
                ch = offset == end ? (char)'\u001a' : bytes[offset++];
            }
            this.comma = ch == ',';
            if (this.comma) {
                char c2 = ch = offset == end ? (char)'\u001a' : bytes[offset++];
                while (ch <= ' ' && (1L << ch & 0x100003700L) != 0L) {
                    ch = offset == end ? (char)'\u001a' : bytes[offset++];
                }
            }
            this.ch = ch;
            this.offset = offset;
            return str;
        }
        if (quote == 'n') {
            this.readNull();
            return null;
        }
        return this.readStringNotMatch();
    }

    @Override
    public final void readNumber0() {
        int digit;
        boolean valid = false;
        this.wasNull = false;
        this.mag0 = 0;
        this.mag1 = 0;
        this.mag2 = 0;
        this.mag3 = 0;
        this.negative = false;
        this.exponent = 0;
        this.scale = 0;
        int firstOffset = this.offset;
        byte[] bytes = this.bytes;
        int end = this.end;
        int ch = this.ch;
        int offset = this.offset;
        int quote = 0;
        if ((ch == 34 || ch == 39) && (ch = (char)bytes[offset++]) == (quote = ch)) {
            int n = ch = offset == end ? 26 : bytes[offset++];
            while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                ch = offset == end ? 26 : bytes[offset++];
            }
            this.ch = (char)ch;
            this.offset = offset;
            this.comma = this.nextIfComma();
            this.wasNull = true;
            this.valueType = (byte)5;
            return;
        }
        int start = offset;
        if (ch == 45) {
            if (offset == end) {
                throw new JSONException(this.info("illegal input"));
            }
            this.negative = true;
            ch = bytes[offset++];
        } else if (ch == 43) {
            if (offset == end) {
                throw new JSONException(this.info("illegal input"));
            }
            ch = bytes[offset++];
        }
        boolean intOverflow = false;
        this.valueType = 1;
        while (ch >= 48 && ch <= 57) {
            valid = true;
            if (!intOverflow) {
                digit = ch - 48;
                this.mag3 *= 10;
                if (this.mag3 < -214748364) {
                    intOverflow = true;
                } else {
                    this.mag3 -= digit;
                    if (this.mag3 < -214748364) {
                        intOverflow = true;
                    }
                }
            }
            if (offset == end) {
                ch = 26;
                ++offset;
                break;
            }
            ch = bytes[offset++];
        }
        if (ch == 46) {
            this.valueType = (byte)2;
            ch = bytes[offset++];
            while (ch >= 48 && ch <= 57) {
                valid = true;
                if (!intOverflow) {
                    digit = ch - 48;
                    this.mag3 *= 10;
                    if (this.mag3 < -214748364) {
                        intOverflow = true;
                    } else {
                        this.mag3 -= digit;
                        if (this.mag3 < -214748364) {
                            intOverflow = true;
                        }
                    }
                }
                this.scale = (short)(this.scale + 1);
                if (offset == end) {
                    ch = 26;
                    ++offset;
                    break;
                }
                ch = bytes[offset++];
            }
        }
        if (intOverflow) {
            int numDigits;
            int numStart = this.negative ? start : start - 1;
            int n = numDigits = this.scale > 0 ? offset - 2 - numStart : offset - 1 - numStart;
            if (numDigits > 38) {
                this.valueType = (byte)8;
                if (this.negative) {
                    --numStart;
                }
                this.stringValue = new String(bytes, numStart, offset - 1 - numStart);
            } else {
                this.bigInt(bytes, numStart, offset - 1);
            }
        } else {
            this.mag3 = -this.mag3;
        }
        if (ch == 101 || ch == 69) {
            boolean negativeExp = false;
            int expValue = 0;
            if ((ch = bytes[offset++]) == 45) {
                negativeExp = true;
                ch = bytes[offset++];
            } else if (ch == 43) {
                ch = (char)bytes[offset++];
            }
            while (ch >= 48 && ch <= 57) {
                valid = true;
                int byteVal = ch - 48;
                if ((expValue = expValue * 10 + byteVal) > 2047) {
                    throw new JSONException("too large exp value : " + expValue);
                }
                if (offset == end) {
                    ch = 26;
                    break;
                }
                ch = bytes[offset++];
            }
            if (negativeExp) {
                expValue = -expValue;
            }
            this.exponent = (short)expValue;
            this.valueType = (byte)2;
        }
        if (offset == start) {
            if (ch == 110) {
                if (bytes[offset] == 117 && bytes[offset + 1] == 108 && bytes[offset + 2] == 108) {
                    valid = true;
                    this.wasNull = true;
                    this.valueType = (byte)5;
                    ch = (offset += 3) == end ? 26 : bytes[offset++];
                }
            } else if (ch == 116 && bytes[offset] == 114 && bytes[offset + 1] == 117 && bytes[offset + 2] == 101) {
                valid = true;
                this.boolValue = true;
                this.valueType = (byte)4;
                ch = (offset += 3) == end ? 26 : bytes[offset++];
            } else if (ch == 102 && offset + 3 < end && IOUtils.isALSE(bytes, offset)) {
                valid = true;
                this.boolValue = false;
                this.valueType = (byte)4;
                ch = (offset += 4) == end ? 26 : bytes[offset++];
            } else if (ch == 78 && bytes[offset] == 97 && bytes[offset + 1] == 78) {
                valid = true;
                this.boolValue = true;
                this.valueType = (byte)14;
                ch = (offset += 2) == end ? 26 : bytes[offset++];
            } else {
                if (ch == 123 && quote == 0) {
                    this.offset = offset;
                    this.ch = (char)ch;
                    this.complex = this.readObject();
                    this.valueType = (byte)6;
                    return;
                }
                if (ch == 91 && quote == 0) {
                    this.offset = offset;
                    this.ch = (char)ch;
                    this.complex = this.readArray();
                    this.valueType = (byte)7;
                    return;
                }
            }
        }
        if (quote != 0) {
            if (ch != quote) {
                this.offset = firstOffset;
                this.ch = (char)quote;
                this.readString0();
                this.valueType = (byte)3;
                return;
            }
            int n = ch = offset == end ? 26 : bytes[offset++];
        }
        if (ch == 76 || ch == 70 || ch == 68 || ch == 66 || ch == 83) {
            switch (ch) {
                case 66: {
                    if (intOverflow || this.valueType == 2) break;
                    this.valueType = (byte)9;
                    break;
                }
                case 83: {
                    if (intOverflow || this.valueType == 2) break;
                    this.valueType = (byte)10;
                    break;
                }
                case 76: {
                    if (offset - start >= 19 || this.valueType == 2) break;
                    this.valueType = (byte)11;
                    break;
                }
                case 70: {
                    this.valueType = (byte)12;
                    break;
                }
                case 68: {
                    this.valueType = (byte)13;
                    break;
                }
            }
            int n = ch = offset == end ? 26 : bytes[offset++];
        }
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == end ? 26 : bytes[offset++];
        }
        this.comma = ch == 44;
        if (this.comma) {
            int n = ch = offset == end ? 26 : bytes[offset++];
            while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                ch = offset == end ? 26 : bytes[offset++];
            }
        }
        if (!valid) {
            throw new JSONException(this.info("illegal input error"));
        }
        this.offset = offset;
        this.ch = (char)ch;
    }

    @Override
    public final void readNumber(ValueConsumer consumer, boolean quoted) {
        int mag3_10;
        boolean valid = false;
        this.wasNull = false;
        this.boolValue = false;
        this.mag0 = 0;
        this.mag1 = 0;
        this.mag2 = 0;
        this.mag3 = 0;
        this.negative = false;
        this.exponent = 0;
        this.scale = 0;
        int end = this.end;
        byte[] bytes = this.bytes;
        char quote = '\u0000';
        if (this.ch == '\"' || this.ch == '\'') {
            quote = this.ch;
            this.ch = (char)bytes[this.offset++];
        }
        int start = this.offset;
        if (this.ch == '-') {
            this.negative = true;
            this.ch = (char)bytes[this.offset++];
        }
        boolean intOverflow = false;
        this.valueType = 1;
        while (this.ch >= '0' && this.ch <= '9') {
            valid = true;
            if (!intOverflow) {
                mag3_10 = this.mag3 * 10 + (this.ch - 48);
                if (mag3_10 < this.mag3) {
                    intOverflow = true;
                } else {
                    this.mag3 = mag3_10;
                }
            }
            this.ch = (char)bytes[this.offset++];
        }
        if (this.ch == '.') {
            this.valueType = (byte)2;
            this.ch = (char)bytes[this.offset++];
            while (this.ch >= '0' && this.ch <= '9') {
                valid = true;
                if (!intOverflow) {
                    mag3_10 = this.mag3 * 10 + (this.ch - 48);
                    if (mag3_10 < this.mag3) {
                        intOverflow = true;
                    } else {
                        this.mag3 = mag3_10;
                    }
                }
                this.scale = (short)(this.scale + 1);
                this.ch = (char)bytes[this.offset++];
            }
        }
        if (intOverflow) {
            int numStart = this.negative ? start : start - 1;
            this.bigInt(bytes, numStart, this.offset - 1);
        }
        if (this.ch == 'e' || this.ch == 'E') {
            boolean negativeExp = false;
            int expValue = 0;
            this.ch = (char)bytes[this.offset++];
            if (this.ch == '-') {
                negativeExp = true;
                this.ch = (char)bytes[this.offset++];
            } else if (this.ch == '+') {
                this.ch = (char)bytes[this.offset++];
            }
            while (this.ch >= '0' && this.ch <= '9') {
                valid = true;
                int byteVal = this.ch - 48;
                if ((expValue = expValue * 10 + byteVal) > 2047) {
                    throw new JSONException("too large exp value : " + expValue);
                }
                this.ch = (char)bytes[this.offset++];
            }
            if (negativeExp) {
                expValue = -expValue;
            }
            this.exponent = (short)expValue;
            this.valueType = (byte)2;
        }
        int len = this.offset - start;
        if (this.offset == start) {
            if (this.ch == 'n') {
                if (bytes[this.offset++] == 117 && bytes[this.offset++] == 108 && bytes[this.offset++] == 108) {
                    valid = true;
                    this.wasNull = true;
                    this.valueType = (byte)5;
                    this.ch = (char)bytes[this.offset++];
                }
            } else if (this.ch == 't') {
                if (bytes[this.offset++] == 114 && bytes[this.offset++] == 117 && bytes[this.offset++] == 101) {
                    valid = true;
                    this.boolValue = true;
                    this.valueType = (byte)4;
                    this.ch = (char)bytes[this.offset++];
                }
            } else if (this.ch == 'f' && this.offset + 3 < end && IOUtils.isALSE(bytes, this.offset)) {
                valid = true;
                this.offset += 4;
                this.boolValue = false;
                this.valueType = (byte)4;
                this.ch = (char)bytes[this.offset++];
            } else {
                if (this.ch == '{' && quote == '\u0000') {
                    this.complex = this.readObject();
                    this.valueType = (byte)6;
                    return;
                }
                if (this.ch == '[' && quote == '\u0000') {
                    this.complex = this.readArray();
                    this.valueType = (byte)7;
                    return;
                }
            }
        }
        if (quote != '\u0000') {
            if (this.ch != quote) {
                --this.offset;
                this.ch = quote;
                this.readString0();
                this.valueType = (byte)3;
                return;
            }
            this.ch = (char)bytes[this.offset++];
        }
        while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
            if (this.offset >= end) {
                this.ch = (char)26;
                continue;
            }
            this.ch = (char)bytes[this.offset++];
        }
        this.comma = this.ch == ',';
        if (this.comma) {
            this.ch = (char)bytes[this.offset++];
            if (this.offset >= end) {
                this.ch = (char)26;
            } else {
                while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                    if (this.offset >= end) {
                        this.ch = (char)26;
                        continue;
                    }
                    this.ch = (char)bytes[this.offset++];
                }
            }
        }
        if (!(quoted || this.valueType != 1 && this.valueType != 2)) {
            consumer.accept(bytes, start - 1, len);
            return;
        }
        if (this.valueType == 1) {
            if (this.mag0 == 0 && this.mag1 == 0 && this.mag2 == 0 && this.mag3 != Integer.MIN_VALUE) {
                int intValue = this.negative ? -this.mag3 : this.mag3;
                consumer.accept(intValue);
                return;
            }
            if (this.mag0 == 0 && this.mag1 == 0) {
                long v3 = (long)this.mag3 & 0xFFFFFFFFL;
                long v2 = (long)this.mag2 & 0xFFFFFFFFL;
                if (v2 <= Integer.MAX_VALUE) {
                    long v23 = (v2 << 32) + v3;
                    long longValue = this.negative ? -v23 : v23;
                    consumer.accept(longValue);
                    return;
                }
            }
        }
        Number number = this.getNumber();
        consumer.accept(number);
        if (!valid) {
            throw new JSONException(this.info("illegal input error"));
        }
    }

    @Override
    public final boolean readIfNull() {
        byte[] bytes = this.bytes;
        int ch = this.ch;
        int offset = this.offset;
        if (ch == 110 && bytes[offset] == 117 && bytes[offset + 1] == 108 && bytes[offset + 2] == 108) {
            ch = offset + 3 == this.end ? 26 : (int)((char)bytes[offset + 3]);
            offset += 4;
        } else {
            return false;
        }
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == this.end ? 26 : bytes[offset++];
        }
        this.comma = ch == 44;
        if (this.comma) {
            ch = (char)(offset == this.end ? 26 : (char)bytes[offset++]);
            char c = (char)ch;
            while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                ch = offset == this.end ? 26 : bytes[offset++];
            }
        }
        this.offset = offset;
        this.ch = (char)ch;
        return true;
    }

    @Override
    public final boolean isNull() {
        return this.ch == 'n' && this.offset < this.end && this.bytes[this.offset] == 117;
    }

    @Override
    public final Date readNullOrNewDate() {
        int ch;
        byte[] bytes = this.bytes;
        int offset = this.offset;
        Date date = null;
        if (offset + 2 < this.end && bytes[offset] == 117 && bytes[offset + 1] == 108 && bytes[offset + 2] == 108) {
            ch = offset + 3 == this.end ? 26 : bytes[offset + 3];
            offset += 4;
        } else if (offset + 1 < this.end && bytes[offset] == 101 && bytes[offset + 1] == 119) {
            ch = offset + 3 == this.end ? 26 : bytes[offset + 2];
            offset += 3;
            while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                ch = offset == this.end ? 26 : bytes[offset++];
            }
            if (offset + 4 < this.end && ch == 68 && bytes[offset] == 97 && bytes[offset + 1] == 116 && bytes[offset + 2] == 101) {
                ch = offset + 3 == this.end ? 26 : bytes[offset + 3];
                offset += 4;
            } else {
                throw new JSONException("json syntax error, not match new Date" + offset);
            }
            while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                ch = offset == this.end ? 26 : bytes[offset++];
            }
            if (ch != 40 || offset >= this.end) {
                throw new JSONException("json syntax error, not match new Date" + offset);
            }
            ch = bytes[offset++];
            while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                ch = offset == this.end ? 26 : bytes[offset++];
            }
            this.ch = (char)ch;
            this.offset = offset;
            long millis = this.readInt64Value();
            ch = this.ch;
            offset = this.offset;
            if (ch != 41) {
                throw new JSONException("json syntax error, not match new Date" + offset);
            }
            ch = offset >= this.end ? 26 : bytes[offset++];
            date = new Date(millis);
        } else {
            throw new JSONException("json syntax error, not match null or new Date" + offset);
        }
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == this.end ? 26 : bytes[offset++];
        }
        this.comma = ch == 44;
        if (this.comma) {
            int n = ch = offset == this.end ? 26 : bytes[offset++];
            while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                ch = offset == this.end ? 26 : bytes[offset++];
            }
        }
        this.offset = offset;
        this.ch = (char)ch;
        return date;
    }

    @Override
    public final boolean nextIfNull() {
        int offset = this.offset;
        if (this.ch == 'n' && offset + 2 < this.end && this.bytes[offset] == 117) {
            this.readNull();
            return true;
        }
        return false;
    }

    @Override
    public final void readNull() {
        int ch;
        byte[] bytes = this.bytes;
        int offset = this.offset;
        if (bytes[offset] == 117 && bytes[offset + 1] == 108 && bytes[offset + 2] == 108) {
            ch = (offset += 3) == this.end ? 26 : bytes[offset++];
        } else {
            throw new JSONException("json syntax error, not match null" + offset);
        }
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset >= this.end ? 26 : bytes[offset++];
        }
        this.comma = ch == 44;
        if (this.comma) {
            int n = ch = offset >= this.end ? 26 : bytes[offset++];
            while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                ch = offset >= this.end ? 26 : bytes[offset++];
            }
        }
        this.ch = (char)ch;
        this.offset = offset;
    }

    @Override
    public final double readNaN() {
        int ch;
        byte[] bytes = this.bytes;
        int offset = this.offset;
        if (bytes[offset] == 97 && bytes[offset + 1] == 78) {
            ch = (offset += 2) == this.end ? 26 : bytes[offset++];
        } else {
            throw new JSONException("json syntax error, not NaN " + offset);
        }
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset >= this.end ? 26 : bytes[offset++];
        }
        this.comma = ch == 44;
        if (this.comma) {
            int n = ch = offset >= this.end ? 26 : bytes[offset++];
            while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                ch = offset >= this.end ? 26 : bytes[offset++];
            }
        }
        this.ch = (char)ch;
        this.offset = offset;
        return Double.NaN;
    }

    @Override
    public final int getStringLength() {
        if (this.ch != '\"' && this.ch != '\'') {
            throw new JSONException("string length only support string input " + this.ch);
        }
        char quote = this.ch;
        int len = 0;
        int i = this.offset;
        byte[] bytes = this.bytes;
        int i8 = i + 8;
        if (i8 < this.end && i8 < bytes.length && bytes[i] != quote && bytes[i + 1] != quote && bytes[i + 2] != quote && bytes[i + 3] != quote && bytes[i + 4] != quote && bytes[i + 5] != quote && bytes[i + 6] != quote && bytes[i + 7] != quote) {
            i += 8;
            len += 8;
        }
        while (i < this.end && bytes[i] != quote) {
            ++i;
            ++len;
        }
        return len;
    }

    @Override
    public final LocalDate readLocalDate() {
        byte[] bytes = this.bytes;
        int offset = this.offset;
        char quote = this.ch;
        if (!(quote != '\"' && quote != '\'' || this.context.formatComplex)) {
            long ymd;
            int yy;
            int c10 = offset + 10;
            if (c10 < bytes.length && c10 < this.end && (yy = DateUtils.yy(bytes, offset)) != -1 && (ymd = DateUtils.ymd(bytes, offset + 2)) != -1L && bytes[offset + 10] == quote) {
                LocalDate ldt;
                int year = yy + ((int)ymd & 0xFF);
                int month = (int)(ymd >> 24) & 0xFF;
                int dom = (int)(ymd >> 48) & 0xFF;
                try {
                    ldt = (year | month | dom) == 0 ? null : LocalDate.of(year, month, dom);
                }
                catch (DateTimeException ex) {
                    throw this.error("read date error", ex);
                }
                this.offset = offset + 11;
                this.next();
                this.comma = this.ch == ',';
                if (this.comma) {
                    this.next();
                }
                return ldt;
            }
            LocalDate localDate = this.readLocalDate0(offset, bytes, quote);
            if (localDate != null) {
                return localDate;
            }
        }
        return super.readLocalDate();
    }

    private LocalDate readLocalDate0(int offset, byte[] bytes, char quote) {
        int i;
        int nextQuoteOffset = -1;
        int end = Math.min(i + 17, this.end);
        for (i = offset; i < end; ++i) {
            if (bytes[i] != quote) continue;
            nextQuoteOffset = i;
        }
        if (nextQuoteOffset != -1 && nextQuoteOffset - offset > 10 && bytes[nextQuoteOffset - 6] == 45 && bytes[nextQuoteOffset - 3] == 45) {
            int year = TypeUtils.parseInt(bytes, offset, nextQuoteOffset - offset - 6);
            int month = IOUtils.digit2(bytes, nextQuoteOffset - 5);
            int dayOfMonth = IOUtils.digit2(bytes, nextQuoteOffset - 2);
            LocalDate localDate = LocalDate.of(year, month, dayOfMonth);
            this.offset = nextQuoteOffset + 1;
            this.next();
            this.comma = this.ch == ',';
            if (this.comma) {
                this.next();
            }
            return localDate;
        }
        return null;
    }

    @Override
    public final OffsetDateTime readOffsetDateTime() {
        ZonedDateTime zdt;
        long hms;
        byte c10;
        long ymd;
        int yy;
        int off21;
        byte[] bytes = this.bytes;
        int offset = this.offset;
        int end = this.end;
        char quote = this.ch;
        if (!(quote != '\"' && quote != '\'' || this.context.formatComplex || (off21 = offset + 19) >= bytes.length || off21 >= end || (yy = DateUtils.yy(bytes, offset)) == -1 || (ymd = DateUtils.ymd(bytes, offset + 2)) == -1L || (c10 = bytes[offset + 10]) != 32 && c10 != 84 || (hms = DateUtils.hms(bytes, offset + 11)) == -1L)) {
            int quoteIndex;
            char ch;
            int nanos = 0;
            int nanoSize = 0;
            offset += 19;
            if ((ch = bytes[offset++]) == '.') {
                ch = bytes[offset++];
            }
            while (ch >= '0' && ch <= '9') {
                nanos = nanos * 10 + (ch - 48);
                ++nanoSize;
                if (offset >= end) break;
                ch = bytes[offset++];
            }
            if (nanoSize != 0) {
                nanos = DateUtils.nanos(nanos, nanoSize);
            }
            ZoneOffset zoneOffset = ZoneOffset.UTC;
            if (ch == 'Z') {
                ch = bytes[offset++];
            } else if (ch != quote && (quoteIndex = IOUtils.indexOfChar(bytes, 34, offset, end)) != -1) {
                zoneOffset = DateUtils.zoneOffset(bytes, offset - 1, quoteIndex - offset + 1);
                offset = quoteIndex + 1;
                ch = quote;
            }
            if (ch == quote) {
                char c = ch = offset >= end ? (char)'\u001a' : bytes[offset++];
                while (ch == '\u0000' || ch <= ' ' && (1L << ch & 0x100003700L) != 0L) {
                    ch = offset == end ? (char)'\u001a' : bytes[offset++];
                }
                this.comma = ch == ',';
                if (this.comma) {
                    ch = offset == end ? (char)'\u001a' : (char)bytes[offset++];
                    char c2 = ch;
                    while (ch <= ' ' && (1L << ch & 0x100003700L) != 0L) {
                        ch = offset == end ? (char)'\u001a' : bytes[offset++];
                    }
                }
                if (ch < '\u0000') {
                    this.char_utf8(ch, offset);
                } else {
                    this.offset = offset;
                    this.ch = ch;
                }
                return OffsetDateTime.of(yy + ((int)ymd & 0xFF), (int)(ymd >> 24) & 0xFF, (int)(ymd >> 48) & 0xFF, (int)hms & 0xFF, (int)(hms >> 24) & 0xFF, (int)(hms >> 48) & 0xFF, nanos, zoneOffset);
            }
        }
        return (zdt = this.readZonedDateTime()) == null ? null : zdt.toOffsetDateTime();
    }

    @Override
    public final OffsetTime readOffsetTime() {
        byte[] bytes = this.bytes;
        int offset = this.offset;
        JSONReader.Context context = this.context;
        if ((this.ch == '\"' || this.ch == '\'') && context.dateFormat == null) {
            char quote = this.ch;
            int off10 = offset + 8;
            if (off10 < bytes.length && off10 < this.end && bytes[offset + 2] == 58 && bytes[offset + 5] == 58) {
                ZoneOffset zoneOffset;
                int start;
                byte h0 = bytes[offset];
                byte h1 = bytes[offset + 1];
                byte i0 = bytes[offset + 3];
                byte i1 = bytes[offset + 4];
                byte s0 = bytes[offset + 6];
                byte s1 = bytes[offset + 7];
                if (h0 < 48 || h0 > 57 || h1 < 48 || h1 > 57) {
                    throw new JSONException(this.info("illegal offsetTime"));
                }
                int hour = (h0 - 48) * 10 + (h1 - 48);
                if (i0 < 48 || i0 > 57 || i1 < 48 || i1 > 57) {
                    throw new JSONException(this.info("illegal offsetTime"));
                }
                int minute = (i0 - 48) * 10 + (i1 - 48);
                if (s0 < 48 || s0 > 57 || s1 < 48 || s1 > 57) {
                    throw new JSONException(this.info("illegal offsetTime"));
                }
                int second = (s0 - 48) * 10 + (s1 - 48);
                int nanoSize = -1;
                int len = 0;
                int end = offset + 25;
                for (int i = start = offset + 8; i < end && i < this.end && i < bytes.length; ++i) {
                    byte b = bytes[i];
                    if (nanoSize == -1 && (b == 90 || b == 43 || b == 45)) {
                        nanoSize = i - start - 1;
                    }
                    if (b != quote) continue;
                    len = i - offset;
                    break;
                }
                int nano = nanoSize <= 0 ? 0 : DateUtils.readNanos(bytes, nanoSize, offset + 9);
                int zoneOffsetSize = len - 9 - nanoSize;
                if (zoneOffsetSize <= 1) {
                    zoneOffset = ZoneOffset.UTC;
                } else {
                    String zonedId = new String(bytes, offset + 9 + nanoSize, zoneOffsetSize);
                    zoneOffset = ZoneOffset.of(zonedId);
                }
                LocalTime localTime = LocalTime.of(hour, minute, second, nano);
                OffsetTime oft = OffsetTime.of(localTime, zoneOffset);
                this.offset += len + 1;
                this.next();
                this.comma = this.ch == ',';
                if (this.comma) {
                    this.next();
                }
                return oft;
            }
        }
        throw new JSONException(this.info("illegal offsetTime"));
    }

    @Override
    protected final ZonedDateTime readZonedDateTimeX(int len) {
        ZonedDateTime zdt;
        if (!this.isString()) {
            throw new JSONException("date only support string input");
        }
        if (len < 19) {
            return null;
        }
        if (len == 30 && this.bytes[this.offset + 29] == 90) {
            LocalDateTime ldt = DateUtils.parseLocalDateTime29(this.bytes, this.offset);
            zdt = ZonedDateTime.of(ldt, ZoneOffset.UTC);
        } else if (len == 29 && this.bytes[this.offset + 28] == 90) {
            LocalDateTime ldt = DateUtils.parseLocalDateTime28(this.bytes, this.offset);
            zdt = ZonedDateTime.of(ldt, ZoneOffset.UTC);
        } else if (len == 28 && this.bytes[this.offset + 27] == 90) {
            LocalDateTime ldt = DateUtils.parseLocalDateTime27(this.bytes, this.offset);
            zdt = ZonedDateTime.of(ldt, ZoneOffset.UTC);
        } else if (len == 27 && this.bytes[this.offset + 26] == 90) {
            LocalDateTime ldt = DateUtils.parseLocalDateTime26(this.bytes, this.offset);
            zdt = ZonedDateTime.of(ldt, ZoneOffset.UTC);
        } else {
            zdt = DateUtils.parseZonedDateTime(this.bytes, this.offset, len, this.context.zoneId);
        }
        if (zdt == null) {
            return null;
        }
        this.offset += len + 1;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return zdt;
    }

    @Override
    public final LocalDate readLocalDate8() {
        LocalDate ldt;
        if (!this.isString()) {
            throw new JSONException("localDate only support string input");
        }
        try {
            ldt = DateUtils.parseLocalDate8(this.bytes, this.offset);
        }
        catch (DateTimeException ex) {
            throw new JSONException(this.info("read date error"), ex);
        }
        this.offset += 9;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return ldt;
    }

    @Override
    public final LocalDate readLocalDate9() {
        LocalDate ldt;
        if (!this.isString()) {
            throw new JSONException("localDate only support string input");
        }
        try {
            ldt = DateUtils.parseLocalDate9(this.bytes, this.offset);
        }
        catch (DateTimeException ex) {
            throw new JSONException(this.info("read date error"), ex);
        }
        this.offset += 10;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return ldt;
    }

    @Override
    public final LocalDate readLocalDate10() {
        LocalDate ldt;
        if (!this.isString()) {
            throw new JSONException("localDate only support string input");
        }
        try {
            ldt = DateUtils.parseLocalDate10(this.bytes, this.offset);
        }
        catch (DateTimeException ex) {
            throw new JSONException(this.info("read date error"), ex);
        }
        if (ldt == null) {
            return null;
        }
        this.offset += 11;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return ldt;
    }

    @Override
    protected final LocalDate readLocalDate11() {
        if (!this.isString()) {
            throw new JSONException("localDate only support string input");
        }
        LocalDate ldt = DateUtils.parseLocalDate11(this.bytes, this.offset);
        if (ldt == null) {
            return null;
        }
        this.offset += 11;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return ldt;
    }

    @Override
    protected final LocalDateTime readLocalDateTime17() {
        if (!this.isString()) {
            throw new JSONException("date only support string input");
        }
        LocalDateTime ldt = DateUtils.parseLocalDateTime17(this.bytes, this.offset);
        if (ldt == null) {
            return null;
        }
        this.offset += 18;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return ldt;
    }

    @Override
    protected final LocalTime readLocalTime5() {
        if (this.ch != '\"' && this.ch != '\'') {
            throw new JSONException("localTime only support string input");
        }
        LocalTime time = DateUtils.parseLocalTime5(this.bytes, this.offset);
        if (time == null) {
            return null;
        }
        this.offset += 6;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return time;
    }

    @Override
    protected final LocalTime readLocalTime6() {
        if (this.ch != '\"' && this.ch != '\'') {
            throw new JSONException("localTime only support string input");
        }
        LocalTime time = DateUtils.parseLocalTime6(this.bytes, this.offset);
        if (time == null) {
            return null;
        }
        this.offset += 7;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return time;
    }

    @Override
    protected final LocalTime readLocalTime7() {
        if (this.ch != '\"' && this.ch != '\'') {
            throw new JSONException("localTime only support string input");
        }
        LocalTime time = DateUtils.parseLocalTime7(this.bytes, this.offset);
        if (time == null) {
            return null;
        }
        this.offset += 8;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return time;
    }

    @Override
    protected final LocalTime readLocalTime8() {
        if (this.ch != '\"' && this.ch != '\'') {
            throw new JSONException("localTime only support string input");
        }
        LocalTime time = DateUtils.parseLocalTime8(this.bytes, this.offset);
        if (time == null) {
            return null;
        }
        this.offset += 9;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return time;
    }

    @Override
    protected final LocalTime readLocalTime9() {
        if (this.ch != '\"' && this.ch != '\'') {
            throw new JSONException("localTime only support string input");
        }
        LocalTime time = DateUtils.parseLocalTime8(this.bytes, this.offset);
        if (time == null) {
            return null;
        }
        this.offset += 10;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return time;
    }

    @Override
    protected final LocalTime readLocalTime10() {
        if (!this.isString()) {
            throw new JSONException("localTime only support string input");
        }
        LocalTime time = DateUtils.parseLocalTime10(this.bytes, this.offset);
        if (time == null) {
            return null;
        }
        this.offset += 11;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return time;
    }

    @Override
    protected final LocalTime readLocalTime11() {
        if (!this.isString()) {
            throw new JSONException("localTime only support string input");
        }
        LocalTime time = DateUtils.parseLocalTime11(this.bytes, this.offset);
        if (time == null) {
            return null;
        }
        this.offset += 12;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return time;
    }

    @Override
    protected final LocalTime readLocalTime12() {
        if (!this.isString()) {
            throw new JSONException("localTime only support string input");
        }
        LocalTime time = DateUtils.parseLocalTime12(this.bytes, this.offset);
        if (time == null) {
            return null;
        }
        this.offset += 13;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return time;
    }

    @Override
    protected final LocalTime readLocalTime15() {
        if (!this.isString()) {
            throw new JSONException("localTime only support string input");
        }
        LocalTime time = DateUtils.parseLocalTime15(this.bytes, this.offset);
        if (time == null) {
            return null;
        }
        this.offset += 16;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return time;
    }

    @Override
    protected final LocalTime readLocalTime18() {
        if (!this.isString()) {
            throw new JSONException("localTime only support string input");
        }
        LocalTime time = DateUtils.parseLocalTime18(this.bytes, this.offset);
        if (time == null) {
            return null;
        }
        this.offset += 19;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return time;
    }

    @Override
    protected final LocalDateTime readLocalDateTime12() {
        if (!this.isString()) {
            throw new JSONException("date only support string input");
        }
        LocalDateTime ldt = DateUtils.parseLocalDateTime12(this.bytes, this.offset);
        if (ldt == null) {
            return null;
        }
        this.offset += 13;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return ldt;
    }

    @Override
    protected final LocalDateTime readLocalDateTime14() {
        if (!this.isString()) {
            throw new JSONException("date only support string input");
        }
        LocalDateTime ldt = DateUtils.parseLocalDateTime14(this.bytes, this.offset);
        if (ldt == null) {
            return null;
        }
        this.offset += 15;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return ldt;
    }

    @Override
    protected final LocalDateTime readLocalDateTime16() {
        if (!this.isString()) {
            throw new JSONException("date only support string input");
        }
        LocalDateTime ldt = DateUtils.parseLocalDateTime16(this.bytes, this.offset);
        if (ldt == null) {
            return null;
        }
        this.offset += 17;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return ldt;
    }

    @Override
    protected final LocalDateTime readLocalDateTime18() {
        if (!this.isString()) {
            throw new JSONException("date only support string input");
        }
        LocalDateTime ldt = DateUtils.parseLocalDateTime18(this.bytes, this.offset);
        this.offset += 19;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return ldt;
    }

    @Override
    protected final LocalDateTime readLocalDateTime19() {
        if (!this.isString()) {
            throw new JSONException("date only support string input");
        }
        LocalDateTime ldt = DateUtils.parseLocalDateTime19(this.bytes, this.offset);
        if (ldt == null) {
            return null;
        }
        this.offset += 20;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return ldt;
    }

    @Override
    protected final LocalDateTime readLocalDateTime20() {
        if (!this.isString()) {
            throw new JSONException("date only support string input");
        }
        LocalDateTime ldt = DateUtils.parseLocalDateTime20(this.bytes, this.offset);
        if (ldt == null) {
            return null;
        }
        this.offset += 21;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return ldt;
    }

    @Override
    public final long readMillis19() {
        char quote = this.ch;
        if (quote != '\"' && quote != '\'') {
            throw new JSONException("date only support string input");
        }
        if (this.offset + 18 >= this.end) {
            this.wasNull = true;
            return 0L;
        }
        long millis = DateUtils.parseMillis19(this.bytes, this.offset, this.context.zoneId);
        if (this.bytes[this.offset + 19] != quote) {
            throw new JSONException(this.info("illegal date input"));
        }
        this.offset += 20;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return millis;
    }

    @Override
    protected final LocalDateTime readLocalDateTimeX(int len) {
        LocalDateTime ldt;
        if (!this.isString()) {
            throw new JSONException("date only support string input");
        }
        if (this.bytes[this.offset + len - 1] == 90) {
            ZonedDateTime zdt = DateUtils.parseZonedDateTime(this.bytes, this.offset, len);
            ldt = zdt.toInstant().atZone(this.context.getZoneId()).toLocalDateTime();
        } else {
            ldt = DateUtils.parseLocalDateTimeX(this.bytes, this.offset, len);
        }
        if (ldt == null) {
            return null;
        }
        this.offset += len + 1;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return ldt;
    }

    @Override
    public final BigDecimal readBigDecimal() {
        long r;
        boolean valid = false;
        byte[] bytes = this.bytes;
        int ch = this.ch;
        int offset = this.offset;
        int end = this.end;
        boolean value = false;
        BigDecimal decimal = null;
        int quote = 0;
        if ((ch == 34 || ch == 39) && (ch = bytes[offset++]) == (quote = ch)) {
            this.ch = (char)(offset == end ? 26 : (char)bytes[offset++]);
            this.offset = offset;
            this.nextIfComma();
            return null;
        }
        int start = offset;
        if (ch == 45) {
            this.negative = true;
            ch = bytes[offset++];
        } else {
            this.negative = false;
            if (ch == 43) {
                ch = bytes[offset++];
            }
        }
        this.valueType = 1;
        boolean overflow = false;
        long longValue = 0L;
        while (ch >= 48 && ch <= 57) {
            valid = true;
            if (!overflow) {
                r = longValue * 10L;
                if ((longValue | 0xAL) >>> 31 == 0L || r / 10L == longValue) {
                    longValue = r + (long)(ch - 48);
                } else {
                    overflow = true;
                }
            }
            if (offset == end) {
                ch = 26;
                ++offset;
                break;
            }
            ch = bytes[offset++];
        }
        if (longValue < 0L) {
            overflow = true;
        }
        this.scale = 0;
        if (ch == 46) {
            this.valueType = (byte)2;
            ch = bytes[offset++];
            while (ch >= 48 && ch <= 57) {
                valid = true;
                this.scale = (short)(this.scale + 1);
                if (!overflow) {
                    r = longValue * 10L;
                    if ((longValue | 0xAL) >>> 31 == 0L || r / 10L == longValue) {
                        longValue = r + (long)(ch - 48);
                    } else {
                        overflow = true;
                    }
                }
                if (offset == end) {
                    ch = 26;
                    ++offset;
                    break;
                }
                ch = bytes[offset++];
            }
        }
        int expValue = 0;
        if (ch == 101 || ch == 69) {
            boolean negativeExp;
            if ((negativeExp = (ch = bytes[offset++]) == 45) || ch == 43) {
                ch = bytes[offset++];
            }
            while (ch >= 48 && ch <= 57) {
                valid = true;
                int byteVal = ch - 48;
                if ((expValue = expValue * 10 + byteVal) > 2047) {
                    throw new JSONException("too large exp value : " + expValue);
                }
                if (offset == end) {
                    ch = 26;
                    ++offset;
                    break;
                }
                ch = bytes[offset++];
            }
            if (negativeExp) {
                expValue = -expValue;
            }
            this.exponent = (short)expValue;
            this.valueType = (byte)2;
        }
        if (offset == start) {
            if (ch == 110 && bytes[offset++] == 117 && bytes[offset++] == 108 && bytes[offset++] == 108) {
                if ((this.context.features & JSONReader.Feature.ErrorOnNullForPrimitives.mask) != 0L) {
                    throw new JSONException(this.info("long value not support input null"));
                }
                this.wasNull = true;
                value = true;
                ch = offset == end ? 26 : bytes[offset];
                ++offset;
                valid = true;
            } else if (ch == 116 && offset + 3 <= end && bytes[offset] == 114 && bytes[offset + 1] == 117 && bytes[offset + 2] == 101) {
                valid = true;
                value = true;
                decimal = BigDecimal.ONE;
                ch = (offset += 3) == end ? 26 : bytes[offset];
                ++offset;
            } else if (ch == 102 && offset + 4 <= end && IOUtils.isALSE(bytes, offset)) {
                valid = true;
                decimal = BigDecimal.ZERO;
                value = true;
                ch = (offset += 4) == end ? 26 : bytes[offset];
                ++offset;
            } else {
                if (ch == 123 && quote == 0) {
                    JSONObject jsonObject = new JSONObject();
                    this.readObject((Object)jsonObject, 0L);
                    this.wasNull = false;
                    return this.decimal(jsonObject);
                }
                if (ch == 91 && quote == 0) {
                    List array = this.readArray();
                    if (!array.isEmpty()) {
                        throw new JSONException(this.info());
                    }
                    this.wasNull = true;
                    return null;
                }
            }
        }
        int len = offset - start;
        if (quote != 0) {
            if (ch != quote) {
                String str = this.readString();
                try {
                    return TypeUtils.toBigDecimal(str);
                }
                catch (NumberFormatException e) {
                    throw new JSONException(this.info(e.getMessage()), e);
                }
            }
            int n = ch = offset >= end ? 26 : bytes[offset++];
        }
        if (!value) {
            if (expValue == 0 && !overflow && longValue != 0L) {
                decimal = BigDecimal.valueOf(this.negative ? -longValue : longValue, this.scale);
                value = true;
            }
            if (!value) {
                decimal = TypeUtils.parseBigDecimal(bytes, start - 1, len);
            }
            if (ch == 76 || ch == 70 || ch == 68 || ch == 66 || ch == 83) {
                int n = ch = offset >= end ? 26 : bytes[offset++];
            }
        }
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == end ? 26 : bytes[offset++];
        }
        this.comma = ch == 44;
        if (this.comma) {
            int n = ch = offset == end ? 26 : bytes[offset++];
            while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                ch = offset == end ? 26 : bytes[offset++];
            }
        }
        if (!valid) {
            throw new JSONException(this.info("illegal input error"));
        }
        this.ch = (char)ch;
        this.offset = offset;
        return decimal;
    }

    @Override
    public final UUID readUUID() {
        UUID uuid;
        byte ch = this.ch;
        int end = this.end;
        if (ch == 110) {
            this.readNull();
            return null;
        }
        if (ch != 34 && ch != 39) {
            throw this.error("syntax error, can not read uuid");
        }
        byte quote = ch;
        byte[] bytes = this.bytes;
        int offset = this.offset;
        if (offset + 36 < end && bytes[offset + 36] == quote && bytes[offset + 8] == 45 && bytes[offset + 13] == 45 && bytes[offset + 18] == 45 && bytes[offset + 23] == 45) {
            uuid = JSONReaderUTF8.readUUID36(bytes, offset);
            offset += 37;
        } else if (offset + 32 < end && bytes[offset + 32] == quote) {
            uuid = JSONReaderUTF8.readUUID32(bytes, offset);
            offset += 33;
        } else {
            String str = this.readString();
            if (str.isEmpty()) {
                return null;
            }
            return UUID.fromString(str);
        }
        byte by = ch = offset == end ? (byte)26 : bytes[offset++];
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == end ? (byte)26 : bytes[offset++];
        }
        this.offset = offset;
        this.comma = ch == 44;
        if (this.comma) {
            this.next();
        } else {
            this.ch = (char)ch;
        }
        return uuid;
    }

    static UUID readUUID32(byte[] bytes, int offset) {
        long lsb4;
        long lsb3;
        long lsb2;
        long lsb1;
        long msb4;
        long msb3;
        long msb2;
        long msb1 = JSONReaderUTF8.parse4Nibbles(bytes, offset);
        if ((msb1 | (msb2 = JSONReaderUTF8.parse4Nibbles(bytes, offset + 4)) | (msb3 = JSONReaderUTF8.parse4Nibbles(bytes, offset + 8)) | (msb4 = JSONReaderUTF8.parse4Nibbles(bytes, offset + 12)) | (lsb1 = JSONReaderUTF8.parse4Nibbles(bytes, offset + 16)) | (lsb2 = JSONReaderUTF8.parse4Nibbles(bytes, offset + 20)) | (lsb3 = JSONReaderUTF8.parse4Nibbles(bytes, offset + 24)) | (lsb4 = JSONReaderUTF8.parse4Nibbles(bytes, offset + 28))) < 0L) {
            throw new JSONException("Invalid UUID string:  ".concat(new String(bytes, offset, 32, StandardCharsets.ISO_8859_1)));
        }
        return new UUID(msb1 << 48 | msb2 << 32 | msb3 << 16 | msb4, lsb1 << 48 | lsb2 << 32 | lsb3 << 16 | lsb4);
    }

    static UUID readUUID36(byte[] bytes, int offset) {
        long lsb4;
        long lsb3;
        long lsb2;
        long lsb1;
        long msb4;
        long msb3;
        long msb2;
        long msb1 = JSONReaderUTF8.parse4Nibbles(bytes, offset);
        if ((msb1 | (msb2 = JSONReaderUTF8.parse4Nibbles(bytes, offset + 4)) | (msb3 = JSONReaderUTF8.parse4Nibbles(bytes, offset + 9)) | (msb4 = JSONReaderUTF8.parse4Nibbles(bytes, offset + 14)) | (lsb1 = JSONReaderUTF8.parse4Nibbles(bytes, offset + 19)) | (lsb2 = JSONReaderUTF8.parse4Nibbles(bytes, offset + 24)) | (lsb3 = JSONReaderUTF8.parse4Nibbles(bytes, offset + 28)) | (lsb4 = JSONReaderUTF8.parse4Nibbles(bytes, offset + 32))) < 0L) {
            throw new JSONException("Invalid UUID string:  ".concat(new String(bytes, offset, 36, StandardCharsets.ISO_8859_1)));
        }
        return new UUID(msb1 << 48 | msb2 << 32 | msb3 << 16 | msb4, lsb1 << 48 | lsb2 << 32 | lsb3 << 16 | lsb4);
    }

    static long parse4Nibbles(byte[] bytes, int offset) {
        int x = JDKUtils.UNSAFE.getInt(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset);
        if (JDKUtils.BIG_ENDIAN) {
            x = Integer.reverseBytes(x);
        }
        byte[] ns = JSONFactory.NIBBLES;
        return ns[x & 0xFF] << 12 | ns[x >> 8 & 0xFF] << 8 | ns[x >> 16 & 0xFF] << 4 | ns[x >> 24 & 0xFF];
    }

    @Override
    public final String readPattern() {
        int ch;
        int offset;
        if (this.ch != '/') {
            throw new JSONException("illegal pattern");
        }
        byte[] bytes = this.bytes;
        int start = offset = this.offset;
        while (offset < this.end && bytes[offset] != 47) {
            ++offset;
        }
        String str = new String(bytes, start, offset - start, StandardCharsets.UTF_8);
        int n = ch = ++offset == this.end ? 26 : bytes[offset++];
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == this.end ? 26 : bytes[offset++];
        }
        this.comma = ch == 44;
        if (this.comma) {
            int n2 = ch = offset == this.end ? 26 : bytes[offset++];
            while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                ch = offset == this.end ? 26 : bytes[offset++];
            }
        }
        this.offset = offset;
        this.ch = (char)ch;
        return str;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean nextIfNullOrEmptyString() {
        int ch;
        char first = this.ch;
        int end = this.end;
        int offset = this.offset;
        byte[] bytes = this.bytes;
        if (first == 'n' && offset + 2 < end && bytes[offset] == 117 && bytes[offset + 1] == 108 && bytes[offset + 2] == 108) {
            offset += 3;
        } else {
            if (first != '\"' && first != '\'') return false;
            if (offset < end && bytes[offset] == first) {
                ++offset;
            } else {
                if (offset + 4 >= end || !IOUtils.isNULL(bytes, offset) || bytes[offset + 4] != first) return false;
                offset += 5;
            }
        }
        int n = ch = offset == end ? 26 : bytes[offset++];
        while (ch >= 0 && ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == end ? 26 : bytes[offset++];
        }
        this.comma = ch == 44;
        if (this.comma) {
            int n2 = ch = offset == end ? 26 : bytes[offset++];
        }
        while (ch >= 0 && ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == end ? 26 : bytes[offset++];
        }
        if (ch < 0) {
            this.char_utf8(ch, offset);
            return true;
        }
        this.offset = offset;
        this.ch = (char)ch;
        return true;
    }

    @Override
    public final boolean nextIfMatchIdent(char c0, char c1) {
        int ch;
        if (this.ch != c0) {
            return false;
        }
        byte[] bytes = this.bytes;
        int offset = this.offset;
        if (offset + 1 > this.end || bytes[offset] != c1) {
            return false;
        }
        int n = ch = ++offset == this.end ? 26 : bytes[offset++];
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == this.end ? 26 : bytes[offset++];
        }
        if (offset == this.offset + 2 && ch != 26 && ch != 40 && ch != 91 && ch != 93 && ch != 41 && ch != 58 && ch != 44) {
            return false;
        }
        this.offset = offset;
        this.ch = (char)ch;
        return true;
    }

    @Override
    public final boolean nextIfMatchIdent(char c0, char c1, char c2) {
        int ch;
        if (this.ch != c0) {
            return false;
        }
        byte[] bytes = this.bytes;
        int offset = this.offset;
        if (offset + 2 > this.end || bytes[offset] != c1 || bytes[offset + 1] != c2) {
            return false;
        }
        int n = ch = (offset += 2) == this.end ? 26 : bytes[offset++];
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == this.end ? 26 : bytes[offset++];
        }
        if (offset == this.offset + 3 && ch != 26 && ch != 40 && ch != 91 && ch != 93 && ch != 41 && ch != 58 && ch != 44) {
            return false;
        }
        this.offset = offset;
        this.ch = (char)ch;
        return true;
    }

    @Override
    public final boolean nextIfMatchIdent(char c0, char c1, char c2, char c3) {
        int ch;
        if (this.ch != c0) {
            return false;
        }
        byte[] bytes = this.bytes;
        int offset = this.offset;
        if (offset + 3 > this.end || bytes[offset] != c1 || bytes[offset + 1] != c2 || bytes[offset + 2] != c3) {
            return false;
        }
        int n = ch = (offset += 3) == this.end ? 26 : bytes[offset++];
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == this.end ? 26 : bytes[offset++];
        }
        if (offset == this.offset + 4 && ch != 26 && ch != 40 && ch != 91 && ch != 93 && ch != 41 && ch != 58 && ch != 44) {
            return false;
        }
        this.offset = offset;
        this.ch = (char)ch;
        return true;
    }

    @Override
    public final boolean nextIfMatchIdent(char c0, char c1, char c2, char c3, char c4) {
        int ch;
        if (this.ch != c0) {
            return false;
        }
        byte[] bytes = this.bytes;
        int offset = this.offset;
        if (offset + 4 > this.end || bytes[offset] != c1 || bytes[offset + 1] != c2 || bytes[offset + 2] != c3 || bytes[offset + 3] != c4) {
            return false;
        }
        int n = ch = (offset += 4) == this.end ? 26 : bytes[offset++];
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == this.end ? 26 : bytes[offset++];
        }
        if (offset == this.offset + 5 && ch != 26 && ch != 40 && ch != 91 && ch != 93 && ch != 41 && ch != 58 && ch != 44) {
            return false;
        }
        this.offset = offset;
        this.ch = (char)ch;
        return true;
    }

    @Override
    public final boolean nextIfMatchIdent(char c0, char c1, char c2, char c3, char c4, char c5) {
        int ch;
        if (this.ch != c0) {
            return false;
        }
        byte[] bytes = this.bytes;
        int offset = this.offset;
        if (offset + 5 > this.end || bytes[offset] != c1 || bytes[offset + 1] != c2 || bytes[offset + 2] != c3 || bytes[offset + 3] != c4 || bytes[offset + 4] != c5) {
            return false;
        }
        int n = ch = (offset += 5) == this.end ? 26 : bytes[offset++];
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == this.end ? 26 : bytes[offset++];
        }
        if (offset == this.offset + 6 && ch != 26 && ch != 40 && ch != 91 && ch != 93 && ch != 41 && ch != 58 && ch != 44) {
            return false;
        }
        this.offset = offset;
        this.ch = (char)ch;
        return true;
    }

    @Override
    public final byte[] readHex() {
        int quote;
        int offset = this.offset;
        byte[] bytes = this.bytes;
        int ch = this.ch;
        if (ch == 120) {
            int n = ch = offset == this.end ? 26 : bytes[offset++];
        }
        if ((quote = ch) != 39 && quote != 34) {
            throw JSONReaderUTF8.syntaxError(offset, ch);
        }
        int start = offset;
        int n = ch = offset == this.end ? 26 : bytes[offset++];
        while (true) {
            if (!(ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70)) {
                if (ch == quote) break;
                throw JSONReaderUTF8.syntaxError(offset, ch);
            }
            ch = offset == this.end ? 26 : bytes[offset++];
        }
        ch = offset == this.end ? 26 : bytes[offset++];
        int len = offset - start - 2;
        if (ch == 26) {
            ++len;
        }
        if (len % 2 != 0) {
            throw JSONReaderUTF8.syntaxError(offset, ch);
        }
        byte[] hex = new byte[len / 2];
        for (int i = 0; i < hex.length; ++i) {
            byte c0 = bytes[start + i * 2];
            byte c1 = bytes[start + i * 2 + 1];
            int b0 = c0 - (c0 <= 57 ? 48 : 55);
            int b1 = c1 - (c1 <= 57 ? 48 : 55);
            hex[i] = (byte)(b0 << 4 | b1);
        }
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == this.end ? 26 : bytes[offset++];
        }
        if (ch != 44 || offset >= this.end) {
            this.offset = offset;
            this.ch = (char)ch;
            return hex;
        }
        this.comma = true;
        int n2 = ch = offset == this.end ? 26 : bytes[offset++];
        while (ch == 0 || ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == this.end ? 26 : bytes[offset++];
        }
        this.offset = offset;
        this.ch = (char)ch;
        if (this.ch == '/') {
            this.skipComment();
        }
        return hex;
    }

    @Override
    public final boolean isReference() {
        if ((this.context.features & 0x200000000L) != 0L) {
            return false;
        }
        byte[] bytes = this.bytes;
        char ch = this.ch;
        if (ch != '{') {
            return false;
        }
        int offset = this.offset;
        int end = this.end;
        if (offset == end) {
            return false;
        }
        ch = bytes[offset];
        while (ch <= ' ' && (1L << ch & 0x100003700L) != 0L) {
            if (++offset >= end) {
                return false;
            }
            ch = bytes[offset];
        }
        if (offset + 6 >= end || bytes[offset + 5] != ch || JDKUtils.UNSAFE.getInt(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset + 1L) != REF) {
            return false;
        }
        return this.isReference0(bytes, offset, end, ch);
    }

    private boolean isReference0(byte[] bytes, int offset, int end, int quote) {
        byte ch = bytes[offset += 6];
        while (ch >= 0 && ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            if (++offset >= end) {
                return false;
            }
            ch = bytes[offset];
        }
        if (ch != 58 || offset + 1 >= end) {
            return false;
        }
        ch = bytes[++offset];
        while (ch >= 0 && ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            if (++offset >= end) {
                return false;
            }
            ch = bytes[offset];
        }
        if (ch != quote || offset + 1 < end && (ch = bytes[offset + 1]) != 36 && ch != 46 && ch != 64) {
            return false;
        }
        this.referenceBegin = offset;
        return true;
    }

    @Override
    public final String readReference() {
        if (this.referenceBegin == this.end) {
            return null;
        }
        byte[] chars = this.bytes;
        this.offset = this.referenceBegin;
        this.ch = (char)chars[this.offset++];
        String reference = this.readString();
        int ch = this.ch;
        int offset = this.offset;
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == this.end ? 26 : chars[offset++];
        }
        if (ch != 125) {
            throw new JSONException("illegal reference : ".concat(reference));
        }
        int n = ch = offset == this.end ? 26 : chars[offset++];
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == this.end ? 26 : chars[offset++];
        }
        this.comma = ch == 44;
        if (this.comma) {
            int n2 = ch = offset == this.end ? 26 : chars[offset++];
            while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                ch = offset == this.end ? 26 : chars[offset++];
            }
        }
        this.ch = (char)ch;
        this.offset = offset;
        return reference;
    }

    @Override
    public final boolean readBoolValue() {
        boolean val = false;
        int end = this.end;
        byte[] bytes = this.bytes;
        int offset = this.offset;
        int ch = this.ch;
        if (ch == 116 && offset + 2 < bytes.length && bytes[offset] == 114 && bytes[offset + 1] == 117 && bytes[offset + 2] == 101) {
            offset += 3;
            val = true;
        } else if (ch == 102 && offset + 3 < end && IOUtils.isALSE(bytes, offset)) {
            offset += 4;
        } else if (!(ch != 49 && ch != 48 || offset >= end || IOUtils.isDigit(ch))) {
            val = ch == 49;
        } else {
            return this.readBoolValue0();
        }
        char c = (char)(ch = (char)(offset == end ? 26 : (char)bytes[offset++]));
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset >= end ? 26 : bytes[offset++];
        }
        this.comma = ch == 44;
        if (this.comma) {
            int n = ch = offset >= end ? 26 : bytes[offset++];
            while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                ch = offset >= end ? 26 : bytes[offset++];
            }
        }
        this.offset = offset;
        this.ch = (char)ch;
        return val;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean readBoolValue0() {
        boolean val;
        this.wasNull = false;
        byte[] bytes = this.bytes;
        int offset = this.offset;
        int ch = this.ch;
        if (ch == 116 && offset + 2 < bytes.length && bytes[offset] == 114 && bytes[offset + 1] == 117 && bytes[offset + 2] == 101) {
            offset += 3;
            val = true;
        } else if (ch == 102 && offset + 3 < this.end && IOUtils.isALSE(bytes, offset)) {
            offset += 4;
            val = false;
        } else {
            if (ch == 45 || ch >= 48 && ch <= 57) {
                this.readNumber();
                if (this.valueType != 1) return false;
                if ((this.context.features & JSONReader.Feature.NonZeroNumberCastToBooleanAsTrue.mask) != 0L) {
                    if (this.mag0 != 0) return true;
                    if (this.mag1 != 0) return true;
                    if (this.mag2 != 0) return true;
                    if (this.mag3 != 0) return true;
                    return false;
                }
                if (this.mag0 != 0) return false;
                if (this.mag1 != 0) return false;
                if (this.mag2 != 0) return false;
                if (this.mag3 != 1) return false;
                return true;
            }
            if (ch == 110 && offset + 2 < bytes.length && bytes[offset] == 117 && bytes[offset + 1] == 108 && bytes[offset + 2] == 108) {
                if ((this.context.features & JSONReader.Feature.ErrorOnNullForPrimitives.mask) != 0L) {
                    throw new JSONException(this.info("boolean value not support input null"));
                }
                this.wasNull = true;
                offset += 3;
                val = false;
            } else {
                if (ch != 34 && ch != 39) {
                    if (ch != 91) throw new JSONException("syntax error : " + ch);
                    this.next();
                    boolean val2 = this.readBoolValue();
                    if (this.nextIfMatch(']')) return val2;
                    throw new JSONException("not closed square brackets, expect ] but found : " + (char)ch);
                }
                if (offset + 1 < bytes.length && bytes[offset + 1] == ch) {
                    byte c0 = bytes[offset];
                    offset += 2;
                    if (c0 == 48 || c0 == 78) {
                        val = false;
                    } else {
                        if (c0 != 49) {
                            if (c0 != 89) throw new JSONException("can not convert to boolean : " + c0);
                        }
                        val = true;
                    }
                } else {
                    String str = this.readString();
                    if ("true".equalsIgnoreCase(str)) {
                        return true;
                    }
                    if ("false".equalsIgnoreCase(str)) {
                        return false;
                    }
                    if (!str.isEmpty()) {
                        if (!"null".equalsIgnoreCase(str)) throw new JSONException("can not convert to boolean : " + str);
                    }
                    this.wasNull = true;
                    return false;
                }
            }
        }
        char c = (char)(ch = (char)(offset == this.end ? 26 : (char)bytes[offset++]));
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset >= this.end ? 26 : bytes[offset++];
        }
        this.comma = ch == 44;
        if (this.comma) {
            int n = ch = offset >= this.end ? 26 : bytes[offset++];
            while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                ch = offset >= this.end ? 26 : bytes[offset++];
            }
        }
        this.offset = offset;
        this.ch = (char)ch;
        return val;
    }

    @Override
    public final byte[] readBase64() {
        byte[] decoded;
        byte[] bytes = this.bytes;
        int ch = this.ch;
        int offset = this.offset;
        int end = this.end;
        int index = IOUtils.indexOfQuote(bytes, ch, offset, end);
        if (index == -1) {
            throw this.error("invalid escape character EOI");
        }
        int slashIndex = JSONReaderUTF8.indexOfSlash(this, bytes, offset, end);
        if (slashIndex != -1) {
            throw this.error("invalid base64 string");
        }
        if (index != offset) {
            int p1;
            int p0;
            String prefix = "data:image/";
            String base64 = "base64";
            if (IOUtils.regionMatches(bytes, offset, prefix) && (p0 = IOUtils.indexOfChar(bytes, 59, prefix.length() + 1, index)) != -1 && (p1 = IOUtils.indexOfChar(bytes, 44, p0 + 1, index)) != -1 && IOUtils.regionMatches(bytes, p0 + 1, base64)) {
                offset = p1 + 1;
            }
            byte[] src = Arrays.copyOfRange(bytes, offset, index);
            decoded = Base64.getDecoder().decode(src);
        } else {
            decoded = new byte[]{};
        }
        offset = index + 1;
        ch = (char)(offset == end ? 26 : (char)bytes[offset++]);
        this.comma = ch == 44;
        if (this.comma) {
            int n = ch = offset == end ? 26 : bytes[offset++];
            while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                ch = offset == end ? 26 : bytes[offset++];
            }
        }
        this.ch = (char)ch;
        this.offset = offset;
        return decoded;
    }

    @Override
    public final String info(String message) {
        int line = 1;
        int column = 0;
        int i = 0;
        while (i < this.offset && i < this.end) {
            if (this.bytes[i] == 10) {
                column = 0;
                ++line;
            }
            ++i;
            ++column;
        }
        StringBuilder buf = new StringBuilder();
        if (message != null && !message.isEmpty()) {
            buf.append(message).append(", ");
        }
        return buf.append("offset ").append(this.offset).append(", character ").append(this.ch).append(", line ").append(line).append(", column ").append(column).append(", fastjson-version ").append("2.0.59").append(line > 1 ? (char)'\n' : ' ').append(new String(this.bytes, this.start, Math.min(this.length, 65535))).toString();
    }

    @Override
    public final void close() {
        if (this.cacheItem != null) {
            if (this.bytes.length < 0x800000) {
                JSONFactory.BYTES_UPDATER.lazySet(this.cacheItem, this.bytes);
            }
            if (this.charBuf != null && this.charBuf.length < 0x800000) {
                JSONFactory.CHARS_UPDATER.lazySet(this.cacheItem, this.charBuf);
            }
        }
        if (this.in != null) {
            try {
                this.in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static JSONReaderUTF8 of(byte[] bytes, int off, int len, JSONReader.Context context) {
        boolean ascii = false;
        if (JDKUtils.METHOD_HANDLE_HAS_NEGATIVE != null) {
            try {
                ascii = !JDKUtils.METHOD_HANDLE_HAS_NEGATIVE.invoke(bytes, off, len);
            }
            catch (Throwable throwable) {}
        } else {
            ascii = IOUtils.isASCII(bytes, off, len);
        }
        if (ascii) {
            return new JSONReaderASCII(context, null, bytes, off, len);
        }
        return new JSONReaderUTF8(context, bytes, off, len);
    }
}

