/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.writer;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONB;
import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.util.Fnv;
import com.alibaba.fastjson2.util.TypeUtils;
import com.alibaba.fastjson2.writer.ObjectWriter;
import com.alibaba.fastjson2.writer.ObjectWriterImplMap;
import com.alibaba.fastjson2.writer.ObjectWriterPrimitiveImpl;
import com.alibaba.fastjson2.writer.ObjectWriterProvider;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

final class ObjectWriterImplList
extends ObjectWriterPrimitiveImpl {
    static final ObjectWriterImplList INSTANCE = new ObjectWriterImplList(null, null, null, null, 0L);
    static final ObjectWriterImplList INSTANCE_JSON_ARRAY = new ObjectWriterImplList(JSONArray.class, null, null, null, 0L);
    static final ObjectWriterImplList INSTANCE_JSON_ARRAY_1x = TypeUtils.CLASS_JSON_ARRAY_1x == null ? null : new ObjectWriterImplList(TypeUtils.CLASS_JSON_ARRAY_1x, null, null, null, 0L);
    static final Class CLASS_SUBLIST = new ArrayList().subList(0, 0).getClass();
    static final String TYPE_NAME_ARRAY_LIST = TypeUtils.getTypeName(ArrayList.class);
    static final byte[] TYPE_NAME_JSONB_ARRAY_LIST = JSONB.toBytes(TYPE_NAME_ARRAY_LIST);
    static final long TYPE_NAME_HASH_ARRAY_LIST = Fnv.hashCode64(TYPE_NAME_ARRAY_LIST);
    final Class defineClass;
    final Type defineType;
    final Class itemClass;
    final Type itemType;
    final long features;
    final boolean itemClassRefDetect;
    volatile ObjectWriter itemClassWriter;

    public ObjectWriterImplList(Class defineClass, Type defineType, Class itemClass, Type itemType, long features) {
        this.defineClass = defineClass;
        this.defineType = defineType;
        this.itemClass = itemClass;
        this.itemType = itemType;
        this.features = features;
        this.itemClassRefDetect = itemClass != null && !ObjectWriterProvider.isNotReferenceDetect(itemClass);
    }

    @Override
    public void writeArrayMappingJSONB(JSONWriter jsonWriter, Object object, Object fieldName, Type fieldType, long features) {
        if (object == null) {
            jsonWriter.writeArrayNull();
            return;
        }
        List list = this.getList(object);
        Class<?> previousClass = null;
        ObjectWriter previousObjectWriter = null;
        jsonWriter.startArray(list.size());
        for (int i = 0; i < list.size(); ++i) {
            ObjectWriter itemObjectWriter;
            Object item = list.get(i);
            if (item == null) {
                jsonWriter.writeNull();
                continue;
            }
            Class<?> itemClass = item.getClass();
            if (itemClass == previousClass) {
                itemObjectWriter = previousObjectWriter;
            } else {
                itemObjectWriter = jsonWriter.getObjectWriter(itemClass);
                previousClass = itemClass;
                previousObjectWriter = itemObjectWriter;
            }
            itemObjectWriter.writeArrayMappingJSONB(jsonWriter, item, i, this.itemType, this.features | features);
        }
    }

    @Override
    public void writeJSONB(JSONWriter jsonWriter, Object object, Object fieldName, Type fieldType, long features) {
        if (object == null) {
            jsonWriter.writeArrayNull();
            return;
        }
        Class fieldItemClass = null;
        Class fieldClass = null;
        if (fieldType instanceof Class) {
            fieldClass = (Class)fieldType;
        } else if (fieldType == this.defineType) {
            fieldClass = this.itemClass;
        } else if (fieldType instanceof ParameterizedType) {
            Type rawType;
            Type fieldItemType;
            ParameterizedType parameterizedType = (ParameterizedType)fieldType;
            Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
            if (actualTypeArguments.length == 1 && (fieldItemType = actualTypeArguments[0]) instanceof Class) {
                fieldItemClass = (Class)fieldItemType;
            }
            if ((rawType = parameterizedType.getRawType()) instanceof Class) {
                fieldClass = (Class)rawType;
            }
        }
        Class<?> objectClass = object.getClass();
        if (jsonWriter.isWriteTypeInfo(object, fieldClass, features)) {
            if (objectClass == CLASS_SUBLIST || objectClass == ArrayList.class) {
                jsonWriter.writeTypeName(TYPE_NAME_JSONB_ARRAY_LIST, TYPE_NAME_HASH_ARRAY_LIST);
            } else {
                String typeName = TypeUtils.getTypeName(objectClass);
                jsonWriter.writeTypeName(typeName);
            }
        }
        List list = this.getList(object);
        Class<?> previousClass = null;
        ObjectWriter<?> previousObjectWriter = null;
        int size = list.size();
        if (size == 0) {
            jsonWriter.writeRaw((byte)-108);
            return;
        }
        boolean beanToArray = jsonWriter.isBeanToArray();
        if (beanToArray) {
            jsonWriter.startArray(size);
            for (int i = 0; i < size; ++i) {
                ObjectWriter<?> itemObjectWriter;
                Object item = list.get(i);
                if (item == null) {
                    jsonWriter.writeNull();
                    continue;
                }
                Class<?> itemClass = item.getClass();
                if (itemClass == previousClass) {
                    itemObjectWriter = previousObjectWriter;
                } else {
                    itemObjectWriter = jsonWriter.getObjectWriter(itemClass);
                    previousClass = itemClass;
                    previousObjectWriter = itemObjectWriter;
                }
                itemObjectWriter.writeArrayMappingJSONB(jsonWriter, item, i, fieldItemClass, features);
            }
            jsonWriter.endArray();
            return;
        }
        JSONWriter.Context context = jsonWriter.context;
        jsonWriter.startArray(size);
        for (int i = 0; i < size; ++i) {
            String refPath;
            ObjectWriter<Object> itemObjectWriter;
            boolean refDetect;
            Object item = list.get(i);
            if (item == null) {
                jsonWriter.writeNull();
                continue;
            }
            Class<?> itemClass = item.getClass();
            if (itemClass == String.class) {
                jsonWriter.writeString((String)item);
                continue;
            }
            boolean bl = itemClass == this.itemClass ? this.itemClassRefDetect && jsonWriter.isRefDetect() : (refDetect = jsonWriter.isRefDetect(item));
            if (itemClass == this.itemClass && this.itemClassWriter != null) {
                itemObjectWriter = this.itemClassWriter;
            } else if (itemClass == previousClass) {
                itemObjectWriter = previousObjectWriter;
            } else {
                itemObjectWriter = itemClass == JSONObject.class ? ObjectWriterImplMap.INSTANCE : (itemClass == TypeUtils.CLASS_JSON_OBJECT_1x ? ObjectWriterImplMap.INSTANCE_1x : (itemClass == JSONArray.class ? INSTANCE_JSON_ARRAY : (itemClass == TypeUtils.CLASS_JSON_ARRAY_1x ? INSTANCE_JSON_ARRAY_1x : context.getObjectWriter(itemClass))));
                previousClass = itemClass;
                previousObjectWriter = itemObjectWriter;
                if (itemClass == this.itemClass) {
                    this.itemClassWriter = itemObjectWriter;
                }
            }
            if (refDetect && (refPath = jsonWriter.setPath(i, item)) != null) {
                jsonWriter.writeReference(refPath);
                jsonWriter.popPath(item);
                continue;
            }
            itemObjectWriter.writeJSONB(jsonWriter, item, i, this.itemType, this.features);
            if (!refDetect) continue;
            jsonWriter.popPath(item);
        }
        jsonWriter.endArray();
    }

    @Override
    public void write(JSONWriter jsonWriter, Object object, Object fieldName, Type fieldType, long features) {
        if (object == null) {
            jsonWriter.writeArrayNull();
            return;
        }
        List list = this.getList(object);
        Class<?> previousClass = null;
        ObjectWriter<?> previousObjectWriter = null;
        boolean previousRefDetect = true;
        if (jsonWriter.jsonb) {
            jsonWriter.startArray(list.size());
            for (int i = 0; i < list.size(); ++i) {
                ObjectWriter<?> itemObjectWriter;
                Object item = list.get(i);
                if (item == null) {
                    jsonWriter.writeNull();
                    continue;
                }
                Class<?> itemClass = item.getClass();
                if (itemClass == previousClass) {
                    itemObjectWriter = previousObjectWriter;
                } else {
                    itemObjectWriter = jsonWriter.getObjectWriter(itemClass);
                    previousClass = itemClass;
                    previousObjectWriter = itemObjectWriter;
                }
                itemObjectWriter.writeJSONB(jsonWriter, item, i, this.itemType, features);
            }
            return;
        }
        JSONWriter.Context context = jsonWriter.context;
        ObjectWriterProvider provider = context.provider;
        int size = list.size();
        if (size == 0) {
            jsonWriter.writeRaw('[', ']');
            return;
        }
        jsonWriter.startArray();
        for (int i = 0; i < size; ++i) {
            String refPath;
            boolean refDetect;
            ObjectWriter<?> itemObjectWriter;
            Object item;
            if (i != 0) {
                jsonWriter.writeComma();
            }
            if ((item = list.get(i)) == null) {
                jsonWriter.writeNull();
                continue;
            }
            Class<?> itemClass = item.getClass();
            if (itemClass == String.class) {
                jsonWriter.writeString((String)item);
                continue;
            }
            if (itemClass == Integer.class) {
                if ((provider.userDefineMask & 2L) == 0L) {
                    jsonWriter.writeInt32((Integer)item);
                    continue;
                }
                ObjectWriter valueWriter = provider.getObjectWriter(itemClass, itemClass, false);
                valueWriter.write(jsonWriter, item, i, (Type)((Object)Integer.class), features);
                continue;
            }
            if (itemClass == Long.class) {
                if ((provider.userDefineMask & 4L) == 0L) {
                    jsonWriter.writeInt64((Long)item);
                    continue;
                }
                ObjectWriter valueWriter = provider.getObjectWriter(itemClass, itemClass, false);
                valueWriter.write(jsonWriter, item, i, (Type)((Object)Long.class), features);
                continue;
            }
            if (itemClass == Boolean.class) {
                if ((provider.userDefineMask & 2L) == 0L) {
                    jsonWriter.writeBool((Boolean)item);
                    continue;
                }
                ObjectWriter valueWriter = provider.getObjectWriter(itemClass, itemClass, false);
                valueWriter.write(jsonWriter, item, i, (Type)((Object)Boolean.class), features);
                continue;
            }
            if (itemClass == BigDecimal.class) {
                if ((provider.userDefineMask & 8L) == 0L) {
                    jsonWriter.writeDecimal((BigDecimal)item, features, null);
                    continue;
                }
                ObjectWriter valueWriter = provider.getObjectWriter(itemClass, itemClass, false);
                valueWriter.write(jsonWriter, item, i, (Type)((Object)BigDecimal.class), features);
                continue;
            }
            if (itemClass == this.itemClass && this.itemClassWriter != null) {
                itemObjectWriter = this.itemClassWriter;
                refDetect = this.itemClassRefDetect && jsonWriter.isRefDetect();
            } else if (itemClass == previousClass) {
                itemObjectWriter = previousObjectWriter;
                refDetect = previousRefDetect;
            } else {
                if (itemClass == JSONObject.class) {
                    itemObjectWriter = ObjectWriterImplMap.INSTANCE;
                    refDetect = jsonWriter.isRefDetect();
                } else if (itemClass == TypeUtils.CLASS_JSON_OBJECT_1x) {
                    itemObjectWriter = ObjectWriterImplMap.INSTANCE_1x;
                    refDetect = jsonWriter.isRefDetect();
                } else if (itemClass == JSONArray.class) {
                    itemObjectWriter = INSTANCE_JSON_ARRAY;
                    refDetect = jsonWriter.isRefDetect();
                } else if (itemClass == TypeUtils.CLASS_JSON_ARRAY_1x) {
                    itemObjectWriter = INSTANCE_JSON_ARRAY_1x;
                    refDetect = jsonWriter.isRefDetect();
                } else {
                    itemObjectWriter = context.getObjectWriter(itemClass);
                    refDetect = jsonWriter.isRefDetect(item);
                }
                previousClass = itemClass;
                previousObjectWriter = itemObjectWriter;
                previousRefDetect = refDetect;
                if (itemClass == this.itemClass) {
                    this.itemClassWriter = itemObjectWriter;
                }
            }
            if (refDetect && (refPath = jsonWriter.setPath(i, item)) != null) {
                jsonWriter.writeReference(refPath);
                jsonWriter.popPath(item);
                continue;
            }
            itemObjectWriter.write(jsonWriter, item, i, this.itemType, this.features);
            if (!refDetect) continue;
            jsonWriter.popPath(item);
        }
        jsonWriter.endArray();
    }

    private List getList(Object object) {
        if (object instanceof List) {
            return (List)object;
        }
        if (object instanceof Iterable) {
            Iterable items = (Iterable)object;
            ArrayList list = items instanceof Collection ? new ArrayList(((Collection)items).size()) : new ArrayList();
            for (Object item : items) {
                list.add(item);
            }
            return list;
        }
        throw new JSONException("Can not cast '" + object.getClass() + "' to List");
    }
}

