/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.util;

import com.alibaba.fastjson2.util.UnsafeUtils;
import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.nio.charset.Charset;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;

public class JDKUtils {
    public static final int JVM_VERSION;
    static volatile ToIntFunction<String> CODER_FUNCTION;
    static volatile Function<String, byte[]> VALUE_FUNCTION;
    static final Class CLASS_SQL_DATASOURCE;
    static final Class CLASS_SQL_ROW_SET;
    public static final boolean HAS_SQL;
    public static final Class CLASS_TRANSIENT;
    public static final byte BIG_ENDIAN;
    public static final boolean UNSAFE_SUPPORT;
    public static final Function<byte[], String> UNSAFE_UTF16_CREATOR;
    public static final Function<byte[], String> UNSAFE_ASCII_CREATOR;

    public static boolean isSQLDataSourceOrRowSet(Class type) {
        return CLASS_SQL_DATASOURCE != null && CLASS_SQL_ROW_SET.isAssignableFrom(type) || CLASS_SQL_ROW_SET != null && CLASS_SQL_ROW_SET.isAssignableFrom(type);
    }

    public static char[] getCharArray(String str) {
        return str.toCharArray();
    }

    public static BiFunction<char[], Boolean, String> getStringCreatorJDK8() throws Throwable {
        MethodHandles.Lookup lookup = JDKUtils.getLookup();
        MethodHandles.Lookup caller = lookup.in(String.class);
        MethodHandle handle = caller.findConstructor(String.class, MethodType.methodType(Void.TYPE, char[].class, Boolean.TYPE));
        CallSite callSite = LambdaMetafactory.metafactory(caller, "apply", MethodType.methodType(BiFunction.class), handle.type().generic(), handle, handle.type());
        return callSite.getTarget().invokeExact();
    }

    public static Function<byte[], String> getStringCreatorJDK11() throws Throwable {
        MethodHandles.Lookup lookup = JDKUtils.getLookup();
        Class<?> clazz = Class.forName("java.lang.StringCoding");
        MethodHandles.Lookup caller = lookup.in(clazz);
        MethodHandle handle = caller.findStatic(clazz, "newStringLatin1", MethodType.methodType(String.class, byte[].class));
        CallSite callSite = LambdaMetafactory.metafactory(caller, "apply", MethodType.methodType(Function.class), handle.type().generic(), handle, handle.type());
        return callSite.getTarget().invokeExact();
    }

    public static BiFunction<byte[], Charset, String> getStringCreatorJDK17() throws Throwable {
        MethodHandles.Lookup lookup = JDKUtils.getLookup();
        MethodHandles.Lookup caller = lookup.in(String.class);
        MethodHandle handle = caller.findStatic(String.class, "newStringNoRepl1", MethodType.methodType(String.class, byte[].class, Charset.class));
        CallSite callSite = LambdaMetafactory.metafactory(caller, "apply", MethodType.methodType(BiFunction.class), handle.type().generic(), handle, handle.type());
        return callSite.getTarget().invokeExact();
    }

    public static ToIntFunction<String> getStringCode11() throws Throwable {
        if (CODER_FUNCTION != null) {
            return CODER_FUNCTION;
        }
        MethodHandles.Lookup lookup = JDKUtils.getLookup();
        MethodHandles.Lookup caller = lookup.in(String.class);
        MethodHandle handle = caller.findVirtual(String.class, "coder", MethodType.methodType(Byte.TYPE));
        CallSite callSite = LambdaMetafactory.metafactory(caller, "applyAsInt", MethodType.methodType(ToIntFunction.class), MethodType.methodType(Integer.TYPE, Object.class), handle, handle.type());
        CODER_FUNCTION = callSite.getTarget().invokeExact();
        return CODER_FUNCTION;
    }

    public static Function<String, byte[]> getStringValue11() throws Throwable {
        if (VALUE_FUNCTION != null) {
            return VALUE_FUNCTION;
        }
        MethodHandles.Lookup lookup = JDKUtils.getLookup();
        MethodHandles.Lookup caller = lookup.in(String.class);
        MethodHandle handle = caller.findVirtual(String.class, "value", MethodType.methodType(byte[].class));
        CallSite callSite = LambdaMetafactory.metafactory(caller, "apply", MethodType.methodType(Function.class), handle.type().generic(), handle, handle.type());
        VALUE_FUNCTION = callSite.getTarget().invokeExact();
        return VALUE_FUNCTION;
    }

    private static MethodHandles.Lookup getLookup() throws Exception {
        MethodHandles.Lookup lookup;
        if (JVM_VERSION >= 17) {
            Constructor constructor = MethodHandles.Lookup.class.getDeclaredConstructor(Class.class, Class.class, Integer.TYPE);
            constructor.setAccessible(true);
            lookup = (MethodHandles.Lookup)constructor.newInstance(String.class, null, -1);
        } else {
            Constructor constructor = MethodHandles.Lookup.class.getDeclaredConstructor(Class.class, Integer.TYPE);
            constructor.setAccessible(true);
            lookup = (MethodHandles.Lookup)constructor.newInstance(String.class, -1);
        }
        return lookup;
    }

    static {
        boolean unsafeSupport;
        int jvmVersion = -1;
        try {
            String property = System.getProperty("java.specification.version");
            if (property.startsWith("1.")) {
                property = property.substring(2);
            }
            jvmVersion = Integer.parseInt(property);
        }
        catch (Throwable property) {
            // empty catch block
        }
        boolean hasJavaSql = true;
        Class<?> dataSourceClass = null;
        Class<?> rowSetClass = null;
        try {
            dataSourceClass = Class.forName("javax.sql.DataSource");
            rowSetClass = Class.forName("javax.sql.RowSet");
        }
        catch (Throwable e) {
            hasJavaSql = false;
        }
        CLASS_SQL_DATASOURCE = dataSourceClass;
        CLASS_SQL_ROW_SET = rowSetClass;
        HAS_SQL = hasJavaSql;
        Class<?> transientClass = null;
        try {
            transientClass = Class.forName("java.beans.Transient");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        CLASS_TRANSIENT = transientClass;
        JVM_VERSION = jvmVersion;
        Boolean bigEndian = null;
        BIG_ENDIAN = (byte)(bigEndian == null ? -1 : (bigEndian != false ? 1 : 0));
        UNSAFE_SUPPORT = unsafeSupport = ((Predicate<Object>)o -> {
            try {
                return UnsafeUtils.UNSAFE != null;
            }
            catch (Throwable ignored) {
                return false;
            }
        }).test(null);
        Function utf16Creator = null;
        Function asciiCreator = null;
        if (unsafeSupport) {
            try {
                utf16Creator = ((Supplier<Function>)() -> UnsafeUtils.getStringCreatorUTF16()).get();
                asciiCreator = ((Supplier<Function>)() -> UnsafeUtils.getStringCreatorASCII()).get();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        UNSAFE_UTF16_CREATOR = utf16Creator;
        UNSAFE_ASCII_CREATOR = asciiCreator;
    }
}

