/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.codec.BeanInfo;
import com.alibaba.fastjson2.codec.FieldInfo;
import com.alibaba.fastjson2.function.ObjBoolConsumer;
import com.alibaba.fastjson2.function.ObjByteConsumer;
import com.alibaba.fastjson2.function.ObjCharConsumer;
import com.alibaba.fastjson2.function.ObjFloatConsumer;
import com.alibaba.fastjson2.function.ObjShortConsumer;
import com.alibaba.fastjson2.modules.ObjectReaderAnnotationProcessor;
import com.alibaba.fastjson2.modules.ObjectReaderModule;
import com.alibaba.fastjson2.reader.FieldReader;
import com.alibaba.fastjson2.reader.FieldReaderBoolValFunc;
import com.alibaba.fastjson2.reader.FieldReaderCharValueFunc;
import com.alibaba.fastjson2.reader.FieldReaderDoubleValueFunc;
import com.alibaba.fastjson2.reader.FieldReaderFloatValueFunc;
import com.alibaba.fastjson2.reader.FieldReaderInt16ValueFunc;
import com.alibaba.fastjson2.reader.FieldReaderInt32ValueFunc;
import com.alibaba.fastjson2.reader.FieldReaderInt64ValueFunc;
import com.alibaba.fastjson2.reader.FieldReaderInt8ValueFunc;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderCreator;
import com.alibaba.fastjson2.util.BeanUtils;
import com.alibaba.fastjson2.writer.ObjectWriterCreatorLambda;
import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.ObjDoubleConsumer;
import java.util.function.ObjIntConsumer;
import java.util.function.ObjLongConsumer;
import java.util.function.Supplier;

public class ObjectReaderCreatorLambda
extends ObjectReaderCreator {
    private static final Map<Class, Class> classFunctionMapping = new HashMap<Class, Class>();
    private static final Map<Class, MethodType> methodTypeMapping = new HashMap<Class, MethodType>();
    private static final MethodType METHODTYPE_BiFunction = MethodType.methodType(BiConsumer.class);
    private static final MethodType METHODTYPE_Function = MethodType.methodType(Function.class);
    private static final MethodType METHODTYPE_VOID = MethodType.methodType(Void.TYPE);
    public static final ObjectReaderCreatorLambda INSTANCE;

    @Override
    public <T> ObjectReader<T> createObjectReader(Class<T> objectClass, Type objectType, boolean fieldBased, List<ObjectReaderModule> modules) {
        Supplier<T> supplier;
        BeanInfo beanInfo = new BeanInfo();
        for (ObjectReaderModule module : modules) {
            ObjectReaderAnnotationProcessor annotationProcessor = module.getAnnotationProcessor();
            if (annotationProcessor == null) continue;
            annotationProcessor.getBeanInfo(beanInfo, objectClass);
        }
        if (beanInfo.deserializer != null && ObjectReader.class.isAssignableFrom(beanInfo.deserializer)) {
            try {
                return (ObjectReader)beanInfo.deserializer.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new JSONException("create deserializer error", e);
            }
        }
        if (Enum.class.isAssignableFrom(objectClass)) {
            return this.createEnumReader(objectClass, beanInfo.createMethod, modules);
        }
        if (fieldBased && (objectClass.isInterface() || objectClass.isInterface())) {
            fieldBased = false;
        }
        AtomicReference constructorRef = new AtomicReference();
        BeanUtils.constructor(objectClass, constructor -> constructorRef.set(constructor));
        int classModifiers = objectClass.getModifiers();
        Constructor constructor2 = (Constructor)constructorRef.get();
        if (constructor2 == null || !constructor2.isAccessible() || Modifier.isAbstract(classModifiers) || Modifier.isInterface(classModifiers)) {
            return super.createObjectReader(objectClass, objectType, fieldBased, modules);
        }
        try {
            supplier = ObjectReaderCreatorLambda.lambdaConstrunctor(objectClass);
        }
        catch (IllegalAccessException | NoSuchMethodException ignored) {
            return super.createObjectReader(objectClass, objectType, fieldBased, modules);
        }
        catch (Throwable e) {
            throw new JSONException("get constructor error, objectClass : " + objectClass, e);
        }
        LinkedHashMap fieldReaders = new LinkedHashMap();
        FieldInfo fieldInfo = new FieldInfo();
        BeanUtils.setters(objectClass, method -> {
            Class<?> fieldClass;
            fieldInfo.init();
            for (ObjectReaderModule module : modules) {
                ObjectReaderAnnotationProcessor annotationProcessor = module.getAnnotationProcessor();
                if (annotationProcessor == null) continue;
                annotationProcessor.getFieldInfo(fieldInfo, objectClass, (Method)method);
            }
            String fieldName = BeanUtils.setterName(method.getName(), beanInfo.namingStrategy);
            if (method.getParameterCount() == 0) {
                FieldReader fieldReader = super.createFieldReaderMethod(objectClass, objectType, fieldName, fieldInfo.ordinal, fieldInfo.features, fieldInfo.format, fieldInfo.locale, fieldInfo.defaultValue, method.getGenericReturnType(), method.getReturnType(), (Method)method);
                FieldReader origin = fieldReaders.putIfAbsent(fieldName, fieldReader);
                if (origin != null && origin.compareTo(fieldReader) > 0) {
                    fieldReaders.put(fieldName, fieldReader);
                }
                return;
            }
            Type fieldType = method.getGenericParameterTypes()[0];
            FieldReader fieldReader = this.createFieldReaderLambda(objectClass, objectType, fieldName, fieldInfo.ordinal, fieldInfo.features, fieldInfo.format, fieldInfo.locale, fieldInfo.defaultValue, fieldType, fieldClass = method.getParameterTypes()[0], (Method)method);
            FieldReader origin = fieldReaders.putIfAbsent(fieldName, fieldReader);
            if (origin != null && origin.compareTo(fieldReader) > 0) {
                fieldReaders.put(fieldName, fieldReader);
            }
        });
        BeanUtils.fields(objectClass, field -> {
            fieldInfo.init();
            for (ObjectReaderModule module : modules) {
                ObjectReaderAnnotationProcessor annotationProcessor = module.getAnnotationProcessor();
                if (annotationProcessor == null) continue;
                annotationProcessor.getFieldInfo(fieldInfo, objectClass, (Field)field);
            }
            String fieldName = field.getName();
            fieldReaders.put(fieldName, this.createFieldReader(objectClass, (Type)objectClass, fieldName, fieldInfo.ordinal, fieldInfo.features, fieldInfo.format, fieldInfo.locale, (Object)fieldInfo.defaultValue, field.getGenericType(), field.getType(), (Field)field));
        });
        Object[] fieldReaderArray = new FieldReader[fieldReaders.size()];
        fieldReaders.values().toArray(fieldReaderArray);
        Arrays.sort(fieldReaderArray);
        Supplier<T> creator = this.createInstanceSupplier(objectClass);
        if (beanInfo.seeAlso != null && beanInfo.seeAlso.length != 0) {
            return this.createObjectReaderSeeAlso(objectClass, creator, beanInfo.typeKey, beanInfo.seeAlso, beanInfo.seeAlsoNames, (FieldReader[])fieldReaderArray);
        }
        return this.createObjectReader(objectClass, beanInfo.readerFeatures, supplier, null, (FieldReader[])fieldReaderArray);
    }

    @Override
    public <T> FieldReader createFieldReaderMethod(Class<T> objectClass, Type objectType, String fieldName, int ordinal, long features, String format, Locale locale, Object defaultValue, Type fieldType, Class fieldClass, Method method) {
        if (method != null && method.getReturnType() != Void.TYPE || !Modifier.isPublic(objectClass.getModifiers()) || ObjectReaderCreatorLambda.isExternalClass(objectClass)) {
            return super.createFieldReaderMethod(objectClass, objectType, fieldName, ordinal, features, format, locale, defaultValue, fieldType, fieldClass, method);
        }
        return this.createFieldReaderLambda(objectClass, objectType, fieldName, ordinal, features, format, locale, defaultValue, fieldType, fieldClass, method);
    }

    protected <T> FieldReader createFieldReaderLambda(Class<T> objectClass, Type objectType, String fieldName, int ordinal, long features, String format, Locale locale, Object defaultValue, Type fieldType, Class fieldClass, Method method) {
        Object function;
        if (defaultValue != null && defaultValue.getClass() != fieldClass) {
            Function typeConvert = JSONFactory.getDefaultObjectReaderProvider().getTypeConvert(defaultValue.getClass(), fieldType);
            if (typeConvert != null) {
                defaultValue = typeConvert.apply(defaultValue);
            } else {
                throw new JSONException("illegal defaultValue : " + defaultValue + ", class " + fieldClass.getName());
            }
        }
        if (fieldType == Boolean.TYPE) {
            function = (ObjBoolConsumer)ObjectReaderCreatorLambda.lambdaFunction(objectClass, fieldClass, method);
            return new FieldReaderBoolValFunc(fieldName, ordinal, method, function);
        }
        if (fieldType == Byte.TYPE) {
            function = (ObjByteConsumer)ObjectReaderCreatorLambda.lambdaFunction(objectClass, fieldClass, method);
            return new FieldReaderInt8ValueFunc(fieldName, ordinal, method, function);
        }
        if (fieldType == Short.TYPE) {
            function = (ObjShortConsumer)ObjectReaderCreatorLambda.lambdaFunction(objectClass, fieldClass, method);
            return new FieldReaderInt16ValueFunc(fieldName, ordinal, method, function);
        }
        if (fieldType == Integer.TYPE) {
            function = (ObjIntConsumer)ObjectReaderCreatorLambda.lambdaFunction(objectClass, fieldClass, method);
            return new FieldReaderInt32ValueFunc(fieldName, ordinal, method, function);
        }
        if (fieldType == Long.TYPE) {
            function = (ObjLongConsumer)ObjectReaderCreatorLambda.lambdaFunction(objectClass, fieldClass, method);
            return new FieldReaderInt64ValueFunc(fieldName, ordinal, method, function);
        }
        if (fieldType == Character.TYPE) {
            function = (ObjCharConsumer)ObjectReaderCreatorLambda.lambdaFunction(objectClass, fieldClass, method);
            return new FieldReaderCharValueFunc(fieldName, ordinal, method, format, method, function);
        }
        if (fieldType == Float.TYPE) {
            function = (ObjFloatConsumer)ObjectReaderCreatorLambda.lambdaFunction(objectClass, fieldClass, method);
            return new FieldReaderFloatValueFunc(fieldName, ordinal, method, function);
        }
        if (fieldType == Double.TYPE) {
            function = (ObjDoubleConsumer)ObjectReaderCreatorLambda.lambdaFunction(objectClass, fieldClass, method);
            return new FieldReaderDoubleValueFunc(fieldName, ordinal, method, function);
        }
        function = (BiConsumer)ObjectReaderCreatorLambda.lambdaFunction(objectClass, fieldClass, method);
        return this.createFieldReader((Class)objectClass, objectType, fieldName, fieldType, fieldClass, ordinal, features, format, defaultValue, method, function);
    }

    private static Object lambdaFunction(Class objectType, Class fieldClass, Method method) {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        MethodType invokedType = methodTypeMapping.getOrDefault(fieldClass, METHODTYPE_BiFunction);
        try {
            MethodHandle target = lookup.findVirtual(objectType, method.getName(), MethodType.methodType(Void.TYPE, fieldClass));
            MethodType func = target.type();
            CallSite callSite = LambdaMetafactory.metafactory(lookup, "accept", invokedType, func.erase(), target, func);
            return callSite.getTarget().invoke();
        }
        catch (Throwable e) {
            throw new JSONException("create fieldReader error", e);
        }
    }

    @Override
    public <T, R> Function<T, R> createBuildFunction(Method builderMethod) {
        if (!Modifier.isPublic(builderMethod.getDeclaringClass().getModifiers())) {
            return super.createBuildFunction(builderMethod);
        }
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        MethodType invokedType = METHODTYPE_Function;
        try {
            MethodHandle target = lookup.findVirtual(builderMethod.getDeclaringClass(), builderMethod.getName(), MethodType.methodType(builderMethod.getReturnType()));
            MethodType func = target.type();
            CallSite callSite = LambdaMetafactory.metafactory(lookup, "apply", invokedType, func.erase(), target, func);
            Object object = callSite.getTarget().invoke();
            return (Function)object;
        }
        catch (Throwable e) {
            throw new JSONException("create fieldReader error", e);
        }
    }

    static <T> Supplier<T> lambdaConstrunctor(Class<T> objectType) throws Throwable {
        if (objectType == List.class) {
            return () -> new ArrayList();
        }
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        MethodHandle mh = lookup.findConstructor(objectType, METHODTYPE_VOID);
        CallSite callSite = LambdaMetafactory.metafactory(lookup, "get", MethodType.methodType(Supplier.class), mh.type().generic(), mh, mh.type());
        return callSite.getTarget().invokeExact();
    }

    static boolean isExternalClass(Class<?> clazz) {
        ClassLoader classLoader = clazz.getClassLoader();
        if (classLoader == null) {
            return false;
        }
        for (ClassLoader current = ObjectWriterCreatorLambda.class.getClassLoader(); current != null; current = current.getParent()) {
            if (current != classLoader) continue;
            return false;
        }
        return true;
    }

    static {
        classFunctionMapping.put(Boolean.TYPE, ObjBoolConsumer.class);
        classFunctionMapping.put(Byte.TYPE, ObjByteConsumer.class);
        classFunctionMapping.put(Short.TYPE, ObjShortConsumer.class);
        classFunctionMapping.put(Integer.TYPE, ObjIntConsumer.class);
        classFunctionMapping.put(Long.TYPE, ObjLongConsumer.class);
        classFunctionMapping.put(Character.TYPE, ObjCharConsumer.class);
        classFunctionMapping.put(Float.TYPE, ObjFloatConsumer.class);
        classFunctionMapping.put(Double.TYPE, ObjDoubleConsumer.class);
        classFunctionMapping.forEach((k, v) -> methodTypeMapping.put((Class)k, MethodType.methodType(v)));
        INSTANCE = new ObjectReaderCreatorLambda();
    }
}

