/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.TypeReference;
import com.alibaba.fastjson2.codec.BeanInfo;
import com.alibaba.fastjson2.codec.FieldInfo;
import com.alibaba.fastjson2.internal.asm.ASMUtils;
import com.alibaba.fastjson2.modules.ObjectReaderAnnotationProcessor;
import com.alibaba.fastjson2.modules.ObjectReaderModule;
import com.alibaba.fastjson2.reader.ConstructorFunction;
import com.alibaba.fastjson2.reader.FactoryFunction;
import com.alibaba.fastjson2.reader.FieldReader;
import com.alibaba.fastjson2.reader.FieldReaderAnySetter;
import com.alibaba.fastjson2.reader.FieldReaderAtomicBooleanFieldReadOnly;
import com.alibaba.fastjson2.reader.FieldReaderAtomicBooleanMethodReadOnly;
import com.alibaba.fastjson2.reader.FieldReaderAtomicIntegerArrayReadOnly;
import com.alibaba.fastjson2.reader.FieldReaderAtomicIntegerMethodReadOnly;
import com.alibaba.fastjson2.reader.FieldReaderAtomicLongArrayReadOnly;
import com.alibaba.fastjson2.reader.FieldReaderAtomicLongReadOnly;
import com.alibaba.fastjson2.reader.FieldReaderAtomicReferenceField;
import com.alibaba.fastjson2.reader.FieldReaderAtomicReferenceMethodReadOnly;
import com.alibaba.fastjson2.reader.FieldReaderBigDecimalField;
import com.alibaba.fastjson2.reader.FieldReaderBigDecimalFunc;
import com.alibaba.fastjson2.reader.FieldReaderBigDecimalMethod;
import com.alibaba.fastjson2.reader.FieldReaderBigIntegerField;
import com.alibaba.fastjson2.reader.FieldReaderBigIntegerFunc;
import com.alibaba.fastjson2.reader.FieldReaderBigIntegerMethod;
import com.alibaba.fastjson2.reader.FieldReaderBoolField;
import com.alibaba.fastjson2.reader.FieldReaderBoolFunc;
import com.alibaba.fastjson2.reader.FieldReaderBoolMethod;
import com.alibaba.fastjson2.reader.FieldReaderBoolValueField;
import com.alibaba.fastjson2.reader.FieldReaderBoolValueMethod;
import com.alibaba.fastjson2.reader.FieldReaderCollectionFieldReadOnly;
import com.alibaba.fastjson2.reader.FieldReaderCollectionMethodReadOnly;
import com.alibaba.fastjson2.reader.FieldReaderDateField;
import com.alibaba.fastjson2.reader.FieldReaderDateFunc;
import com.alibaba.fastjson2.reader.FieldReaderDateMethod;
import com.alibaba.fastjson2.reader.FieldReaderDoubleField;
import com.alibaba.fastjson2.reader.FieldReaderDoubleMethod;
import com.alibaba.fastjson2.reader.FieldReaderDoubleValueField;
import com.alibaba.fastjson2.reader.FieldReaderDoubleValueMethod;
import com.alibaba.fastjson2.reader.FieldReaderFloatField;
import com.alibaba.fastjson2.reader.FieldReaderFloatMethod;
import com.alibaba.fastjson2.reader.FieldReaderFloatValueField;
import com.alibaba.fastjson2.reader.FieldReaderFloatValueMethod;
import com.alibaba.fastjson2.reader.FieldReaderInt16Field;
import com.alibaba.fastjson2.reader.FieldReaderInt16Func;
import com.alibaba.fastjson2.reader.FieldReaderInt16Method;
import com.alibaba.fastjson2.reader.FieldReaderInt16Param;
import com.alibaba.fastjson2.reader.FieldReaderInt16ValueField;
import com.alibaba.fastjson2.reader.FieldReaderInt16ValueMethod;
import com.alibaba.fastjson2.reader.FieldReaderInt32Field;
import com.alibaba.fastjson2.reader.FieldReaderInt32Func;
import com.alibaba.fastjson2.reader.FieldReaderInt32Method;
import com.alibaba.fastjson2.reader.FieldReaderInt32Param;
import com.alibaba.fastjson2.reader.FieldReaderInt32ValueArrayFinalField;
import com.alibaba.fastjson2.reader.FieldReaderInt32ValueField;
import com.alibaba.fastjson2.reader.FieldReaderInt32ValueMethod;
import com.alibaba.fastjson2.reader.FieldReaderInt64Field;
import com.alibaba.fastjson2.reader.FieldReaderInt64Func;
import com.alibaba.fastjson2.reader.FieldReaderInt64Method;
import com.alibaba.fastjson2.reader.FieldReaderInt64Param;
import com.alibaba.fastjson2.reader.FieldReaderInt64ValueArrayFinalField;
import com.alibaba.fastjson2.reader.FieldReaderInt64ValueField;
import com.alibaba.fastjson2.reader.FieldReaderInt64ValueMethod;
import com.alibaba.fastjson2.reader.FieldReaderInt8Field;
import com.alibaba.fastjson2.reader.FieldReaderInt8Func;
import com.alibaba.fastjson2.reader.FieldReaderInt8Method;
import com.alibaba.fastjson2.reader.FieldReaderInt8Param;
import com.alibaba.fastjson2.reader.FieldReaderInt8ValueField;
import com.alibaba.fastjson2.reader.FieldReaderInt8ValueMethod;
import com.alibaba.fastjson2.reader.FieldReaderListField;
import com.alibaba.fastjson2.reader.FieldReaderListFieldUF;
import com.alibaba.fastjson2.reader.FieldReaderListFunc;
import com.alibaba.fastjson2.reader.FieldReaderListMethod;
import com.alibaba.fastjson2.reader.FieldReaderListStrField;
import com.alibaba.fastjson2.reader.FieldReaderListStrFieldUF;
import com.alibaba.fastjson2.reader.FieldReaderListStrFunc;
import com.alibaba.fastjson2.reader.FieldReaderListStrMethod;
import com.alibaba.fastjson2.reader.FieldReaderMapMethodReadOnly;
import com.alibaba.fastjson2.reader.FieldReaderNumberFunc;
import com.alibaba.fastjson2.reader.FieldReaderObjectField;
import com.alibaba.fastjson2.reader.FieldReaderObjectFieldUF;
import com.alibaba.fastjson2.reader.FieldReaderObjectFunc;
import com.alibaba.fastjson2.reader.FieldReaderObjectMethod;
import com.alibaba.fastjson2.reader.FieldReaderObjectParam;
import com.alibaba.fastjson2.reader.FieldReaderStringField;
import com.alibaba.fastjson2.reader.FieldReaderStringFunc;
import com.alibaba.fastjson2.reader.FieldReaderStringMethod;
import com.alibaba.fastjson2.reader.FielderReaderImplMapFieldReadOnly;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReader1;
import com.alibaba.fastjson2.reader.ObjectReader2;
import com.alibaba.fastjson2.reader.ObjectReader3;
import com.alibaba.fastjson2.reader.ObjectReader4;
import com.alibaba.fastjson2.reader.ObjectReader5;
import com.alibaba.fastjson2.reader.ObjectReader6;
import com.alibaba.fastjson2.reader.ObjectReaderAdapter;
import com.alibaba.fastjson2.reader.ObjectReaderImplEnum;
import com.alibaba.fastjson2.reader.ObjectReaderImplEnum2X4;
import com.alibaba.fastjson2.reader.ObjectReaderInterface;
import com.alibaba.fastjson2.reader.ObjectReaderNoneDefaultConstrutor;
import com.alibaba.fastjson2.reader.ObjectReaderProvider;
import com.alibaba.fastjson2.reader.ObjectReaderSeeAlso;
import com.alibaba.fastjson2.util.BeanUtils;
import com.alibaba.fastjson2.util.Fnv;
import com.alibaba.fastjson2.util.JDKUtils;
import com.alibaba.fastjson2.util.TypeUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class ObjectReaderCreator {
    public static final ObjectReaderCreator INSTANCE = new ObjectReaderCreator();

    public <T> ObjectReader<T> createObjectReaderNoneDefaultConstrutor(Constructor constructor, String ... paramNames) {
        Function<Map<Long, Object>, T> function = this.createFunction(constructor, paramNames);
        FieldReader[] fieldReaders = this.createFieldReaders(constructor.getParameters(), paramNames);
        return this.createObjectReaderNoneDefaultConstrutor(constructor.getDeclaringClass(), function, fieldReaders);
    }

    public <T> ObjectReader<T> createObjectReaderNoneDefaultConstrutor(Class objectClass, Constructor constructor, String[] paramNames, FieldReader[] paramFieldReaders, FieldReader[] setterFieldReaders) {
        Function<Map<Long, Object>, T> function = this.createFunction(constructor, paramNames);
        return new ObjectReaderNoneDefaultConstrutor<T>(objectClass, null, 0L, function, null, paramNames, paramFieldReaders, setterFieldReaders);
    }

    public <T> ObjectReader<T> createObjectReaderNoneDefaultConstrutor(Class objectClass, Function<Map<Long, Object>, T> creator, FieldReader ... fieldReaders) {
        return new ObjectReaderNoneDefaultConstrutor<T>(objectClass, null, 0L, creator, null, null, fieldReaders, null);
    }

    public <T> ObjectReader<T> createObjectReaderFactoryMethod(Method factoryMethod, String ... paramNames) {
        Function<Map<Long, Object>, T> factoryFunction = this.createFactoryFunction(factoryMethod, paramNames);
        FieldReader[] fieldReaders = this.createFieldReaders(factoryMethod.getParameters(), paramNames);
        return new ObjectReaderNoneDefaultConstrutor<T>(null, null, 0L, factoryFunction, null, paramNames, fieldReaders, null);
    }

    public FieldReader[] createFieldReaders(Parameter[] parameters, String ... paramNames) {
        FieldReader[] fieldReaders = new FieldReader[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            Parameter parameter = parameters[i];
            String paramName = i < paramNames.length ? paramNames[i] : parameter.getName();
            Type paramType = parameter.getParameterizedType();
            fieldReaders[i] = this.createFieldReaderParam(null, null, paramName, null, paramType, parameter.getType(), paramName, parameter, i);
        }
        return fieldReaders;
    }

    public <T> Function<Map<Long, Object>, T> createFactoryFunction(Method factoryMethod, String ... paramNames) {
        factoryMethod.setAccessible(true);
        return new FactoryFunction(factoryMethod, paramNames);
    }

    public <T> Function<Map<Long, Object>, T> createFunction(Constructor constructor, String ... paramNames) {
        constructor.setAccessible(true);
        return new ConstructorFunction(constructor, paramNames);
    }

    public <T> ObjectReader<T> createObjectReader(Class<T> objectType, FieldReader ... fieldReaders) {
        return this.createObjectReader(objectType, null, 0L, this.createInstanceSupplier(objectType), null, fieldReaders);
    }

    public <T> ObjectReader<T> createObjectReader(Class<T> objectType, Supplier<T> defaultCreator, FieldReader ... fieldReaders) {
        return this.createObjectReader(objectType, null, 0L, defaultCreator, null, fieldReaders);
    }

    public <T> ObjectReader<T> createObjectReaderSeeAlso(Class<T> objectType, Class[] seeAlso, FieldReader ... fieldReaders) {
        Supplier<T> instanceSupplier = this.createInstanceSupplier(objectType);
        return new ObjectReaderSeeAlso<T>(objectType, instanceSupplier, "@type", seeAlso, null, fieldReaders);
    }

    public <T> ObjectReader<T> createObjectReaderSeeAlso(Class<T> objectType, Supplier<T> defaultCreator, String typeKey, Class[] seeAlso, String[] seeAlsoNames, FieldReader ... fieldReaders) {
        return new ObjectReaderSeeAlso<T>(objectType, defaultCreator, typeKey, seeAlso, seeAlsoNames, fieldReaders);
    }

    protected <T> ObjectReader<T> createObjectReaderWithBuilder(Class<T> objectType, List<ObjectReaderModule> modules, BeanInfo beanInfo) {
        Function builderFunction = null;
        if (beanInfo.buildMethod != null) {
            builderFunction = this.createBuildFunction(beanInfo.buildMethod);
        }
        Class builderClass = beanInfo.builder;
        String builderWithPrefix = beanInfo.builderWithPrefix;
        if (builderWithPrefix == null || builderWithPrefix.isEmpty()) {
            builderWithPrefix = "with";
        }
        int builderWithPrefixLenth = builderWithPrefix.length();
        LinkedHashMap fieldReaders = new LinkedHashMap();
        String prefix = builderWithPrefix;
        FieldInfo fieldInfo = new FieldInfo();
        BeanUtils.setters(builderClass, false, method -> {
            String fieldName;
            fieldInfo.init();
            for (ObjectReaderModule module : modules) {
                ObjectReaderAnnotationProcessor annotationProcessor = module.getAnnotationProcessor();
                if (annotationProcessor == null) continue;
                annotationProcessor.getFieldInfo(fieldInfo, objectType, (Method)method);
            }
            if (fieldInfo.ignore) {
                return;
            }
            String methodName = method.getName();
            if (fieldInfo.fieldName == null || fieldInfo.fieldName.isEmpty()) {
                int methodNameLength = methodName.length();
                if (methodNameLength <= prefix.length() || !methodName.startsWith(prefix)) {
                    return;
                }
                fieldName = BeanUtils.setterName(methodName, builderWithPrefixLenth);
            } else {
                fieldName = fieldInfo.fieldName;
            }
            if (method.getParameterCount() == 0) {
                FieldReader fieldReader = this.createFieldReaderMethod(builderClass, builderClass, fieldName, fieldInfo.ordinal, fieldInfo.features, fieldInfo.format, fieldInfo.locale, fieldInfo.defaultValue, method.getGenericReturnType(), method.getReturnType(), (Method)method);
                FieldReader origin = fieldReaders.putIfAbsent(fieldName, fieldReader);
                if (origin != null && origin.compareTo(fieldReader) > 0) {
                    fieldReaders.put(fieldName, fieldReader);
                }
                return;
            }
            Type fieldType = method.getGenericParameterTypes()[0];
            Class<?> fieldClass = method.getParameterTypes()[0];
            method.setAccessible(true);
            FieldReader fieldReader = this.createFieldReaderMethod(builderClass, objectType, fieldName, fieldInfo.ordinal, fieldInfo.features, fieldInfo.format, fieldInfo.locale, fieldInfo.defaultValue, fieldType, fieldClass, (Method)method);
            FieldReader origin = fieldReaders.putIfAbsent(fieldName, fieldReader);
            if (origin != null && origin.compareTo(fieldReader) > 0) {
                fieldReaders.put(fieldName, fieldReader);
            }
            if (fieldInfo.alternateNames != null) {
                for (String alternateName : fieldInfo.alternateNames) {
                    if (fieldName.equals(alternateName)) continue;
                    fieldReaders.putIfAbsent(alternateName, this.createFieldReaderMethod(builderClass, objectType, alternateName, fieldInfo.ordinal, fieldInfo.features, fieldInfo.format, fieldInfo.locale, fieldInfo.defaultValue, fieldType, fieldClass, (Method)method));
                }
            }
        });
        Object[] fieldReaderArray = new FieldReader[fieldReaders.size()];
        fieldReaders.values().toArray(fieldReaderArray);
        Arrays.sort(fieldReaderArray);
        Supplier<T> instanceSupplier = this.createInstanceSupplier(builderClass);
        return this.createObjectReader(builderClass, 0L, instanceSupplier, builderFunction, (FieldReader[])fieldReaderArray);
    }

    protected <T> ObjectReader<T> createObjectReaderWithCreator(Class<T> objectClass, List<ObjectReaderModule> modules, BeanInfo beanInfo) {
        String[] paramNames;
        Parameter[] parameters;
        FieldInfo fieldInfo = new FieldInfo();
        LinkedHashMap<String, FieldReader> fieldReaders = new LinkedHashMap<String, FieldReader>();
        if (beanInfo.creatorConstructor != null) {
            parameters = beanInfo.creatorConstructor.getParameters();
            paramNames = ASMUtils.lookupParameterNames(beanInfo.creatorConstructor);
        } else {
            parameters = beanInfo.createMethod.getParameters();
            paramNames = ASMUtils.lookupParameterNames(beanInfo.createMethod);
        }
        for (int i = 0; i < parameters.length; ++i) {
            fieldInfo.init();
            Parameter parameter = parameters[i];
            for (ObjectReaderModule module : modules) {
                ObjectReaderAnnotationProcessor annotationProcessor = module.getAnnotationProcessor();
                if (annotationProcessor == null) continue;
                if (beanInfo.creatorConstructor != null) {
                    annotationProcessor.getFieldInfo(fieldInfo, objectClass, beanInfo.creatorConstructor, i, parameter);
                    continue;
                }
                annotationProcessor.getFieldInfo(fieldInfo, objectClass, beanInfo.createMethod, i, parameter);
            }
            String fieldName = fieldInfo.fieldName;
            if (fieldName == null || fieldName.isEmpty()) {
                if (beanInfo.createParameterNames != null && i < beanInfo.createParameterNames.length) {
                    fieldName = beanInfo.createParameterNames[i];
                }
                if (fieldName == null || fieldName.isEmpty()) {
                    fieldName = parameter.getName();
                }
            }
            if (fieldName == null || fieldName.isEmpty() || fieldName.startsWith("arg")) {
                fieldName = paramNames[i];
            } else {
                paramNames[i] = fieldName;
            }
            Type paramType = parameter.getParameterizedType();
            fieldReaders.put(fieldName, this.createFieldReaderParam(objectClass, objectClass, fieldName, fieldInfo.format, paramType, parameter.getType(), fieldName, parameter, i));
            if (fieldInfo.alternateNames == null) continue;
            for (String alternateName : fieldInfo.alternateNames) {
                if (fieldName.equals(alternateName)) continue;
                fieldReaders.putIfAbsent(alternateName, this.createFieldReaderParam(objectClass, objectClass, alternateName, fieldInfo.format, paramType, parameter.getType(), fieldName, parameter, i));
            }
        }
        Function<Map<Long, Object>, Object> function = null;
        function = beanInfo.creatorConstructor != null ? this.createFunction(beanInfo.creatorConstructor, paramNames) : this.createFactoryFunction(beanInfo.createMethod, paramNames);
        Object[] fieldReaderArray = new FieldReader[fieldReaders.size()];
        fieldReaders.values().toArray(fieldReaderArray);
        Object[] setterFieldReaders = this.createFieldReaders(objectClass);
        Arrays.sort(setterFieldReaders);
        Arrays.sort(fieldReaderArray);
        return new ObjectReaderNoneDefaultConstrutor<T>(objectClass, beanInfo.typeName, beanInfo.readerFeatures, function, null, paramNames, (FieldReader[])fieldReaderArray, (FieldReader[])setterFieldReaders);
    }

    public <T> ObjectReader<T> createObjectReader(Class<T> objectClass, long features, Supplier<T> defaultCreator, Function buildFunction, FieldReader ... fieldReaders) {
        return this.createObjectReader(objectClass, null, features, defaultCreator, buildFunction, fieldReaders);
    }

    public <T> ObjectReader<T> createObjectReader(Class<T> objectClass, String typeKey, long features, Supplier<T> defaultCreator, Function buildFunction, FieldReader ... fieldReaders) {
        int modifiers;
        if (objectClass != null && (Modifier.isAbstract(modifiers = objectClass.getModifiers()) || Modifier.isInterface(modifiers))) {
            return new ObjectReaderAdapter<T>(objectClass, typeKey, null, features, defaultCreator, buildFunction, fieldReaders);
        }
        switch (fieldReaders.length) {
            case 1: {
                return new ObjectReader1<T>(objectClass, features, defaultCreator, buildFunction, fieldReaders[0]);
            }
            case 2: {
                return new ObjectReader2<T>(objectClass, features, defaultCreator, buildFunction, fieldReaders[0], fieldReaders[1]);
            }
            case 3: {
                return new ObjectReader3<T>(objectClass, defaultCreator, features, buildFunction, fieldReaders[0], fieldReaders[1], fieldReaders[2]);
            }
            case 4: {
                return new ObjectReader4<T>(objectClass, features, defaultCreator, buildFunction, fieldReaders[0], fieldReaders[1], fieldReaders[2], fieldReaders[3]);
            }
            case 5: {
                return new ObjectReader5<T>(objectClass, defaultCreator, features, buildFunction, fieldReaders[0], fieldReaders[1], fieldReaders[2], fieldReaders[3], fieldReaders[4]);
            }
            case 6: {
                return new ObjectReader6<T>(objectClass, defaultCreator, features, buildFunction, fieldReaders[0], fieldReaders[1], fieldReaders[2], fieldReaders[3], fieldReaders[4], fieldReaders[5]);
            }
        }
        return new ObjectReaderAdapter<T>(objectClass, typeKey, null, features, defaultCreator, buildFunction, fieldReaders);
    }

    public <T> ObjectReader<T> createObjectReader(Type objectType) {
        if (objectType instanceof Class) {
            return this.createObjectReader((Class)objectType);
        }
        Class<?> objectClass = TypeUtils.getMapping(objectType);
        FieldReader[] fieldReaderArray = this.createFieldReaders(objectClass, objectType);
        return this.createObjectReader(objectClass, this.createInstanceSupplier(objectClass), fieldReaderArray);
    }

    public <T> ObjectReader<T> createObjectReader(Class<T> objectType) {
        return this.createObjectReader(objectType, objectType, false, JSONFactory.getDefaultObjectReaderProvider().modules);
    }

    public <T> ObjectReader<T> createObjectReader(Class<T> objectType, boolean fieldBased) {
        return this.createObjectReader(objectType, objectType, fieldBased, JSONFactory.getDefaultObjectReaderProvider().modules);
    }

    public <T> ObjectReader<T> createObjectReader(Class<T> objectClass, Type objectType, boolean fieldBased, List<ObjectReaderModule> modules) {
        BeanInfo beanInfo = new BeanInfo();
        for (ObjectReaderModule module : modules) {
            ObjectReaderAnnotationProcessor annotationProcessor = module.getAnnotationProcessor();
            if (annotationProcessor == null) continue;
            annotationProcessor.getBeanInfo(beanInfo, objectClass);
        }
        if (beanInfo.deserializer != null && ObjectReader.class.isAssignableFrom(beanInfo.deserializer)) {
            try {
                return (ObjectReader)beanInfo.deserializer.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new JSONException("create deserializer error", e);
            }
        }
        if (fieldBased) {
            beanInfo.readerFeatures |= JSONReader.Feature.FieldBased.mask;
        }
        if (Enum.class.isAssignableFrom(objectClass)) {
            return this.createEnumReader(objectClass, beanInfo.createMethod, modules);
        }
        if (fieldBased && JDKUtils.JVM_VERSION >= 11 && Throwable.class.isAssignableFrom(objectClass)) {
            fieldBased = false;
            beanInfo.readerFeatures |= JSONReader.Feature.IgnoreSetNullValue.mask;
        }
        if (fieldBased && objectClass.isInterface()) {
            fieldBased = false;
        }
        Object[] fieldReaderArray = this.createFieldReaders(objectClass, objectType, beanInfo, fieldBased, modules);
        if (!fieldBased && Throwable.class.isAssignableFrom(objectClass)) {
            try {
                Constructor<?>[] constructors;
                Constructor<?> constructor2 = null;
                for (Constructor<?> c : constructors = objectClass.getConstructors()) {
                    Class<?>[] parameterTypes;
                    if (c.getParameterCount() != 2 || (parameterTypes = c.getParameterTypes())[0] != String.class || !Throwable.class.isAssignableFrom(parameterTypes[1])) continue;
                    constructor2 = c;
                    break;
                }
                if (constructor2 != null) {
                    String[] paramNames = new String[]{"message", "cause"};
                    FieldReader[] constructorParamReaders = this.createFieldReaders(constructor2.getParameters(), paramNames);
                    Arrays.sort(fieldReaderArray);
                    return this.createObjectReaderNoneDefaultConstrutor(objectClass, constructor2, paramNames, constructorParamReaders, (FieldReader[])fieldReaderArray);
                }
            }
            catch (Throwable constructor2) {
                // empty catch block
            }
        }
        if (beanInfo.creatorConstructor != null || beanInfo.createMethod != null) {
            return this.createObjectReaderWithCreator(objectClass, modules, beanInfo);
        }
        if (beanInfo.builder != null) {
            return this.createObjectReaderWithBuilder(objectClass, modules, beanInfo);
        }
        Constructor creatorConstructor = beanInfo.creatorConstructor;
        ArrayList<Constructor> alternateConstructors = new ArrayList<Constructor>();
        BeanUtils.constructor(objectClass, constructor -> alternateConstructors.add((Constructor)constructor));
        Constructor defaultConstructor = null;
        int index = -1;
        for (int i = 0; i < alternateConstructors.size(); ++i) {
            Constructor constructor3 = (Constructor)alternateConstructors.get(i);
            if (constructor3.getParameterCount() == 0) {
                defaultConstructor = constructor3;
            }
            if (creatorConstructor == null) {
                creatorConstructor = constructor3;
                index = i;
                continue;
            }
            if (constructor3.getParameterCount() == 0) {
                creatorConstructor = constructor3;
                index = i;
                continue;
            }
            if (creatorConstructor.getParameterCount() >= constructor3.getParameterCount()) continue;
            creatorConstructor = constructor3;
            index = i;
        }
        if (index != -1) {
            alternateConstructors.remove(index);
        }
        if (creatorConstructor != null && creatorConstructor.getParameterCount() != 0 && beanInfo.seeAlso == null) {
            creatorConstructor.setAccessible(true);
            String[] parameterNames = beanInfo.createParameterNames;
            if (parameterNames == null || parameterNames.length == 0) {
                parameterNames = ASMUtils.lookupParameterNames(creatorConstructor);
            }
            int matchCount = 0;
            if (defaultConstructor != null) {
                block7: for (int i = 0; i < parameterNames.length; ++i) {
                    for (int j = 0; j < fieldReaderArray.length; ++j) {
                        if (!parameterNames[i].equals(fieldReaderArray[j].getFieldName())) continue;
                        ++matchCount;
                        continue block7;
                    }
                }
            }
            if (!(fieldBased && JDKUtils.UNSAFE_SUPPORT || Throwable.class.isAssignableFrom(objectClass) || defaultConstructor != null || matchCount == parameterNames.length)) {
                ConstructorFunction function = new ConstructorFunction(alternateConstructors, creatorConstructor, parameterNames);
                FieldReader[] paramFieldReaders = this.createFieldReaders(creatorConstructor.getParameters(), parameterNames);
                return new ObjectReaderNoneDefaultConstrutor(objectClass, beanInfo.typeName, beanInfo.readerFeatures, function, alternateConstructors, parameterNames, paramFieldReaders, (FieldReader[])fieldReaderArray);
            }
        }
        Supplier<T> creator = this.createInstanceSupplier(objectClass);
        if (beanInfo.seeAlso != null && beanInfo.seeAlso.length != 0) {
            return this.createObjectReaderSeeAlso(objectClass, creator, beanInfo.typeKey, beanInfo.seeAlso, beanInfo.seeAlsoNames, (FieldReader[])fieldReaderArray);
        }
        if (objectClass.isInterface()) {
            return new ObjectReaderInterface((Class)objectClass, null, null, 0L, null, null, (FieldReader[])fieldReaderArray);
        }
        return this.createObjectReader(objectClass, beanInfo.typeKey, beanInfo.readerFeatures, creator, null, (FieldReader[])fieldReaderArray);
    }

    public <T> FieldReader[] createFieldReaders(Class<T> objectClass) {
        return this.createFieldReaders(objectClass, objectClass, null, false, JSONFactory.getDefaultObjectReaderProvider().modules);
    }

    public <T> FieldReader[] createFieldReaders(Class<T> objectClass, Type objectType) {
        return this.createFieldReaders(objectClass, objectType, null, false, JSONFactory.getDefaultObjectReaderProvider().modules);
    }

    protected void createFieldReader(Class objectClass, Type objectType, FieldInfo fieldInfo, Field field, Map<String, FieldReader> fieldReaders, List<ObjectReaderModule> modules) {
        int cmp;
        Class<?> fieldClass;
        Type fieldType;
        FieldReader fieldReader;
        for (ObjectReaderModule module : modules) {
            ObjectReaderAnnotationProcessor annotationProcessor = module.getAnnotationProcessor();
            if (annotationProcessor == null) continue;
            annotationProcessor.getFieldInfo(fieldInfo, objectClass, field);
        }
        if (fieldInfo.ignore) {
            return;
        }
        String fieldName = fieldInfo.fieldName == null || fieldInfo.fieldName.isEmpty() ? field.getName() : fieldInfo.fieldName;
        FieldReader previous = fieldReaders.putIfAbsent(fieldName, fieldReader = this.createFieldReader(objectClass, objectType, fieldName, fieldInfo.ordinal, fieldInfo.features, fieldInfo.format, fieldInfo.locale, (Object)fieldInfo.defaultValue, fieldType = field.getGenericType(), fieldClass = field.getType(), field));
        if (previous != null && (cmp = fieldReader.compareTo(previous)) > 0) {
            fieldReaders.put(fieldName, fieldReader);
        }
        if (fieldInfo.alternateNames != null) {
            for (String alternateName : fieldInfo.alternateNames) {
                if (fieldName.equals(alternateName)) continue;
                fieldReaders.putIfAbsent(alternateName, this.createFieldReader(objectClass, objectType, alternateName, fieldInfo.ordinal, fieldInfo.features, null, fieldInfo.locale, (Object)fieldInfo.defaultValue, fieldType, fieldClass, field));
            }
        }
    }

    protected void createFieldReader(Class objectClass, Type objectType, String namingStrategy, String[] orders, FieldInfo fieldInfo, Method method, Map<String, FieldReader> fieldReaders, List<ObjectReaderModule> modules) {
        Class<?> fieldClass;
        int parameterCount;
        String methodName;
        for (ObjectReaderModule module : modules) {
            ObjectReaderAnnotationProcessor annotationProcessor = module.getAnnotationProcessor();
            if (annotationProcessor == null) continue;
            annotationProcessor.getFieldInfo(fieldInfo, objectClass, method);
        }
        if (fieldInfo.ignore) {
            return;
        }
        String fieldName = fieldInfo.fieldName == null || fieldInfo.fieldName.isEmpty() ? ((methodName = method.getName()).startsWith("set") ? BeanUtils.setterName(methodName, namingStrategy) : BeanUtils.getterName(methodName, namingStrategy)) : fieldInfo.fieldName;
        if (orders != null && orders.length > 0) {
            boolean match = false;
            for (int i = 0; i < orders.length; ++i) {
                if (!fieldName.equals(orders[i])) continue;
                fieldInfo.ordinal = i;
                match = true;
                break;
            }
            if (!match && fieldInfo.ordinal == 0) {
                fieldInfo.ordinal = orders.length;
            }
        }
        if ((parameterCount = method.getParameterCount()) == 0) {
            FieldReader fieldReader = this.createFieldReaderMethod(objectClass, objectType, fieldName, fieldInfo.ordinal, fieldInfo.features, fieldInfo.format, fieldInfo.locale, fieldInfo.defaultValue, method.getGenericReturnType(), method.getReturnType(), method);
            FieldReader origin = fieldReaders.putIfAbsent(fieldName, fieldReader);
            if (origin != null && origin.compareTo(fieldReader) > 0) {
                fieldReaders.put(fieldName, fieldReader);
            }
            return;
        }
        if (parameterCount == 2) {
            Class<?> fieldClass2 = method.getParameterTypes()[1];
            Type fieldType = method.getGenericParameterTypes()[1];
            method.setAccessible(true);
            FieldReaderAnySetter anySetter = new FieldReaderAnySetter(fieldType, fieldClass2, fieldInfo.ordinal, fieldInfo.features, fieldInfo.format, method);
            fieldReaders.put(anySetter.fieldName, anySetter);
            return;
        }
        Type fieldType = method.getGenericParameterTypes()[0];
        FieldReader fieldReader = this.createFieldReaderMethod(objectClass, objectType, fieldName, fieldInfo.ordinal, fieldInfo.features, fieldInfo.format, fieldInfo.locale, fieldInfo.defaultValue, fieldType, fieldClass = method.getParameterTypes()[0], method);
        FieldReader origin = fieldReaders.putIfAbsent(fieldName, fieldReader);
        if (origin != null && origin.compareTo(fieldReader) > 0) {
            fieldReaders.put(fieldName, fieldReader);
        }
        if (fieldInfo.alternateNames != null) {
            for (String alternateName : fieldInfo.alternateNames) {
                if (fieldName.equals(alternateName)) continue;
                fieldReaders.putIfAbsent(alternateName, this.createFieldReaderMethod(objectClass, objectType, alternateName, fieldInfo.ordinal, fieldInfo.features, fieldInfo.format, fieldInfo.locale, fieldInfo.defaultValue, fieldType, fieldClass, method));
            }
        }
    }

    protected <T> FieldReader[] createFieldReaders(Class<T> objectClass, Type objectType, BeanInfo beanInfo, boolean fieldBased, List<ObjectReaderModule> modules) {
        if (beanInfo == null) {
            beanInfo = new BeanInfo();
            for (ObjectReaderModule module : modules) {
                ObjectReaderAnnotationProcessor annotationProcessor = module.getAnnotationProcessor();
                if (annotationProcessor == null) continue;
                annotationProcessor.getBeanInfo(beanInfo, objectClass);
            }
        }
        String namingStrategy = beanInfo.namingStrategy;
        LinkedHashMap fieldReaders = new LinkedHashMap();
        FieldInfo fieldInfo = new FieldInfo();
        String[] orders = beanInfo.orders;
        if (fieldBased) {
            BeanUtils.declaredFields(objectClass, field -> {
                fieldInfo.init();
                fieldInfo.features |= JSONReader.Feature.FieldBased.mask;
                this.createFieldReader(objectClass, objectType, fieldInfo, (Field)field, fieldReaders, Collections.emptyList());
            });
        } else {
            BeanUtils.fields(objectClass, field -> {
                fieldInfo.init();
                this.createFieldReader(objectClass, objectType, fieldInfo, (Field)field, fieldReaders, modules);
            });
            BeanUtils.setters(objectClass, method -> {
                fieldInfo.init();
                this.createFieldReader(objectClass, objectType, namingStrategy, orders, fieldInfo, (Method)method, fieldReaders, modules);
            });
        }
        Object[] fieldReaderArray = new FieldReader[fieldReaders.size()];
        fieldReaders.values().toArray(fieldReaderArray);
        Arrays.sort(fieldReaderArray);
        return fieldReaderArray;
    }

    public <T> Supplier<T> createInstanceSupplier(Class<T> objectClass) {
        Constructor constructor;
        if (objectClass.isInterface()) {
            return null;
        }
        int modifiers = objectClass.getModifiers();
        if (Modifier.isAbstract(modifiers)) {
            return null;
        }
        try {
            constructor = objectClass.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
        }
        catch (NoSuchMethodException ignored) {
            return null;
        }
        catch (Throwable e) {
            throw new JSONException("get constructor error, class " + objectClass.getName(), e);
        }
        return () -> {
            try {
                return constructor.newInstance(new Object[0]);
            }
            catch (Throwable e) {
                throw new JSONException("create instance error", e);
            }
        };
    }

    public <T> Supplier<T> createInstanceSupplier(Constructor<T> constructor) {
        return () -> {
            try {
                return constructor.newInstance(new Object[0]);
            }
            catch (Throwable e) {
                throw new JSONException("create instance error", e);
            }
        };
    }

    public <T> Supplier<T> createInstanceSupplier(Method staticFactoryMethod) {
        return () -> {
            try {
                return staticFactoryMethod.invoke(null, new Object[0]);
            }
            catch (Throwable e) {
                throw new JSONException("create instance error", e);
            }
        };
    }

    public <T, R> Function<T, R> createBuildFunction(Method builderMethod) {
        builderMethod.setAccessible(true);
        return o -> {
            try {
                return builderMethod.invoke(o, new Object[0]);
            }
            catch (Throwable e) {
                throw new JSONException("create instance error", e);
            }
        };
    }

    public <T> FieldReader createFieldReader(Class<T> objectType, String fieldName, Type fieldType, Class fieldClass, Method method) {
        return this.createFieldReaderMethod(objectType, objectType, fieldName, 0, 0L, null, null, null, fieldType, fieldClass, method);
    }

    public <T> FieldReader createFieldReader(Class<T> objectType, String fieldName, String format, Type fieldType, Class fieldClass, Method method) {
        return this.createFieldReaderMethod(objectType, fieldName, format, fieldType, fieldClass, method);
    }

    public <T> FieldReader createFieldReaderMethod(Class<T> objectClass, String fieldName, String format, Type fieldType, Class fieldClass, Method method) {
        return this.createFieldReaderMethod(objectClass, objectClass, fieldName, 0, 0L, format, null, null, fieldType, fieldClass, method);
    }

    protected <T> FieldReader createFieldReaderParam(Class<T> objectClass, Type objectType, String fieldName, String format, Type fieldType, Class fieldClass, String paramName, Parameter parameter, int ordinal) {
        if (fieldType == Byte.TYPE || fieldType == Byte.class) {
            return new FieldReaderInt8Param(fieldName, fieldClass, paramName, parameter, ordinal);
        }
        if (fieldType == Short.TYPE || fieldType == Short.class) {
            return new FieldReaderInt16Param(fieldName, fieldClass, paramName, parameter, ordinal);
        }
        if (fieldType == Integer.TYPE || fieldType == Integer.class) {
            return new FieldReaderInt32Param(fieldName, fieldClass, paramName, parameter, ordinal);
        }
        if (fieldType == Long.TYPE || fieldType == Long.class) {
            return new FieldReaderInt64Param(fieldName, fieldClass, paramName, parameter, ordinal);
        }
        return new FieldReaderObjectParam(fieldName, fieldType, fieldClass, paramName, parameter, ordinal, 0L, format);
    }

    public <T> FieldReader createFieldReaderMethod(Class<T> objectClass, Type objectType, String fieldName, int ordinal, long features, String format, Locale locale, Object defaultValue, Type fieldType, Class fieldClass, Method method) {
        if (method != null) {
            method.setAccessible(true);
        }
        if (defaultValue != null && defaultValue.getClass() != fieldClass) {
            Function typeConvert = JSONFactory.getDefaultObjectReaderProvider().getTypeConvert(defaultValue.getClass(), fieldType);
            if (typeConvert != null) {
                defaultValue = typeConvert.apply(defaultValue);
            } else {
                throw new JSONException("illegal defaultValue : " + defaultValue + ", class " + fieldClass.getName());
            }
        }
        if (fieldType == Boolean.TYPE) {
            return new FieldReaderBoolValueMethod(fieldName, fieldType, fieldClass, ordinal, features, format, (Boolean)defaultValue, method);
        }
        if (fieldType == Boolean.class) {
            return new FieldReaderBoolMethod(fieldName, fieldType, fieldClass, ordinal, features, format, (Boolean)defaultValue, method);
        }
        if (fieldType == Byte.TYPE) {
            return new FieldReaderInt8ValueMethod(fieldName, fieldType, fieldClass, ordinal, features, format, (Byte)defaultValue, method);
        }
        if (fieldType == Short.TYPE) {
            return new FieldReaderInt16ValueMethod(fieldName, fieldType, fieldClass, ordinal, features, format, (Short)defaultValue, method);
        }
        if (fieldType == Integer.TYPE) {
            return new FieldReaderInt32ValueMethod(fieldName, fieldType, fieldClass, ordinal, features, format, (Integer)defaultValue, method);
        }
        if (fieldType == Long.TYPE) {
            return new FieldReaderInt64ValueMethod(fieldName, fieldType, fieldClass, ordinal, features, format, (Long)defaultValue, method);
        }
        if (fieldType == Float.TYPE) {
            return new FieldReaderFloatValueMethod(fieldName, fieldType, fieldClass, ordinal, features, format, (Float)defaultValue, method);
        }
        if (fieldType == Double.TYPE) {
            return new FieldReaderDoubleValueMethod(fieldName, fieldType, fieldClass, ordinal, features, format, (Double)defaultValue, method);
        }
        if (fieldType == Byte.class) {
            return new FieldReaderInt8Method(fieldName, fieldType, fieldClass, ordinal, features, format, (Byte)defaultValue, method);
        }
        if (fieldType == Short.class) {
            return new FieldReaderInt16Method(fieldName, fieldType, fieldClass, ordinal, features, format, (Short)defaultValue, method);
        }
        if (fieldType == Integer.class) {
            return new FieldReaderInt32Method(fieldName, fieldType, fieldClass, ordinal, features, format, (Integer)defaultValue, method);
        }
        if (fieldType == Long.class) {
            return new FieldReaderInt64Method(fieldName, fieldType, fieldClass, ordinal, features, format, (Long)defaultValue, method);
        }
        if (fieldType == Float.class) {
            return new FieldReaderFloatMethod(fieldName, fieldType, fieldClass, ordinal, features, format, (Float)defaultValue, method);
        }
        if (fieldType == Double.class) {
            return new FieldReaderDoubleMethod(fieldName, fieldType, fieldClass, ordinal, features, format, (Double)defaultValue, method);
        }
        if (fieldClass == BigDecimal.class) {
            return new FieldReaderBigDecimalMethod(fieldName, fieldType, fieldClass, ordinal, features, format, (BigDecimal)defaultValue, method);
        }
        if (fieldClass == BigInteger.class) {
            return new FieldReaderBigIntegerMethod(fieldName, fieldType, fieldClass, ordinal, features, format, (BigInteger)defaultValue, method);
        }
        if (fieldType == String.class) {
            return new FieldReaderStringMethod(fieldName, fieldType, fieldClass, ordinal, features, format, (String)defaultValue, method);
        }
        if (method.getParameterCount() == 0) {
            if (fieldClass == AtomicInteger.class) {
                return new FieldReaderAtomicIntegerMethodReadOnly(fieldName, fieldClass, ordinal, method);
            }
            if (fieldClass == AtomicLong.class) {
                return new FieldReaderAtomicLongReadOnly(fieldName, fieldClass, ordinal, method);
            }
            if (fieldClass == AtomicIntegerArray.class) {
                return new FieldReaderAtomicIntegerArrayReadOnly(fieldName, fieldClass, ordinal, method);
            }
            if (fieldClass == AtomicLongArray.class) {
                return new FieldReaderAtomicLongArrayReadOnly(fieldName, fieldClass, ordinal, method);
            }
            if (fieldClass == AtomicBoolean.class) {
                return new FieldReaderAtomicBooleanMethodReadOnly(fieldName, fieldClass, ordinal, method);
            }
            if (fieldClass == AtomicReference.class) {
                return new FieldReaderAtomicReferenceMethodReadOnly(fieldName, fieldType, fieldClass, ordinal, method);
            }
            if (Collection.class.isAssignableFrom(fieldClass)) {
                return new FieldReaderCollectionMethodReadOnly(fieldName, fieldType, fieldClass, ordinal, features, format, method);
            }
            if (Map.class.isAssignableFrom(fieldClass)) {
                return new FieldReaderMapMethodReadOnly(fieldName, fieldType, fieldClass, ordinal, features, format, method);
            }
            return null;
        }
        Type fieldTypeResolved = null;
        Class<?> fieldClassResolved = null;
        if (!(fieldType instanceof Class)) {
            fieldTypeResolved = BeanUtils.getFieldType(TypeReference.get(objectType), objectClass, method, fieldType);
            fieldClassResolved = TypeUtils.getMapping(fieldTypeResolved);
        }
        if (fieldClass == List.class) {
            ParameterizedType parameterizedType;
            Type[] actualTypeArguments;
            if (fieldTypeResolved instanceof ParameterizedType && (actualTypeArguments = (parameterizedType = (ParameterizedType)fieldTypeResolved).getActualTypeArguments()).length == 1) {
                Type itemType = actualTypeArguments[0];
                Class<?> itemClass = TypeUtils.getMapping(itemType);
                if (itemClass == String.class) {
                    return new FieldReaderListStrMethod(fieldName, fieldTypeResolved, fieldClass, ordinal, features, format, method);
                }
                return new FieldReaderListMethod(fieldName, fieldTypeResolved, fieldClassResolved, ordinal, features, itemType, method);
            }
            return new FieldReaderListMethod(fieldName, fieldType, fieldClass, ordinal, features, format, method);
        }
        if (fieldClass == Date.class) {
            return new FieldReaderDateMethod(fieldName, fieldClass, ordinal, features, format, locale, method);
        }
        if (fieldClass == StackTraceElement[].class && method.getDeclaringClass() == Throwable.class) {
            features |= JSONReader.Feature.IgnoreSetNullValue.mask;
        }
        return new FieldReaderObjectMethod(fieldName, fieldTypeResolved != null ? fieldTypeResolved : fieldType, fieldClass, ordinal, features, format, locale, defaultValue, method);
    }

    public <T> FieldReader<T> createFieldReader(String fieldName, Type fieldType, Field field) {
        return this.createFieldReader(fieldName, null, fieldType, field);
    }

    public <T> FieldReader<T> createFieldReader(String fieldName, String format, Type fieldType, Field field) {
        Class<?> objectClass = field.getDeclaringClass();
        return this.createFieldReader(objectClass, objectClass, fieldName, 0L, format, fieldType, field.getType(), field);
    }

    public <T> FieldReader<T> createFieldReader(Class objectClass, Type objectType, String fieldName, long features, String format, Type fieldType, Class fieldClass, Field field) {
        return this.createFieldReader(objectClass, objectType, fieldName, 0, features, format, null, null, fieldType, field.getType(), field);
    }

    public <T> FieldReader<T> createFieldReader(Class objectClass, Type objectType, String fieldName, int ordinal, long features, String format, Locale locale, Object defaultValue, Type fieldType, Class fieldClass, Field field) {
        ParameterizedType parameterizedType;
        Type[] actualTypeArguments;
        if (defaultValue != null && defaultValue.getClass() != fieldClass) {
            Function typeConvert = JSONFactory.getDefaultObjectReaderProvider().getTypeConvert(defaultValue.getClass(), fieldType);
            if (typeConvert != null) {
                defaultValue = typeConvert.apply(defaultValue);
            } else {
                throw new JSONException("illegal defaultValue : " + defaultValue + ", class " + fieldClass.getName());
            }
        }
        if (field != null && !objectClass.getName().startsWith("java.lang")) {
            field.setAccessible(true);
        }
        if (fieldClass == Integer.TYPE) {
            return new FieldReaderInt32ValueField(fieldName, fieldClass, ordinal, format, (Integer)defaultValue, field);
        }
        if (fieldClass == Integer.class) {
            return new FieldReaderInt32Field(fieldName, fieldClass, ordinal, format, (Integer)defaultValue, field);
        }
        if (fieldClass == Long.TYPE) {
            return new FieldReaderInt64ValueField(fieldName, fieldClass, ordinal, format, (Long)defaultValue, field);
        }
        if (fieldClass == Long.class) {
            return new FieldReaderInt64Field(fieldName, fieldClass, ordinal, format, (Long)defaultValue, field);
        }
        if (fieldClass == Short.TYPE) {
            return new FieldReaderInt16ValueField(fieldName, fieldClass, ordinal, format, (Short)defaultValue, field);
        }
        if (fieldClass == Short.class) {
            return new FieldReaderInt16Field(fieldName, fieldClass, ordinal, format, (Short)defaultValue, field);
        }
        if (fieldClass == Boolean.TYPE) {
            return new FieldReaderBoolValueField(fieldName, fieldClass, ordinal, (Boolean)defaultValue, field);
        }
        if (fieldClass == Boolean.class) {
            return new FieldReaderBoolField(fieldName, fieldClass, ordinal, (Boolean)defaultValue, field);
        }
        if (fieldClass == Byte.TYPE) {
            return new FieldReaderInt8ValueField(fieldName, fieldClass, ordinal, (Byte)defaultValue, field);
        }
        if (fieldClass == Byte.class) {
            return new FieldReaderInt8Field(fieldName, fieldClass, ordinal, format, (Byte)defaultValue, field);
        }
        if (fieldClass == Float.TYPE) {
            return new FieldReaderFloatValueField(fieldName, fieldClass, ordinal, features, format, (Float)defaultValue, field);
        }
        if (fieldClass == Float.class) {
            return new FieldReaderFloatField(fieldName, fieldClass, ordinal, features, format, (Float)defaultValue, field);
        }
        if (fieldClass == Double.TYPE) {
            return new FieldReaderDoubleValueField(fieldName, fieldClass, ordinal, features, format, (Double)defaultValue, field);
        }
        if (fieldClass == Double.class) {
            return new FieldReaderDoubleField(fieldName, fieldClass, ordinal, format, (Double)defaultValue, field);
        }
        if (fieldClass == BigDecimal.class) {
            return new FieldReaderBigDecimalField(fieldName, fieldClass, ordinal, features, format, (BigDecimal)defaultValue, field);
        }
        if (fieldClass == BigInteger.class) {
            return new FieldReaderBigIntegerField(fieldName, fieldClass, ordinal, format, (BigInteger)defaultValue, field);
        }
        if (fieldClass == String.class) {
            return new FieldReaderStringField(fieldName, fieldClass, ordinal, features, format, (String)defaultValue, field);
        }
        if (fieldClass == Date.class) {
            return new FieldReaderDateField(fieldName, fieldClass, ordinal, features, format, locale, (Date)defaultValue, field);
        }
        if (fieldClass == AtomicBoolean.class) {
            return new FieldReaderAtomicBooleanFieldReadOnly(fieldName, fieldClass, ordinal, format, (AtomicBoolean)defaultValue, field);
        }
        if (fieldClass == AtomicReference.class) {
            return new FieldReaderAtomicReferenceField(fieldName, fieldType, fieldClass, ordinal, format, field);
        }
        Type fieldTypeResolved = null;
        Class<?> fieldClassResolved = null;
        if (!(fieldType instanceof Class)) {
            fieldTypeResolved = BeanUtils.getFieldType(TypeReference.get(objectType), objectClass, field, fieldType);
            fieldClassResolved = TypeUtils.getMapping(fieldTypeResolved);
        }
        boolean finalField = Modifier.isFinal(field.getModifiers());
        if (Collection.class.isAssignableFrom(fieldClass)) {
            ParameterizedType parameterizedType2;
            Type[] actualTypeArguments2;
            if (fieldTypeResolved instanceof ParameterizedType && (actualTypeArguments2 = (parameterizedType2 = (ParameterizedType)fieldTypeResolved).getActualTypeArguments()).length == 1) {
                Type itemType = actualTypeArguments2[0];
                Class<?> itemClass = TypeUtils.getMapping(itemType);
                if (itemClass == String.class) {
                    if (finalField) {
                        if (JDKUtils.UNSAFE_SUPPORT && (features & JSONReader.Feature.FieldBased.mask) != 0L) {
                            return new FieldReaderListStrFieldUF(fieldName, fieldTypeResolved, fieldClassResolved, ordinal, features, format, field);
                        }
                        return new FieldReaderCollectionFieldReadOnly(fieldName, fieldTypeResolved, fieldClassResolved, ordinal, features, format, field);
                    }
                    if (JDKUtils.UNSAFE_SUPPORT) {
                        return new FieldReaderListStrFieldUF(fieldName, fieldTypeResolved, fieldClassResolved, ordinal, features, format, field);
                    }
                    return new FieldReaderListStrField(fieldName, fieldTypeResolved, fieldClassResolved, ordinal, features, format, field);
                }
                if (JDKUtils.UNSAFE_SUPPORT) {
                    return new FieldReaderListFieldUF(fieldName, fieldTypeResolved, fieldClassResolved, itemType, ordinal, features, format, locale, (Collection)defaultValue, field);
                }
                return new FieldReaderListField(fieldName, fieldTypeResolved, fieldClassResolved, itemType, ordinal, features, format, locale, (Collection)defaultValue, field);
            }
            Object itemType = null;
            if (fieldType instanceof ParameterizedType && (actualTypeArguments2 = ((ParameterizedType)fieldType).getActualTypeArguments()).length > 0) {
                itemType = actualTypeArguments2[0];
            }
            if (itemType == null) {
                itemType = Object.class;
            }
            if (JDKUtils.UNSAFE_SUPPORT) {
                return new FieldReaderListFieldUF(fieldName, fieldType, fieldClass, (Type)itemType, ordinal, features, format, locale, (Collection)defaultValue, field);
            }
            return new FieldReaderListField(fieldName, fieldType, fieldClass, (Type)itemType, ordinal, features, format, locale, (Collection)defaultValue, field);
        }
        if (Map.class.isAssignableFrom(fieldClass) && fieldTypeResolved instanceof ParameterizedType && (actualTypeArguments = (parameterizedType = (ParameterizedType)fieldTypeResolved).getActualTypeArguments()).length == 2 && finalField && (!JDKUtils.UNSAFE_SUPPORT || (features & JSONReader.Feature.FieldBased.mask) == 0L)) {
            return new FielderReaderImplMapFieldReadOnly(fieldName, fieldTypeResolved, fieldClassResolved, ordinal, features, format, field);
        }
        if (finalField) {
            if (fieldClass == int[].class) {
                return new FieldReaderInt32ValueArrayFinalField(fieldName, fieldClass, ordinal, format, (int[])defaultValue, field);
            }
            if (fieldClass == long[].class) {
                return new FieldReaderInt64ValueArrayFinalField(fieldName, fieldClass, ordinal, format, (long[])defaultValue, field);
            }
        }
        if (fieldClassResolved != null) {
            if (JDKUtils.UNSAFE_SUPPORT) {
                return new FieldReaderObjectFieldUF(fieldName, fieldTypeResolved, fieldClass, ordinal, features, format, defaultValue, field);
            }
            return new FieldReaderObjectField(fieldName, fieldTypeResolved, fieldClass, ordinal, features, format, defaultValue, field);
        }
        if (JDKUtils.UNSAFE_SUPPORT) {
            return new FieldReaderObjectFieldUF(fieldName, fieldType, fieldClass, ordinal, features, format, defaultValue, field);
        }
        return new FieldReaderObjectField(fieldName, fieldType, fieldClass, ordinal, features, format, defaultValue, field);
    }

    <T, V> FieldReader createFieldReader(String fieldName, Type fieldType, Class<V> fieldClass, Method method, BiConsumer<T, V> function) {
        return this.createFieldReader(null, null, fieldName, fieldType, fieldClass, 0, 0L, null, null, method, function);
    }

    <T, V> FieldReader createFieldReader(Class objectClass, Type objectType, String fieldName, Type fieldType, Class<V> fieldClass, int ordinal, long features, String format, Object defaultValue, Method method, BiConsumer<T, V> function) {
        if (fieldClass == Integer.class) {
            return new FieldReaderInt32Func<T, V>(fieldName, fieldClass, ordinal, format, defaultValue, method, function);
        }
        if (fieldClass == Long.class) {
            return new FieldReaderInt64Func<T, V>(fieldName, fieldClass, ordinal, format, defaultValue, method, function);
        }
        if (fieldClass == String.class) {
            return new FieldReaderStringFunc<T, V>(fieldName, fieldClass, ordinal, features, format, defaultValue, method, function);
        }
        if (fieldClass == Boolean.class) {
            return new FieldReaderBoolFunc<T, V>(fieldName, fieldClass, ordinal, format, defaultValue, method, function);
        }
        if (fieldClass == Short.class) {
            return new FieldReaderInt16Func<T, V>(fieldName, fieldClass, ordinal, format, defaultValue, method, function);
        }
        if (fieldClass == Byte.class) {
            return new FieldReaderInt8Func<T, V>(fieldName, fieldClass, ordinal, format, defaultValue, method, function);
        }
        if (fieldClass == BigDecimal.class) {
            return new FieldReaderBigDecimalFunc<T, V>(fieldName, fieldClass, ordinal, format, defaultValue, method, function);
        }
        if (fieldClass == BigInteger.class) {
            return new FieldReaderBigIntegerFunc<T, V>(fieldName, fieldClass, ordinal, format, defaultValue, method, function);
        }
        if (fieldClass == Number.class) {
            return new FieldReaderNumberFunc<T, V>(fieldName, fieldClass, ordinal, format, defaultValue, method, function);
        }
        if (fieldClass == Date.class) {
            return new FieldReaderDateFunc<T>(fieldName, fieldClass, ordinal, features, format, method, function);
        }
        Type fieldTypeResolved = null;
        Class<?> fieldClassResolved = null;
        if (!(fieldType instanceof Class)) {
            fieldTypeResolved = BeanUtils.getFieldType(TypeReference.get(objectType), objectClass, method, fieldType);
            fieldClassResolved = TypeUtils.getMapping(fieldTypeResolved);
        }
        if (fieldClass == List.class || fieldClass == ArrayList.class) {
            Type itemType;
            Class<?> itemClass;
            ParameterizedType parameterizedType;
            Type[] actualTypeArguments;
            if (fieldTypeResolved instanceof ParameterizedType && (actualTypeArguments = (parameterizedType = (ParameterizedType)fieldTypeResolved).getActualTypeArguments()).length == 1 && (itemClass = TypeUtils.getMapping(itemType = actualTypeArguments[0])) == String.class) {
                return new FieldReaderListStrFunc<T>(fieldName, fieldTypeResolved, fieldClassResolved, ordinal, format, defaultValue, method, function);
            }
            return new FieldReaderListFunc(fieldName, fieldTypeResolved, fieldClassResolved, ordinal, format, defaultValue, method, function);
        }
        if (fieldTypeResolved != null) {
            return new FieldReaderObjectFunc<T, V>(fieldName, fieldTypeResolved, fieldClass, ordinal, features, format, defaultValue, method, function);
        }
        return new FieldReaderObjectFunc<T, V>(fieldName, fieldType, fieldClass, ordinal, features, format, defaultValue, method, function);
    }

    protected ObjectReader createEnumReader(Class objectClass, Method createMethod, List<ObjectReaderModule> modules) {
        Class fieldClassMixInSource;
        ObjectReaderProvider provider;
        Object name;
        Enum e;
        int i;
        FieldInfo fieldInfo = new FieldInfo();
        Enum[] ordinalEnums = (Enum[])objectClass.getEnumConstants();
        HashMap<Long, Enum> enumMap = new HashMap<Long, Enum>();
        for (i = 0; i < ordinalEnums.length; ++i) {
            e = ordinalEnums[i];
            name = e.name();
            long hash = Fnv.hashCode64((String)name);
            enumMap.put(hash, e);
            try {
                fieldInfo.init();
                Field field = objectClass.getField((String)name);
                for (ObjectReaderModule module : modules) {
                    ObjectReaderAnnotationProcessor annotationProcessor = module.getAnnotationProcessor();
                    if (annotationProcessor == null) continue;
                    annotationProcessor.getFieldInfo(fieldInfo, objectClass, field);
                }
                String jsonFieldName = fieldInfo.fieldName;
                if (jsonFieldName != null && !jsonFieldName.isEmpty() && !jsonFieldName.equals(name)) {
                    long jsonFieldNameHash = Fnv.hashCode64(jsonFieldName);
                    enumMap.putIfAbsent(jsonFieldNameHash, e);
                }
                if (fieldInfo.alternateNames == null) continue;
                for (String alternateName : fieldInfo.alternateNames) {
                    if (alternateName == null || alternateName.isEmpty()) continue;
                    long alternateNameHash = Fnv.hashCode64(alternateName);
                    enumMap.putIfAbsent(alternateNameHash, e);
                }
                continue;
            }
            catch (Exception field) {
                // empty catch block
            }
        }
        for (i = 0; i < ordinalEnums.length; ++i) {
            e = ordinalEnums[i];
            name = e.name();
            long hashLCase = Fnv.hashCode64LCase((String)name);
            enumMap.putIfAbsent(hashLCase, e);
        }
        long[] enumNameHashCodes = new long[enumMap.size()];
        int i2 = 0;
        for (Long h : enumMap.keySet()) {
            enumNameHashCodes[i2++] = h;
        }
        Arrays.sort(enumNameHashCodes);
        Member enumValueField = BeanUtils.getEnumValueField(objectClass);
        if (enumValueField == null && modules.size() > 0 && (provider = modules.get(0).getProvider()) != null && (fieldClassMixInSource = provider.getMixIn(objectClass)) != null) {
            Member mixedValueField = BeanUtils.getEnumValueField(fieldClassMixInSource);
            if (mixedValueField instanceof Field) {
                try {
                    enumValueField = objectClass.getField(mixedValueField.getName());
                }
                catch (NoSuchFieldException field) {}
            } else if (mixedValueField instanceof Method) {
                try {
                    enumValueField = objectClass.getMethod(mixedValueField.getName(), new Class[0]);
                }
                catch (NoSuchMethodException field) {
                    // empty catch block
                }
            }
        }
        Enum[] enums = new Enum[enumNameHashCodes.length];
        for (int i3 = 0; i3 < enumNameHashCodes.length; ++i3) {
            Enum e2;
            long hash = enumNameHashCodes[i3];
            enums[i3] = e2 = (Enum)enumMap.get(hash);
        }
        if (createMethod == null && enumValueField == null && ordinalEnums.length == 2) {
            Enum first = ordinalEnums[0];
            int matchCount = 0;
            for (int i4 = 0; i4 < enums.length; ++i4) {
                if (enums[i4] != first) continue;
                ++matchCount;
            }
            if (matchCount == 2) {
                return new ObjectReaderImplEnum2X4(objectClass, enums, ordinalEnums, enumNameHashCodes);
            }
        }
        return new ObjectReaderImplEnum(objectClass, createMethod, enumValueField, enums, ordinalEnums, enumNameHashCodes);
    }
}

