/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.FieldReaderObjectField;
import com.alibaba.fastjson2.util.TypeUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Type;

final class FieldReaderInt8Field<T>
extends FieldReaderObjectField<T> {
    FieldReaderInt8Field(String fieldName, Class fieldType, int ordinal, String format, Byte defaultValue, Field field) {
        super(fieldName, (Type)fieldType, fieldType, ordinal, 0L, format, defaultValue, field);
    }

    @Override
    public void readFieldValue(JSONReader jsonReader, T object) {
        Integer fieldInt = jsonReader.readInt32();
        try {
            this.field.set(object, fieldInt == null ? null : Byte.valueOf(fieldInt.byteValue()));
        }
        catch (Exception e) {
            throw new JSONException("set " + this.fieldName + " error", e);
        }
    }

    @Override
    public void accept(T object, int value) {
        try {
            this.field.set(object, (byte)value);
        }
        catch (Exception e) {
            throw new JSONException("set " + this.fieldName + " error", e);
        }
    }

    @Override
    public void accept(T object, long value) {
        try {
            this.field.set(object, (byte)value);
        }
        catch (Exception e) {
            throw new JSONException("set " + this.fieldName + " error", e);
        }
    }

    @Override
    public void accept(T object, Object value) {
        try {
            this.field.set(object, TypeUtils.toByte(value));
        }
        catch (Exception e) {
            throw new JSONException("set " + this.fieldName + " error", e);
        }
    }

    @Override
    public Object readFieldValue(JSONReader jsonReader) {
        return (byte)jsonReader.readInt32Value();
    }
}

