/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.reader.FieldReaderAtomicReference;
import com.alibaba.fastjson2.reader.FieldReaderReadOnly;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.concurrent.atomic.AtomicReference;

final class FieldReaderAtomicReferenceField<T>
extends FieldReaderAtomicReference<T>
implements FieldReaderReadOnly<T> {
    final Field field;
    final boolean readOnly;

    FieldReaderAtomicReferenceField(String fieldName, Type fieldType, Class fieldClass, int ordinal, String format, Field field) {
        super(fieldName, fieldType, fieldClass, ordinal, 0L, format);
        this.field = field;
        this.readOnly = Modifier.isFinal(field.getModifiers());
    }

    @Override
    public Field getField() {
        return this.field;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public void accept(T object, Object value) {
        if (value == null) {
            return;
        }
        try {
            if (this.readOnly) {
                AtomicReference atomic = (AtomicReference)this.field.get(object);
                atomic.set(value);
            } else {
                this.field.set(object, new AtomicReference<Object>(value));
            }
        }
        catch (Exception e) {
            throw new JSONException("set " + this.fieldName + " error", e);
        }
    }
}

